/*

  sshuserfiles.h

  Authors:
        Tatu Ylnen <ylo@ssh.com>
        Markku-Juhani Saarinen <mjos@ssh.com>
        Timo J. Rinne <tri@ssh.com>
        Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1997-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Simple functions that update user's files.

*/

/*
 * $Log: sshuserfiles.h,v $ * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * $EndLog$
 */

#ifndef SSHUSERFILES_H
#define SSHUSERFILES_H

#include "sshincludes.h"
#include "sshcrypt.h"
#include "sshuser.h"
#include "sshconfig.h"
#include "sshkeyblob2.h"



#ifndef SSH_USER_DIR
#define SSH_USER_DIR ".ssh2"
#endif /* SSH_USER_DIR */

#ifdef VXWORKS
#define SSH_RANDSEED_FILE "rndseed"
#endif /* VXWORKS */

/* the random seed file */
#ifndef SSH_RANDSEED_FILE
#define SSH_RANDSEED_FILE "random_seed"
#endif /* SSH_RANDSEED_FILE */

/* the size of the random seed file (in bytes) */
#ifndef SSH_RANDSEED_LEN
#define SSH_RANDSEED_LEN 512
#endif /* SSH_RANDSEED_LEN */




















/* Default names for pgp keyring files */
#ifndef SSH_PGP_PUBLIC_KEY_FILE
#define SSH_PGP_PUBLIC_KEY_FILE "pubring.pgp"
#endif /* SSH_PGP_PUBLIC_KEY_FILE */

#ifndef SSH_PGP_SECRET_KEY_FILE
#define SSH_PGP_SECRET_KEY_FILE "secring.pgp"
#endif /* SSH_PGP_SECRET_KEY_FILE */

/* the standard "authorization" file */

#ifdef VXWORKS
#define SSH_AUTHORIZATION_FILE "authfile"
#endif /* VXWORKS */

#ifndef SSH_AUTHORIZATION_FILE
#define SSH_AUTHORIZATION_FILE "authorization"
#endif /* SSH_AUTHORIZATION_FILE */

#ifndef SSH_USER_CONFIG_DIRECTORY
#define SSH_USER_CONFIG_DIRECTORY "%D/" SSH_USER_DIR
#endif /* SSH_USER_CONFIG_DIRECTORY */

/* the standard "identification" file */

#ifndef SSH_IDENTIFICATION_FILE
#define SSH_IDENTIFICATION_FILE "identification"
#endif /* SSH_IDENTIFICATION_FILE */

/* the standard "hostkey" file */

#  ifndef SSH_HOSTKEY_FILE
#    define SSH_HOSTKEY_FILE "hostkey"
#  endif /* SSH_HOSTKEY_FILE */
#  ifndef SSH_PUBLIC_HOSTKEY
#    define SSH_PUBLIC_HOSTKEY "hostkey.pub"
#  endif








/* server directory */

#ifndef PASSWD_PATH
#define PASSWD_PATH "/bin/passwd"
#endif /* !PASSWD_PATH */

#ifdef VXWORKS
#define ETCDIR "/fd0"
#endif /* VXWORKS */

#ifndef ETCDIR
#define ETCDIR "/etc/ssh2"
#endif /* !ETCDIR */

#ifndef SSH_SERVER_DIR
#define SSH_SERVER_DIR ETCDIR
#endif /* !SSH_SERVER_DIR */

#ifndef SSHD_PIDDIR
#ifdef HAVE_VAR_RUN
#define SSHD_PIDDIR "/var/run"
#else /* HAVE_VAR_RUN */
#define SSHD_PIDDIR SSH_SERVER_DIR
#endif /* HAVE_VAR_RUN */
#endif /* !SSHD_PIDDIR */















#ifndef SSH_HOSTKEYS_DIR
#define SSH_HOSTKEYS_DIR "/hostkeys"
#endif /* !SSH_HOSTKEYS_DIR */

#ifndef SSH_KNOWNHOSTS_DIR
#define SSH_KNOWNHOSTS_DIR "/knownhosts"
#endif /* !SSH_KNOWNHOSTS_DIR */

#ifndef SSH_GLOBAL_HOSTKEYS_DIR
#define SSH_GLOBAL_HOSTKEYS_DIR SSH_SERVER_DIR SSH_HOSTKEYS_DIR
#endif /* !SSH_GLOBAL_KNOWNHOSTS_DIR */

#ifndef SSH_GLOBAL_KNOWNHOSTS_DIR
#define SSH_GLOBAL_KNOWNHOSTS_DIR SSH_SERVER_DIR SSH_KNOWNHOSTS_DIR
#endif /* !SSH_GLOBAL_KNOWNHOSTS_DIR */

/* File, from which a possible banner message is sent to the client
   before authentication. */
#ifndef SSH_BANNER_MSG_FILE
#define SSH_BANNER_MSG_FILE SSH_SERVER_DIR "/ssh_banner_message"
#endif /* !SSH_BANNER_MSG_FILE */

/* global configuration file for the client */

#ifndef SSH_CLIENT_GLOBAL_CONFIG_FILE
#define SSH_CLIENT_GLOBAL_CONFIG_FILE SSH_SERVER_DIR "/ssh2_config"
#endif /* !SSH_CLIENT_GLOBAL_CONFIG_FILE */

/* configuration file for the client */

#ifndef SSH_CLIENT_CONFIG_FILE
#define SSH_CLIENT_CONFIG_FILE "ssh2_config"
#endif /* !SSH_CLIENT_CONFIG_FILE */

#ifdef VXWORKS
/* VxWorks allows only 8 character long file names */
#define SSH_SERVER_CONFIG_FILE "sshd2.cnf"
#endif /* VXWORKS */

/* configuration file for the server */
#ifndef SSH_SERVER_CONFIG_FILE
#define SSH_SERVER_CONFIG_FILE "sshd2_config"
#endif /* !SSH_SERVER_CONFIG_FILE */

/* sshd1-specific config file */
#ifndef SSHD1_CONFIG_FILE
#define SSHD1_CONFIG_FILE FOREIGN_ETCDIR "/sshd_config"
#endif /* !SSHD1_CONFIG_FILE */

/* Ssh-only version of /etc/hosts.equiv. */
#ifndef SSH_HOSTS_EQUIV
#define SSH_HOSTS_EQUIV FOREIGN_ETCDIR "/shosts.equiv"
#endif /* !SSH_HOSTS_EQUIV */












/* Return a pointer to user's ssh2 directory.  The directory is
   created if `create_if_needed' is TRUE.  Return NULL on failure.
   The returned value has been allocated with ssh_xmalloc, and the
   caller is responsible for freeing it with ssh_xfree when no longer
   needed. */
char *ssh_userdir(SshUser user, SshConfig config, Boolean create_if_needed);

/* Forms an absolute path from `file', returning an xmallocated
   string. If `file' is already absolute, it is used as is. If it is
   relative, an absolute path is formed, using user's ssh2 directory
   as the prefix. If user's ssh2 directory is invalid, the
   `default_prefix' is used (this string should start with a '/'). */
char *ssh_userdir_prefix(SshUser user, SshConfig config,
                         const char *file, const char *default_prefix,
                         Boolean create_if_needed);

/* Return a pointer to the user's random seed file name.
   Return NULL on failure. The file name is found from `config'.
   If `config' is NULL, use the standard SSH_RANDSEED_FILE.

   'create' specifies whether an empty seed file is created if the file
   does not exist.

   The caller is responsible for freeing the returned value with ssh_xfree
   when no longer needed. */
char *ssh_randseed_file(SshUser user, SshConfig config, Boolean create);

/* Get the random state from the file.  This loads and merges any data
   in the seed file into the generator. */

void ssh_randseed_load(SshUser user,SshConfig config);

/* Get the random state from the file.  The caller is responsible for
   freeing the random number generator with ssh_random_free, or closing and
   updating to the seed file with ssh_randseed_close (recommended) when no
   longer needed. */
void ssh_randseed_open(SshUser user, SshConfig config);

/* Updates the random seed file with information from the random
   number generator.  Information from the old random seed file and
   the generator is mixed, so that the new random seed file will
   contain traces of both the generator state and the old seed
   file. */
void ssh_randseed_update(SshUser user, SshConfig config);

typedef enum {
  SSH_PRIVKEY_PLAIN,
  SSH_PRIVKEY_CERT,
  SSH_PRIVKEY_PGP
} SshConfigPrivateKeyType;

struct SshConfigPrivateKey {
  char *keyfile;
  SshConfigPrivateKeyType type;
#ifdef WITH_PGP
  char *pgp_keyring;
  char *pgp_name;
  char *pgp_fingerprint;
  SshUInt32 pgp_id;
#endif /* WITH_PGP */
};

/* Build a list of private key files that should be tried when
   logging into `host'.  The list's last entry is NULL.
   The caller should free the array and all strings in it with ssh_xfree when
   no longer needed. */
struct SshConfigPrivateKey **ssh_privkey_list(SshUser user,
                                              char *host,
                                              SshConfig config);

/* Generate a directory, where the config files of given user
   are.  This is usually %D/.ssh2 where %D is user's home
   directory. */
char *ssh_user_conf_dir(SshUser user, SshConfig config);

/* Builds a directory name according to the dir template and user info.
   Extracts %D, %U, %IU and %IG in the template to the values
   specified by user. */
char *ssh_user_build_dir(SshUser user, const char *path_template);

#endif /* SSHUSERFILES_H */
