/*

  t-snlist.c
  
  Author: Tatu Ylonen <ylo@ssh.com>

  Copyright (c) 1996,2001 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved
  
  Modified by ylo and mkojo
*/

#include "sshincludes.h"
#include "sshsnlist.h"

#define TA(type,src,expect)                                             \
  buf = ssh_snlist_intersection_##type(src);                            \
  if (strcmp(buf, expect) != 0)                                         \
    ssh_fatal("%.100s '%.100s' yields '%.100s', expected '%.100s'",     \
          #type, src, buf, expect);                                     \
  ssh_xfree(buf);

int main(int ac, char **av)
{
  char *buf;
  
#ifdef SSHDIST_CRYPT_GENCIPH
  TA(cipher, "des-foobar,none", "none");
#ifdef SSHDIST_CRYPT_DES
  TA(cipher, "des-cbc,des-cfb,des-ecb", "des-cbc,des-cfb,des-ecb");
#endif /* SSHDIST_CRYPT_DES */
  TA(cipher, "des-cbc@foo.com", "");
#endif /* SSHDIST_CRYPT_GENCIPH */
#ifdef SSHDIST_CRYPT_GENMAC
#ifdef SSHDIST_CRYPT_HMAC
#ifdef SSHDIST_CRYPT_MD5
#ifdef SSHDIST_CRYPT_SHA
  TA(mac, "hmac-md5,hmac-sha1,none,barz,fooz@ssh.fi",
     "hmac-md5,hmac-sha1,none");
#endif /* SSHDIST_CRYPT_SHA */
#endif /* SSHDIST_CRYPT_MD5 */
#endif /* SSHDIST_CRYPT_HMAC */
#endif /* SSHDIST_CRYPT_GENMAC */
#ifdef SSHDIST_CRYPT_GENHASH
#ifdef SSHDIST_CRYPT_MD5
#ifdef SSHDIST_CRYPT_SHA
  TA(hash, "foo,bar,md5,baz,sha1", "md5,sha1");
#endif /* SSHDIST_CRYPT_SHA */
#endif /* SSHDIST_CRYPT_MD5 */
#endif /* SSHDIST_CRYPT_GENHASH */
#ifdef SSHDIST_CRYPT_COMPRESS
#ifdef SSHDIST_ZLIB
  TA(compression, "foo,bar,none,zlib,baz", "none,zlib");


#endif /* SSHDIST_ZLIB */
#endif /* SSHDIST_CRYPT_COMPRESS */
  return 0;
}
