/*

cast.h

Author: Mika Kojo
Copyright (c) 1997 SSH Communications Security Oy

CAST-128 adapted from Peter Gutmann's and Leonard Janke's implementation. 

*/

/*
 * $Id: cast.h,v 1.1 2001/07/25 08:44:17 tmo Exp $
 * $Log: cast.h,v $ * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * $EndLog$
 */

#ifndef CAST_H
#define CAST_H

/* Prototypes */

/* Gives the size of memory block allocated for cast context */
size_t ssh_cast_ctxsize(void);

/* Initializes an already allocated area for cast encryption/decryption */
Boolean ssh_cast_init(void *context,
                      const unsigned char *key, size_t keylen,
                      Boolean for_encryption);

/* Encrypt/decrypt in electronic code book mode. */
void ssh_cast_ecb(void *context, unsigned char *dest,
                  const unsigned char *src, size_t len,
                  unsigned char *iv);

/* Encrypt/decrypt in cipher block chaining mode. */
void ssh_cast_cbc(void *context, unsigned char *dest,
                  const unsigned char *src, size_t len,
                  unsigned char *iv);

/* Encrypt/decrypt in cipher feedback mode. */
void ssh_cast_cfb(void *context, unsigned char *dest,
                  const unsigned char *src, size_t len,
                  unsigned char *iv);

/* Encrypt/decrypt in output feedback mode. */
void ssh_cast_ofb(void *context, unsigned char *dest,
                  const unsigned char *src, size_t len,
                  unsigned char *iv);

/* Cast CBC-MAC. */
void ssh_cast_cbc_mac(void *context, const unsigned char *src, size_t len,
                      unsigned char *iv);

/* Encrypt/decrypt in electronic code book mode. */
void ssh_cast_12_ecb(void *context, unsigned char *dest,
                     const unsigned char *src, size_t len,
                     unsigned char *iv);

/* Encrypt/decrypt in cipher block chaining mode. */
void ssh_cast_12_cbc(void *context, unsigned char *dest,
                     const unsigned char *src, size_t len,
                     unsigned char *iv);

/* Encrypt/decrypt in cipher feedback mode. */
void ssh_cast_12_cfb(void *context, unsigned char *dest,
                     const unsigned char *src, size_t len,
                     unsigned char *iv);

/* Encrypt/decrypt in output feedback mode. */
void ssh_cast_12_ofb(void *context, unsigned char *dest,
                     const unsigned char *src, size_t len,
                     unsigned char *iv);

/* Cast-12 CBC-MAC. */
void ssh_cast_12_cbc_mac(void *context, const unsigned char *src, size_t len,
                         unsigned char *iv);

#endif
