/*
  File: sshhash.h

  Authors:
        Tero T Mononen <tmo@ssh.fi>

  Description:


  Copyright:
        Copyright (c) 2000 SSH Communications Security Corp, Finland.
        All rights reserved.
*/


#ifndef SSHHASH_H
#define SSHHASH_H

/* Definition structure for hash functions. That is, by using this
   structure crypto library transparently is able to use "any"
   hash functions. */
typedef struct SshHashDefRec
{
  const char *name;
  const char *asn1_oid;
  unsigned char iso_identifier;
  size_t digest_length;
  size_t input_block_length;
  size_t (*ctxsize)(void);
  void (*reset_context)(void *context);
  void (*update)(void *context, const unsigned char *buf, size_t len);
  void (*final)(void *context, unsigned char *digest);
} *SshHashDef, SshHashDefStruct;

SshHash
ssh_hash_allocate_internal(const SshHashDefStruct *hash_def);

const SshHashDefStruct *
ssh_hash_get_definition_internal(const SshHash hash);

/* Expansion from a passphrase into a key. */
void ssh_hash_expand_key_internal(unsigned char *buffer, size_t buffer_len,
                                  const unsigned char *ps, size_t ps_len,
                                  unsigned char *magic, size_t magic_len,
                                  const SshHashDefStruct *hash);

#endif /* SSHHASH_H */
