/*
  File: ssh-dsa-maker.c

  Authors:
        Mika Kojo <mkojo@ssh.fi>
        Tero T Mononen <tmo@ssh.fi>

  Description:
        Description for how to make DSA keys

  Copyright:
        Copyright (c) 2001 SSH Communications Security Corp, Finland.
        All rights reserved.
*/


#include "sshincludes.h"
#include "sshpk.h"
#include "dlglue.h"
#include "sshrgf.h"
#include "sshcrypt.h"

extern const SshPkSignature ssh_dl_modp_signature_schemes[];
extern const SshPkEncryption ssh_dl_modp_encryption_schemes[];
extern const SshPkAction ssh_pk_dl_modp_actions[];

const SshPkType ssh_pk_dl_modp_generator =
{
  "dl-modp",
  ssh_pk_dl_modp_actions,

  /* Basic group operations. */
  ssh_dlp_action_init,
  ssh_dlp_param_action_make,
  ssh_dlp_action_free,

  ssh_dlp_param_import,
  ssh_dlp_param_export,
  ssh_dlp_param_free,
  ssh_dlp_param_copy,
  ssh_dlp_param_get_predefined_groups,

  /* Precomputation. */
  ssh_dlp_param_precompute,

  /* Randomizer generation. */
  ssh_dlp_param_count_randomizers,
  ssh_dlp_param_generate_randomizer,
  ssh_dlp_param_export_randomizer,
  ssh_dlp_param_import_randomizer,

  /* Public key operations. */
  ssh_dlp_action_public_key_init,
  ssh_dlp_public_key_action_make,
  ssh_dlp_action_free,

  ssh_dlp_public_key_import,
  ssh_dlp_public_key_export,
  ssh_dlp_public_key_free,
  ssh_dlp_public_key_copy,
  ssh_dlp_public_key_derive_param,

  /* Precomputation. */
  ssh_dlp_public_key_precompute,

  /* Private key operations. */
  ssh_dlp_action_init,
  ssh_dlp_private_key_action_define,
  ssh_dlp_private_key_action_generate,
  ssh_dlp_action_free,

  ssh_dlp_private_key_import,
  ssh_dlp_private_key_export,
  ssh_dlp_private_key_free,
  ssh_dlp_private_key_derive_public_key,
  ssh_dlp_private_key_copy,
  ssh_dlp_private_key_derive_param,

  /* Precomputation. */
  ssh_dlp_private_key_precompute
};
