/*
  File: ssh-dsa-user.c

  Authors:
        Mika Kojo <mkojo@ssh.fi>
        Tero T Mononen <tmo@ssh.fi>

  Description:
        Description for how to make DSA keys

  Copyright:
        Copyright (c) 2001 SSH Communications Security Corp, Finland.
        All rights reserved.
*/

#include "sshincludes.h"
#include "sshpk.h"
#include "dlglue.h"
#include "sshrgf.h"
#include "sshcrypt.h"

const SshPkSignature ssh_dl_modp_signature_schemes[] =
{
#ifdef SSHDIST_CRYPT_SHA
  { "dsa-nist-sha1",
    ssh_dlp_dsa_nist,
    &ssh_rgf_std_sha1_def,
    ssh_dlp_dsa_private_key_max_signature_input_len,
    ssh_dlp_dsa_private_key_max_signature_output_len,
    ssh_dlp_dsa_public_key_verify,
    NULL,
    ssh_dlp_dsa_private_key_sign,
    NULL
  },
#endif /* SSHDIST_CRYPT_SHA */
  { NULL }
};

/* Table of all supported encryption schemes for dl-modp keys. */
const SshPkEncryption ssh_dl_modp_encryption_schemes[] =
{
  { NULL }
};

#ifdef SSHDIST_CRYPT_DH

/* Table of all supported diffie-hellman schemes for dl-modp keys. */
const SshPkDiffieHellman ssh_dl_modp_diffie_hellman_schemes[] =
{
  { "plain",
    NULL,
    ssh_dlp_diffie_hellman_exchange_length,
    ssh_dlp_diffie_hellman_shared_secret_length,
    ssh_dlp_diffie_hellman_generate,
    NULL,
    ssh_dlp_diffie_hellman_final,
    NULL,
    ssh_dlp_unified_diffie_hellman_shared_secret_length,
    ssh_dlp_unified_diffie_hellman_final,
    NULL
  },
  { NULL },
};
#endif /* SSHDIST_CRYPT_DH */

/* DLP special actions. */
const SshPkAction ssh_pk_dl_modp_actions[] =
{
  /* key type */
  { SSH_PKF_KEY_TYPE, NULL,
    SSH_PK_FLAG_KEY_TYPE | SSH_PK_FLAG_PRIVATE_KEY |
    SSH_PK_FLAG_PUBLIC_KEY | SSH_PK_FLAG_PK_GROUP,
    SSH_PK_SCHEME_NONE, 0, NULL },

  /* Schemes */
  { SSH_PKF_SIGN, "sign",
    SSH_PK_FLAG_SCHEME | SSH_PK_FLAG_PRIVATE_KEY | SSH_PK_FLAG_PUBLIC_KEY,
    SSH_PK_SCHEME_SIGN,
    sizeof(SshPkSignature),
    ssh_dl_modp_signature_schemes, NULL },

#ifdef SSHDIST_CRYPT_DH
  { SSH_PKF_DH, "dh",
    SSH_PK_FLAG_SCHEME | SSH_PK_FLAG_PRIVATE_KEY | SSH_PK_FLAG_PUBLIC_KEY |
    SSH_PK_FLAG_PK_GROUP,
    SSH_PK_SCHEME_DH,
    sizeof(SshPkDiffieHellman),
    ssh_dl_modp_diffie_hellman_schemes, NULL },
#endif /* SSHDIST_CRYPT_DH */

  /* Handling of keys and parameters. */

  /* prime-p (private_key, public_key, pk_group versions) */
  { SSH_PKF_PRIME_P, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_private_key_put,
    ssh_dlp_action_private_key_get },

  { SSH_PKF_PRIME_P, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PUBLIC_KEY | SSH_PK_FLAG_LIST,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_public_key_put,
    ssh_dlp_action_public_key_get },

  { SSH_PKF_PRIME_P, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PK_GROUP | SSH_PK_FLAG_LIST,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_param_put,
    ssh_dlp_action_param_get },

  /* generator-g (private_key, public_key, pk_group versions) */
  { SSH_PKF_GENERATOR_G, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_private_key_put,
    ssh_dlp_action_private_key_get },

  { SSH_PKF_GENERATOR_G, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PUBLIC_KEY | SSH_PK_FLAG_LIST,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_public_key_put,
    ssh_dlp_action_public_key_get },

  { SSH_PKF_GENERATOR_G, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PK_GROUP | SSH_PK_FLAG_LIST,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_param_put,
    ssh_dlp_action_param_get },

  /* prime-q (private_key, public_key, pk_group versions) */
  { SSH_PKF_PRIME_Q, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_private_key_put,
    ssh_dlp_action_private_key_get },

  { SSH_PKF_PRIME_Q, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PUBLIC_KEY | SSH_PK_FLAG_LIST,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_public_key_put,
    ssh_dlp_action_public_key_get },

  { SSH_PKF_PRIME_Q, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PK_GROUP | SSH_PK_FLAG_LIST,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_param_put,
    ssh_dlp_action_param_get },

  /* secret-x (private_key) */
  { SSH_PKF_SECRET_X, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_private_key_put,
    ssh_dlp_action_private_key_get },

  /* public-y (private_key, public_key) */
  { SSH_PKF_PUBLIC_Y, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_private_key_put,
    ssh_dlp_action_private_key_get },

  { SSH_PKF_PUBLIC_Y, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PUBLIC_KEY | SSH_PK_FLAG_LIST,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_public_key_put,
    ssh_dlp_action_public_key_get },

  /* size (private_key, public_key, pk_group) */
  { SSH_PKF_SIZE, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_private_key_put,
    ssh_dlp_action_private_key_get },

  { SSH_PKF_SIZE, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PUBLIC_KEY | SSH_PK_FLAG_LIST,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_public_key_put,
    ssh_dlp_action_public_key_get },

  { SSH_PKF_SIZE, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PK_GROUP | SSH_PK_FLAG_LIST,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_param_put,
    ssh_dlp_action_param_get },

  /* randomizer entropy (private_key, public_key, pk_group) */
  { SSH_PKF_RANDOMIZER_ENTROPY, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_private_key_put,
    ssh_dlp_action_private_key_get },

  { SSH_PKF_RANDOMIZER_ENTROPY, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PUBLIC_KEY | SSH_PK_FLAG_LIST,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_public_key_put,
    ssh_dlp_action_public_key_get },

  { SSH_PKF_RANDOMIZER_ENTROPY, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PK_GROUP | SSH_PK_FLAG_LIST,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_param_put,
    ssh_dlp_action_param_get },

  /* Predefined group. */
  { SSH_PKF_PREDEFINED_GROUP, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_private_key_put,
    ssh_dlp_action_private_key_get },

  { SSH_PKF_PREDEFINED_GROUP, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PUBLIC_KEY | SSH_PK_FLAG_LIST,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_public_key_put,
    ssh_dlp_action_public_key_get },

  { SSH_PKF_PREDEFINED_GROUP, NULL,
    SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PK_GROUP | SSH_PK_FLAG_LIST,
    SSH_PK_SCHEME_NONE, 0,
    NULL,
    ssh_dlp_action_param_put,
    ssh_dlp_action_param_get },

  /* End of list. */
  { SSH_PKF_END }
};

const SshPkType ssh_pk_dl_modp =
{
  "dl-modp",
  ssh_pk_dl_modp_actions,

  /* Basic group operations. */
  ssh_dlp_action_init,
  ssh_dlp_param_action_make,
  ssh_dlp_action_free,

  ssh_dlp_param_import,
  ssh_dlp_param_export,
  ssh_dlp_param_free,
  ssh_dlp_param_copy,
  ssh_dlp_param_get_predefined_groups,

  /* Precomputation. */
  ssh_dlp_param_precompute,

  /* Randomizer generation. */
  ssh_dlp_param_count_randomizers,
  ssh_dlp_param_generate_randomizer,
  ssh_dlp_param_export_randomizer,
  ssh_dlp_param_import_randomizer,

  /* Public key operations. */
  ssh_dlp_action_public_key_init,
  ssh_dlp_public_key_action_make,
  ssh_dlp_action_free,

  ssh_dlp_public_key_import,
  ssh_dlp_public_key_export,
  ssh_dlp_public_key_free,
  ssh_dlp_public_key_copy,
  ssh_dlp_public_key_derive_param,

  /* Precomputation. */
  ssh_dlp_public_key_precompute,

  /* Private key operations. */
  ssh_dlp_action_init,
  ssh_dlp_private_key_action_define,
  NULL,
  ssh_dlp_action_free,

  ssh_dlp_private_key_import,
  ssh_dlp_private_key_export,
  ssh_dlp_private_key_free,
  ssh_dlp_private_key_derive_public_key,
  ssh_dlp_private_key_copy,
  ssh_dlp_private_key_derive_param,

  /* Precomputation. */
  ssh_dlp_private_key_precompute
};
