/*
  File: ssh-rsa-maker.c

  Authors:
        Mika Kojo <mkojo@ssh.fi>
        Tero T Mononen <tmo@ssh.fi>

  Description:
        Description for how to make RSA keys

  Copyright:
        Copyright (c) 2001 SSH Communications Security Corp, Finland.
        All rights reserved.
*/

#include "sshincludes.h"
#include "sshpk.h"
#include "rsa.h"
#include "sshrgf.h"
#include "sshcrypt.h"

#ifdef WITH_RSA

extern const SshPkSignature ssh_if_modn_signature_schemes[];
extern const SshPkEncryption ssh_if_modn_encryption_schemes[];
extern const SshPkAction ssh_pk_if_modn_actions[];

const SshPkType ssh_pk_if_modn_generator =
  {
    "if-modn",
    ssh_pk_if_modn_actions,

    /* No group operations available. */
    NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL,
    NULL,

    /* Basic public key operations. */
    ssh_rsa_public_key_init_action,
    ssh_rsa_public_key_make_action,
    ssh_rsa_private_key_init_ctx_free,

    ssh_rsa_public_key_import,
    ssh_rsa_public_key_export,
    ssh_rsa_public_key_free,
    ssh_rsa_public_key_copy,
    NULL, NULL,

    /* Basic private key operations. */
    ssh_rsa_private_key_init_action,
    ssh_rsa_private_key_define_action,
    ssh_rsa_private_key_generate_action,
    ssh_rsa_private_key_init_ctx_free,

    ssh_rsa_private_key_import,
    ssh_rsa_private_key_export,
    ssh_rsa_private_key_free,
    ssh_rsa_private_key_derive_public_key,
    ssh_rsa_private_key_copy,
    NULL, NULL,
  };
#endif /* WITH_RSA */

/* eof */
