/*

sshproxykey.h

Author: Vesa Suontama <vsuontam@ssh.fi>

Copyright (c) 1999-2001 SSH Communications Security Corp, Helsinki, Finland
              All rights reserved

  Interface for creating proxy keys (e.g) creating keys with a callback 
  that is called when crypto-operation is required. 

*/


#include "sshcrypt.h"

#ifndef SSH_PROXYKEY_H_DEFINED
#define SSH_PROXYKEY_H_DEFINED

/* A callback of this type must be called by the key operation callback 
   to complete the asynchronous operation. If the operation was 
   succesfull, the operated data contains the operated data. Otherwise
  the operated data must be set to NULL. */
typedef void (*SshProxyKeyReplyCB)(const unsigned char *operated_data,
                                   size_t data_len,
                                   void *reply_context);

/* A callback of this type must be provider for ssh_private_key_create_proxy. 
   The callback is called to 'operate' on the provided data. When data is 
   operated, the function must call the reply_cb to continue the asynchronous
   operation. Reply callback must be called with NULL data is the operation
   could not be completed. 

   If this callback is asynchronous it has to return operation handle, 
   which can be used to cancel the operation. 
*/
typedef SshOperationHandle (*SshProxyKeyOpCB)(const unsigned char *data,
                                              size_t data_len,
                                              SshProxyKeyReplyCB reply_cb,
                                              void *reply_context,
                                              void *context);
/* Create a proxy key. The returned key is of type key_type, 
   which must be "if-modn" (which is RSA) at the moment. 

   Calls the operation_cb with the data that is being operated when 
   the library is performing crypto operations with the returned proxy key. 

   The proxy key is freed with ssh_private_key_free. It is error to free a key
   that is currently being used. 
*/
SshPrivateKey ssh_private_key_create_proxy(const char *key_type, 
                                           SshUInt32 size_in_bits,
                                           SshProxyKeyOpCB operation_cb,
                                           void *context);

#endif /* SSH_PROXYKEY_H_DEFINED */

