/*

  sshrgf.h

  Author: Mika Kojo <mkojo@ssh.fi>

  Copyright (c) 1999-2001 SSH Communications Security, Finland
  All rights reserved.

  Created Thu Dec  9 23:42:00 1999.

  */

/*
  Redundancy generating functions for public key cryptosystems.
 */

#ifndef SSHRGF_H
#define SSHRGF_H

typedef struct SshRGFDefRec *SshRGFDef, SshRGFDefStruct;

typedef enum
{
  SSH_RGF_OK,
  SSH_RGF_OP_FAILED,
  SSH_RGF_OP_INCOMPLETE
} SshRGFStatus;

SshRGFHash ssh_rgf_hash_allocate(const SshRGFDefStruct *rgf_def);
void ssh_rgf_hash_free(SshRGFHash hash);
size_t ssh_rgf_hash_digest_length(SshRGFHash hash);

/* Pad for encryption. This function frees the hash. */
SshRGFStatus
ssh_rgf_hash_encrypt(SshRGFHash             hash,
                     const unsigned char   *msg,
                     size_t                 msg_len,
                     unsigned char         *output_msg,
                     size_t                 output_msg_len);

/* Pad for decryption. This function frees the hash. */
SshRGFStatus
ssh_rgf_hash_decrypt(SshRGFHash             hash,
                     const unsigned char   *decrypted_msg,
                     size_t                 decrypted_msg_len,
                     size_t                 max_output_msg_len,
                     unsigned char        **output_msg,
                     size_t                *output_msg_len);

/* Pad for signature. This function frees the hash. */
SshRGFStatus
ssh_rgf_hash_sign(SshRGFHash                hash,
                  unsigned char            *output_msg,
                  size_t                    output_msg_len);

/* Pad for verification. This function frees the hash. */
SshRGFStatus
ssh_rgf_hash_verify(SshRGFHash             hash,
                    const unsigned char   *decrypted_signature,
                    size_t                 decrypted_signature_len,
                    size_t                 max_output_msg_len,
                    unsigned char        **output_msg,
                    size_t                *output_msg_len);


/* Definition structures. */

#ifdef SSHDIST_CRYPT_SHA
extern const SshRGFDefStruct ssh_rgf_pkcs1_sha1_def;
extern const SshRGFDefStruct ssh_rgf_pkcs1v2_sha1_def;
extern const SshRGFDefStruct ssh_rgf_std_sha1_def;
extern const SshRGFDefStruct ssh_rgf_pkcs1_nopad_sha1_def;
#endif /* SSHDIST_CRYPT_SHA */

#ifdef SSHDIST_CRYPT_MD5
extern const SshRGFDefStruct ssh_rgf_pkcs1_md5_def;
extern const SshRGFDefStruct ssh_rgf_pkcs1v2_md5_def;
extern const SshRGFDefStruct ssh_rgf_std_md5_def;
extern const SshRGFDefStruct ssh_rgf_pkcs1_nopad_md5_def;
#endif /* SSHDIST_CRYPT_MD5 */







extern const SshRGFDefStruct ssh_rgf_pkcs1_none_def;
extern const SshRGFDefStruct ssh_rgf_pkcs1v2_none_def;
extern const SshRGFDefStruct ssh_rgf_dummy_def;

#endif /* SSHRGF_H */
