/*

  gentest.c

  Author: Mika Kojo <mkojo@ssh.fi>

  Copyright (C) 1996, 2000, 2001 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  Created: Fri Nov  1 05:37:55 1996 [mkojo]

  Testing those gen- prefixed files.

  */

/*
 * $Id: t-gentest.c,v 1.6 2001/10/19 12:56:16 tmo Exp $
 * $Log: t-gentest.c,v $ * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * $EndLog$
 */

#include "sshincludes.h"
#include "sshcryptocore/namelist.h"
#include "sshcrypt.h"
#include "sshtimemeasure.h"
#include "readfile.h"
#include "sshmp.h"
#include "sshdsprintf.h"
#include "sshgetopt.h"
#include "sshenum.h"
#include "t-gentest.h"


/* Location for the test script files, derived from environment
   variable srcdir (from automake), or "." if the variable was not
   set. */
char *srcpath = NULL;
/* Temporary; concatenation of srcpath and the script filename for
   current test module. */
char filename[128];

Boolean verbose = FALSE;

/******************** Misc. routines. ************************/

void hex_dump(unsigned char *cp, size_t len)
{
  int i;
  for (i = 0; i < len; i++)
    {
      printf("%02x", cp[i]);
    }
}

void tstart(SshTimeMeasure tmit, char *fmt, ...)
{
  va_list ap;
  char buffer[1024];

  va_start(ap, fmt);
  ssh_vsnprintf(buffer, 1024, fmt, ap);
  va_end(ap);

  if (verbose) printf("Timing start: %s\n", buffer);

  ssh_time_measure_reset(tmit);
  ssh_time_measure_start(tmit);
}

void tstop(SshTimeMeasure tmit, char *fmt, ...)
{
  va_list ap;
  char buffer[1024];
  ssh_time_measure_stop(tmit);

  va_start(ap, fmt);
  ssh_vsnprintf(buffer, 1024, fmt, ap);
  va_end(ap);

  printf("@ %6.3f sec : %s\n",
         (double) ssh_time_measure_get(tmit,
                                       SSH_TIME_GRANULARITY_MILLISECOND) /
         1000.0,
         buffer);
}


void tstartn(SshTimeMeasure tmit, int total, char *fmt, ...)
{
  va_list ap;
  char buffer[1024];

  if (total > 0)
    {
      ssh_time_measure_reset(tmit);
      ssh_time_measure_start(tmit);
      return;
    }

  va_start(ap, fmt);
  ssh_vsnprintf(buffer, 1024, fmt, ap);
  va_end(ap);

  if (verbose) printf("Timing start: %s\n", buffer);

  ssh_time_measure_reset(tmit);
  ssh_time_measure_start(tmit);
}

int tstopn(SshTimeMeasure tmit, int total, char *fmt, ...)
{
  va_list ap;
  char buffer[1024];
  ssh_time_measure_stop(tmit);

  /* Just check that the operation takes at least some time. */
  if (ssh_time_measure_get(tmit, SSH_TIME_GRANULARITY_MILLISECOND) < 100.0)
    {
      return 1;
    }

  va_start(ap, fmt);
  ssh_vsnprintf(buffer, 1024, fmt, ap);
  va_end(ap);

  printf("@ %6.3f sec / %u ops = %6.4f sec / op: %s\n",
         (double) ssh_time_measure_get(tmit,
                                       SSH_TIME_GRANULARITY_MILLISECOND) /
         1000.0, total,
         ((double) ssh_time_measure_get(tmit,
                                       SSH_TIME_GRANULARITY_MILLISECOND) /
         1000.0)/(double)total,
         buffer);
  return 0;
}

/****************************** Main ***************************************/

#define TEST_RANDOM (1 << 0)
#define TEST_HASH   (1 << 1)
#define TEST_MAC    (1 << 2)
#define TEST_CIPHER (1 << 3)
#define TEST_PKCS   (1 << 4)

const SshKeywordStruct t_gentest_test_flags[] =
  {
    { "all", TEST_RANDOM|TEST_HASH|TEST_MAC|TEST_CIPHER|TEST_PKCS },
    { "random", TEST_RANDOM },
    { "hash", TEST_HASH },
    { "mac", TEST_MAC },
    { "cipher", TEST_CIPHER },
    { "pkcs", TEST_PKCS },
    { NULL }
  };
const SshKeywordStruct t_gentest_cipher_flags[] =
  {
    { "all", MODE_ECB|MODE_CBC|MODE_CFB|MODE_OFB },
    { "ecb", MODE_ECB },
    { "cbc", MODE_CBC },
    { "cfb", MODE_CFB },
    { "ofb", MODE_OFB }
  };

/* Main function that calls all the tests above. */

int main(int argc, char *argv[])
{
  int opt;
  int tests = 0L;
  int cipher_flags = MODE_CBC;

  while ((opt = ssh_getopt(argc, argv, "s:c:t:v:", NULL)) != EOF)
    {
      switch (opt)
        {
        case 'v':
          verbose = TRUE;
          break;
        case 't':
          tests |= ssh_find_keyword_number(t_gentest_test_flags, ssh_optarg);
          break;
        case 'c':
          cipher_flags |=
            ssh_find_keyword_number(t_gentest_cipher_flags, ssh_optarg);
          break;
        case 's':
          srcpath = ssh_optarg;
          break;
        default:
          fprintf(stderr, "usage: t-gentest [-v] [-t testname]* [-c mode]*\n");
          exit(1);
        }
    }

  if (!tests)
    tests = TEST_RANDOM|TEST_HASH|TEST_MAC|TEST_CIPHER|TEST_PKCS;

  if ((srcpath = getenv("srcdir")) == NULL)
    {
      ssh_warning("$srcdir not set, defaulting script file location to `.'");
      srcpath = ".";
    }


  printf("\nCrypto Library testing.\n");

#ifndef SSH_USE_CYCLE_COUNTING
  printf("(Cycle counting not available -- cycles/bytes fields are hence invalid.)\n");
#endif /* SSH_USE_CYCLE_COUNTING */

  if (tests & TEST_RANDOM)
    {
      printf("\nRandom number test...\n");
      test_random(0L);
    }

#ifdef SSHDIST_CRYPT_GENHASH
   if (tests & TEST_HASH)
     {
       printf("\nHash test...\n");
       test_hash(0L);
     }
#endif /* SSHDIST_CRYPT_GENHASH */

#ifdef SSHDIST_CRYPT_GENMAC
   if (tests & TEST_MAC)
     {
       printf("\nMac test...\n");
       test_mac(0L);
     }
#endif /* SSHDIST_CRYPT_GENMAC */

#ifdef SSHDIST_CRYPT_GENCIPH
  if (tests & TEST_CIPHER)
    {
      printf("\nCipher test...\n");
      test_cipher(cipher_flags);
    }
#endif /* SSHDIST_CRYPT_GENCIPH */

#ifdef SSHDIST_CRYPT_GENPKCS
  if (tests & TEST_PKCS)
    {
      printf("\nPkcs test...\n");
      /* Register some key types. */
      ssh_pk_provider_register(&ssh_pk_if_modn_generator);
      ssh_pk_provider_register(&ssh_pk_dl_modp_generator);







      test_pkcs(0L);
    }
#endif /* SSHDIST_CRYPT_GENPKCS */

  ssh_random_free();
  ssh_debug_uninit();

  exit(0);
}
