/*
 * Authors: Tero Kivinen  <kivinen@ssh.com>
 *          Sami Lehtinen <sjl@ssh.com>
 *
 * Copyright (c) 1996-2001 SSH Communications Security Corp, Helsinki, Finland
 * All rights reserved.
 */
/*
 *        Program: sshreadline test
 *        $Source: /ssh/CVS/src/lib/sshreadline/tests/t-readline.c,v $
 *        $Author: sjl $
 *
 *        Creation          : 06:45 Mar 14 1997 kivinen
 *        Last Modification : Mon Aug 13 02:19:09 2001 sjl
 *        Last check in     : $Date: 2001/08/13 03:49:05 $
 *        Revision number   : $Revision: 1.9 $
 *        State             : $State: Exp $
 *        Version           : 1.4
 *        
 *
 *        Description       : Readline library test program
 *
 *
 *        $Log: t-readline.c,v $ *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        
 *        $EndLog$
 */

#include "sshincludes.h"
#include "sshreadline.h"
#include "ssheloop.h"
#include "sshfdstream.h"
#include "sshgetopt.h"

#define SSH_DEBUG_MODULE "TReadLine"

typedef struct TRLCtxRec
{
  SshStream stream;
  SshReadLineCtx rl;
  char *prompt;
  char *line;
} *TRLCtx, TRLCtxStruct;

void cb(const char *line, void *context)
{
  TRLCtx ctx = (TRLCtx)context;
  
  ssh_stream_write(ctx->stream, "\n", 1);
  fprintf(stderr, "line = `%s'\n", line);
  if (!line || strcmp(line, "quit") == 0)
    {
      ssh_readline_eloop_unitialize(ctx->rl);
      ssh_stream_destroy(ctx->stream);
      ssh_xfree(ctx->prompt);
      ssh_xfree(ctx->line);
      ssh_xfree(ctx);
      return;
    }
  ssh_xfree(ctx->line);
  ssh_readline_eloop(ctx->prompt, NULL, ctx->rl, cb, ctx);
}

int main(int argc, char **argv)
{
  char *line = NULL, *prompt = "*> ";
  int opt;
  Boolean eloop = FALSE;
  
  while ((opt = ssh_getopt(argc, argv, "p:i:ed:", NULL)) != EOF)
    {
      switch (opt)
        {
        case 'p': prompt = ssh_optarg; break;
        case 'd': ssh_debug_set_level_string(ssh_optarg); break;
        case 'i': line = ssh_xstrdup(ssh_optarg); break;
        case 'e': eloop = TRUE; break;
        default:
          fprintf(stderr, "%s: usage %s [-e] [-d debug-level-string] "
                  "[-p prompt] [-i initial-data]\n",
                  argv[0], argv[0]);
          exit(1);
        }
    }

  if (eloop)
    {
      TRLCtx ctx = ssh_xcalloc(1, sizeof(*ctx));

      ssh_event_loop_initialize();

      ctx->stream = ssh_stream_fd_stdio();
      SSH_ASSERT(ctx->stream);

      ctx->rl = ssh_readline_eloop_initialize(ctx->stream);
      SSH_ASSERT(ctx->rl);

      ctx->prompt = ssh_xstrdup(prompt);
      ctx->line = line ? ssh_xstrdup(line) : NULL;
      ssh_readline_eloop(prompt, line, ctx->rl, cb, ctx);
      ssh_event_loop_run();
      ssh_event_loop_uninitialize();
    }
  else
    {
      ssh_readline(prompt, &line, fileno(stdin), fileno(stdout));
      fprintf(stderr, "\nline = %s\n", line);
    }
  return 0;
}
