/*

  sshadt_assoc.h

  Author: Antti Huima <huima@ssh.fi>

  Copyright (c) 1999 SSH Communications Security, Finland
  All rights reserved.

  Created Fri Sep 24 16:45:01 1999.

  */

#ifndef SSH_ADT_ASSOC_H_INCLUDED
#define SSH_ADT_ASSOC_H_INCLUDED

#include "sshadt.h"

/************************************************************** Associations */

/* Here `domain' must be of type SSH_ADT_MAP. */
Boolean ssh_adt_associate_unimap(SshADTContainer domain, SshADTContainer range);

/* Here both `c1' and `c2' must be of type SSH_ADT_MAP. */
Boolean ssh_adt_associate_bimap(SshADTContainer c1, SshADTContainer c2);

void ssh_adt_unassociate(SshADTContainer c1, SshADTContainer c2);

#endif /* SSH_ADT_ASSOC_H_INCLUDED */
