/*

  sshadt_intmap.h

  Author: Antti Huima <huima@ssh.fi>

  Copyright (c) 2000 SSH Communications Security, Finland
  All rights reserved.

  Created Wed Sep 20 23:18:48 2000.

  */

#ifndef SSHADT_INTMAP_H_INCLUDED
#define SSHADT_INTMAP_H_INCLUDED

#include "sshadt.h"
#include "sshadt_map.h"


SshADTContainer ssh_adt_create_intmap(void);

SshADTHandle ssh_adt_intmap_add(SshADTContainer c, SshUInt32 key, void *value);

void ssh_adt_intmap_remove(SshADTContainer c, SshUInt32 key);

void ssh_adt_intmap_set(SshADTContainer c, SshUInt32 key, void *value);

void *ssh_adt_intmap_get(SshADTContainer c, SshUInt32 key);

Boolean ssh_adt_intmap_exists(SshADTContainer c, SshUInt32 key);

#endif /* !SSHADT_INTMAP_H_INCLUDED */
