/*

  sshadt_list_i.h

  Author: Antti Huima <huima@ssh.fi>

  Copyright (c) 1999 SSH Communications Security, Finland
  All rights reserved.

  Created Thu Sep  9 11:54:09 1999.

  */

#ifndef SSHADT_LIST_I_H_INCLUDED
#define SSHADT_LIST_I_H_INCLUDED

#include "sshadt.h"
#include "sshadt_i.h"

/* SshADTListNodeStruct == SshADTHeaderStruct.  (abstraction) */
typedef struct SshADTListNodeRec {
  struct SshADTListNodeRec *next, *prev;
} SshADTListNodeStruct;

/* SshADTListENode is a tuple of header and object.  See also
   documentation for NEED_EXTRA_NODE flag in sshadt_i.h.  */
typedef struct {
  void *object;
  SshADTListNodeStruct i;
} SshADTListENodeStruct;

/* SshADTListRoot is written the container_specific field of the
   generic container structure, and contains pointers to the list
   ends.  */
typedef struct {
  SshADTListNodeStruct *first_node, *last_node;
} SshADTListRootStruct;

extern SshADTStaticData ssh_adt_list_static_data;

#define SSH_ADT__LIST_INSERT_TO_END(root, node)                               \
do                                                                            \
{                                                                             \
  SshADTListNodeStruct *__last = (root)->last_node;                           \
  node->next = NULL;                                                          \
  if (__last == NULL)                                                         \
    {                                                                         \
      node->prev = NULL;                                                      \
      (root)->last_node = (root)->first_node = node;                          \
    }                                                                         \
  else                                                                        \
    {                                                                         \
      node->prev = __last; __last->next = node;                               \
      (root)->last_node = node;                                               \
    }                                                                         \
}                                                                             \
while(0)

#define SSH_ADT__LIST_INSERT_TO_BEGINNING(root, node)                         \
do                                                                            \
{                                                                             \
  SshADTListNodeStruct *__first = (root)->first_node;                         \
  node->prev = NULL;                                                          \
  if (__first == NULL)                                                        \
    {                                                                         \
      node->next = NULL;                                                      \
      (root)->last_node = (root)->first_node = node;                          \
    }                                                                         \
  else                                                                        \
    {                                                                         \
      node->next = __first; __first->prev = node;                             \
      (root)->first_node = node;                                              \
    }                                                                         \
}                                                                             \
while(0)

#endif /* SSHADT_LIST_I_H_INCLUDED */
