/*

  sshadt_map.h

  Author: Antti Huima <huima@ssh.fi>

  Copyright (c) 1999, 2000 SSH Communications Security, Finland
  All rights reserved.

  Created Tue Sep 14 09:26:13 1999.

  */

#ifndef SSH_ADT_MAP_H_INCLUDED
#define SSH_ADT_MAP_H_INCLUDED

#include "sshadt.h"


extern const SshADTContainerType ssh_adt_map_type;

#define SSH_ADT_MAP (ssh_adt_map_type)


/* Use this instead of SshADTHeaderStruct if you want to save 8 bytes
   of memory per header.  */
typedef struct {
  Boolean a; void *b, *c;
} SshADTMapHeaderStruct;

/* Since mapping keys to values is already taken care of by the
   standard interface, the only thing we need to do here is provide a
   function that notifies the container of changed hash values: if an
   object has changed, the hash value needs to be recomputed.  */
Boolean ssh_adt_map_changed(SshADTContainer map,
                            SshADTHandle object_with_changed_contents);


/************************************************ Some useful Hash functions */

/* Take the contents of an object into account, not only the pointer.
   Cyclically shift val so that repeating values in obj have more
   impact on the distribution.  */
#define SSH_ADT_MK_SOME_HASH(name, key_size)                                  \
SshUInt32 name(const void *obj, void *context)                                \
{                                                                             \
  SshUInt32 val = (SshUInt32)obj;                                             \
                                                                              \
  for (i = 0; i < key_size; i++)                                              \
    {                                                                         \
      val = (val << 3) | (val & 7);                                           \
      val ^= *((unsigned char *)obj++);                                       \
    }                                                                         \
                                                                              \
  return val;                                                                 \
}


#endif /* SSH_ADT_MAP_H_INCLUDED */





