/*

  sshadt_priority_heap.h

  Author: Kenneth Oksanen <cessu@ssh.fi>

  Copyright (c) 2001 SSH Communications Security, Finland
  All rights reserved.

  */

/* Priority heaps behave like priority queues but it is additionally
   possible to remove arbitrary items from the middle of the heap, and
   it is possible to move all items from one priority queue to
   another.  All of those operations take logarithmic time. */

#ifndef SSH_ADT_PRIORITY_HEAP_INCLUDED
#define SSH_ADT_PRIORITY_HEAP_INCLUDED

#include "sshadt.h"

extern const SshADTContainerType ssh_adt_priority_heap_type;

#define SSH_ADT_PRIORITY_HEAP (ssh_adt_priority_heap_type)

/* Move all objects from the priority heap 'from' to the priority heap
   'to'.  This is accomplished in logarithmic time. */
void ssh_adt_priority_heap_move(SshADTContainer to, SshADTContainer from);

#endif /* SSH_ADT_PRIORITY_HEAP_INCLUDED */
