/*

  sshadt_avltree.h

  Author: Matthias Fischmann <fis@ssh.fi>

  Copyright (c) 2000 SSH Communications Security, Finland
  All rights reserved.

  Created Thu Mar 22 15:33:24 2001.


  The range container can be used to store, merge and shrink intervals
  of arbitrary delimiter type.  It shares most of its code with avl
  trees (see there).

  The basic philosophy is as follows: a node N in the tree represents
  the lower bound of the interval [N, M), where M is the next bigger
  node.  Each interval is associated with a value via
  ssh_adt_map_lookup and ssh_adt_map_attach.  In its simplest form,
  NULL or (void *)1 can be attached to every node to simply describe
  set membership of all elements in the interval not, but more complex
  situations can be modeled as well.  There are two restrictions to
  the semantics of values:

   - Two values are equal if their pointers cast to (void *) are
     equal.  (There is no callback for comparing map values.)

   - By definition, (-inf, K), where K is the smallest tree element,
     always maps to NULL.

  Note that this model implies that the set of intervals in a range
  container always covers the entire range of all possible values.
  always (-inf to +inf), independent of the value type.

  The lower-level interface recycles basically all standard methods:

   - A new interval is inserted by giving the lower bound, the higher
     bound is implicit by the tree: it's simply the next larger node.
     Discarding objects works as expected.

   - Mapping is similar to the mapping methods for hash tables.

  To get a handle to the interval that contains an arbitrary value
  (not necessarily in the tree), a new function is defined:

   - ssh_adt_get_handle_to_glb returns a handle to the greatest lower
     bound (SSH_ADT_INVALID for -inf).

  Merging: if two neighbouring intervals map to the same value, the
  higher one is discarded.  Merging happens iff

   - a node is deleted or

   - a value is mapped to a range.

  CAUTION: because of implicit mergings, not only deletion but also
  mapping an interval handle to a value invalidates the handle and all
  object pointers obtained previously.  during merging, all nodes that
  must die are killed with ssh_adt_delete; if the values attached to
  the nodes need to be deleted, the callbacks must be instantiated
  properly by the user.

  */

#ifndef SSH_ADT_RANGES_H_INCLUDED
#define SSH_ADT_RANGES_H_INCLUDED

#include "sshadt.h"

extern const SshADTContainerType ssh_adt_ranges_type;

#define SSH_ADT_RANGES (ssh_adt_ranges_type)

SshADTHandle ssh_adt_get_handle_to_glb(SshADTContainer c, void *o);

#endif /* SSH_ADT_RANGES_H_INCLUDED */
