/*

  sshadt_strmap.h

  Author: Antti Huima <huima@ssh.fi>

  Copyright (c) 2000 SSH Communications Security, Finland
  All rights reserved.

  Created Wed Sep 20 04:57:29 2000.

  */

#ifndef SSHADT_STRMAP_H_INCLUDED
#define SSHADT_STRMAP_H_INCLUDED

#include "sshadt.h"
#include "sshadt_map.h"


SshADTContainer ssh_adt_create_strmap(void);

SshADTHandle ssh_adt_strmap_add(SshADTContainer c, const char *key,
                                void *value);

void ssh_adt_strmap_remove(SshADTContainer c, const char *key);

void ssh_adt_strmap_set(SshADTContainer c, const char *key, void *value);

void *ssh_adt_strmap_get(SshADTContainer c, const char *key);

Boolean ssh_adt_strmap_exists(SshADTContainer c, const char *key);

#endif /* !SSHADT_STRMAP_H_INCLUDED */
