/*

  sshadt_strmap.h

  Author: Matthias Fischmann <fis@ssh.fi

  Copyright (c) 2000 SSH Communications Security, Finland
  All rights reserved.

  Created Tue Apr 24 09:55:38 EEST 2001

  */

#ifndef SSHADT_XMAP_H_INCLUDED
#define SSHADT_XMAP_H_INCLUDED

#include "sshadt.h"
#include "sshadt_map.h"


/************************************************ The abstract map interface */

/* add a new element (using ssh_adt_duplicate or ssh_adt_put,
   depending on memory allocation mode).  fails if key exists. */
SshADTHandle ssh_adt_xmap_add(SshADTContainer c, void *key, void *value);

/* (all the following methods use get_handle_to_equal to compute key
   handles, so take care that the compare callback works.) */

/* remove an element (call to ssh_adt_delete).  if key does exist,
   remove simply does nothing.  does nothing if key does not exist. */
void ssh_adt_xmap_remove(SshADTContainer c, void *key);

/* modify existing element.  fails if key does not exist.  the object
   previously attached to key will be freed during this operation. */
void ssh_adt_xmap_set(SshADTContainer c, void *key, void *value);

/* look up existing element.  returns NULL if key does not exist. */
void *ssh_adt_xmap_get(SshADTContainer c, void *key);

/* existencial predicate. */
Boolean ssh_adt_xmap_exists(SshADTContainer c, void *key);


#endif /* SSHADT_XMAP_H_INCLUDED */
