/*

  sshmalloci.h

  Author: Santeri Paavolainen <santtu@ssh.com>

  Copyright (c) 2001 SSH Communications Security
  All rights reserved

  Definitions for some of the internal malloc routines. These *must*
  not be used on any code relying upon published SSH API.

*/

#ifndef SSH_MALLOCI_H
#define SSH_MALLOCI_H

void *_ssh_malloc(size_t size);
void *_ssh_realloc(void *ptr, size_t old_size, size_t new_size);
void *_ssh_calloc(size_t nitems, size_t size);
void *_ssh_strdup(const void *p);
void *_ssh_memdup(const void *p, size_t len);
void _ssh_free(void *ptr);

#endif /* SSH_MALLOCI_H */
