/*

  sshobstack.h
  
  Author: Mika Kojo <mkojo@ssh.fi>

  Copyright (C) 1997 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  Created: Sat Feb 15 20:02:47 1997 [mkojo]

  Mallocation to a context, with out possibility to free specific elements.

  */

/*
 * $Id: sshobstack.h,v 1.4 2001/04/24 18:29:54 fis Exp $
 * $Log: sshobstack.h,v $ * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * $EndLog$
 */

#ifndef CMALLOC_H
#define CMALLOC_H

typedef struct SshObStackContextRec *SshObStackContext;

/* Initialize the mallocation context. This same context can be used for
   all data, that is rather static i.e. need not to be freed separately.
   Of course this method can be used for allocation in general, but it is
   not recommended. */

SshObStackContext ssh_obstack_create(void);

/* Free all data allocated using this particular context. This function
   makes all allocated space invalid. */

void ssh_obstack_destroy(SshObStackContext context);

/* Allocate byte buffer of length size from the context. If enough
   memory is not available the function will not return. */

/* Allocated data is not aligned. */
unsigned char *ssh_obstack_alloc_unaligned(SshObStackContext context,
                                           size_t size);

/* Allocated data is aligned to sizeof(unsigned long).
   XXX This should make allocation for structures possible (need to
       verify this). */
void *ssh_obstack_alloc(SshObStackContext context, size_t size);

#endif /* CMALLOC_H */
