/*
  File: sshxmalloc.c

  Authors:
        Tero T Mononen <tmo@ssh.fi>

  Description:
        Versions of malloc and friends that check their results, and
        never return failure (they call fatal if they encounter an
        error).

  Copyright:
        Copyright (c) 2001 SSH Communications Security Corp, Finland.
        All rights reserved.
*/

#include "sshincludes.h"
#include "sshmalloc_i.h"

/* Note, these functions are multithread safe, thus they can not call
   any MT-unsafe routines, notably debugging macros. */

#undef SSH_DEBUG_MODULE












void *ssh_xmalloc(size_t size)
{
  void *ptr;

  if ((ptr = _ssh_malloc(size)) == NULL)
    ssh_fatal("ssh_xmalloc: Can not allocate %ld bytes of memory.", size);
  return ptr;
}

void *ssh_xcalloc(size_t nitems, size_t size)
{
  void *ptr;

  if ((ptr = _ssh_calloc(nitems, size)) == NULL)
    ssh_fatal("ssh_xcalloc: Can not allocate %ld bytes of memory.", size);
  return ptr;
}

void *ssh_xrealloc(void *ptr, size_t new_size)
{
  void *new_ptr = NULL;

  if ((new_ptr = _ssh_realloc(ptr, 0, new_size)) == NULL)
    ssh_fatal("ssh_xrealloc: Can not allocate %ld bytes of memory.", new_size);
  return new_ptr;
}

void ssh_xfree(void *ptr)
{
  _ssh_free(ptr);
}

void *ssh_xstrdup(const void *p)
{
  char *cp;

  /* XXX. Mononen changed the semantics of xmemdup, check from
     him what should be done, if NULL, 0 is given in. */
  if (p == NULL)
    ssh_fatal("ssh_xstrdup: Can not duplicate a NULL string.");

  if ((cp = _ssh_strdup(p)) == NULL)
    ssh_fatal("ssh_xstrdup: Can not duplicate string.");

  return (void *)cp;
}

void *ssh_xmemdup(const void *p, size_t len)
{
  char *cp;

  if ((cp = _ssh_memdup(p, len)) == NULL)
    {
      if (p && len > 0)
        ssh_fatal("ssh_xmemdup: Can not duplicate %d bytes of memory.", len);
    }
  return (void *)cp;
}
