/*

sshincludes.h

Author: Tatu Ylonen <ylo@cs.hut.fi>

Copyright (c) 1995-2001 Tatu Ylonen <ylo@cs.hut.fi>, Espoo, Finland
                   All rights reserved

Created: Mon Jan 15 10:36:06 1996 ylo

Common include files for various platforms.

*/

#ifndef SSHINCLUDES_H
#define SSHINCLUDES_H

/* */
#include "sshdistdefs.h"

#if defined(KERNEL) || defined(_KERNEL)

#ifdef WINNT
#include "sshincludes_ntddk.h"
#elif WIN95
#include "sshincludes_w95ddk.h"
#elif macintosh
#include "kernel_includes_macos.h"
#else
#include "kernel_includes.h"
#endif

/* Some internal headers used in almost every file. */
#include "sshdebug.h"
#include "engine_alloc.h"

#else /* KERNEL || _KERNEL */

#if defined(WIN32)
# include "sshincludes_win32.h"
#elif macintosh
# include "mac/sshincludes_macos.h"
#else
# ifdef VXWORKS
#   include "sshincludes_vxworks.h"
# else /* VXWORKS */
#   include "sshincludes_unix.h"
# endif /* VXWORKS */
#endif /* WIN32 */

#ifdef SSH_INCLUDE_ENGINE_ALLOC_H
#include "engine_alloc.h"
#endif /* SSH_INCLUDE_ENGINE_ALLOC_H */
#include "sshmalloc.h"
#endif /* KERNEL || _KERNEL */


/* Common (operating system independent) stuff below */

#include "sshsnprintf.h"

#ifndef SSH_ALLOW_SYSTEM_SPRINTFS

/* The sprintf and vsprintf functions are FORBIDDEN in all SSH code.
   This is for security reasons - they are the source of way too many
   security bugs.  Instead, we guarantee the existence of snprintf and
   ssh_vsnprintf.  These MUST be used instead. */
#ifdef sprintf
# undef sprintf
#endif
#define sprintf ssh_fatal(SPRINTF_IS_FORBIDDEN_USE_SSH_SNPRINTF_INSTEAD)

#ifdef vsprintf
# undef vsprintf
#endif
#define vsprintf ssh_fatal(VSPRINTF_IS_FORBIDDEN_USE_SSH_VSNPRINTF_INSTEAD)

#ifdef snprintf
# undef snprintf
#endif
#define snprintf ssh_fatal(SNPRINTF_IS_FORBIDDEN_USE_SSH_SNPRINTF_INSTEAD)

#ifdef vsnprintf
# undef vsnprintf
#endif
#define vsnprintf ssh_fatal(VSNPRINTF_IS_FORBIDDEN_USE_SSH_VSNPRINTF_INSTEAD)

#endif /* !SSH_ALLOW_SYSTEM_SPRINTFS */

#ifdef index
# undef index
#endif
#define index(A,B) ssh_fatal(INDEX_IS_BSDISM_USE_STRCHR_INSTEAD)

#ifdef rindex
# undef rindex
#endif
#define rindex(A,B) ssh_fatal(RINDEX_IS_BSDISM_USE_STRRCHR_INSTEAD)

/* Force library to use ssh- memory allocators (they may be
   implemented using zone mallocs, debug-routines or something
   similar) */

#ifndef SSH_ALLOW_SYSTEM_ALLOCATORS
#ifdef malloc
# undef malloc
#endif
#ifdef calloc
# undef calloc
#endif
#ifdef realloc
# undef realloc
#endif
#ifdef free
# undef free
#endif
#ifdef strdup
# undef strdup
#endif
#ifdef memdup
# undef memdup
#endif

# define malloc  MALLOC_IS_FORBIDDEN_USE_SSH_XMALLOC_INSTEAD
# define calloc  CALLOC_IS_FORBIDDEN_USE_SSH_XCALLOC_INSTEAD
# define realloc REALLOC_IS_FORBIDDEN_USE_SSH_XREALLOC_INSTEAD
# define free    FREE_IS_FORBIDDEN_USE_SSH_XFREE_INSTEAD
# define strdup  STRDUP_IS_FORBIDDEN_USE_SSH_XSTRDUP_INSTEAD
# define memdup  MEMDUP_IS_FORBIDDEN_USE_SSH_XMEMDUP_INSTEAD
#endif /* SSH_ALLOW_SYSTEM_ALLOCATORS */

#ifdef time
# undef time
#endif
#define time(x) ssh_fatal(TIME_IS_FORBIDDEN_USE_SSH_TIME_INSTEAD)

#ifdef localtime
# undef localtime
#endif
#define localtime \
        ssh_fatal(LOCALTIME_IS_FORBIDDEN_USE_SSH_CALENDAR_TIME_INSTEAD)

#ifdef gmtime
# undef gmtime
#endif
#define gmtime ssh_fatal(GMTIME_IS_FORBIDDEN_USE_SSH_CALENDAR_TIME_INSTEAD)

#ifdef asctime
# undef asctime
#endif
#define asctime ssh_fatal(ASCTIME_IS_FORBIDDEN)

#ifdef ctime
# undef ctime
#endif
#define ctime ssh_fatal(CTIME_IS_FORBIDDEN)

#ifdef mktime
# undef mktime
#endif
#define mktime ssh_fatal(MKTIME_IS_FORBIDDEN_USE_SSH_MAKE_TIME_INSTEAD)

/* Conditionals for various OS & compilation environments */











































































































































/* Some internal headers used in almost every file. */
#include "sshdebug.h"
#include "sshtime.h"

#ifndef SSH_CODE_SEGMENT
#ifdef WINDOWS
#define SSH_CODE_SEGMENT __based(__segname("_CODE"))
#else /* WINDOWS */
#define SSH_CODE_SEGMENT
#endif /* WINDOWS */
#endif /* SSH_CODE_SEGMENT */

/* Define UID_ROOT to be the user id for root (normally zero, but different
   e.g. on Amiga). */
#ifndef UID_ROOT
#define UID_ROOT 0
#endif /* UID_ROOT */

#ifdef SSHDIST_ZLIB
/* Define zlib to have ssh prefix, so we will not care if there is another zlib
   in the kernel */
#define deflateInit_            ssh_z_deflateInit_
#define deflate                 ssh_z_deflate
#define deflateEnd              ssh_z_deflateEnd
#define inflateInit_            ssh_z_inflateInit_
#define inflate                 ssh_z_inflate
#define inflateEnd              ssh_z_inflateEnd
#define deflateInit2_           ssh_z_deflateInit2_
#define deflateSetDictionary    ssh_z_deflateSetDictionary
#define deflateCopy             ssh_z_deflateCopy
#define deflateReset            ssh_z_deflateReset
#define deflateParams           ssh_z_deflateParams
#define inflateInit2_           ssh_z_inflateInit2_
#define inflateSetDictionary    ssh_z_inflateSetDictionary
#define inflateSync             ssh_z_inflateSync
#define inflateSyncPoint        ssh_z_inflateSyncPoint
#define inflateReset            ssh_z_inflateReset
#define compress                ssh_z_compress
#define compress2               ssh_z_compress2
#define uncompress              ssh_z_uncompress
#define adler32                 ssh_z_adler32
#define crc32                   ssh_z_crc32
#define get_crc_table           ssh_z_get_crc_table

#define Byte                    ssh_z_Byte
#define uInt                    ssh_z_uInt
#define uLong                   ssh_z_uLong
#define Bytef                   ssh_z_Bytef
#define charf                   ssh_z_charf
#define intf                    ssh_z_intf
#define uIntf                   ssh_z_uIntf
#define uLongf                  ssh_z_uLongf
#define voidpf                  ssh_z_voidpf
#define voidp                   ssh_z_voidp
#endif /* SSHDIST_ZLIB */


















#endif /* SSHINCLUDES_H */
