/*

  sshdlib.c

  Author: Jukka Aittokallio <jai@ssh.com>

  Copyright (c) 2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved

*/

#include "sshincludes.h"
#include "sshdlib.h"

#ifndef WIN32
#ifdef HAVE_DLFCN_H
#include <dlfcn.h>
#endif /* HAVE_DLFCN_H */
#endif /* WIN32 */

#define SSH_DEBUG_MODULE "SshDLib"

SshDLib
ssh_dlib_load(const char *path)
{
#if defined(WIN32)
  return LoadLibrary(path);
#elif defined(HAVE_DLFCN_H)
  return dlopen(path, RTLD_LAZY);
#else /* !WIN32 && !HAVE_DLFCN_H */
  SSH_DEBUG(0, ("No way to perform dynamic loading."));
  return NULL;
#endif /* !WIN32 && !HAVE_DLFCN_H */
}

void *
ssh_dlib_get_address(SshDLib lib, const char *name)
{
#if defined(WIN32)
  return (void *)GetProcAddress(lib, name);
#elif defined(HAVE_DLFCN_H)
  return dlsym(lib, name);
#else /* !WIN32 && !HAVE_DLFCN_H */
  return NULL;
#endif /* !WIN32 && !HAVE_DLFCN_H */
}

void
ssh_dlib_free(SshDLib lib)
{
#if defined(WIN32)
  FreeLibrary(lib);
#elif defined(HAVE_DLFCN_H)
  dlclose(lib);
#endif /* !WIN32 && !HAVE_DLFCN_H */
}
