/*

  t-eventloop.c 

Author: Vesa Suontama <vsuontam@ssh.fi>

Copyright (c) 2000 SSH Communications Security Corp, Helsinki, Finland
                   All rights reserved
                   

  Created Thu Sep 21 10:24:48 2000. 

*/

#include "sshincludes.h"
#include "ssheloop.h"
#include "sshtimeouts.h"

void another_callback(void *ctx)
{
  fprintf(stderr, "Another callback\n");
  ssh_event_loop_abort();
}

void signal_callback(int sig_num, void *context)
{
  fprintf(stderr, "The signal %d invoked\n", sig_num);
#ifndef WIN32
  ssh_register_signal(SIGUSR1, signal_callback, NULL);
#endif /* WIN32 */
}

void program_entry(void *context)
{
  int argc = (int)context;
  fprintf(stderr, "The number of arguments given to the program is %d\n",
          argc);
#ifndef WIN32
  ssh_register_signal(SIGUSR1, signal_callback, NULL);
  ssh_register_signal(SIGINT, signal_callback, NULL);
#endif /* WIN32 */
  ssh_register_timeout(2, 00000, another_callback, NULL);

}


#ifdef WIN32
/* Windows multiple waiting threads -test */
HANDLE events[200];

void event_signaled(void *context)
{
  int i = (int)context;
  fprintf(stderr, "event signaled %d\n", context);

  if (i != 4)
    ssh_event_loop_unregister_handle(events[4]);
  if (i != 33)
    ssh_event_loop_unregister_handle(events[33]);
}

void multiple_threads_stop(void *context)
{
  int i;

  fprintf(stderr, "multiple_threads_stop\n");
  for(i=0;i<200;i++)
  {
    ssh_event_loop_unregister_handle(events[i]);
  }
}

void multiple_threads(void *context)
{
  int i;

  fprintf(stderr, "multiple threads test starts\n");
  fprintf(stderr, "In this test, you should get *only three* event callbacks.\n");

  for(i=0;i<200;i++)
  {
    events[i] = CreateEvent(NULL, FALSE, FALSE, NULL);
    ssh_event_loop_register_handle(events[i], event_signaled, (void*)i);
  }

  /* take events from far apart and signal them */
  SetEvent(events[4]);
  SetEvent(events[32]);
  SetEvent(events[33]);
  SetEvent(events[117]);
  SetEvent(events[189]);

  ssh_register_timeout(1, 0, multiple_threads_stop, NULL);
}
/* Windows multiple waiting threads -test */
#endif


int main(int argc, char **argv)
{
  
  ssh_event_loop_initialize();
  ssh_register_timeout(2, 0, program_entry, (void *)argc);
#ifdef WIN32
  ssh_register_timeout(1, 0, multiple_threads, (void *)argc);
#endif
  ssh_event_loop_run();
  ssh_event_loop_uninitialize();
  return 0;
}
