/*

  t-fsm.c

  Author: Antti Huima <huima@ssh.fi>

  Copyright (c) 1999, 2001 SSH Communications Security, Finland
  All rights reserved.

  Created Thu Aug 26 15:26:11 1999.

  */

#include "sshincludes.h"
#include "sshdebug.h"
#include "ssholdfsm.h"
#include "ssheloop.h"
#include "sshstream.h"
#include "sshfdstream.h"
#include "sshbuffer.h"
#include "ssholdfsmstreams.h"

#include <ctype.h>

#define SSH_DEBUG_MODULE "t-fsm"

typedef struct {
  SshStream stdio_stream;
  SshUInt32 flags;
  SshOldFSMCondition input_avail, input_consumed;
  SshOldFSMCondition output_avail, output_consumed;
  SshOldFSMCondition stub_done;
  SshBuffer inbuf, outbuf;
  SshOldFSMThread stub, processer;
} GlobalData;

typedef struct {
  int d;
} ProcesserData;

SSH_OLDFSM_STEP(process)
{
  int k;
  unsigned char *ptr;
  int i;
  SSH_OLDFSM_DATA(GlobalData *, ProcesserData *);

  k = ssh_buffer_len(gdata->inbuf);

  if (gdata->flags & SSH_OLDSTREAMSTUB_EOF_RECEIVED)
    {
      SSH_DEBUG(6, ("EOF got, finishing the processor thread."));
      SSH_OLDFSM_THROW(gdata->stub, SSH_OLDSTREAMSTUB_FINISH);
      return SSH_OLDFSM_FINISH;
    }

  if (k == 0)
    SSH_OLDFSM_CONDITION_WAIT(gdata->input_avail);

  ptr = ssh_buffer_ptr(gdata->inbuf);
  for (i = 0; i < k; i++)
    {
      ptr[i] = toupper(ptr[i]);
    }
  ssh_buffer_append(gdata->outbuf, ptr, k);
  ssh_buffer_consume(gdata->inbuf, k);
  SSH_OLDFSM_CONDITION_SIGNAL(gdata->input_consumed);
  SSH_OLDFSM_CONDITION_SIGNAL(gdata->output_avail);
  return SSH_OLDFSM_CONTINUE;
}

SSH_OLDFSM_STEP(watch)
{
  SSH_OLDFSM_GDATA(GlobalData *);
  SSH_OLDFSM_SET_NEXT("kill");
  SSH_OLDFSM_CONDITION_WAIT(gdata->stub_done);
}

SSH_OLDFSM_STEP(kill_fsm)
{
  ssh_oldfsm_destroy(ssh_oldfsm_get_fsm(thread));
  return SSH_OLDFSM_FINISH;
}

SshOldFSMStateMapItemStruct states_array [] =
{
#include "ssholdfsmstreams_states.h"
  { "process", "Process data", process },
  { "watch", "Terminate FSM when possible", watch },
  { "kill", "Terminate FSM", kill_fsm }
};

int main(int argc, char **argv)
{
  SshOldFSM fsm;
  GlobalData *g;

#if 0
  /* XXX: use these; or get rid of them. They do not work under
     windows. */
  int fd1, fd2;

  fd1 = open("./Makefile", O_RDONLY, 0666);
  fd2 = open("./temp-out", O_WRONLY|O_CREAT|O_TRUNC, 0666);
#endif

  ssh_event_loop_initialize();

  ssh_debug_set_level_string("*=8");

  fsm = ssh_oldfsm_allocate(sizeof(GlobalData),
                         states_array,
                         SSH_OLDFSM_NUM_STATES(states_array),
                         NULL);

  g = ssh_oldfsm_get_gdata_fsm(fsm);

  g->flags = 0;
  g->input_avail = ssh_oldfsm_condition_create(fsm);
  g->input_consumed = ssh_oldfsm_condition_create(fsm);
  g->output_avail = ssh_oldfsm_condition_create(fsm);
  g->output_consumed = ssh_oldfsm_condition_create(fsm);
  g->stub_done = ssh_oldfsm_condition_create(fsm);
  g->inbuf = ssh_buffer_allocate();
  g->outbuf = ssh_buffer_allocate();
  g->stdio_stream = ssh_stream_fd_stdio();

  g->processer =
    ssh_oldfsm_spawn(fsm, sizeof(ProcesserData), "process", NULL, NULL);

  ssh_oldfsm_spawn(fsm, 0, "watch", NULL, NULL);

  ssh_oldfsm_set_thread_name(g->processer, "processer");

  g->stub = ssh_oldstreamstub_spawn(fsm,
                                 g->stdio_stream,
                                 g->inbuf,
                                 g->outbuf,
                                 5000,
                                 g->input_avail,
                                 g->input_consumed,
                                 g->output_consumed,
                                 g->output_avail,
                                 g->stub_done,
                                 &(g->flags));

  ssh_event_loop_run();

  exit(0);
}
