/*
  File: t-sshstr.c

  Authors:
        Tero T Mononen <tmo@ssh.fi>

  Description:
        Test routines for sshstr.c module.

        Currently very trivial module only trying to utilize iso-latin
        base converted to utf8, and teletext.

  Copyright:
        Copyright (c) 2000, 2001 SSH Communications Security Corp, Finland.
        All rights reserved.
*/

#include "sshincludes.h"
#include "sshstr.h"

static char *test_strings[] = {
  "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789",
  "abcdefghijklmnopqrstuvwxyz0123456789",
  "!@#$%&/()=?+-_.:,;<>'\"*~[]{}\\",
  "",
  NULL,
};

int main(int ac, char **av)
{
  SshStr s;
  int i;

  for (i = 0; test_strings[i]; i++)
    {
      if ((s =
           ssh_str_make(SSH_CHARSET_ISO_8859_1,
                        test_strings[i], strlen(test_strings[i])))
          != NULL)
        {
          SshStr t61, latin, ucs2, ucs4, utf8;

          if ((t61 = ssh_str_charset_convert(s, SSH_CHARSET_T61)) == NULL)
            ssh_fatal("t61");
          if ((ucs2 = ssh_str_charset_convert(t61, SSH_CHARSET_BMP)) == NULL)
            ssh_fatal("ucs2");
          if ((ucs4 = ssh_str_charset_convert(ucs2, SSH_CHARSET_UNIVERSAL)) == NULL)
            ssh_fatal("ucs4");
          if ((utf8 = ssh_str_charset_convert(ucs4, SSH_CHARSET_UTF8)) == NULL)
            ssh_fatal("utf8");
          if ((latin = ssh_str_charset_convert(utf8, SSH_CHARSET_ISO_8859_1)) == NULL)
            ssh_fatal("latin");

          {
            unsigned char *b1, *b2;
            size_t b1_len, b2_len;

            if ((b1 = ssh_str_get(s, &b1_len)) != NULL)
              {
                if ((b2 = ssh_str_get(latin, &b2_len)) != NULL)
                  {
                    if (b1_len != b2_len) ssh_fatal("b1_len != b2_len");
                    if (memcmp(b1, b2, b1_len)) ssh_fatal("b1 != b2");
                    ssh_xfree(b2);
                  }
                else
                  ssh_fatal("no b2");
                ssh_xfree(b1);
              }
            else
              ssh_fatal("no b1");
          }
        }
    }
  return 0;
}

/* eof */
