/* ease-editor-embed.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-editor-embed.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ease-core.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <clutter-gtk/clutter-gtk.h>
#include <gdk/gdk.h>
#include <flutter.h>


#define EASE_TYPE_SCROLLABLE_EMBED (ease_scrollable_embed_get_type ())
#define EASE_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbed))
#define EASE_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))
#define EASE_IS_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_IS_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_SCROLLABLE_EMBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))

typedef struct _EaseScrollableEmbed EaseScrollableEmbed;
typedef struct _EaseScrollableEmbedClass EaseScrollableEmbedClass;
typedef struct _EaseScrollableEmbedPrivate EaseScrollableEmbedPrivate;

#define EASE_TYPE_EDITOR_EMBED (ease_editor_embed_get_type ())
#define EASE_EDITOR_EMBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbed))
#define EASE_EDITOR_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbedClass))
#define EASE_IS_EDITOR_EMBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_EDITOR_EMBED))
#define EASE_IS_EDITOR_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_EDITOR_EMBED))
#define EASE_EDITOR_EMBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbedClass))

typedef struct _EaseEditorEmbed EaseEditorEmbed;
typedef struct _EaseEditorEmbedClass EaseEditorEmbedClass;
typedef struct _EaseEditorEmbedPrivate EaseEditorEmbedPrivate;

#define EASE_TYPE_SLIDE_ACTOR (ease_slide_actor_get_type ())
#define EASE_SLIDE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_ACTOR, EaseSlideActor))
#define EASE_SLIDE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorClass))
#define EASE_IS_SLIDE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_ACTOR))
#define EASE_IS_SLIDE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_ACTOR))
#define EASE_SLIDE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorClass))

typedef struct _EaseSlideActor EaseSlideActor;
typedef struct _EaseSlideActorClass EaseSlideActorClass;

#define EASE_TYPE_EDITOR_WINDOW (ease_editor_window_get_type ())
#define EASE_EDITOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindow))
#define EASE_EDITOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowClass))
#define EASE_IS_EDITOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_EDITOR_WINDOW))
#define EASE_IS_EDITOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_EDITOR_WINDOW))
#define EASE_EDITOR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowClass))

typedef struct _EaseEditorWindow EaseEditorWindow;
typedef struct _EaseEditorWindowClass EaseEditorWindowClass;

#define EASE_TYPE_SELECTION_RECTANGLE (ease_selection_rectangle_get_type ())
#define EASE_SELECTION_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SELECTION_RECTANGLE, EaseSelectionRectangle))
#define EASE_SELECTION_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SELECTION_RECTANGLE, EaseSelectionRectangleClass))
#define EASE_IS_SELECTION_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SELECTION_RECTANGLE))
#define EASE_IS_SELECTION_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SELECTION_RECTANGLE))
#define EASE_SELECTION_RECTANGLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SELECTION_RECTANGLE, EaseSelectionRectangleClass))

typedef struct _EaseSelectionRectangle EaseSelectionRectangle;
typedef struct _EaseSelectionRectangleClass EaseSelectionRectangleClass;

#define EASE_TYPE_HANDLE (ease_handle_get_type ())
#define EASE_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HANDLE, EaseHandle))
#define EASE_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HANDLE, EaseHandleClass))
#define EASE_IS_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HANDLE))
#define EASE_IS_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HANDLE))
#define EASE_HANDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HANDLE, EaseHandleClass))

typedef struct _EaseHandle EaseHandle;
typedef struct _EaseHandleClass EaseHandleClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _EaseSlideActorPrivate EaseSlideActorPrivate;
#define _flutter_container_iterator_unref0(var) ((var == NULL) ? NULL : (var = (flutter_container_iterator_unref (var), NULL)))

struct _EaseScrollableEmbed {
	GtkHBox parent_instance;
	EaseScrollableEmbedPrivate * priv;
};

struct _EaseScrollableEmbedClass {
	GtkHBoxClass parent_class;
};

struct _EaseEditorEmbed {
	EaseScrollableEmbed parent_instance;
	EaseEditorEmbedPrivate * priv;
	EaseSlideActor* slide_actor;
};

struct _EaseEditorEmbedClass {
	EaseScrollableEmbedClass parent_class;
};

struct _EaseEditorEmbedPrivate {
	EaseEditorWindow* win;
	EaseSelectionRectangle* selection_rectangle;
	EaseHandle** handles;
	gint handles_length1;
	gint _handles_size_;
	EaseActor* selected_priv;
	gboolean _is_editing;
	gboolean is_dragging;
	gboolean is_drag_initialized;
	EaseUndoAction* move_undo;
	float mouse_x;
	float mouse_y;
	float orig_x;
	float orig_y;
	float orig_w;
	float orig_h;
	float drag_total_x;
	float drag_total_y;
	gboolean proportional_drag;
	gboolean from_center_drag;
	gboolean keys_connected;
	EaseDocument* document;
	float zoom_priv;
	gboolean _zoom_fit;
};

struct _EaseSlideActor {
	ClutterGroup parent_instance;
	EaseSlideActorPrivate * priv;
	ClutterCairoTexture* background;
	FlutterGroup* contents;
	EaseActorContext context;
};

struct _EaseSlideActorClass {
	ClutterGroupClass parent_class;
};


static gpointer ease_editor_embed_parent_class = NULL;
static EaseUndoSourceIface* ease_editor_embed_ease_undo_source_parent_iface = NULL;

GType ease_scrollable_embed_get_type (void) G_GNUC_CONST;
GType ease_editor_embed_get_type (void) G_GNUC_CONST;
GType ease_slide_actor_get_type (void) G_GNUC_CONST;
GType ease_editor_window_get_type (void) G_GNUC_CONST;
GType ease_selection_rectangle_get_type (void) G_GNUC_CONST;
GType ease_handle_get_type (void) G_GNUC_CONST;
#define EASE_EDITOR_EMBED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbedPrivate))
enum  {
	EASE_EDITOR_EMBED_DUMMY_PROPERTY,
	EASE_EDITOR_EMBED_SELECTED,
	EASE_EDITOR_EMBED_ZOOM,
	EASE_EDITOR_EMBED_ZOOM_FIT
};
#define EASE_EDITOR_EMBED_BG_COLOR "bg_color:"
#define EASE_EDITOR_EMBED_SHADE_FACTOR 0.85
#define EASE_EDITOR_EMBED_HANDLE_COUNT 8
#define EASE_EDITOR_EMBED_NUDGE_PIXELS 10
#define EASE_EDITOR_EMBED_NUDGE_SHIFT_PIXELS 50
EaseEditorEmbed* ease_editor_embed_new (EaseDocument* d, EaseEditorWindow* w);
EaseEditorEmbed* ease_editor_embed_construct (GType object_type, EaseDocument* d, EaseEditorWindow* w);
EaseScrollableEmbed* ease_scrollable_embed_new (gboolean horizontal, gboolean has_frame);
EaseScrollableEmbed* ease_scrollable_embed_construct (GType object_type, gboolean horizontal, gboolean has_frame);
ClutterStage* ease_scrollable_embed_get_stage (EaseScrollableEmbed* self);
void ease_editor_embed_set_zoom (EaseEditorEmbed* self, float value);
void ease_editor_embed_set_zoom_fit (EaseEditorEmbed* self, gboolean value);
static void _lambda95_ (EaseEditorEmbed* self);
gboolean ease_editor_embed_get_zoom_fit (EaseEditorEmbed* self);
float ease_scrollable_embed_get_width (EaseScrollableEmbed* self);
float ease_scrollable_embed_get_height (EaseScrollableEmbed* self);
void ease_editor_embed_reposition_group (EaseEditorEmbed* self);
static void __lambda95__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static void _lambda96_ (GObject* o, GParamSpec* pspec, EaseEditorEmbed* self);
static void __lambda96__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void ease_editor_embed_connect_keys (EaseEditorEmbed* self);
void ease_editor_embed_set_slide (EaseEditorEmbed* self, EaseSlide* slide);
static gboolean ease_editor_embed_get_is_editing (EaseEditorEmbed* self);
EaseActor* ease_editor_embed_get_selected (EaseEditorEmbed* self);
static void ease_editor_embed_set_is_editing (EaseEditorEmbed* self, gboolean value);
static void ease_editor_embed_deselect_actor (EaseEditorEmbed* self);
ClutterGroup* ease_scrollable_embed_get_contents (EaseScrollableEmbed* self);
static gboolean ease_editor_embed_actor_clicked (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event);
static gboolean _ease_editor_embed_actor_clicked_clutter_actor_button_press_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
static gboolean ease_editor_embed_actor_released (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event);
static gboolean _ease_editor_embed_actor_released_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
void ease_editor_embed_on_ease_actor_added (EaseEditorEmbed* self, EaseActor* actor);
static void _ease_editor_embed_on_ease_actor_added_ease_slide_actor_ease_actor_added (EaseSlideActor* _sender, EaseActor* actor, gpointer self);
void ease_editor_embed_on_ease_actor_removed (EaseEditorEmbed* self, EaseActor* actor);
static void _ease_editor_embed_on_ease_actor_removed_ease_slide_actor_ease_actor_removed (EaseSlideActor* _sender, EaseActor* actor, gpointer self);
EaseSlide* ease_slide_actor_get_slide (EaseSlideActor* self);
void ease_editor_embed_on_element_removed (EaseEditorEmbed* self, EaseSlide* slide, EaseElement* element, gint index);
static void _ease_editor_embed_on_element_removed_ease_slide_element_removed (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gint index, gpointer self);
static void ease_editor_embed_remove_selection_rect (EaseEditorEmbed* self);
EaseSlideActor* ease_slide_actor_new_from_slide (EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx);
EaseSlideActor* ease_slide_actor_construct_from_slide (GType object_type, EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx);
static gboolean ease_editor_embed_handle_clicked (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event);
static gboolean _ease_editor_embed_handle_clicked_clutter_actor_button_press_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
static gboolean ease_editor_embed_handle_released (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event);
static gboolean _ease_editor_embed_handle_released_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
float ease_editor_embed_get_zoom (EaseEditorEmbed* self);
static void ease_editor_embed_position_selection (EaseEditorEmbed* self);
void ease_handle_reposition (EaseHandle* self, ClutterActor* selection);
void ease_editor_embed_recreate_slide (EaseEditorEmbed* self);
void ease_editor_embed_select_element (EaseEditorEmbed* self, EaseElement* e);
static void ease_editor_embed_select_actor (EaseEditorEmbed* self, EaseActor* sender);
void ease_editor_embed_disconnect_keys (EaseEditorEmbed* self);
static gboolean ease_editor_embed_actor_motion (EaseEditorEmbed* self, ClutterActor* sender, ClutterMotionEvent* event);
static gboolean _ease_editor_embed_actor_motion_clutter_actor_motion_event (ClutterActor* _sender, ClutterMotionEvent* event, gpointer self);
static void ease_editor_embed_set_selected (EaseEditorEmbed* self, EaseActor* value);
EaseSelectionRectangle* ease_selection_rectangle_new (void);
EaseSelectionRectangle* ease_selection_rectangle_construct (GType object_type);
EaseHandle* ease_handle_new (EaseHandlePosition pos);
EaseHandle* ease_handle_construct (GType object_type, EaseHandlePosition pos);
void ease_handle_flip (EaseHandle* self, gboolean f);
static gboolean ease_editor_embed_handle_motion (EaseEditorEmbed* self, ClutterActor* sender, ClutterMotionEvent* event);
static gboolean _ease_editor_embed_handle_motion_clutter_actor_motion_event (ClutterActor* _sender, ClutterMotionEvent* event, gpointer self);
void ease_handle_drag (EaseHandle* self, float change_x, float change_y, EaseElement* target, gboolean proportional, gboolean from_center);
void ease_editor_embed_set_element_color (EaseEditorEmbed* self, ClutterColor* color);
gboolean ease_editor_embed_on_key_press_event (EaseEditorEmbed* self, GtkWidget* _self_, GdkEventKey* event);
static gboolean _ease_editor_embed_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void ease_editor_embed_on_selected_changed (EaseEditorEmbed* self, EaseSlide* sender);
static void _ease_editor_embed_on_selected_changed_ease_slide_changed (EaseSlide* _sender, EaseSlide* _self_, gpointer self);
static void ease_editor_embed_finalize (GObject* obj);
static void ease_editor_embed_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_editor_embed_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



/**
 * Create an EditorEmbed representing a {@link Document}.
 * 
 * EditorEmbed is the outermost part of the editing canvas in an Ease
 * window. Each EditorEmbed is linked to a {@link Document}, and
 * changes in the editor are immediately reflected in the Document, but
 * are not saved to disk until the user clicks on a save button or
 * menu item. 
 *
 * @param d The {@link Document} this EditorEmbed represents.
 * @param w The {@link EditorWindow} this EditorEmbed is part of.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 250 "ease-editor-embed.vala"
static void _lambda95_ (EaseEditorEmbed* self) {
#line 251 "ease-editor-embed.vala"
	if (self->priv->_zoom_fit) {
#line 273 "ease-editor-embed.c"
		float _tmp0_ = 0.0F;
#line 253 "ease-editor-embed.vala"
		if ((ease_scrollable_embed_get_width ((EaseScrollableEmbed*) self) / ease_scrollable_embed_get_height ((EaseScrollableEmbed*) self)) > (((float) ease_document_get_width (self->priv->document)) / ease_document_get_height (self->priv->document))) {
#line 254 "ease-editor-embed.vala"
			_tmp0_ = ease_scrollable_embed_get_height ((EaseScrollableEmbed*) self) / ease_document_get_height (self->priv->document);
#line 279 "ease-editor-embed.c"
		} else {
#line 255 "ease-editor-embed.vala"
			_tmp0_ = ease_scrollable_embed_get_width ((EaseScrollableEmbed*) self) / ease_document_get_width (self->priv->document);
#line 283 "ease-editor-embed.c"
		}
#line 253 "ease-editor-embed.vala"
		ease_editor_embed_set_zoom (self, _tmp0_);
#line 256 "ease-editor-embed.vala"
		ease_editor_embed_reposition_group (self);
#line 289 "ease-editor-embed.c"
	} else {
#line 260 "ease-editor-embed.vala"
		ease_editor_embed_reposition_group (self);
#line 293 "ease-editor-embed.c"
	}
}


#line 250 "ease-editor-embed.vala"
static void __lambda95__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
#line 300 "ease-editor-embed.c"
	_lambda95_ (self);
}


#line 265 "ease-editor-embed.vala"
static void _lambda96_ (GObject* o, GParamSpec* pspec, EaseEditorEmbed* self) {
#line 307 "ease-editor-embed.c"
	float _tmp0_ = 0.0F;
#line 265 "ease-editor-embed.vala"
	g_return_if_fail (o != NULL);
#line 265 "ease-editor-embed.vala"
	g_return_if_fail (pspec != NULL);
#line 266 "ease-editor-embed.vala"
	if (!self->priv->_zoom_fit) {
#line 266 "ease-editor-embed.vala"
		return;
#line 317 "ease-editor-embed.c"
	}
#line 268 "ease-editor-embed.vala"
	if ((ease_scrollable_embed_get_width ((EaseScrollableEmbed*) self) / ease_scrollable_embed_get_height ((EaseScrollableEmbed*) self)) > (((float) ease_document_get_width (self->priv->document)) / ease_document_get_height (self->priv->document))) {
#line 269 "ease-editor-embed.vala"
		_tmp0_ = ease_scrollable_embed_get_height ((EaseScrollableEmbed*) self) / ease_document_get_height (self->priv->document);
#line 323 "ease-editor-embed.c"
	} else {
#line 270 "ease-editor-embed.vala"
		_tmp0_ = ease_scrollable_embed_get_width ((EaseScrollableEmbed*) self) / ease_document_get_width (self->priv->document);
#line 327 "ease-editor-embed.c"
	}
#line 268 "ease-editor-embed.vala"
	ease_editor_embed_set_zoom (self, _tmp0_);
#line 271 "ease-editor-embed.vala"
	ease_editor_embed_reposition_group (self);
#line 333 "ease-editor-embed.c"
}


#line 265 "ease-editor-embed.vala"
static void __lambda96__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 339 "ease-editor-embed.c"
	_lambda96_ (_sender, pspec, self);
}


#line 228 "ease-editor-embed.vala"
EaseEditorEmbed* ease_editor_embed_construct (GType object_type, EaseDocument* d, EaseEditorWindow* w) {
#line 346 "ease-editor-embed.c"
	EaseEditorEmbed * self;
	EaseEditorWindow* _tmp0_;
	ClutterStage* _tmp1_;
	ClutterColor out_color = {0};
	ClutterColor color = {0};
	ClutterStage* _tmp2_;
	EaseDocument* _tmp3_;
#line 228 "ease-editor-embed.vala"
	g_return_val_if_fail (d != NULL, NULL);
#line 228 "ease-editor-embed.vala"
	g_return_val_if_fail (w != NULL, NULL);
#line 230 "ease-editor-embed.vala"
	self = (EaseEditorEmbed*) ease_scrollable_embed_construct (object_type, TRUE, TRUE);
#line 231 "ease-editor-embed.vala"
	self->priv->win = (_tmp0_ = _g_object_ref0 (w), _g_object_unref0 (self->priv->win), _tmp0_);
#line 234 "ease-editor-embed.vala"
	clutter_stage_set_use_fog (_tmp1_ = ease_scrollable_embed_get_stage ((EaseScrollableEmbed*) self), FALSE);
#line 364 "ease-editor-embed.c"
	_g_object_unref0 (_tmp1_);
#line 238 "ease-editor-embed.vala"
	gtk_clutter_get_bg_color ((GtkWidget*) self, GTK_STATE_NORMAL, &color);
#line 239 "ease-editor-embed.vala"
	clutter_color_shade (&color, EASE_EDITOR_EMBED_SHADE_FACTOR, &out_color);
#line 241 "ease-editor-embed.vala"
	clutter_stage_set_color (_tmp2_ = ease_scrollable_embed_get_stage ((EaseScrollableEmbed*) self), &out_color);
#line 372 "ease-editor-embed.c"
	_g_object_unref0 (_tmp2_);
#line 243 "ease-editor-embed.vala"
	self->priv->document = (_tmp3_ = _g_object_ref0 (d), _g_object_unref0 (self->priv->document), _tmp3_);
#line 244 "ease-editor-embed.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 320, 240);
#line 246 "ease-editor-embed.vala"
	ease_editor_embed_set_zoom (self, (float) 1);
#line 247 "ease-editor-embed.vala"
	ease_editor_embed_set_zoom_fit (self, FALSE);
#line 250 "ease-editor-embed.vala"
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) __lambda95__gtk_widget_size_allocate, self, 0);
#line 265 "ease-editor-embed.vala"
	g_signal_connect_object ((GObject*) self, "notify::zoom-fit", (GCallback) __lambda96__g_object_notify, self, 0);
#line 274 "ease-editor-embed.vala"
	ease_editor_embed_connect_keys (self);
#line 388 "ease-editor-embed.c"
	return self;
}


#line 228 "ease-editor-embed.vala"
EaseEditorEmbed* ease_editor_embed_new (EaseDocument* d, EaseEditorWindow* w) {
#line 228 "ease-editor-embed.vala"
	return ease_editor_embed_construct (EASE_TYPE_EDITOR_EMBED, d, w);
#line 397 "ease-editor-embed.c"
}


/**
 * Sets the current {@link Slide} that the EditorEmbed is displaying.
 * 
 * The current slide is displayed in the center of the EditorEmbed.
 * Components of it should also be editable via interface elements such
 * as the Inspector.
 *
 * This function will work with a {@link Slide} that is not in the
 * displayed {@link Document}. For obvious reasons, this is not a 
 * particularly good idea.
 *
 * @param node The initial XML node to begin with.
 */
#line 449 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_actor_clicked_clutter_actor_button_press_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
#line 416 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_actor_clicked (self, _sender, event);
	return result;
}


#line 558 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_actor_released_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
#line 425 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_actor_released (self, _sender, event);
	return result;
}


#line 775 "ease-editor-embed.vala"
static void _ease_editor_embed_on_ease_actor_added_ease_slide_actor_ease_actor_added (EaseSlideActor* _sender, EaseActor* actor, gpointer self) {
#line 434 "ease-editor-embed.c"
	ease_editor_embed_on_ease_actor_added (self, actor);
}


#line 764 "ease-editor-embed.vala"
static void _ease_editor_embed_on_ease_actor_removed_ease_slide_actor_ease_actor_removed (EaseSlideActor* _sender, EaseActor* actor, gpointer self) {
#line 441 "ease-editor-embed.c"
	ease_editor_embed_on_ease_actor_removed (self, actor);
}


#line 851 "ease-editor-embed.vala"
static void _ease_editor_embed_on_element_removed_ease_slide_element_removed (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gint index, gpointer self) {
#line 448 "ease-editor-embed.c"
	ease_editor_embed_on_element_removed (self, _self_, element, index);
}


#line 290 "ease-editor-embed.vala"
void ease_editor_embed_set_slide (EaseEditorEmbed* self, EaseSlide* slide) {
#line 455 "ease-editor-embed.c"
	EaseSlideActor* _tmp5_;
#line 290 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 290 "ease-editor-embed.vala"
	g_return_if_fail (slide != NULL);
#line 292 "ease-editor-embed.vala"
	if (slide == NULL) {
#line 292 "ease-editor-embed.vala"
		return;
#line 465 "ease-editor-embed.c"
	}
#line 294 "ease-editor-embed.vala"
	if (self->priv->_is_editing) {
#line 296 "ease-editor-embed.vala"
		ease_actor_end_edit (ease_editor_embed_get_selected (self), (GtkWidget*) self);
#line 297 "ease-editor-embed.vala"
		ease_editor_embed_set_is_editing (self, FALSE);
#line 473 "ease-editor-embed.c"
	}
#line 300 "ease-editor-embed.vala"
	ease_editor_embed_connect_keys (self);
#line 301 "ease-editor-embed.vala"
	ease_editor_embed_deselect_actor (self);
#line 302 "ease-editor-embed.vala"
	g_signal_emit_by_name (self, "element-deselected", NULL);
#line 305 "ease-editor-embed.vala"
	if (self->slide_actor != NULL) {
#line 483 "ease-editor-embed.c"
		guint _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
#line 307 "ease-editor-embed.vala"
		clutter_container_remove_actor ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) self->slide_actor);
#line 489 "ease-editor-embed.c"
		{
			FlutterContainerIterator* _a_it;
#line 308 "ease-editor-embed.vala"
			_a_it = flutter_container_iterator ((FlutterContainer*) self->slide_actor->contents);
#line 308 "ease-editor-embed.vala"
			while (TRUE) {
#line 496 "ease-editor-embed.c"
				ClutterActor* a;
				guint _tmp0_;
				guint _tmp1_;
#line 308 "ease-editor-embed.vala"
				if (!flutter_container_iterator_next (_a_it)) {
#line 308 "ease-editor-embed.vala"
					break;
#line 504 "ease-editor-embed.c"
				}
#line 308 "ease-editor-embed.vala"
				a = flutter_container_iterator_get (_a_it);
#line 310 "ease-editor-embed.vala"
				g_signal_parse_name ("button-press-event", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
#line 310 "ease-editor-embed.vala"
				g_signal_handlers_disconnect_matched (a, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ease_editor_embed_actor_clicked_clutter_actor_button_press_event, self);
#line 311 "ease-editor-embed.vala"
				g_signal_parse_name ("button-release-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
#line 311 "ease-editor-embed.vala"
				g_signal_handlers_disconnect_matched (a, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_editor_embed_actor_released_clutter_actor_button_release_event, self);
#line 312 "ease-editor-embed.vala"
				clutter_actor_set_reactive (a, FALSE);
#line 518 "ease-editor-embed.c"
				_g_object_unref0 (a);
			}
			_flutter_container_iterator_unref0 (_a_it);
		}
#line 315 "ease-editor-embed.vala"
		g_signal_parse_name ("ease-actor-added", EASE_TYPE_SLIDE_ACTOR, &_tmp2_, NULL, FALSE);
#line 315 "ease-editor-embed.vala"
		g_signal_handlers_disconnect_matched (self->slide_actor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _ease_editor_embed_on_ease_actor_added_ease_slide_actor_ease_actor_added, self);
#line 316 "ease-editor-embed.vala"
		g_signal_parse_name ("ease-actor-removed", EASE_TYPE_SLIDE_ACTOR, &_tmp3_, NULL, FALSE);
#line 316 "ease-editor-embed.vala"
		g_signal_handlers_disconnect_matched (self->slide_actor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _ease_editor_embed_on_ease_actor_removed_ease_slide_actor_ease_actor_removed, self);
#line 317 "ease-editor-embed.vala"
		g_signal_parse_name ("element-removed", EASE_TYPE_SLIDE, &_tmp4_, NULL, FALSE);
#line 317 "ease-editor-embed.vala"
		g_signal_handlers_disconnect_matched (ease_slide_actor_get_slide (self->slide_actor), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _ease_editor_embed_on_element_removed_ease_slide_element_removed, self);
#line 535 "ease-editor-embed.c"
	}
#line 321 "ease-editor-embed.vala"
	ease_editor_embed_remove_selection_rect (self);
#line 324 "ease-editor-embed.vala"
	self->slide_actor = (_tmp5_ = g_object_ref_sink (ease_slide_actor_new_from_slide (self->priv->document, slide, FALSE, EASE_ACTOR_CONTEXT_EDITOR)), _g_object_unref0 (self->slide_actor), _tmp5_);
#line 541 "ease-editor-embed.c"
	{
		FlutterContainerIterator* _a_it;
#line 330 "ease-editor-embed.vala"
		_a_it = flutter_container_iterator ((FlutterContainer*) self->slide_actor->contents);
#line 330 "ease-editor-embed.vala"
		while (TRUE) {
#line 548 "ease-editor-embed.c"
			ClutterActor* a;
#line 330 "ease-editor-embed.vala"
			if (!flutter_container_iterator_next (_a_it)) {
#line 330 "ease-editor-embed.vala"
				break;
#line 554 "ease-editor-embed.c"
			}
#line 330 "ease-editor-embed.vala"
			a = flutter_container_iterator_get (_a_it);
#line 332 "ease-editor-embed.vala"
			g_signal_connect_object (a, "button-press-event", (GCallback) _ease_editor_embed_actor_clicked_clutter_actor_button_press_event, self, 0);
#line 333 "ease-editor-embed.vala"
			g_signal_connect_object (a, "button-release-event", (GCallback) _ease_editor_embed_actor_released_clutter_actor_button_release_event, self, 0);
#line 334 "ease-editor-embed.vala"
			clutter_actor_set_reactive (a, TRUE);
#line 564 "ease-editor-embed.c"
			_g_object_unref0 (a);
		}
		_flutter_container_iterator_unref0 (_a_it);
	}
#line 337 "ease-editor-embed.vala"
	g_signal_connect_object (self->slide_actor, "ease-actor-added", (GCallback) _ease_editor_embed_on_ease_actor_added_ease_slide_actor_ease_actor_added, self, 0);
#line 338 "ease-editor-embed.vala"
	g_signal_connect_object (self->slide_actor, "ease-actor-removed", (GCallback) _ease_editor_embed_on_ease_actor_removed_ease_slide_actor_ease_actor_removed, self, 0);
#line 339 "ease-editor-embed.vala"
	g_signal_connect_object (ease_slide_actor_get_slide (self->slide_actor), "element-removed", (GCallback) _ease_editor_embed_on_element_removed_ease_slide_element_removed, self, 0);
#line 341 "ease-editor-embed.vala"
	clutter_container_add_actor ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) self->slide_actor);
#line 342 "ease-editor-embed.vala"
	ease_editor_embed_reposition_group (self);
#line 579 "ease-editor-embed.c"
}


/**
 * Removes the selection rectangle and handles.
 */
#line 622 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_handle_clicked_clutter_actor_button_press_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
#line 588 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_handle_clicked (self, _sender, event);
	return result;
}


#line 650 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_handle_released_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
#line 597 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_handle_released (self, _sender, event);
	return result;
}


#line 348 "ease-editor-embed.vala"
static void ease_editor_embed_remove_selection_rect (EaseEditorEmbed* self) {
#line 348 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 350 "ease-editor-embed.vala"
	if (self->priv->selection_rectangle != NULL) {
#line 610 "ease-editor-embed.c"
		EaseHandle** _tmp2_;
#line 352 "ease-editor-embed.vala"
		if (clutter_actor_get_parent ((ClutterActor*) self->priv->selection_rectangle) == CLUTTER_ACTOR (ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self))) {
#line 354 "ease-editor-embed.vala"
			clutter_container_remove_actor ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) self->priv->selection_rectangle);
#line 616 "ease-editor-embed.c"
		}
		{
			EaseHandle** h_collection;
			int h_collection_length1;
			int h_it;
#line 356 "ease-editor-embed.vala"
			h_collection = self->priv->handles;
#line 624 "ease-editor-embed.c"
			h_collection_length1 = self->priv->handles_length1;
			for (h_it = 0; h_it < self->priv->handles_length1; h_it = h_it + 1) {
				EaseHandle* h;
				h = _g_object_ref0 (h_collection[h_it]);
				{
					guint _tmp0_;
					guint _tmp1_;
#line 358 "ease-editor-embed.vala"
					if (clutter_actor_get_parent ((ClutterActor*) h) == CLUTTER_ACTOR (ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self))) {
#line 360 "ease-editor-embed.vala"
						clutter_container_remove_actor ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) h);
#line 636 "ease-editor-embed.c"
					}
#line 362 "ease-editor-embed.vala"
					g_signal_parse_name ("button-press-event", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
#line 362 "ease-editor-embed.vala"
					g_signal_handlers_disconnect_matched ((ClutterActor*) h, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ease_editor_embed_handle_clicked_clutter_actor_button_press_event, self);
#line 363 "ease-editor-embed.vala"
					g_signal_parse_name ("button-release-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
#line 363 "ease-editor-embed.vala"
					g_signal_handlers_disconnect_matched ((ClutterActor*) h, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_editor_embed_handle_released_clutter_actor_button_release_event, self);
#line 646 "ease-editor-embed.c"
					_g_object_unref0 (h);
				}
			}
		}
#line 365 "ease-editor-embed.vala"
		self->priv->handles = (_tmp2_ = NULL, self->priv->handles = (_vala_array_free (self->priv->handles, self->priv->handles_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->handles_length1 = 0, self->priv->_handles_size_ = self->priv->handles_length1, _tmp2_);
#line 653 "ease-editor-embed.c"
	}
}


/**
 * Repositions the EditorEmbed's {@link SlideActor}.
 * 
 * Call this function after changing the zoom level, document size, or
 * any other properties that could place the slide off center. 
 */
#line 375 "ease-editor-embed.vala"
void ease_editor_embed_reposition_group (EaseEditorEmbed* self) {
#line 666 "ease-editor-embed.c"
	float w;
	float h;
	float _tmp0_ = 0.0F;
	float _tmp1_ = 0.0F;
	gboolean _tmp2_ = FALSE;
#line 375 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 377 "ease-editor-embed.vala"
	if (self->slide_actor == NULL) {
#line 379 "ease-editor-embed.vala"
		return;
#line 678 "ease-editor-embed.c"
	}
#line 382 "ease-editor-embed.vala"
	w = ease_editor_embed_get_zoom (self) * ease_slide_get_width (ease_slide_actor_get_slide (self->slide_actor));
#line 383 "ease-editor-embed.vala"
	h = ease_editor_embed_get_zoom (self) * ease_slide_get_height (ease_slide_actor_get_slide (self->slide_actor));
#line 385 "ease-editor-embed.vala"
	clutter_actor_set_scale_full ((ClutterActor*) self->slide_actor, (double) ease_editor_embed_get_zoom (self), (double) ease_editor_embed_get_zoom (self), (float) 0, (float) 0);
#line 387 "ease-editor-embed.vala"
	if (w < ease_scrollable_embed_get_width ((EaseScrollableEmbed*) self)) {
#line 387 "ease-editor-embed.vala"
		_tmp0_ = (ease_scrollable_embed_get_width ((EaseScrollableEmbed*) self) / 2) - (w / 2);
#line 690 "ease-editor-embed.c"
	} else {
#line 387 "ease-editor-embed.vala"
		_tmp0_ = (float) 0;
#line 694 "ease-editor-embed.c"
	}
#line 387 "ease-editor-embed.vala"
	clutter_actor_set_x ((ClutterActor*) self->slide_actor, roundf (_tmp0_));
#line 389 "ease-editor-embed.vala"
	if (h < ease_scrollable_embed_get_height ((EaseScrollableEmbed*) self)) {
#line 389 "ease-editor-embed.vala"
		_tmp1_ = (ease_scrollable_embed_get_height ((EaseScrollableEmbed*) self) / 2) - (h / 2);
#line 702 "ease-editor-embed.c"
	} else {
#line 389 "ease-editor-embed.vala"
		_tmp1_ = (float) 0;
#line 706 "ease-editor-embed.c"
	}
#line 389 "ease-editor-embed.vala"
	clutter_actor_set_y ((ClutterActor*) self->slide_actor, roundf (_tmp1_));
#line 391 "ease-editor-embed.vala"
	if (self->priv->selection_rectangle != NULL) {
#line 391 "ease-editor-embed.vala"
		_tmp2_ = ease_editor_embed_get_selected (self) != NULL;
#line 714 "ease-editor-embed.c"
	} else {
#line 391 "ease-editor-embed.vala"
		_tmp2_ = FALSE;
#line 718 "ease-editor-embed.c"
	}
#line 391 "ease-editor-embed.vala"
	if (_tmp2_) {
#line 393 "ease-editor-embed.vala"
		ease_editor_embed_position_selection (self);
#line 724 "ease-editor-embed.c"
	}
}


/**
 * Repositions the EditorEmbed's selection rectangle
 * 
 * Call this function after changing the zoom level, document size, or
 * any other properties that could place the slide off center. 
 */
#line 403 "ease-editor-embed.vala"
static void ease_editor_embed_position_selection (EaseEditorEmbed* self) {
#line 403 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 405 "ease-editor-embed.vala"
	clutter_actor_set_position ((ClutterActor*) self->priv->selection_rectangle, (ease_editor_embed_get_zoom (self) * clutter_actor_get_x ((ClutterActor*) ease_editor_embed_get_selected (self))) + clutter_actor_get_x ((ClutterActor*) self->slide_actor), (ease_editor_embed_get_zoom (self) * clutter_actor_get_y ((ClutterActor*) ease_editor_embed_get_selected (self))) + clutter_actor_get_y ((ClutterActor*) self->slide_actor));
#line 407 "ease-editor-embed.vala"
	clutter_actor_set_size ((ClutterActor*) self->priv->selection_rectangle, ease_editor_embed_get_zoom (self) * clutter_actor_get_width ((ClutterActor*) ease_editor_embed_get_selected (self)), ease_editor_embed_get_zoom (self) * clutter_actor_get_height ((ClutterActor*) ease_editor_embed_get_selected (self)));
#line 743 "ease-editor-embed.c"
	{
		EaseHandle** h_collection;
		int h_collection_length1;
		int h_it;
#line 410 "ease-editor-embed.vala"
		h_collection = self->priv->handles;
#line 750 "ease-editor-embed.c"
		h_collection_length1 = self->priv->handles_length1;
		for (h_it = 0; h_it < self->priv->handles_length1; h_it = h_it + 1) {
			EaseHandle* h;
			h = _g_object_ref0 (h_collection[h_it]);
			{
#line 412 "ease-editor-embed.vala"
				ease_handle_reposition (h, (ClutterActor*) self->priv->selection_rectangle);
#line 758 "ease-editor-embed.c"
				_g_object_unref0 (h);
			}
		}
	}
}


/**
 * Recreates the current SlideActor.
 */
#line 419 "ease-editor-embed.vala"
void ease_editor_embed_recreate_slide (EaseEditorEmbed* self) {
#line 419 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 421 "ease-editor-embed.vala"
	ease_editor_embed_set_slide (self, ease_slide_actor_get_slide (self->slide_actor));
#line 775 "ease-editor-embed.c"
}


/**
 * Selects an {@link Actor} by {@link Element}.
 *
 * @param e The element to search for.
 */
#line 429 "ease-editor-embed.vala"
void ease_editor_embed_select_element (EaseEditorEmbed* self, EaseElement* e) {
#line 429 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 429 "ease-editor-embed.vala"
	g_return_if_fail (e != NULL);
#line 790 "ease-editor-embed.c"
	{
		FlutterContainerIterator* _a_it;
#line 431 "ease-editor-embed.vala"
		_a_it = flutter_container_iterator ((FlutterContainer*) self->slide_actor->contents);
#line 431 "ease-editor-embed.vala"
		while (TRUE) {
#line 797 "ease-editor-embed.c"
			ClutterActor* a;
			ClutterActor* _tmp0_;
#line 431 "ease-editor-embed.vala"
			if (!flutter_container_iterator_next (_a_it)) {
#line 431 "ease-editor-embed.vala"
				break;
#line 804 "ease-editor-embed.c"
			}
#line 431 "ease-editor-embed.vala"
			a = flutter_container_iterator_get (_a_it);
#line 433 "ease-editor-embed.vala"
			if ((_tmp0_ = a, EASE_IS_ACTOR (_tmp0_) ? ((EaseActor*) _tmp0_) : NULL)->element == e) {
#line 810 "ease-editor-embed.c"
				ClutterActor* _tmp1_;
#line 435 "ease-editor-embed.vala"
				ease_editor_embed_select_actor (self, (_tmp1_ = a, EASE_IS_ACTOR (_tmp1_) ? ((EaseActor*) _tmp1_) : NULL));
#line 814 "ease-editor-embed.c"
			}
			_g_object_unref0 (a);
		}
		_flutter_container_iterator_unref0 (_a_it);
	}
}


/**
 * Signal handler for clicking on {@link Actor}s.
 * 
 * This handler is attached to the button_press_event of all
 * {@link Actor}s in the currently displayed {@link SlideActor}.
 *
 * @param sender The {@link Actor} that was clicked
 * @param event The corresponding Clutter.Event
 */
#line 580 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_actor_motion_clutter_actor_motion_event (ClutterActor* _sender, ClutterMotionEvent* event, gpointer self) {
#line 834 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_actor_motion (self, _sender, event);
	return result;
}


#line 449 "ease-editor-embed.vala"
static gboolean ease_editor_embed_actor_clicked (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event) {
#line 843 "ease-editor-embed.c"
	gboolean result = FALSE;
	ClutterActor* _tmp2_;
#line 449 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 449 "ease-editor-embed.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 452 "ease-editor-embed.vala"
	if ((*event).click_count == 2) {
#line 852 "ease-editor-embed.c"
		ClutterActor* _tmp0_;
#line 454 "ease-editor-embed.vala"
		ease_editor_embed_disconnect_keys (self);
#line 455 "ease-editor-embed.vala"
		ease_actor_edit ((_tmp0_ = sender, EASE_IS_ACTOR (_tmp0_) ? ((EaseActor*) _tmp0_) : NULL), (GtkWidget*) self);
#line 456 "ease-editor-embed.vala"
		ease_editor_embed_set_is_editing (self, TRUE);
#line 860 "ease-editor-embed.c"
		result = TRUE;
#line 457 "ease-editor-embed.vala"
		return result;
#line 864 "ease-editor-embed.c"
	} else {
#line 461 "ease-editor-embed.vala"
		if (sender == CLUTTER_ACTOR (ease_editor_embed_get_selected (self))) {
#line 868 "ease-editor-embed.c"
			EaseUndoAction* _tmp1_;
#line 463 "ease-editor-embed.vala"
			self->priv->is_dragging = TRUE;
#line 464 "ease-editor-embed.vala"
			self->priv->is_drag_initialized = FALSE;
#line 465 "ease-editor-embed.vala"
			clutter_grab_pointer (sender);
#line 466 "ease-editor-embed.vala"
			g_signal_connect_object (sender, "motion-event", (GCallback) _ease_editor_embed_actor_motion_clutter_actor_motion_event, self, 0);
#line 469 "ease-editor-embed.vala"
			self->priv->move_undo = (_tmp1_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self)->element, "x"), _g_object_unref0 (self->priv->move_undo), _tmp1_);
#line 470 "ease-editor-embed.vala"
			ease_undo_action_add (self->priv->move_undo, (GObject*) ease_editor_embed_get_selected (self)->element, "y");
#line 882 "ease-editor-embed.c"
			result = TRUE;
#line 472 "ease-editor-embed.vala"
			return result;
#line 886 "ease-editor-embed.c"
		}
	}
#line 475 "ease-editor-embed.vala"
	ease_editor_embed_select_actor (self, (_tmp2_ = sender, EASE_IS_ACTOR (_tmp2_) ? ((EaseActor*) _tmp2_) : NULL));
#line 891 "ease-editor-embed.c"
	result = TRUE;
#line 477 "ease-editor-embed.vala"
	return result;
#line 895 "ease-editor-embed.c"
}


/**
 * Selects an {@link Actor}.
 *
 * @param sender The Actor to select.
 */
#line 485 "ease-editor-embed.vala"
static void ease_editor_embed_select_actor (EaseEditorEmbed* self, EaseActor* sender) {
#line 906 "ease-editor-embed.c"
	EaseActor* _tmp0_;
	EaseSelectionRectangle* _tmp1_;
#line 485 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 485 "ease-editor-embed.vala"
	g_return_if_fail (sender != NULL);
#line 488 "ease-editor-embed.vala"
	ease_editor_embed_deselect_actor (self);
#line 490 "ease-editor-embed.vala"
	ease_editor_embed_connect_keys (self);
#line 492 "ease-editor-embed.vala"
	ease_editor_embed_set_selected (self, (_tmp0_ = sender, EASE_IS_ACTOR (_tmp0_) ? ((EaseActor*) _tmp0_) : NULL));
#line 493 "ease-editor-embed.vala"
	g_signal_emit_by_name (self, "element-selected", ease_editor_embed_get_selected (self)->element);
#line 496 "ease-editor-embed.vala"
	self->priv->selection_rectangle = (_tmp1_ = g_object_ref_sink (ease_selection_rectangle_new ()), _g_object_unref0 (self->priv->selection_rectangle), _tmp1_);
#line 497 "ease-editor-embed.vala"
	ease_editor_embed_position_selection (self);
#line 498 "ease-editor-embed.vala"
	clutter_container_add_actor ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) self->priv->selection_rectangle);
#line 501 "ease-editor-embed.vala"
	if (self->priv->handles == NULL) {
#line 929 "ease-editor-embed.c"
		EaseHandle** _tmp2_;
#line 503 "ease-editor-embed.vala"
		self->priv->handles = (_tmp2_ = g_new0 (EaseHandle*, EASE_EDITOR_EMBED_HANDLE_COUNT + 1), self->priv->handles = (_vala_array_free (self->priv->handles, self->priv->handles_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->handles_length1 = EASE_EDITOR_EMBED_HANDLE_COUNT, self->priv->_handles_size_ = self->priv->handles_length1, _tmp2_);
#line 933 "ease-editor-embed.c"
		{
			gint i;
#line 504 "ease-editor-embed.vala"
			i = 0;
#line 938 "ease-editor-embed.c"
			{
				gboolean _tmp3_;
#line 504 "ease-editor-embed.vala"
				_tmp3_ = TRUE;
#line 504 "ease-editor-embed.vala"
				while (TRUE) {
#line 945 "ease-editor-embed.c"
					EaseHandle* _tmp4_;
#line 504 "ease-editor-embed.vala"
					if (!_tmp3_) {
#line 504 "ease-editor-embed.vala"
						i++;
#line 951 "ease-editor-embed.c"
					}
#line 504 "ease-editor-embed.vala"
					_tmp3_ = FALSE;
#line 504 "ease-editor-embed.vala"
					if (!(i < EASE_EDITOR_EMBED_HANDLE_COUNT)) {
#line 504 "ease-editor-embed.vala"
						break;
#line 959 "ease-editor-embed.c"
					}
#line 506 "ease-editor-embed.vala"
					self->priv->handles[i] = (_tmp4_ = g_object_ref_sink (ease_handle_new ((EaseHandlePosition) i)), _g_object_unref0 (self->priv->handles[i]), _tmp4_);
#line 507 "ease-editor-embed.vala"
					clutter_container_add_actor ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) self->priv->handles[i]);
#line 508 "ease-editor-embed.vala"
					g_signal_connect_object ((ClutterActor*) self->priv->handles[i], "button-press-event", (GCallback) _ease_editor_embed_handle_clicked_clutter_actor_button_press_event, self, 0);
#line 509 "ease-editor-embed.vala"
					g_signal_connect_object ((ClutterActor*) self->priv->handles[i], "button-release-event", (GCallback) _ease_editor_embed_handle_released_clutter_actor_button_release_event, self, 0);
#line 969 "ease-editor-embed.c"
				}
			}
		}
	}
	{
		gint i;
#line 513 "ease-editor-embed.vala"
		i = 0;
#line 978 "ease-editor-embed.c"
		{
			gboolean _tmp5_;
#line 513 "ease-editor-embed.vala"
			_tmp5_ = TRUE;
#line 513 "ease-editor-embed.vala"
			while (TRUE) {
#line 513 "ease-editor-embed.vala"
				if (!_tmp5_) {
#line 513 "ease-editor-embed.vala"
					i++;
#line 989 "ease-editor-embed.c"
				}
#line 513 "ease-editor-embed.vala"
				_tmp5_ = FALSE;
#line 513 "ease-editor-embed.vala"
				if (!(i < EASE_EDITOR_EMBED_HANDLE_COUNT)) {
#line 513 "ease-editor-embed.vala"
					break;
#line 997 "ease-editor-embed.c"
				}
#line 515 "ease-editor-embed.vala"
				ease_handle_reposition (self->priv->handles[i], (ClutterActor*) self->priv->selection_rectangle);
#line 516 "ease-editor-embed.vala"
				clutter_container_raise_child ((ClutterContainer*) ease_scrollable_embed_get_contents ((EaseScrollableEmbed*) self), (ClutterActor*) self->priv->handles[i], (ClutterActor*) self->priv->selection_rectangle);
#line 1003 "ease-editor-embed.c"
			}
		}
	}
#line 520 "ease-editor-embed.vala"
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
#line 521 "ease-editor-embed.vala"
	gtk_widget_grab_focus ((GtkWidget*) self);
#line 1011 "ease-editor-embed.c"
}


/**
 * Deselects the currently selected {@link Actor}.
 *
 * This method is safe to call if nothing is selected.
 */
#line 529 "ease-editor-embed.vala"
static void ease_editor_embed_deselect_actor (EaseEditorEmbed* self) {
#line 1022 "ease-editor-embed.c"
	gboolean _tmp0_ = FALSE;
#line 529 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 532 "ease-editor-embed.vala"
	if (ease_editor_embed_get_selected (self) != NULL) {
#line 532 "ease-editor-embed.vala"
		_tmp0_ = self->priv->_is_editing;
#line 1030 "ease-editor-embed.c"
	} else {
#line 532 "ease-editor-embed.vala"
		_tmp0_ = FALSE;
#line 1034 "ease-editor-embed.c"
	}
#line 532 "ease-editor-embed.vala"
	if (_tmp0_) {
#line 534 "ease-editor-embed.vala"
		ease_actor_end_edit (ease_editor_embed_get_selected (self), (GtkWidget*) self);
#line 535 "ease-editor-embed.vala"
		ease_editor_embed_set_is_editing (self, FALSE);
#line 536 "ease-editor-embed.vala"
		g_signal_emit_by_name (self, "element-deselected", ease_editor_embed_get_selected (self)->element);
#line 1044 "ease-editor-embed.c"
	}
#line 538 "ease-editor-embed.vala"
	ease_editor_embed_connect_keys (self);
#line 541 "ease-editor-embed.vala"
	ease_editor_embed_set_selected (self, NULL);
#line 544 "ease-editor-embed.vala"
	ease_editor_embed_remove_selection_rect (self);
#line 1052 "ease-editor-embed.c"
}


/**
 * Signal handler for releasing an {@link Actor}.
 * 
 * This handler is attached to the button_release_event of all
 * {@link Actor}s in the currently displayed {@link SlideActor}.
 *
 * When the {@link Actor} is being dragged, this ends the drag action.
 *
 * @param sender The {@link Actor} that was released
 * @param event The corresponding Clutter.Event
 */
#line 558 "ease-editor-embed.vala"
static gboolean ease_editor_embed_actor_released (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event) {
#line 1069 "ease-editor-embed.c"
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 558 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 558 "ease-editor-embed.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 560 "ease-editor-embed.vala"
	if (sender == CLUTTER_ACTOR (ease_editor_embed_get_selected (self))) {
#line 560 "ease-editor-embed.vala"
		_tmp0_ = self->priv->is_dragging;
#line 1080 "ease-editor-embed.c"
	} else {
#line 560 "ease-editor-embed.vala"
		_tmp0_ = FALSE;
#line 1084 "ease-editor-embed.c"
	}
#line 560 "ease-editor-embed.vala"
	if (_tmp0_) {
#line 1088 "ease-editor-embed.c"
		guint _tmp1_;
#line 562 "ease-editor-embed.vala"
		self->priv->is_dragging = FALSE;
#line 563 "ease-editor-embed.vala"
		clutter_ungrab_pointer ();
#line 564 "ease-editor-embed.vala"
		g_signal_parse_name ("motion-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
#line 564 "ease-editor-embed.vala"
		g_signal_handlers_disconnect_matched (sender, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_editor_embed_actor_motion_clutter_actor_motion_event, self);
#line 565 "ease-editor-embed.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) self->priv->move_undo);
#line 1100 "ease-editor-embed.c"
	}
	result = TRUE;
#line 567 "ease-editor-embed.vala"
	return result;
#line 1105 "ease-editor-embed.c"
}


/**
 * Signal handler for dragging an {@link Actor}.
 * 
 * This handler is attached to the motion_event of all
 * {@link Actor}s in the currently displayed {@link SlideActor}.
 * It will only have an effect if a drag is active.
 *
 * @param sender The {@link Actor} that was dragged
 * @param event The corresponding Clutter.Event
 */
#line 580 "ease-editor-embed.vala"
static gboolean ease_editor_embed_actor_motion (EaseEditorEmbed* self, ClutterActor* sender, ClutterMotionEvent* event) {
#line 1121 "ease-editor-embed.c"
	gboolean result = FALSE;
	EaseActor* actor;
	gboolean _tmp0_ = FALSE;
#line 580 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 580 "ease-editor-embed.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 582 "ease-editor-embed.vala"
	actor = _g_object_ref0 (EASE_ACTOR (sender));
#line 584 "ease-editor-embed.vala"
	if (sender == CLUTTER_ACTOR (ease_editor_embed_get_selected (self))) {
#line 584 "ease-editor-embed.vala"
		_tmp0_ = self->priv->is_dragging;
#line 1135 "ease-editor-embed.c"
	} else {
#line 584 "ease-editor-embed.vala"
		_tmp0_ = FALSE;
#line 1139 "ease-editor-embed.c"
	}
#line 584 "ease-editor-embed.vala"
	if (_tmp0_) {
#line 1143 "ease-editor-embed.c"
		float factor;
#line 586 "ease-editor-embed.vala"
		if (!self->priv->is_drag_initialized) {
#line 588 "ease-editor-embed.vala"
			self->priv->is_drag_initialized = TRUE;
#line 589 "ease-editor-embed.vala"
			self->priv->mouse_x = (*event).x;
#line 590 "ease-editor-embed.vala"
			self->priv->mouse_y = (*event).y;
#line 592 "ease-editor-embed.vala"
			self->priv->orig_x = clutter_actor_get_x ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 593 "ease-editor-embed.vala"
			self->priv->orig_y = clutter_actor_get_y ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 594 "ease-editor-embed.vala"
			self->priv->orig_w = clutter_actor_get_width ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 595 "ease-editor-embed.vala"
			self->priv->orig_h = clutter_actor_get_height ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 1161 "ease-editor-embed.c"
			result = TRUE;
			_g_object_unref0 (actor);
#line 597 "ease-editor-embed.vala"
			return result;
#line 1166 "ease-editor-embed.c"
		}
#line 600 "ease-editor-embed.vala"
		factor = 1 / ease_editor_embed_get_zoom (self);
#line 602 "ease-editor-embed.vala"
		ease_actor_translate (actor, factor * ((*event).x - self->priv->mouse_x), factor * ((*event).y - self->priv->mouse_y));
#line 605 "ease-editor-embed.vala"
		self->priv->mouse_x = (*event).x;
#line 606 "ease-editor-embed.vala"
		self->priv->mouse_y = (*event).y;
#line 608 "ease-editor-embed.vala"
		g_signal_emit_by_name (ease_editor_embed_get_selected (self)->element, "changed");
#line 1178 "ease-editor-embed.c"
	}
	result = TRUE;
	_g_object_unref0 (actor);
#line 610 "ease-editor-embed.vala"
	return result;
#line 1184 "ease-editor-embed.c"
}


/**
 * Signal handler for clicking on a {@link Handle}.
 * 
 * This handler is attached to the button_press_event of all
 * {@link Handle}s.
 *
 * @param sender The {@link Handle} that was clicked
 * @param event The corresponding Clutter.Event
 */
#line 675 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_handle_motion_clutter_actor_motion_event (ClutterActor* _sender, ClutterMotionEvent* event, gpointer self) {
#line 1199 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_handle_motion (self, _sender, event);
	return result;
}


#line 622 "ease-editor-embed.vala"
static gboolean ease_editor_embed_handle_clicked (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event) {
#line 1208 "ease-editor-embed.c"
	gboolean result = FALSE;
	ClutterActor* _tmp0_;
	EaseUndoAction* _tmp1_;
#line 622 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 622 "ease-editor-embed.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 624 "ease-editor-embed.vala"
	ease_handle_flip ((_tmp0_ = sender, EASE_IS_HANDLE (_tmp0_) ? ((EaseHandle*) _tmp0_) : NULL), TRUE);
#line 625 "ease-editor-embed.vala"
	self->priv->is_dragging = TRUE;
#line 626 "ease-editor-embed.vala"
	self->priv->is_drag_initialized = FALSE;
#line 627 "ease-editor-embed.vala"
	g_signal_connect_object (sender, "motion-event", (GCallback) _ease_editor_embed_handle_motion_clutter_actor_motion_event, self, 0);
#line 628 "ease-editor-embed.vala"
	clutter_grab_pointer (sender);
#line 631 "ease-editor-embed.vala"
	self->priv->move_undo = (_tmp1_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self)->element, "x"), _g_object_unref0 (self->priv->move_undo), _tmp1_);
#line 632 "ease-editor-embed.vala"
	ease_undo_action_add (self->priv->move_undo, (GObject*) ease_editor_embed_get_selected (self)->element, "y");
#line 633 "ease-editor-embed.vala"
	ease_undo_action_add (self->priv->move_undo, (GObject*) ease_editor_embed_get_selected (self)->element, "width");
#line 634 "ease-editor-embed.vala"
	ease_undo_action_add (self->priv->move_undo, (GObject*) ease_editor_embed_get_selected (self)->element, "height");
#line 1234 "ease-editor-embed.c"
	result = TRUE;
#line 636 "ease-editor-embed.vala"
	return result;
#line 1238 "ease-editor-embed.c"
}


/**
 * Signal handler for releasing an {@link Handle}.
 * 
 * This handler is attached to the button_release_event of all
 * {@link Handle}s.
 *
 * When the {@link Handle} is being dragged, this ends the drag action.
 *
 * @param sender The {@link Handle} that was released
 * @param event The corresponding Clutter.Event
 */
#line 650 "ease-editor-embed.vala"
static gboolean ease_editor_embed_handle_released (EaseEditorEmbed* self, ClutterActor* sender, ClutterButtonEvent* event) {
#line 1255 "ease-editor-embed.c"
	gboolean result = FALSE;
#line 650 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 650 "ease-editor-embed.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 652 "ease-editor-embed.vala"
	if (self->priv->is_dragging) {
#line 1263 "ease-editor-embed.c"
		ClutterActor* _tmp0_;
		guint _tmp1_;
#line 654 "ease-editor-embed.vala"
		ease_handle_flip ((_tmp0_ = sender, EASE_IS_HANDLE (_tmp0_) ? ((EaseHandle*) _tmp0_) : NULL), FALSE);
#line 655 "ease-editor-embed.vala"
		self->priv->is_dragging = FALSE;
#line 656 "ease-editor-embed.vala"
		g_signal_parse_name ("motion-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
#line 656 "ease-editor-embed.vala"
		g_signal_handlers_disconnect_matched (sender, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_editor_embed_handle_motion_clutter_actor_motion_event, self);
#line 657 "ease-editor-embed.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) self->priv->move_undo);
#line 1276 "ease-editor-embed.c"
	}
#line 660 "ease-editor-embed.vala"
	clutter_ungrab_pointer ();
#line 1280 "ease-editor-embed.c"
	result = TRUE;
#line 661 "ease-editor-embed.vala"
	return result;
#line 1284 "ease-editor-embed.c"
}


/**
 * Signal handler for dragging an {@link Handle}.
 * 
 * This handler is attached to the motion_event of all
 * {@link Handle}s.
 *
 * It will only have an effect if a drag is active.
 *
 * @param sender The {@link Handle} that was dragged
 * @param event The corresponding Clutter.Event
 */
#line 675 "ease-editor-embed.vala"
static gboolean ease_editor_embed_handle_motion (EaseEditorEmbed* self, ClutterActor* sender, ClutterMotionEvent* event) {
#line 1301 "ease-editor-embed.c"
	gboolean result = FALSE;
	EaseHandle* handle;
	float factor;
	gboolean proportional;
	gboolean from_center;
	float change_x;
	float change_y;
#line 675 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 675 "ease-editor-embed.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 677 "ease-editor-embed.vala"
	handle = _g_object_ref0 (EASE_HANDLE (sender));
#line 679 "ease-editor-embed.vala"
	if (!self->priv->is_drag_initialized) {
#line 681 "ease-editor-embed.vala"
		self->priv->is_drag_initialized = TRUE;
#line 682 "ease-editor-embed.vala"
		self->priv->mouse_x = (*event).x;
#line 683 "ease-editor-embed.vala"
		self->priv->mouse_y = (*event).y;
#line 685 "ease-editor-embed.vala"
		self->priv->orig_x = clutter_actor_get_x ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 686 "ease-editor-embed.vala"
		self->priv->orig_y = clutter_actor_get_y ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 687 "ease-editor-embed.vala"
		self->priv->orig_w = clutter_actor_get_width ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 688 "ease-editor-embed.vala"
		self->priv->orig_h = clutter_actor_get_height ((ClutterActor*) ease_editor_embed_get_selected (self));
#line 689 "ease-editor-embed.vala"
		self->priv->drag_total_x = (float) 0;
#line 690 "ease-editor-embed.vala"
		self->priv->drag_total_y = (float) 0;
#line 692 "ease-editor-embed.vala"
		self->priv->proportional_drag = ((*event).modifier_state & CLUTTER_SHIFT_MASK) != 0;
#line 694 "ease-editor-embed.vala"
		self->priv->from_center_drag = ((*event).modifier_state & CLUTTER_CONTROL_MASK) != 0;
#line 1339 "ease-editor-embed.c"
		result = TRUE;
		_g_object_unref0 (handle);
#line 697 "ease-editor-embed.vala"
		return result;
#line 1344 "ease-editor-embed.c"
	}
#line 700 "ease-editor-embed.vala"
	factor = 1 / ease_editor_embed_get_zoom (self);
#line 702 "ease-editor-embed.vala"
	proportional = ((*event).modifier_state & CLUTTER_SHIFT_MASK) != 0;
#line 704 "ease-editor-embed.vala"
	from_center = ((*event).modifier_state & CLUTTER_CONTROL_MASK) != 0;
#line 705 "ease-editor-embed.vala"
	change_x = (*event).x - self->priv->mouse_x;
#line 706 "ease-editor-embed.vala"
	change_y = (*event).y - self->priv->mouse_y;
#line 707 "ease-editor-embed.vala"
	self->priv->drag_total_x = self->priv->drag_total_x + change_x;
#line 708 "ease-editor-embed.vala"
	self->priv->drag_total_y = self->priv->drag_total_y + change_y;
#line 713 "ease-editor-embed.vala"
	if (proportional != self->priv->proportional_drag) {
#line 715 "ease-editor-embed.vala"
		ease_element_set_x (ease_editor_embed_get_selected (self)->element, self->priv->orig_x);
#line 716 "ease-editor-embed.vala"
		ease_element_set_y (ease_editor_embed_get_selected (self)->element, self->priv->orig_y);
#line 717 "ease-editor-embed.vala"
		ease_element_set_width (ease_editor_embed_get_selected (self)->element, self->priv->orig_w);
#line 718 "ease-editor-embed.vala"
		ease_element_set_height (ease_editor_embed_get_selected (self)->element, self->priv->orig_h);
#line 720 "ease-editor-embed.vala"
		ease_handle_drag (handle, self->priv->drag_total_x, self->priv->drag_total_y, ease_editor_embed_get_selected (self)->element, proportional, from_center);
#line 722 "ease-editor-embed.vala"
		self->priv->proportional_drag = proportional;
#line 1374 "ease-editor-embed.c"
		result = TRUE;
		_g_object_unref0 (handle);
#line 723 "ease-editor-embed.vala"
		return result;
#line 1379 "ease-editor-embed.c"
	}
	{
#line 736 "ease-editor-embed.vala"
		ease_handle_drag (handle, factor * change_x, factor * change_y, ease_editor_embed_get_selected (self)->element, proportional, from_center);
#line 1384 "ease-editor-embed.c"
	}
#line 740 "ease-editor-embed.vala"
	self->priv->mouse_x = (*event).x;
#line 741 "ease-editor-embed.vala"
	self->priv->mouse_y = (*event).y;
#line 743 "ease-editor-embed.vala"
	g_signal_emit_by_name (ease_editor_embed_get_selected (self)->element, "changed");
#line 1392 "ease-editor-embed.c"
	result = TRUE;
	_g_object_unref0 (handle);
#line 745 "ease-editor-embed.vala"
	return result;
#line 1397 "ease-editor-embed.c"
}


/**
 * Sets the color of the currently selected element, if applicable.
 *
 * If no element is selected, or the selected element does not have a
 * "color" property, this property is ignored.
 */
#line 754 "ease-editor-embed.vala"
void ease_editor_embed_set_element_color (EaseEditorEmbed* self, ClutterColor* color) {
#line 754 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 756 "ease-editor-embed.vala"
	if (ease_editor_embed_get_selected (self) == NULL) {
#line 756 "ease-editor-embed.vala"
		return;
#line 1415 "ease-editor-embed.c"
	}
#line 757 "ease-editor-embed.vala"
	if (!ease_element_set_color (ease_editor_embed_get_selected (self)->element, color)) {
#line 757 "ease-editor-embed.vala"
		return;
#line 1421 "ease-editor-embed.c"
	}
}


/**
 * Handles actor removal events. Deselects the current
 * {@link Actor} if necessary, and disconnects handlers.
 */
#line 764 "ease-editor-embed.vala"
void ease_editor_embed_on_ease_actor_removed (EaseEditorEmbed* self, EaseActor* actor) {
#line 1432 "ease-editor-embed.c"
	guint _tmp0_;
	guint _tmp1_;
#line 764 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 764 "ease-editor-embed.vala"
	g_return_if_fail (actor != NULL);
#line 766 "ease-editor-embed.vala"
	if (ease_editor_embed_get_selected (self) == actor) {
#line 766 "ease-editor-embed.vala"
		ease_editor_embed_deselect_actor (self);
#line 1443 "ease-editor-embed.c"
	}
#line 767 "ease-editor-embed.vala"
	g_signal_parse_name ("button-press-event", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
#line 767 "ease-editor-embed.vala"
	g_signal_handlers_disconnect_matched ((ClutterActor*) actor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ease_editor_embed_actor_clicked_clutter_actor_button_press_event, self);
#line 768 "ease-editor-embed.vala"
	g_signal_parse_name ("button-release-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
#line 768 "ease-editor-embed.vala"
	g_signal_handlers_disconnect_matched ((ClutterActor*) actor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_editor_embed_actor_released_clutter_actor_button_release_event, self);
#line 769 "ease-editor-embed.vala"
	clutter_actor_set_reactive ((ClutterActor*) actor, FALSE);
#line 1455 "ease-editor-embed.c"
}


/**
 * Handles new actor events. Connects handlers.
 */
#line 775 "ease-editor-embed.vala"
void ease_editor_embed_on_ease_actor_added (EaseEditorEmbed* self, EaseActor* actor) {
#line 775 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 775 "ease-editor-embed.vala"
	g_return_if_fail (actor != NULL);
#line 777 "ease-editor-embed.vala"
	g_signal_connect_object ((ClutterActor*) actor, "button-press-event", (GCallback) _ease_editor_embed_actor_clicked_clutter_actor_button_press_event, self, 0);
#line 778 "ease-editor-embed.vala"
	g_signal_connect_object ((ClutterActor*) actor, "button-release-event", (GCallback) _ease_editor_embed_actor_released_clutter_actor_button_release_event, self, 0);
#line 779 "ease-editor-embed.vala"
	clutter_actor_set_reactive ((ClutterActor*) actor, TRUE);
#line 1474 "ease-editor-embed.c"
}


/**
 * Handles keypresses within the embed.
 */
#line 785 "ease-editor-embed.vala"
gboolean ease_editor_embed_on_key_press_event (EaseEditorEmbed* self, GtkWidget* _self_, GdkEventKey* event) {
#line 1483 "ease-editor-embed.c"
	gboolean result = FALSE;
	gboolean shift;
#line 785 "ease-editor-embed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 785 "ease-editor-embed.vala"
	g_return_val_if_fail (_self_ != NULL, FALSE);
#line 787 "ease-editor-embed.vala"
	if ((*event).type == GDK_KEY_RELEASE) {
#line 1492 "ease-editor-embed.c"
		result = FALSE;
#line 787 "ease-editor-embed.vala"
		return result;
#line 1496 "ease-editor-embed.c"
	}
#line 789 "ease-editor-embed.vala"
	shift = ((*event).state & GDK_SHIFT_MASK) != 0;
#line 791 "ease-editor-embed.vala"
	switch ((*event).keyval) {
#line 1502 "ease-editor-embed.c"
		case EASE_KEY_UP:
		{
			EaseUndoAction* _tmp0_;
			gint _tmp1_ = 0;
#line 794 "ease-editor-embed.vala"
			if (ease_editor_embed_get_selected (self) == NULL) {
#line 794 "ease-editor-embed.vala"
				break;
#line 1511 "ease-editor-embed.c"
			}
#line 795 "ease-editor-embed.vala"
			if (self->priv->_is_editing) {
#line 1515 "ease-editor-embed.c"
				result = TRUE;
#line 795 "ease-editor-embed.vala"
				return result;
#line 1519 "ease-editor-embed.c"
			}
#line 797 "ease-editor-embed.vala"
			g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp0_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self)->element, "y")));
#line 1523 "ease-editor-embed.c"
			_g_object_unref0 (_tmp0_);
#line 798 "ease-editor-embed.vala"
			if (shift) {
#line 799 "ease-editor-embed.vala"
				_tmp1_ = -EASE_EDITOR_EMBED_NUDGE_SHIFT_PIXELS;
#line 1529 "ease-editor-embed.c"
			} else {
#line 799 "ease-editor-embed.vala"
				_tmp1_ = -EASE_EDITOR_EMBED_NUDGE_PIXELS;
#line 1533 "ease-editor-embed.c"
			}
#line 798 "ease-editor-embed.vala"
			ease_actor_translate (ease_editor_embed_get_selected (self), (float) 0, (float) _tmp1_);
#line 800 "ease-editor-embed.vala"
			g_signal_emit_by_name (ease_editor_embed_get_selected (self)->element, "changed");
#line 1539 "ease-editor-embed.c"
			result = TRUE;
#line 801 "ease-editor-embed.vala"
			return result;
#line 1543 "ease-editor-embed.c"
		}
		case EASE_KEY_DOWN:
		{
			EaseUndoAction* _tmp2_;
			gint _tmp3_ = 0;
#line 804 "ease-editor-embed.vala"
			if (ease_editor_embed_get_selected (self) == NULL) {
#line 804 "ease-editor-embed.vala"
				break;
#line 1553 "ease-editor-embed.c"
			}
#line 805 "ease-editor-embed.vala"
			if (self->priv->_is_editing) {
#line 1557 "ease-editor-embed.c"
				result = TRUE;
#line 805 "ease-editor-embed.vala"
				return result;
#line 1561 "ease-editor-embed.c"
			}
#line 807 "ease-editor-embed.vala"
			g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp2_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self)->element, "y")));
#line 1565 "ease-editor-embed.c"
			_g_object_unref0 (_tmp2_);
#line 808 "ease-editor-embed.vala"
			if (shift) {
#line 809 "ease-editor-embed.vala"
				_tmp3_ = EASE_EDITOR_EMBED_NUDGE_SHIFT_PIXELS;
#line 1571 "ease-editor-embed.c"
			} else {
#line 809 "ease-editor-embed.vala"
				_tmp3_ = EASE_EDITOR_EMBED_NUDGE_PIXELS;
#line 1575 "ease-editor-embed.c"
			}
#line 808 "ease-editor-embed.vala"
			ease_actor_translate (ease_editor_embed_get_selected (self), (float) 0, (float) _tmp3_);
#line 810 "ease-editor-embed.vala"
			g_signal_emit_by_name (ease_editor_embed_get_selected (self)->element, "changed");
#line 1581 "ease-editor-embed.c"
			result = TRUE;
#line 811 "ease-editor-embed.vala"
			return result;
#line 1585 "ease-editor-embed.c"
		}
		case EASE_KEY_LEFT:
		{
			EaseUndoAction* _tmp4_;
			gint _tmp5_ = 0;
#line 814 "ease-editor-embed.vala"
			if (ease_editor_embed_get_selected (self) == NULL) {
#line 814 "ease-editor-embed.vala"
				break;
#line 1595 "ease-editor-embed.c"
			}
#line 815 "ease-editor-embed.vala"
			if (self->priv->_is_editing) {
#line 1599 "ease-editor-embed.c"
				result = TRUE;
#line 815 "ease-editor-embed.vala"
				return result;
#line 1603 "ease-editor-embed.c"
			}
#line 817 "ease-editor-embed.vala"
			g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp4_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self)->element, "x")));
#line 1607 "ease-editor-embed.c"
			_g_object_unref0 (_tmp4_);
#line 818 "ease-editor-embed.vala"
			if (shift) {
#line 819 "ease-editor-embed.vala"
				_tmp5_ = -EASE_EDITOR_EMBED_NUDGE_SHIFT_PIXELS;
#line 1613 "ease-editor-embed.c"
			} else {
#line 819 "ease-editor-embed.vala"
				_tmp5_ = -EASE_EDITOR_EMBED_NUDGE_PIXELS;
#line 1617 "ease-editor-embed.c"
			}
#line 818 "ease-editor-embed.vala"
			ease_actor_translate (ease_editor_embed_get_selected (self), (float) _tmp5_, (float) 0);
#line 820 "ease-editor-embed.vala"
			g_signal_emit_by_name (ease_editor_embed_get_selected (self)->element, "changed");
#line 1623 "ease-editor-embed.c"
			result = TRUE;
#line 821 "ease-editor-embed.vala"
			return result;
#line 1627 "ease-editor-embed.c"
		}
		case EASE_KEY_RIGHT:
		{
			EaseUndoAction* _tmp6_;
			gint _tmp7_ = 0;
#line 824 "ease-editor-embed.vala"
			if (ease_editor_embed_get_selected (self) == NULL) {
#line 824 "ease-editor-embed.vala"
				break;
#line 1637 "ease-editor-embed.c"
			}
#line 825 "ease-editor-embed.vala"
			if (self->priv->_is_editing) {
#line 1641 "ease-editor-embed.c"
				result = TRUE;
#line 825 "ease-editor-embed.vala"
				return result;
#line 1645 "ease-editor-embed.c"
			}
#line 827 "ease-editor-embed.vala"
			g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp6_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self)->element, "x")));
#line 1649 "ease-editor-embed.c"
			_g_object_unref0 (_tmp6_);
#line 828 "ease-editor-embed.vala"
			if (shift) {
#line 829 "ease-editor-embed.vala"
				_tmp7_ = EASE_EDITOR_EMBED_NUDGE_SHIFT_PIXELS;
#line 1655 "ease-editor-embed.c"
			} else {
#line 829 "ease-editor-embed.vala"
				_tmp7_ = EASE_EDITOR_EMBED_NUDGE_PIXELS;
#line 1659 "ease-editor-embed.c"
			}
#line 828 "ease-editor-embed.vala"
			ease_actor_translate (ease_editor_embed_get_selected (self), (float) _tmp7_, (float) 0);
#line 830 "ease-editor-embed.vala"
			g_signal_emit_by_name (ease_editor_embed_get_selected (self)->element, "changed");
#line 1665 "ease-editor-embed.c"
			result = TRUE;
#line 831 "ease-editor-embed.vala"
			return result;
#line 1669 "ease-editor-embed.c"
		}
		case EASE_KEY_BACKSPACE:
		case EASE_KEY_DELETE:
		{
			EaseSlide* slide;
			gint i;
#line 835 "ease-editor-embed.vala"
			if (ease_editor_embed_get_selected (self) == NULL) {
#line 835 "ease-editor-embed.vala"
				break;
#line 1680 "ease-editor-embed.c"
			}
#line 837 "ease-editor-embed.vala"
			slide = _g_object_ref0 (ease_slide_actor_get_slide (self->slide_actor));
#line 838 "ease-editor-embed.vala"
			i = ease_slide_index_of (slide, ease_editor_embed_get_selected (self)->element);
#line 839 "ease-editor-embed.vala"
			ease_slide_remove_at (slide, i);
#line 840 "ease-editor-embed.vala"
			g_signal_emit_by_name (self, "element-deselected", NULL);
#line 1690 "ease-editor-embed.c"
			result = TRUE;
			_g_object_unref0 (slide);
#line 842 "ease-editor-embed.vala"
			return result;
#line 1695 "ease-editor-embed.c"
		}
	}
	result = FALSE;
#line 845 "ease-editor-embed.vala"
	return result;
#line 1701 "ease-editor-embed.c"
}


/**
 * Handles {@link Slide.element_removed}.
 */
#line 851 "ease-editor-embed.vala"
void ease_editor_embed_on_element_removed (EaseEditorEmbed* self, EaseSlide* slide, EaseElement* element, gint index) {
#line 851 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 851 "ease-editor-embed.vala"
	g_return_if_fail (slide != NULL);
#line 851 "ease-editor-embed.vala"
	g_return_if_fail (element != NULL);
#line 853 "ease-editor-embed.vala"
	if (slide != ease_slide_actor_get_slide (self->slide_actor)) {
#line 853 "ease-editor-embed.vala"
		return;
#line 1720 "ease-editor-embed.c"
	}
#line 854 "ease-editor-embed.vala"
	if (ease_editor_embed_get_selected (self) == NULL) {
#line 854 "ease-editor-embed.vala"
		g_signal_emit_by_name (self, "element-deselected", element);
#line 1726 "ease-editor-embed.c"
	}
}


/**
 * Connects the key event handlers.
 */
#line 785 "ease-editor-embed.vala"
static gboolean _ease_editor_embed_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
#line 1736 "ease-editor-embed.c"
	gboolean result;
	result = ease_editor_embed_on_key_press_event (self, _sender, event);
	return result;
}


#line 860 "ease-editor-embed.vala"
void ease_editor_embed_connect_keys (EaseEditorEmbed* self) {
#line 860 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 862 "ease-editor-embed.vala"
	if (self->priv->keys_connected) {
#line 862 "ease-editor-embed.vala"
		return;
#line 1751 "ease-editor-embed.c"
	}
#line 863 "ease-editor-embed.vala"
	self->priv->keys_connected = TRUE;
#line 864 "ease-editor-embed.vala"
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _ease_editor_embed_on_key_press_event_gtk_widget_key_press_event, self, 0);
#line 1757 "ease-editor-embed.c"
}


/**
 * Disconnects the key event handlers.
 */
#line 870 "ease-editor-embed.vala"
void ease_editor_embed_disconnect_keys (EaseEditorEmbed* self) {
#line 1766 "ease-editor-embed.c"
	guint _tmp0_;
#line 870 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 872 "ease-editor-embed.vala"
	if (!self->priv->keys_connected) {
#line 872 "ease-editor-embed.vala"
		return;
#line 1774 "ease-editor-embed.c"
	}
#line 873 "ease-editor-embed.vala"
	self->priv->keys_connected = FALSE;
#line 874 "ease-editor-embed.vala"
	g_signal_parse_name ("key-press-event", GTK_TYPE_WIDGET, &_tmp0_, NULL, FALSE);
#line 874 "ease-editor-embed.vala"
	g_signal_handlers_disconnect_matched ((GtkWidget*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ease_editor_embed_on_key_press_event_gtk_widget_key_press_event, self);
#line 1782 "ease-editor-embed.c"
}


/**
 * Notifies of changes to the selected actor.
 */
#line 880 "ease-editor-embed.vala"
void ease_editor_embed_on_selected_changed (EaseEditorEmbed* self, EaseSlide* sender) {
#line 880 "ease-editor-embed.vala"
	g_return_if_fail (self != NULL);
#line 880 "ease-editor-embed.vala"
	g_return_if_fail (sender != NULL);
#line 882 "ease-editor-embed.vala"
	if (self->priv->selection_rectangle == NULL) {
#line 882 "ease-editor-embed.vala"
		return;
#line 1799 "ease-editor-embed.c"
	}
#line 883 "ease-editor-embed.vala"
	ease_editor_embed_position_selection (self);
#line 1803 "ease-editor-embed.c"
}


EaseActor* ease_editor_embed_get_selected (EaseEditorEmbed* self) {
	EaseActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->selected_priv;
#line 57 "ease-editor-embed.vala"
	return result;
#line 1813 "ease-editor-embed.c"
}


#line 880 "ease-editor-embed.vala"
static void _ease_editor_embed_on_selected_changed_ease_slide_changed (EaseSlide* _sender, EaseSlide* _self_, gpointer self) {
#line 1819 "ease-editor-embed.c"
	ease_editor_embed_on_selected_changed (self, _self_);
}


static void ease_editor_embed_set_selected (EaseEditorEmbed* self, EaseActor* value) {
	EaseActor* _tmp1_;
	g_return_if_fail (self != NULL);
#line 60 "ease-editor-embed.vala"
	if (self->priv->selected_priv != NULL) {
#line 1829 "ease-editor-embed.c"
		guint _tmp0_;
#line 62 "ease-editor-embed.vala"
		g_signal_parse_name ("changed", EASE_TYPE_SLIDE, &_tmp0_, NULL, FALSE);
#line 62 "ease-editor-embed.vala"
		g_signal_handlers_disconnect_matched (ease_slide_actor_get_slide (self->slide_actor), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ease_editor_embed_on_selected_changed_ease_slide_changed, self);
#line 1835 "ease-editor-embed.c"
	}
#line 64 "ease-editor-embed.vala"
	self->priv->selected_priv = (_tmp1_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->selected_priv), _tmp1_);
#line 65 "ease-editor-embed.vala"
	if (value != NULL) {
#line 67 "ease-editor-embed.vala"
		g_signal_connect_object (ease_slide_actor_get_slide (self->slide_actor), "changed", (GCallback) _ease_editor_embed_on_selected_changed_ease_slide_changed, self, 0);
#line 1843 "ease-editor-embed.c"
	}
	g_object_notify ((GObject *) self, "selected");
}


static gboolean ease_editor_embed_get_is_editing (EaseEditorEmbed* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_editing;
#line 76 "ease-editor-embed.vala"
	return result;
#line 1855 "ease-editor-embed.c"
}


static void ease_editor_embed_set_is_editing (EaseEditorEmbed* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_editing = value;
}


float ease_editor_embed_get_zoom (EaseEditorEmbed* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->zoom_priv;
#line 197 "ease-editor-embed.vala"
	return result;
#line 1871 "ease-editor-embed.c"
}


void ease_editor_embed_set_zoom (EaseEditorEmbed* self, float value) {
	g_return_if_fail (self != NULL);
#line 201 "ease-editor-embed.vala"
	self->priv->zoom_priv = value;
#line 202 "ease-editor-embed.vala"
	ease_editor_embed_reposition_group (self);
#line 1881 "ease-editor-embed.c"
	g_object_notify ((GObject *) self, "zoom");
}


gboolean ease_editor_embed_get_zoom_fit (EaseEditorEmbed* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_zoom_fit;
#line 214 "ease-editor-embed.vala"
	return result;
#line 1892 "ease-editor-embed.c"
}


void ease_editor_embed_set_zoom_fit (EaseEditorEmbed* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_zoom_fit = value;
	g_object_notify ((GObject *) self, "zoom-fit");
}


static void ease_editor_embed_class_init (EaseEditorEmbedClass * klass) {
	ease_editor_embed_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseEditorEmbedPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_editor_embed_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_editor_embed_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_editor_embed_finalize;
	/**
	 * The currently selected {@link Actor}.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_EDITOR_EMBED_SELECTED, g_param_spec_object ("selected", "selected", "selected", EASE_TYPE_ACTOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The zoom level of the slide displayed by this EditorEmbed.
	 * 
	 * When this property is set is called, only the EditorEmbed's zoom level
	 * is set. Therefore, any other relevant parts of the interface should
	 * also be updated by the method setting the zoom value.
	 *
	 * The zoom level is set on a 0-1 scale. Higher values, are, of
	 * course, possible, but values below 0.1 or so are unlikely to produce
	 * desirable results.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_EDITOR_EMBED_ZOOM, g_param_spec_float ("zoom", "zoom", "zoom", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * If the zoom factor should automatically be set to fill the EditorEmbed.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_EDITOR_EMBED_ZOOM_FIT, g_param_spec_boolean ("zoom-fit", "zoom-fit", "zoom-fit", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("element_selected", EASE_TYPE_EDITOR_EMBED, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_ELEMENT);
	g_signal_new ("element_deselected", EASE_TYPE_EDITOR_EMBED, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_ELEMENT);
}


static void ease_editor_embed_ease_undo_source_interface_init (EaseUndoSourceIface * iface) {
	ease_editor_embed_ease_undo_source_parent_iface = g_type_interface_peek_parent (iface);
}


static void ease_editor_embed_instance_init (EaseEditorEmbed * self) {
	self->priv = EASE_EDITOR_EMBED_GET_PRIVATE (self);
	self->priv->keys_connected = FALSE;
}


static void ease_editor_embed_finalize (GObject* obj) {
	EaseEditorEmbed * self;
	self = EASE_EDITOR_EMBED (obj);
	_g_object_unref0 (self->priv->win);
	_g_object_unref0 (self->priv->selection_rectangle);
	self->priv->handles = (_vala_array_free (self->priv->handles, self->priv->handles_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->slide_actor);
	_g_object_unref0 (self->priv->selected_priv);
	_g_object_unref0 (self->priv->move_undo);
	_g_object_unref0 (self->priv->document);
	G_OBJECT_CLASS (ease_editor_embed_parent_class)->finalize (obj);
}


/**
 * The main editing widget.
 *
 * EditorEmbed is the outermost part of the editing canvas in an Ease
 * window. Each EditorEmbed is linked to a {@link Document}, and
 * changes in the editor are immediately reflected in the Document, but
 * are not saved to disk until the user clicks on a save button or
 * menu item.
 * 
 * EditorEmbed is a subclass of {@link ScrollableEmbed}, and has both
 * horizontal and vertical scrollbars.
 */
GType ease_editor_embed_get_type (void) {
	static volatile gsize ease_editor_embed_type_id__volatile = 0;
	if (g_once_init_enter (&ease_editor_embed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseEditorEmbedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_editor_embed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseEditorEmbed), 0, (GInstanceInitFunc) ease_editor_embed_instance_init, NULL };
		static const GInterfaceInfo ease_undo_source_info = { (GInterfaceInitFunc) ease_editor_embed_ease_undo_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType ease_editor_embed_type_id;
		ease_editor_embed_type_id = g_type_register_static (EASE_TYPE_SCROLLABLE_EMBED, "EaseEditorEmbed", &g_define_type_info, 0);
		g_type_add_interface_static (ease_editor_embed_type_id, EASE_TYPE_UNDO_SOURCE, &ease_undo_source_info);
		g_once_init_leave (&ease_editor_embed_type_id__volatile, ease_editor_embed_type_id);
	}
	return ease_editor_embed_type_id__volatile;
}


static void ease_editor_embed_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseEditorEmbed * self;
	self = EASE_EDITOR_EMBED (object);
	switch (property_id) {
		case EASE_EDITOR_EMBED_SELECTED:
		g_value_set_object (value, ease_editor_embed_get_selected (self));
		break;
		case EASE_EDITOR_EMBED_ZOOM:
		g_value_set_float (value, ease_editor_embed_get_zoom (self));
		break;
		case EASE_EDITOR_EMBED_ZOOM_FIT:
		g_value_set_boolean (value, ease_editor_embed_get_zoom_fit (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_editor_embed_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseEditorEmbed * self;
	self = EASE_EDITOR_EMBED (object);
	switch (property_id) {
		case EASE_EDITOR_EMBED_SELECTED:
		ease_editor_embed_set_selected (self, g_value_get_object (value));
		break;
		case EASE_EDITOR_EMBED_ZOOM:
		ease_editor_embed_set_zoom (self, g_value_get_float (value));
		break;
		case EASE_EDITOR_EMBED_ZOOM_FIT:
		ease_editor_embed_set_zoom_fit (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




