/* persona-store.c generated by valac, the Vala compiler
 * generated from persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;
typedef struct _FolksPersonaStorePrivate FolksPersonaStorePrivate;

#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;

#define FOLKS_GROUPS_TYPE_CHANGE_REASON (folks_groups_change_reason_get_type ())

typedef enum  {
	FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT,
	FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED
} FolksPersonaStoreError;
#define FOLKS_PERSONA_STORE_ERROR folks_persona_store_error_quark ()
struct _FolksPersonaStore {
	GObject parent_instance;
	FolksPersonaStorePrivate * priv;
};

struct _FolksPersonaStoreClass {
	GObjectClass parent_class;
	void (*prepare) (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_finish) (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
	void (*add_persona_from_details) (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
	FolksPersona* (*add_persona_from_details_finish) (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
	void (*remove_persona) (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_persona_finish) (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
	const char* (*get_type_id) (FolksPersonaStore* self);
	void (*set_type_id) (FolksPersonaStore* self, const char* value);
	const char* (*get_id) (FolksPersonaStore* self);
	void (*set_id) (FolksPersonaStore* self, const char* value);
	GHashTable* (*get_personas) (FolksPersonaStore* self);
};

typedef enum  {
	FOLKS_GROUPS_CHANGE_REASON_NONE = 0,
	FOLKS_GROUPS_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUPS_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUPS_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUPS_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUPS_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUPS_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUPS_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUPS_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUPS_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUPS_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUPS_CHANGE_REASON_SEPARATED = 11
} FolksGroupsChangeReason;


static gpointer folks_persona_store_parent_class = NULL;

GQuark folks_persona_store_error_quark (void);
GType folks_persona_store_get_type (void) G_GNUC_CONST;
GType folks_persona_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_PERSONA_STORE_DUMMY_PROPERTY,
	FOLKS_PERSONA_STORE_TYPE_ID,
	FOLKS_PERSONA_STORE_ID,
	FOLKS_PERSONA_STORE_PERSONAS
};
void folks_persona_store_prepare (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_prepare_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
void folks_persona_store_add_persona_from_details (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* folks_persona_store_add_persona_from_details_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
void folks_persona_store_remove_persona (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_remove_persona_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
FolksPersonaStore* folks_persona_store_construct (GType object_type);
const char* folks_persona_store_get_type_id (FolksPersonaStore* self);
void folks_persona_store_set_type_id (FolksPersonaStore* self, const char* value);
const char* folks_persona_store_get_id (FolksPersonaStore* self);
void folks_persona_store_set_id (FolksPersonaStore* self, const char* value);
GHashTable* folks_persona_store_get_personas (FolksPersonaStore* self);
GType folks_groups_change_reason_get_type (void) G_GNUC_CONST;
static void folks_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void folks_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

GQuark folks_persona_store_error_quark (void) {
	return g_quark_from_static_string ("folks_persona_store_error-quark");
}


void folks_persona_store_prepare (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->prepare (self, _callback_, _user_data_);
}


void folks_persona_store_prepare_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->prepare_finish (self, _res_, error);
}


void folks_persona_store_add_persona_from_details (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->add_persona_from_details (self, details, _callback_, _user_data_);
}


FolksPersona* folks_persona_store_add_persona_from_details_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error) {
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->add_persona_from_details_finish (self, _res_, error);
}


void folks_persona_store_remove_persona (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->remove_persona (self, persona, _callback_, _user_data_);
}


void folks_persona_store_remove_persona_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->remove_persona_finish (self, _res_, error);
}


FolksPersonaStore* folks_persona_store_construct (GType object_type) {
	FolksPersonaStore * self;
	self = (FolksPersonaStore*) g_object_new (object_type, NULL);
	return self;
}


const char* folks_persona_store_get_type_id (FolksPersonaStore* self) {
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_type_id (self);
}


void folks_persona_store_set_type_id (FolksPersonaStore* self, const char* value) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->set_type_id (self, value);
}


const char* folks_persona_store_get_id (FolksPersonaStore* self) {
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_id (self);
}


void folks_persona_store_set_id (FolksPersonaStore* self, const char* value) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->set_id (self, value);
}


GHashTable* folks_persona_store_get_personas (FolksPersonaStore* self) {
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_personas (self);
}


static void folks_persona_store_class_init (FolksPersonaStoreClass * klass) {
	folks_persona_store_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = folks_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = folks_persona_store_set_property;
	/**
	   * The type of PersonaStore this is.
	   *
	   * This is the same for all PersonaStores provided by a given {@link Backend}.
	   *
	   * This is guaranteed to always be available; even before
	   * {@link PersonaStore.prepare} is called.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_TYPE_ID, g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The instance identifier for this PersonaStore.
	   *
	   * Since each {@link Backend} can provide multiple different PersonaStores
	   * for different accounts or servers (for example), they each need an ID
	   * which is unique within the backend.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_PERSONAS, g_param_spec_boxed ("personas", "personas", "personas", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Emitted when one or more {@link Persona}s are added to or removed from
	   * the store.
	   *
	   * This will not be emitted until after {@link PersonaStore.prepare} has been
	   * called.
	   *
	   * @param added a list of {@link Persona}s which have been removed
	   * @param removed a list of {@link Persona}s which have been removed
	   * @param message a string message from the backend, if any
	   * @param actor the {@link Persona} who made the change, if known
	   * @param reason the reason for the change
	   */
	g_signal_new ("personas_changed", FOLKS_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM, G_TYPE_NONE, 5, G_TYPE_POINTER, G_TYPE_POINTER, G_TYPE_STRING, FOLKS_TYPE_PERSONA, FOLKS_GROUPS_TYPE_CHANGE_REASON);
	/**
	   * Emitted when the backing store for this PersonaStore has been removed.
	   *
	   * At this point, the PersonaStore and all its {@link Persona}s are invalid,
	   * so any client referencing it should unreference it.
	   *
	   * This will not be emitted until after {@link PersonaStore.prepare} has been
	   * called.
	   */
	g_signal_new ("removed", FOLKS_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void folks_persona_store_instance_init (FolksPersonaStore * self) {
}


/**
 * A store for {@link Persona}s.
 *
 * After creating a PersonaStore instance, you must connect to the
 * {@link PersonaStore.personas_changed} signal, //then// call
 * {@link PersonaStore.prepare}, otherwise a race condition may occur between
 * emission of {@link PersonaStore.personas_changed} and your code connecting to
 * it.
 */
GType folks_persona_store_get_type (void) {
	static volatile gsize folks_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&folks_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPersonaStore), 0, (GInstanceInitFunc) folks_persona_store_instance_init, NULL };
		GType folks_persona_store_type_id;
		folks_persona_store_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPersonaStore", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&folks_persona_store_type_id__volatile, folks_persona_store_type_id);
	}
	return folks_persona_store_type_id__volatile;
}


static void folks_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksPersonaStore * self;
	self = FOLKS_PERSONA_STORE (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void folks_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksPersonaStore * self;
	self = FOLKS_PERSONA_STORE (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



static void g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_string (param_values + 3), g_value_get_object (param_values + 4), g_value_get_enum (param_values + 5), data2);
}



