/* individual.c generated by valac 0.10.0-dirty, the Vala compiler
 * generated from individual.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define FOLKS_TYPE_TRUST_LEVEL (folks_trust_level_get_type ())

#define FOLKS_TYPE_ALIAS (folks_alias_get_type ())
#define FOLKS_ALIAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ALIAS, FolksAlias))
#define FOLKS_IS_ALIAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ALIAS))
#define FOLKS_ALIAS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_ALIAS, FolksAliasIface))

typedef struct _FolksAlias FolksAlias;
typedef struct _FolksAliasIface FolksAliasIface;

#define FOLKS_TYPE_AVATAR (folks_avatar_get_type ())
#define FOLKS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_AVATAR, FolksAvatar))
#define FOLKS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_AVATAR))
#define FOLKS_AVATAR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_AVATAR, FolksAvatarIface))

typedef struct _FolksAvatar FolksAvatar;
typedef struct _FolksAvatarIface FolksAvatarIface;

#define FOLKS_TYPE_FAVOURITE (folks_favourite_get_type ())
#define FOLKS_FAVOURITE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_FAVOURITE, FolksFavourite))
#define FOLKS_IS_FAVOURITE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_FAVOURITE))
#define FOLKS_FAVOURITE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_FAVOURITE, FolksFavouriteIface))

typedef struct _FolksFavourite FolksFavourite;
typedef struct _FolksFavouriteIface FolksFavouriteIface;

#define FOLKS_TYPE_GROUPS (folks_groups_get_type ())
#define FOLKS_GROUPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_GROUPS, FolksGroups))
#define FOLKS_IS_GROUPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_GROUPS))
#define FOLKS_GROUPS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_GROUPS, FolksGroupsIface))

typedef struct _FolksGroups FolksGroups;
typedef struct _FolksGroupsIface FolksGroupsIface;

#define FOLKS_TYPE_PRESENCE (folks_presence_get_type ())
#define FOLKS_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PRESENCE, FolksPresence))
#define FOLKS_IS_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PRESENCE))
#define FOLKS_PRESENCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_PRESENCE, FolksPresenceIface))

typedef struct _FolksPresence FolksPresence;
typedef struct _FolksPresenceIface FolksPresenceIface;

#define FOLKS_TYPE_PRESENCE_TYPE (folks_presence_type_get_type ())

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;
typedef struct _FolksIndividualPrivate FolksIndividualPrivate;

#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _FolksIndividualChangeGroupData FolksIndividualChangeGroupData;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))

#define FOLKS_GROUPS_TYPE_CHANGE_REASON (folks_groups_change_reason_get_type ())
typedef struct _Block2Data Block2Data;
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

#define FOLKS_TYPE_PERSONA_STORE_TRUST (folks_persona_store_trust_get_type ())
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;

typedef enum  {
	FOLKS_TRUST_LEVEL_NONE,
	FOLKS_TRUST_LEVEL_PERSONAS
} FolksTrustLevel;

struct _FolksAliasIface {
	GTypeInterface parent_iface;
	const char* (*get_alias) (FolksAlias* self);
	void (*set_alias) (FolksAlias* self, const char* value);
};

struct _FolksAvatarIface {
	GTypeInterface parent_iface;
	GFile* (*get_avatar) (FolksAvatar* self);
	void (*set_avatar) (FolksAvatar* self, GFile* value);
};

struct _FolksFavouriteIface {
	GTypeInterface parent_iface;
	gboolean (*get_is_favourite) (FolksFavourite* self);
	void (*set_is_favourite) (FolksFavourite* self, gboolean value);
};

struct _FolksGroupsIface {
	GTypeInterface parent_iface;
	void (*change_group) (FolksGroups* self, const char* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_group_finish) (FolksGroups* self, GAsyncResult* _res_, GError** error);
	GHashTable* (*get_groups) (FolksGroups* self);
	void (*set_groups) (FolksGroups* self, GHashTable* value);
};

typedef enum  {
	FOLKS_PRESENCE_TYPE_UNSET,
	FOLKS_PRESENCE_TYPE_OFFLINE,
	FOLKS_PRESENCE_TYPE_AVAILABLE,
	FOLKS_PRESENCE_TYPE_AWAY,
	FOLKS_PRESENCE_TYPE_EXTENDED_AWAY,
	FOLKS_PRESENCE_TYPE_HIDDEN,
	FOLKS_PRESENCE_TYPE_BUSY,
	FOLKS_PRESENCE_TYPE_UNKNOWN,
	FOLKS_PRESENCE_TYPE_ERROR
} FolksPresenceType;

struct _FolksPresenceIface {
	GTypeInterface parent_iface;
	FolksPresenceType (*get_presence_type) (FolksPresence* self);
	void (*set_presence_type) (FolksPresence* self, FolksPresenceType value);
	const char* (*get_presence_message) (FolksPresence* self);
	void (*set_presence_message) (FolksPresence* self, const char* value);
};

struct _FolksIndividual {
	GObject parent_instance;
	FolksIndividualPrivate * priv;
};

struct _FolksIndividualClass {
	GObjectClass parent_class;
};

struct _FolksIndividualPrivate {
	gboolean _is_favourite;
	char* _alias;
	GHashTable* _groups;
	GList* _persona_list;
	GeeHashSet* _persona_set;
	GeeHashMap* stores;
	FolksTrustLevel _trust_level;
	GFile* _avatar;
	FolksPresenceType _presence_type;
	char* _presence_message;
	char* _id;
};

struct _Block1Data {
	int _ref_count_;
	FolksIndividual * self;
	char* group;
	gboolean is_member;
	gpointer _async_data_;
};

struct _FolksIndividualChangeGroupData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividual* self;
	char* group;
	gboolean is_member;
	Block1Data* _data1_;
};

typedef enum  {
	FOLKS_GROUPS_CHANGE_REASON_NONE = 0,
	FOLKS_GROUPS_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUPS_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUPS_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUPS_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUPS_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUPS_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUPS_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUPS_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUPS_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUPS_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUPS_CHANGE_REASON_SEPARATED = 11
} FolksGroupsChangeReason;

struct _Block2Data {
	int _ref_count_;
	FolksIndividual * self;
	GList* removed_personas;
};

struct _Block3Data {
	int _ref_count_;
	FolksIndividual * self;
	GHashTable* new_groups;
	GList* removes;
};

struct _Block4Data {
	int _ref_count_;
	FolksIndividual * self;
	char* presence_message;
	FolksPresenceType presence_type;
};

struct _Block5Data {
	int _ref_count_;
	FolksIndividual * self;
	gboolean favourite;
};

struct _Block6Data {
	int _ref_count_;
	FolksIndividual * self;
	GFile* avatar;
};

typedef enum  {
	FOLKS_PERSONA_STORE_TRUST_NONE,
	FOLKS_PERSONA_STORE_TRUST_PARTIAL,
	FOLKS_PERSONA_STORE_TRUST_FULL
} FolksPersonaStoreTrust;

struct _Block7Data {
	int _ref_count_;
	FolksIndividual * self;
	gboolean alias_changed;
	char* value;
};

struct _Block8Data {
	int _ref_count_;
	FolksIndividual * self;
	gboolean value;
};

struct _Block9Data {
	int _ref_count_;
	FolksIndividual * self;
	GHashTable* value;
};


static gpointer folks_individual_parent_class = NULL;
static FolksAliasIface* folks_individual_folks_alias_parent_iface = NULL;
static FolksAvatarIface* folks_individual_folks_avatar_parent_iface = NULL;
static FolksFavouriteIface* folks_individual_folks_favourite_parent_iface = NULL;
static FolksGroupsIface* folks_individual_folks_groups_parent_iface = NULL;
static FolksPresenceIface* folks_individual_folks_presence_parent_iface = NULL;

GType folks_trust_level_get_type (void) G_GNUC_CONST;
GType folks_alias_get_type (void) G_GNUC_CONST;
GType folks_avatar_get_type (void) G_GNUC_CONST;
GType folks_favourite_get_type (void) G_GNUC_CONST;
GType folks_groups_get_type (void) G_GNUC_CONST;
GType folks_presence_type_get_type (void) G_GNUC_CONST;
GType folks_presence_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
GType folks_persona_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
#define FOLKS_INDIVIDUAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_INDIVIDUAL, FolksIndividualPrivate))
enum  {
	FOLKS_INDIVIDUAL_DUMMY_PROPERTY,
	FOLKS_INDIVIDUAL_TRUST_LEVEL,
	FOLKS_INDIVIDUAL_AVATAR,
	FOLKS_INDIVIDUAL_PRESENCE_TYPE,
	FOLKS_INDIVIDUAL_PRESENCE_MESSAGE,
	FOLKS_INDIVIDUAL_ID,
	FOLKS_INDIVIDUAL_ALIAS,
	FOLKS_INDIVIDUAL_IS_FAVOURITE,
	FOLKS_INDIVIDUAL_GROUPS,
	FOLKS_INDIVIDUAL_PERSONAS
};
static void folks_individual_notify_alias_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
static void folks_individual_update_alias (FolksIndividual* self);
static void folks_individual_notify_avatar_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
static void folks_individual_update_avatar (FolksIndividual* self);
static void folks_individual_persona_group_changed_cb (FolksIndividual* self, const char* group, gboolean is_member);
static void folks_individual_update_groups (FolksIndividual* self);
static void folks_individual_real_change_group_data_free (gpointer _data);
static void folks_individual_real_change_group (FolksGroups* base, const char* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_individual_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_individual_real_change_group_co (FolksIndividualChangeGroupData* data);
static void _lambda7_ (void* p, Block1Data* _data1_);
void folks_groups_change_group (FolksGroups* self, const char* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_groups_change_group_finish (FolksGroups* self, GAsyncResult* _res_, GError** error);
static void __lambda7__gfunc (void* data, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void folks_individual_notify_presence_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
static void folks_individual_update_presence (FolksIndividual* self);
static void folks_individual_notify_is_favourite_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
static void folks_individual_update_is_favourite (FolksIndividual* self);
FolksIndividual* folks_individual_new (GList* personas);
FolksIndividual* folks_individual_construct (GType object_type, GList* personas);
void folks_individual_set_personas (FolksIndividual* self, GList* value);
static void folks_individual_store_removed_cb (FolksIndividual* self, FolksPersonaStore* store);
static void _g_list_free_g_object_unref (GList* self);
static void folks_individual_update_fields (FolksIndividual* self);
GType folks_groups_change_reason_get_type (void) G_GNUC_CONST;
static void folks_individual_store_personas_changed_cb (FolksIndividual* self, FolksPersonaStore* store, GList* added, GList* removed, const char* message, FolksPersona* actor, FolksGroupsChangeReason reason);
static void _lambda10_ (void* data, Block2Data* _data2_);
static void __lambda10__gfunc (void* data, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void folks_individual_update_trust_level (FolksIndividual* self);
static void _lambda1_ (void* p, Block3Data* _data3_);
GHashTable* folks_groups_get_groups (FolksGroups* self);
static void _lambda2_ (void* k, void* v, Block3Data* _data3_);
static void __lambda2__gh_func (void* key, void* value, gpointer self);
static void __lambda1__gfunc (void* data, gpointer self);
static void _lambda3_ (void* k, void* v, FolksIndividual* self);
static void _lambda4_ (void* k, void* v, FolksIndividual* self);
static void __lambda4__gh_func (void* key, void* value, gpointer self);
static void __lambda3__gh_func (void* key, void* value, gpointer self);
static void _lambda5_ (void* k, void* v, Block3Data* _data3_);
static void __lambda5__gh_func (void* key, void* value, gpointer self);
static void _lambda6_ (void* l, FolksIndividual* self);
static void __lambda6__gfunc (void* data, gpointer self);
static void _g_list_free_g_free (GList* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda8_ (void* p, Block4Data* _data4_);
gint folks_presence_typecmp (FolksPresenceType type_a, FolksPresenceType type_b);
FolksPresenceType folks_presence_get_presence_type (FolksPresence* self);
const char* folks_presence_get_presence_message (FolksPresence* self);
static void __lambda8__gfunc (void* data, gpointer self);
void folks_presence_set_presence_message (FolksPresence* self, const char* value);
void folks_presence_set_presence_type (FolksPresence* self, FolksPresenceType value);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
const char* folks_individual_get_id (FolksIndividual* self);
static void _lambda9_ (void* p, Block5Data* _data5_);
gboolean folks_favourite_get_is_favourite (FolksFavourite* self);
static void __lambda9__gfunc (void* data, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
FolksPersonaStore* folks_persona_get_store (FolksPersona* self);
gboolean folks_persona_store_get_is_writeable (FolksPersonaStore* self);
const char* folks_alias_get_alias (FolksAlias* self);
const char* folks_persona_get_display_id (FolksPersona* self);
static void _lambda0_ (void* p, Block6Data* _data6_);
GFile* folks_avatar_get_avatar (FolksAvatar* self);
static void __lambda0__gfunc (void* data, gpointer self);
void folks_avatar_set_avatar (FolksAvatar* self, GFile* value);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
GType folks_persona_store_trust_get_type (void) G_GNUC_CONST;
FolksPersonaStoreTrust folks_persona_store_get_trust_level (FolksPersonaStore* self);
FolksTrustLevel folks_individual_get_trust_level (FolksIndividual* self);
static void folks_individual_set_trust_level (FolksIndividual* self, FolksTrustLevel value);
const char* folks_individual_get_alias (FolksIndividual* self);
GHashTable* folks_individual_get_groups (FolksIndividual* self);
const char* folks_individual_get_presence_message (FolksIndividual* self);
FolksPresenceType folks_individual_get_presence_type (FolksIndividual* self);
gboolean folks_individual_is_online (FolksIndividual* self);
gboolean folks_presence_is_online (FolksPresence* self);
static void folks_individual_connect_to_persona (FolksIndividual* self, FolksPersona* persona);
static void _folks_individual_notify_alias_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_notify_avatar_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_notify_presence_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_notify_is_favourite_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_persona_group_changed_cb_folks_groups_group_changed (FolksGroups* _sender, const char* group, gboolean is_member, gpointer self);
static void folks_individual_disconnect_from_persona (FolksIndividual* self, FolksPersona* persona);
static void _folks_individual_set_personas (FolksIndividual* self, GList* persona_list, FolksIndividual* replacement_individual);
static void _folks_individual_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static void _folks_individual_store_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GList* added, GList* removed, const char* message, FolksPersona* actor, FolksGroupsChangeReason reason, gpointer self);
const char* folks_persona_get_uid (FolksPersona* self);
static void folks_individual_set_id (FolksIndividual* self, const char* value);
void folks_individual_replace (FolksIndividual* self, FolksIndividual* replacement_individual);
static void _lambda11_ (void* p, Block7Data* _data7_);
void folks_alias_set_alias (FolksAlias* self, const char* value);
static void __lambda11__gfunc (void* data, gpointer self);
static void _lambda12_ (void* p, Block7Data* _data7_);
static void __lambda12__gfunc (void* data, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static void _lambda13_ (void* p, Block8Data* _data8_);
void folks_favourite_set_is_favourite (FolksFavourite* self, gboolean value);
static void __lambda13__gfunc (void* data, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static void _lambda14_ (void* p, Block9Data* _data9_);
void folks_groups_set_groups (FolksGroups* self, GHashTable* value);
static void __lambda14__gfunc (void* data, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
GList* folks_individual_get_personas (FolksIndividual* self);
static void folks_individual_finalize (GObject* obj);
static void folks_individual_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void folks_individual_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
 * Trust level for an {@link Individual} for use in the UI.
 *
 * @since 0.1.15
 */
GType folks_trust_level_get_type (void) {
	static volatile gsize folks_trust_level_type_id__volatile = 0;
	if (g_once_init_enter (&folks_trust_level_type_id__volatile)) {
		static const GEnumValue values[] = {{FOLKS_TRUST_LEVEL_NONE, "FOLKS_TRUST_LEVEL_NONE", "none"}, {FOLKS_TRUST_LEVEL_PERSONAS, "FOLKS_TRUST_LEVEL_PERSONAS", "personas"}, {0, NULL, NULL}};
		GType folks_trust_level_type_id;
		folks_trust_level_type_id = g_enum_register_static ("FolksTrustLevel", values);
		g_once_init_leave (&folks_trust_level_type_id__volatile, folks_trust_level_type_id);
	}
	return folks_trust_level_type_id__volatile;
}


static void folks_individual_notify_alias_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_alias (self);
}


static void folks_individual_notify_avatar_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_avatar (self);
}


static void folks_individual_persona_group_changed_cb (FolksIndividual* self, const char* group, gboolean is_member) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	folks_individual_update_groups (self);
}


static void folks_individual_real_change_group_data_free (gpointer _data) {
	FolksIndividualChangeGroupData* data;
	data = _data;
	_g_free0 (data->group);
	g_object_unref (data->self);
	g_slice_free (FolksIndividualChangeGroupData, data);
}


static void folks_individual_real_change_group (FolksGroups* base, const char* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividual * self;
	FolksIndividualChangeGroupData* _data_;
	self = (FolksIndividual*) base;
	_data_ = g_slice_new0 (FolksIndividualChangeGroupData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_real_change_group);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_real_change_group_data_free);
	_data_->self = g_object_ref (self);
	_data_->group = g_strdup (group);
	_data_->is_member = is_member;
	folks_individual_real_change_group_co (_data_);
}


static void folks_individual_real_change_group_finish (FolksGroups* base, GAsyncResult* _res_, GError** error) {
	FolksIndividualChangeGroupData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_individual_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualChangeGroupData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_individual_real_change_group_co (data);
}


/**
   * Add or remove the Individual from the specified group.
   *
   * If `is_member` is `true`, the Individual will be added to the `group`. If
   * it is `false`, they will be removed from the `group`.
   *
   * The group membership change will propagate to every {@link Persona} in
   * the Individual.
   *
   * @param group a freeform group identifier
   * @param is_member whether the Individual should be a member of the group
   * @since 0.1.11
   */
static void _lambda7_ (void* p, Block1Data* _data1_) {
	FolksIndividual * self;
	self = _data1_->self;
	if (FOLKS_IS_GROUPS (p)) {
		folks_groups_change_group (FOLKS_GROUPS (p), _data1_->group, _data1_->is_member, NULL, NULL);
	}
}


static void __lambda7__gfunc (void* data, gpointer self) {
	_lambda7_ (data, self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_free0 (_data1_->group);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean folks_individual_real_change_group_co (FolksIndividualChangeGroupData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data1_ = g_slice_new0 (Block1Data);
	data->_data1_->_ref_count_ = 1;
	data->_data1_->self = g_object_ref (data->self);
	data->_data1_->group = g_strdup (data->group);
	data->_data1_->is_member = data->is_member;
	data->_data1_->_async_data_ = data;
	g_list_foreach (data->self->priv->_persona_list, __lambda7__gfunc, data->_data1_);
	block1_data_unref (data->_data1_);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void folks_individual_notify_presence_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_presence (self);
}


static void folks_individual_notify_is_favourite_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_is_favourite (self);
}


/**
   * Create a new Individual.
   *
   * The Individual can optionally be seeded with the {@link Persona}s in
   * `personas`. Otherwise, it will have to have personas added using the
   * {@link Folks.Individual.personas} property after construction.
   *
   * @return a new Individual
   */
FolksIndividual* folks_individual_construct (GType object_type, GList* personas) {
	FolksIndividual * self;
	GeeHashSet* _tmp0_;
	GeeHashMap* _tmp1_;
	self = (FolksIndividual*) g_object_new (object_type, NULL);
	self->priv->_persona_set = (_tmp0_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL), _g_object_unref0 (self->priv->_persona_set), _tmp0_);
	self->priv->stores = (_tmp1_ = gee_hash_map_new (FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->stores), _tmp1_);
	folks_individual_set_personas (self, personas);
	return self;
}


FolksIndividual* folks_individual_new (GList* personas) {
	return folks_individual_construct (FOLKS_TYPE_INDIVIDUAL, personas);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void folks_individual_store_removed_cb (FolksIndividual* self, FolksPersonaStore* store) {
	GList* removed_personas;
	GeeIterator* iter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	removed_personas = NULL;
	iter = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_persona_set);
	while (TRUE) {
		FolksPersona* persona;
		if (!gee_iterator_next (iter)) {
			break;
		}
		persona = (FolksPersona*) gee_iterator_get (iter);
		removed_personas = g_list_prepend (removed_personas, _g_object_ref0 (persona));
		self->priv->_persona_list = g_list_remove (self->priv->_persona_list, persona);
		gee_iterator_remove (iter);
		_g_object_unref0 (persona);
	}
	if (removed_personas != NULL) {
		g_signal_emit_by_name (self, "personas-changed", NULL, removed_personas);
	}
	if (store != NULL) {
		gee_abstract_map_unset ((GeeAbstractMap*) self->priv->stores, store, NULL);
	}
	if (gee_collection_get_size ((GeeCollection*) self->priv->_persona_set) < 1) {
		g_signal_emit_by_name (self, "removed", NULL);
		_g_object_unref0 (iter);
		__g_list_free_g_object_unref0 (removed_personas);
		return;
	}
	folks_individual_update_fields (self);
	_g_object_unref0 (iter);
	__g_list_free_g_object_unref0 (removed_personas);
}


static void _lambda10_ (void* data, Block2Data* _data2_) {
	FolksIndividual * self;
	FolksPersona* p;
	self = _data2_->self;
	p = FOLKS_PERSONA (data);
	if (gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_persona_set, p)) {
		_data2_->removed_personas = g_list_prepend (_data2_->removed_personas, _g_object_ref0 (p));
		self->priv->_persona_list = g_list_remove (self->priv->_persona_list, p);
	}
}


static void __lambda10__gfunc (void* data, gpointer self) {
	_lambda10_ (data, self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		__g_list_free_g_object_unref0 (_data2_->removed_personas);
		g_slice_free (Block2Data, _data2_);
	}
}


static void folks_individual_store_personas_changed_cb (FolksIndividual* self, FolksPersonaStore* store, GList* added, GList* removed, const char* message, FolksPersona* actor, FolksGroupsChangeReason reason) {
	Block2Data* _data2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->removed_personas = NULL;
	g_list_foreach (removed, __lambda10__gfunc, _data2_);
	if (_data2_->removed_personas != NULL) {
		g_signal_emit_by_name (self, "personas-changed", NULL, _data2_->removed_personas);
	}
	if (gee_collection_get_size ((GeeCollection*) self->priv->_persona_set) < 1) {
		g_signal_emit_by_name (self, "removed", NULL);
		block2_data_unref (_data2_);
		return;
	}
	folks_individual_update_fields (self);
	block2_data_unref (_data2_);
}


static void folks_individual_update_fields (FolksIndividual* self) {
	g_return_if_fail (self != NULL);
	folks_individual_update_groups (self);
	folks_individual_update_presence (self);
	folks_individual_update_is_favourite (self);
	folks_individual_update_avatar (self);
	folks_individual_update_alias (self);
	folks_individual_update_trust_level (self);
}


static void _lambda2_ (void* k, void* v, Block3Data* _data3_) {
	FolksIndividual * self;
	self = _data3_->self;
	g_hash_table_insert (_data3_->new_groups, g_strdup ((const char*) k), GINT_TO_POINTER (TRUE));
}


static void __lambda2__gh_func (void* key, void* value, gpointer self) {
	_lambda2_ (key, value, self);
}


static void _lambda1_ (void* p, Block3Data* _data3_) {
	FolksIndividual * self;
	self = _data3_->self;
	if (FOLKS_IS_GROUPS (p)) {
		FolksGroups* persona;
		persona = FOLKS_GROUPS (p);
		g_hash_table_foreach (folks_groups_get_groups (persona), __lambda2__gh_func, _data3_);
	}
}


static void __lambda1__gfunc (void* data, gpointer self) {
	_lambda1_ (data, self);
}


static void _lambda4_ (void* k, void* v, FolksIndividual* self) {
	char* g;
	g = g_strdup ((const char*) k);
	g_debug ("individual.vala:437:    %s", g);
	_g_free0 (g);
}


static void __lambda4__gh_func (void* key, void* value, gpointer self) {
	_lambda4_ (key, value, self);
}


static void _lambda3_ (void* k, void* v, FolksIndividual* self) {
	char* group;
	group = g_strdup ((const char*) k);
	if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->_groups, group)) != TRUE) {
		g_hash_table_insert (self->priv->_groups, g_strdup (group), GINT_TO_POINTER (TRUE));
		g_hash_table_foreach (self->priv->_groups, __lambda4__gh_func, self);
		g_signal_emit_by_name ((FolksGroups*) self, "group-changed", group, TRUE);
	}
	_g_free0 (group);
}


static void __lambda3__gh_func (void* key, void* value, gpointer self) {
	_lambda3_ (key, value, self);
}


static void _lambda5_ (void* k, void* v, Block3Data* _data3_) {
	FolksIndividual * self;
	char* group;
	self = _data3_->self;
	group = g_strdup ((const char*) k);
	if (GPOINTER_TO_INT (g_hash_table_lookup (_data3_->new_groups, group)) != TRUE) {
		_data3_->removes = g_list_prepend (_data3_->removes, g_strdup (group));
	}
	_g_free0 (group);
}


static void __lambda5__gh_func (void* key, void* value, gpointer self) {
	_lambda5_ (key, value, self);
}


static void _lambda6_ (void* l, FolksIndividual* self) {
	char* group;
	group = g_strdup ((const char*) l);
	g_hash_table_remove (self->priv->_groups, group);
	g_signal_emit_by_name ((FolksGroups*) self, "group-changed", group, FALSE);
	_g_free0 (group);
}


static void __lambda6__gfunc (void* data, gpointer self) {
	_lambda6_ (data, self);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		__g_list_free_g_free0 (_data3_->removes);
		_g_hash_table_unref0 (_data3_->new_groups);
		g_slice_free (Block3Data, _data3_);
	}
}


static void folks_individual_update_groups (FolksIndividual* self) {
	Block3Data* _data3_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->new_groups = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	if (self->priv->_groups == NULL) {
		GHashTable* _tmp0_;
		self->priv->_groups = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL), _g_hash_table_unref0 (self->priv->_groups), _tmp0_);
	}
	g_list_foreach (self->priv->_persona_list, __lambda1__gfunc, _data3_);
	g_hash_table_foreach (_data3_->new_groups, __lambda3__gh_func, self);
	_data3_->removes = NULL;
	g_hash_table_foreach (self->priv->_groups, __lambda5__gh_func, _data3_);
	g_list_foreach (_data3_->removes, __lambda6__gfunc, self);
	block3_data_unref (_data3_);
}


static void _lambda8_ (void* p, Block4Data* _data4_) {
	FolksIndividual * self;
	self = _data4_->self;
	if (FOLKS_IS_PRESENCE (p)) {
		FolksPresence* presence;
		presence = FOLKS_PRESENCE (p);
		if (folks_presence_typecmp (folks_presence_get_presence_type (presence), _data4_->presence_type) > 0) {
			char* _tmp0_;
			_data4_->presence_type = folks_presence_get_presence_type (presence);
			_data4_->presence_message = (_tmp0_ = g_strdup (folks_presence_get_presence_message (presence)), _g_free0 (_data4_->presence_message), _tmp0_);
		}
	}
}


static void __lambda8__gfunc (void* data, gpointer self) {
	_lambda8_ (data, self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_free0 (_data4_->presence_message);
		g_slice_free (Block4Data, _data4_);
	}
}


static void folks_individual_update_presence (FolksIndividual* self) {
	Block4Data* _data4_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->presence_message = g_strdup ("");
	_data4_->presence_type = FOLKS_PRESENCE_TYPE_UNSET;
	g_list_foreach (self->priv->_persona_list, __lambda8__gfunc, _data4_);
	if (_data4_->presence_message == NULL) {
		char* _tmp0_;
		_data4_->presence_message = (_tmp0_ = g_strdup (""), _g_free0 (_data4_->presence_message), _tmp0_);
	}
	if (_vala_strcmp0 (folks_presence_get_presence_message ((FolksPresence*) self), _data4_->presence_message) != 0) {
		folks_presence_set_presence_message ((FolksPresence*) self, _data4_->presence_message);
	}
	if (folks_presence_get_presence_type ((FolksPresence*) self) != _data4_->presence_type) {
		folks_presence_set_presence_type ((FolksPresence*) self, _data4_->presence_type);
	}
	block4_data_unref (_data4_);
}


static void _lambda9_ (void* p, Block5Data* _data5_) {
	FolksIndividual * self;
	gboolean _tmp0_ = FALSE;
	self = _data5_->self;
	if (_data5_->favourite == FALSE) {
		_tmp0_ = FOLKS_IS_FAVOURITE (p);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_data5_->favourite = folks_favourite_get_is_favourite (FOLKS_FAVOURITE (p));
		if (_data5_->favourite == TRUE) {
			return;
		}
	}
}


static void __lambda9__gfunc (void* data, gpointer self) {
	_lambda9_ (data, self);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void folks_individual_update_is_favourite (FolksIndividual* self) {
	Block5Data* _data5_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->favourite = FALSE;
	g_debug ("individual.vala:496: Running update_is_favourite() on '%s'", self->priv->_id);
	g_list_foreach (self->priv->_persona_list, __lambda9__gfunc, _data5_);
	if (self->priv->_is_favourite != _data5_->favourite) {
		self->priv->_is_favourite = _data5_->favourite;
		g_object_notify ((GObject*) self, "is-favourite");
	}
	block5_data_unref (_data5_);
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void folks_individual_update_alias (FolksIndividual* self) {
	char* alias;
	gboolean alias_is_display_id;
	g_return_if_fail (self != NULL);
	alias = NULL;
	alias_is_display_id = FALSE;
	g_debug ("individual.vala:523: Updating alias for individual '%s'", self->priv->_id);
	{
		GList* p_collection;
		GList* p_it;
		p_collection = self->priv->_persona_list;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			FolksPersona* p;
			p = _g_object_ref0 ((FolksPersona*) p_it->data);
			{
				gboolean _tmp0_ = FALSE;
				if (FOLKS_IS_ALIAS (p)) {
					_tmp0_ = folks_persona_store_get_is_writeable (folks_persona_get_store (p)) == TRUE;
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					FolksAlias* a;
					gboolean _tmp1_ = FALSE;
					a = FOLKS_ALIAS (p);
					if (folks_alias_get_alias (a) != NULL) {
						char* _tmp2_;
						_tmp1_ = _vala_strcmp0 (_tmp2_ = string_strip (folks_alias_get_alias (a)), "") != 0;
						_g_free0 (_tmp2_);
					} else {
						_tmp1_ = FALSE;
					}
					if (_tmp1_) {
						char* _tmp3_;
						alias = (_tmp3_ = g_strdup (folks_alias_get_alias (a)), _g_free0 (alias), _tmp3_);
						_g_object_unref0 (p);
						break;
					}
				}
				_g_object_unref0 (p);
			}
		}
	}
	g_debug ("individual.vala:542:     got alias '%s' from writeable personas", alias);
	if (alias == NULL) {
		{
			GList* p_collection;
			GList* p_it;
			p_collection = self->priv->_persona_list;
			for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
				FolksPersona* p;
				p = _g_object_ref0 ((FolksPersona*) p_it->data);
				{
					if (FOLKS_IS_ALIAS (p)) {
						FolksAlias* a;
						gboolean _tmp4_ = FALSE;
						gboolean _tmp6_ = FALSE;
						a = FOLKS_ALIAS (p);
						if (folks_alias_get_alias (a) == NULL) {
							_tmp4_ = TRUE;
						} else {
							char* _tmp5_;
							_tmp4_ = _vala_strcmp0 (_tmp5_ = string_strip (folks_alias_get_alias (a)), "") == 0;
							_g_free0 (_tmp5_);
						}
						if (_tmp4_) {
							_g_object_unref0 (p);
							continue;
						}
						if (alias == NULL) {
							_tmp6_ = TRUE;
						} else {
							_tmp6_ = alias_is_display_id == TRUE;
						}
						if (_tmp6_) {
							char* _tmp7_;
							alias = (_tmp7_ = g_strdup (folks_alias_get_alias (a)), _g_free0 (alias), _tmp7_);
							if (_vala_strcmp0 (folks_alias_get_alias (a), folks_persona_get_display_id (p)) == 0) {
								alias_is_display_id = TRUE;
							} else {
								if (alias != NULL) {
									_g_object_unref0 (p);
									break;
								}
							}
						}
					}
					_g_object_unref0 (p);
				}
			}
		}
	}
	g_debug ("individual.vala:577:     got alias '%s' from non-writeable personas", alias);
	if (alias == NULL) {
		char* _tmp8_;
		alias = (_tmp8_ = g_strdup (folks_persona_get_display_id ((FolksPersona*) self->priv->_persona_list->data)), _g_free0 (alias), _tmp8_);
		g_debug ("No aliases available for individual; using display ID " "instead: %s", alias);
	}
	if (_vala_strcmp0 (self->priv->_alias, alias) != 0) {
		char* _tmp9_;
		g_debug ("individual.vala:595: Changing alias of individual '%s' from '%s' to '%" \
"s'.", self->priv->_id, self->priv->_alias, alias);
		self->priv->_alias = (_tmp9_ = g_strdup (alias), _g_free0 (self->priv->_alias), _tmp9_);
		g_object_notify ((GObject*) self, "alias");
	}
	_g_free0 (alias);
}


static void _lambda0_ (void* p, Block6Data* _data6_) {
	FolksIndividual * self;
	gboolean _tmp0_ = FALSE;
	self = _data6_->self;
	if (_data6_->avatar == NULL) {
		_tmp0_ = FOLKS_IS_AVATAR (p);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFile* _tmp1_;
		_data6_->avatar = (_tmp1_ = _g_object_ref0 (folks_avatar_get_avatar (FOLKS_AVATAR (p))), _g_object_unref0 (_data6_->avatar), _tmp1_);
		return;
	}
}


static void __lambda0__gfunc (void* data, gpointer self) {
	_lambda0_ (data, self);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_g_object_unref0 (_data6_->avatar);
		g_slice_free (Block6Data, _data6_);
	}
}


static void folks_individual_update_avatar (FolksIndividual* self) {
	Block6Data* _data6_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->avatar = NULL;
	g_list_foreach (self->priv->_persona_list, __lambda0__gfunc, _data6_);
	if (folks_avatar_get_avatar ((FolksAvatar*) self) != _data6_->avatar) {
		folks_avatar_set_avatar ((FolksAvatar*) self, _data6_->avatar);
	}
	block6_data_unref (_data6_);
}


static void folks_individual_update_trust_level (FolksIndividual* self) {
	FolksTrustLevel trust_level;
	g_return_if_fail (self != NULL);
	trust_level = FOLKS_TRUST_LEVEL_PERSONAS;
	{
		GList* p_collection;
		GList* p_it;
		p_collection = self->priv->_persona_list;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			FolksPersona* p;
			p = _g_object_ref0 ((FolksPersona*) p_it->data);
			{
				if (folks_persona_store_get_trust_level (folks_persona_get_store (p)) == FOLKS_PERSONA_STORE_TRUST_NONE) {
					trust_level = FOLKS_TRUST_LEVEL_NONE;
				}
				_g_object_unref0 (p);
			}
		}
	}
	if (self->priv->_trust_level != trust_level) {
		folks_individual_set_trust_level (self, trust_level);
	}
}


/**
   * Get the Individual's alias.
   *
   * The alias is a user-chosen name for the Individual; how the user wants that
   * Individual to be represented in UIs.
   *
   * @return the Individual's alias
   */
const char* folks_individual_get_alias (FolksIndividual* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = folks_alias_get_alias ((FolksAlias*) self);
	return result;
}


/**
   * Get a mapping of group ID to whether the Individual is a member.
   *
   * Freeform group IDs are mapped to a boolean which is `true` if the
   * Individual is a member of the group, and `false` otherwise.
   *
   * @return a mapping of group ID to membership status
   */
static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


GHashTable* folks_individual_get_groups (FolksIndividual* self) {
	GHashTable* result = NULL;
	FolksGroups* g;
	g_return_val_if_fail (self != NULL, NULL);
	g = _g_object_ref0 ((FolksGroups*) self);
	result = _g_hash_table_ref0 (folks_groups_get_groups (g));
	_g_object_unref0 (g);
	return result;
}


/**
   * Get the Individual's current presence message.
   *
   * The presence message returned is from the same {@link Persona} which
   * provided the presence type returned by
   * {@link Individual.get_presence_type}.
   *
   * If none of the {@link Persona}s in the Individual have a presence message
   * set, an empty string is returned.
   *
   * @return the Individual's presence message
   */
const char* folks_individual_get_presence_message (FolksIndividual* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = folks_presence_get_presence_message ((FolksPresence*) self);
	return result;
}


/**
   * Get the Individual's current presence type.
   *
   * The presence type returned is from the same {@link Persona} which provided
   * the presence message returned by {@link Individual.get_presence_message}.
   *
   * If none of the {@link Persona}s in the Individual have a presence type set,
   * {@link PresenceType.UNSET} is returned.
   *
   * @return the Individual's presence type
   */
FolksPresenceType folks_individual_get_presence_type (FolksIndividual* self) {
	FolksPresenceType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = folks_presence_get_presence_type ((FolksPresence*) self);
	return result;
}


/**
   * Whether the Individual is online.
   *
   * This will be `true` if any of the Individual's {@link Persona}s have a
   * presence type higher than {@link PresenceType.OFFLINE}, as determined by
   * {@link Presence.typecmp}.
   *
   * @return `true` if the Individual is online, `false` otherwise
   */
gboolean folks_individual_is_online (FolksIndividual* self) {
	gboolean result = FALSE;
	FolksPresence* p;
	g_return_val_if_fail (self != NULL, FALSE);
	p = _g_object_ref0 ((FolksPresence*) self);
	result = folks_presence_is_online (p);
	_g_object_unref0 (p);
	return result;
}


static void _folks_individual_notify_alias_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_alias_cb (self, _sender, pspec);
}


static void _folks_individual_notify_avatar_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_avatar_cb (self, _sender, pspec);
}


static void _folks_individual_notify_presence_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_presence_cb (self, _sender, pspec);
}


static void _folks_individual_notify_is_favourite_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_is_favourite_cb (self, _sender, pspec);
}


static void _folks_individual_persona_group_changed_cb_folks_groups_group_changed (FolksGroups* _sender, const char* group, gboolean is_member, gpointer self) {
	folks_individual_persona_group_changed_cb (self, group, is_member);
}


static void folks_individual_connect_to_persona (FolksIndividual* self, FolksPersona* persona) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_signal_connect_object ((GObject*) persona, "notify::alias", (GCallback) _folks_individual_notify_alias_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::avatar", (GCallback) _folks_individual_notify_avatar_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::presence-message", (GCallback) _folks_individual_notify_presence_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::presence-type", (GCallback) _folks_individual_notify_presence_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::is-favourite", (GCallback) _folks_individual_notify_is_favourite_cb_g_object_notify, self, 0);
	if (FOLKS_IS_GROUPS (persona)) {
		g_signal_connect_object (FOLKS_GROUPS (persona), "group-changed", (GCallback) _folks_individual_persona_group_changed_cb_folks_groups_group_changed, self, 0);
	}
}


static void folks_individual_disconnect_from_persona (FolksIndividual* self, FolksPersona* persona) {
	guint _tmp0_;
	GQuark _tmp1_;
	guint _tmp2_;
	GQuark _tmp3_;
	guint _tmp4_;
	GQuark _tmp5_;
	guint _tmp6_;
	GQuark _tmp7_;
	guint _tmp8_;
	GQuark _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_signal_parse_name ("notify::alias", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _folks_individual_notify_alias_cb_g_object_notify, self);
	g_signal_parse_name ("notify::avatar", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _folks_individual_notify_avatar_cb_g_object_notify, self);
	g_signal_parse_name ("notify::presence-message", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _folks_individual_notify_presence_cb_g_object_notify, self);
	g_signal_parse_name ("notify::presence-type", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) _folks_individual_notify_presence_cb_g_object_notify, self);
	g_signal_parse_name ("notify::is-favourite", G_TYPE_OBJECT, &_tmp8_, &_tmp9_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, _tmp9_, NULL, (GCallback) _folks_individual_notify_is_favourite_cb_g_object_notify, self);
	if (FOLKS_IS_GROUPS (persona)) {
		guint _tmp10_;
		g_signal_parse_name ("group-changed", FOLKS_TYPE_GROUPS, &_tmp10_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (FOLKS_GROUPS (persona), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _folks_individual_persona_group_changed_cb_folks_groups_group_changed, self);
	}
}


static void _folks_individual_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	folks_individual_store_removed_cb (self, _sender);
}


static void _folks_individual_store_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GList* added, GList* removed, const char* message, FolksPersona* actor, FolksGroupsChangeReason reason, gpointer self) {
	folks_individual_store_personas_changed_cb (self, _sender, added, removed, message, actor, reason);
}


static void _folks_individual_set_personas (FolksIndividual* self, GList* persona_list, FolksIndividual* replacement_individual) {
	GeeHashSet* persona_set;
	GList* added;
	GList* removed;
	GList* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	persona_set = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	added = NULL;
	removed = NULL;
	{
		GList* p_collection;
		GList* p_it;
		p_collection = persona_list;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			FolksPersona* p;
			p = _g_object_ref0 ((FolksPersona*) p_it->data);
			{
				if (!gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->_persona_set, p)) {
					FolksPersonaStore* store;
					guint num_from_store;
					added = g_list_prepend (added, _g_object_ref0 (p));
					gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_persona_set, p);
					folks_individual_connect_to_persona (self, p);
					store = folks_persona_get_store (p);
					num_from_store = GPOINTER_TO_UINT (gee_abstract_map_get ((GeeAbstractMap*) self->priv->stores, store));
					if (num_from_store == 0) {
						gee_abstract_map_set ((GeeAbstractMap*) self->priv->stores, store, GUINT_TO_POINTER (num_from_store + 1));
					} else {
						gee_abstract_map_set ((GeeAbstractMap*) self->priv->stores, store, GUINT_TO_POINTER ((guint) 1));
						g_signal_connect_object (store, "removed", (GCallback) _folks_individual_store_removed_cb_folks_persona_store_removed, self, 0);
						g_signal_connect_object (store, "personas-changed", (GCallback) _folks_individual_store_personas_changed_cb_folks_persona_store_personas_changed, self, 0);
					}
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) persona_set, p);
				_g_object_unref0 (p);
			}
		}
	}
	{
		GList* p_collection;
		GList* p_it;
		p_collection = self->priv->_persona_list;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			FolksPersona* p;
			p = _g_object_ref0 ((FolksPersona*) p_it->data);
			{
				if (!gee_abstract_collection_contains ((GeeAbstractCollection*) persona_set, p)) {
					FolksPersonaStore* store;
					guint num_from_store;
					removed = g_list_prepend (removed, _g_object_ref0 (p));
					store = folks_persona_get_store (p);
					num_from_store = GPOINTER_TO_UINT (gee_abstract_map_get ((GeeAbstractMap*) self->priv->stores, store));
					if (num_from_store > 1) {
						gee_abstract_map_set ((GeeAbstractMap*) self->priv->stores, store, GUINT_TO_POINTER (num_from_store - 1));
					} else {
						guint _tmp0_;
						guint _tmp1_;
						g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp0_, NULL, FALSE);
						g_signal_handlers_disconnect_matched (store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _folks_individual_store_removed_cb_folks_persona_store_removed, self);
						g_signal_parse_name ("personas-changed", FOLKS_TYPE_PERSONA_STORE, &_tmp1_, NULL, FALSE);
						g_signal_handlers_disconnect_matched (store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _folks_individual_store_personas_changed_cb_folks_persona_store_personas_changed, self);
						gee_abstract_map_unset ((GeeAbstractMap*) self->priv->stores, store, NULL);
					}
					folks_individual_disconnect_from_persona (self, p);
					gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_persona_set, p);
				}
				_g_object_unref0 (p);
			}
		}
	}
	self->priv->_persona_list = (_tmp2_ = g_list_copy (persona_list), _g_list_free0 (self->priv->_persona_list), _tmp2_);
	g_signal_emit_by_name (self, "personas-changed", added, removed);
	if (gee_collection_get_size ((GeeCollection*) self->priv->_persona_set) < 1) {
		g_signal_emit_by_name (self, "removed", replacement_individual);
		__g_list_free_g_object_unref0 (removed);
		__g_list_free_g_object_unref0 (added);
		_g_object_unref0 (persona_set);
		return;
	}
	if (self->priv->_id == NULL) {
		_tmp3_ = ((FolksPersona*) self->priv->_persona_list->data) != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		folks_individual_set_id (self, folks_persona_get_uid ((FolksPersona*) self->priv->_persona_list->data));
	}
	folks_individual_update_fields (self);
	__g_list_free_g_object_unref0 (removed);
	__g_list_free_g_object_unref0 (added);
	_g_object_unref0 (persona_set);
}


void folks_individual_replace (FolksIndividual* self, FolksIndividual* replacement_individual) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (replacement_individual != NULL);
	_folks_individual_set_personas (self, NULL, replacement_individual);
}


FolksTrustLevel folks_individual_get_trust_level (FolksIndividual* self) {
	FolksTrustLevel result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_trust_level;
	return result;
}


static void folks_individual_set_trust_level (FolksIndividual* self, FolksTrustLevel value) {
	g_return_if_fail (self != NULL);
	self->priv->_trust_level = value;
	g_object_notify ((GObject *) self, "trust-level");
}


static GFile* folks_individual_real_get_avatar (FolksAvatar* base) {
	GFile* result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_avatar;
	return result;
}


static void folks_individual_real_set_avatar (FolksAvatar* base, GFile* value) {
	FolksIndividual* self;
	GFile* _tmp0_;
	self = (FolksIndividual*) base;
	self->priv->_avatar = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_avatar), _tmp0_);
	g_object_notify ((GObject *) self, "avatar");
}


static FolksPresenceType folks_individual_real_get_presence_type (FolksPresence* base) {
	FolksPresenceType result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_presence_type;
	return result;
}


static void folks_individual_real_set_presence_type (FolksPresence* base, FolksPresenceType value) {
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	self->priv->_presence_type = value;
	g_object_notify ((GObject *) self, "presence-type");
}


static const char* folks_individual_real_get_presence_message (FolksPresence* base) {
	const char* result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_presence_message;
	return result;
}


static void folks_individual_real_set_presence_message (FolksPresence* base, const char* value) {
	FolksIndividual* self;
	char* _tmp0_;
	self = (FolksIndividual*) base;
	self->priv->_presence_message = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_presence_message), _tmp0_);
	g_object_notify ((GObject *) self, "presence-message");
}


const char* folks_individual_get_id (FolksIndividual* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_id;
	return result;
}


static void folks_individual_set_id (FolksIndividual* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_id = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_id), _tmp0_);
	g_object_notify ((GObject *) self, "id");
}


static const char* folks_individual_real_get_alias (FolksAlias* base) {
	const char* result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_alias;
	return result;
}


static void _lambda11_ (void* p, Block7Data* _data7_) {
	FolksIndividual * self;
	gboolean _tmp0_ = FALSE;
	self = _data7_->self;
	if (FOLKS_IS_ALIAS (p)) {
		_tmp0_ = folks_persona_store_get_is_writeable (folks_persona_get_store (FOLKS_PERSONA (p))) == TRUE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_debug ("individual.vala:162:     written to writeable persona '%s'", folks_persona_get_uid (FOLKS_PERSONA (p)));
		folks_alias_set_alias (FOLKS_ALIAS (p), _data7_->value);
		_data7_->alias_changed = TRUE;
	}
}


static void __lambda11__gfunc (void* data, gpointer self) {
	_lambda11_ (data, self);
}


static void _lambda12_ (void* p, Block7Data* _data7_) {
	FolksIndividual * self;
	self = _data7_->self;
	if (FOLKS_IS_ALIAS (p)) {
		g_debug ("individual.vala:177:     written to non-writeable persona '%s'", folks_persona_get_uid (FOLKS_PERSONA (p)));
		folks_alias_set_alias (FOLKS_ALIAS (p), _data7_->value);
	}
}


static void __lambda12__gfunc (void* data, gpointer self) {
	_lambda12_ (data, self);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_free0 (_data7_->value);
		g_slice_free (Block7Data, _data7_);
	}
}


static void folks_individual_real_set_alias (FolksAlias* base, const char* value) {
	FolksIndividual* self;
	Block7Data* _data7_;
	char* _tmp0_;
	self = (FolksIndividual*) base;
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->value = g_strdup (value);
	if (_vala_strcmp0 (self->priv->_alias, _data7_->value) == 0) {
		block7_data_unref (_data7_);
		return;
	}
	self->priv->_alias = (_tmp0_ = g_strdup (_data7_->value), _g_free0 (self->priv->_alias), _tmp0_);
	g_debug ("individual.vala:154: Setting alias of individual '%s' to '%s'…", self->priv->_id, _data7_->value);
	_data7_->alias_changed = FALSE;
	g_list_foreach (self->priv->_persona_list, __lambda11__gfunc, _data7_);
	if (_data7_->alias_changed == FALSE) {
		g_list_foreach (self->priv->_persona_list, __lambda12__gfunc, _data7_);
	}
	block7_data_unref (_data7_);
	g_object_notify ((GObject *) self, "alias");
}


static gboolean folks_individual_real_get_is_favourite (FolksFavourite* base) {
	gboolean result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_is_favourite;
	return result;
}


static void _lambda13_ (void* p, Block8Data* _data8_) {
	FolksIndividual * self;
	self = _data8_->self;
	if (FOLKS_IS_FAVOURITE (p)) {
		g_signal_handlers_block_by_func (p, (void*) folks_individual_notify_is_favourite_cb, self);
		folks_favourite_set_is_favourite (FOLKS_FAVOURITE (p), _data8_->value);
		g_signal_handlers_unblock_by_func (p, (void*) folks_individual_notify_is_favourite_cb, self);
	}
}


static void __lambda13__gfunc (void* data, gpointer self) {
	_lambda13_ (data, self);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->self);
		g_slice_free (Block8Data, _data8_);
	}
}


static void folks_individual_real_set_is_favourite (FolksFavourite* base, gboolean value) {
	FolksIndividual* self;
	Block8Data* _data8_;
	const char* _tmp0_;
	self = (FolksIndividual*) base;
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->value = value;
	if (self->priv->_is_favourite == _data8_->value) {
		block8_data_unref (_data8_);
		return;
	}
	_tmp0_ = NULL;
	if (_data8_->value) {
		_tmp0_ = "TRUE";
	} else {
		_tmp0_ = "FALSE";
	}
	g_debug ("individual.vala:201: Setting '%s' favourite status to %s", self->priv->_id, _tmp0_);
	self->priv->_is_favourite = _data8_->value;
	g_list_foreach (self->priv->_persona_list, __lambda13__gfunc, _data8_);
	block8_data_unref (_data8_);
	g_object_notify ((GObject *) self, "is-favourite");
}


static GHashTable* folks_individual_real_get_groups (FolksGroups* base) {
	GHashTable* result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_groups;
	return result;
}


static void _lambda14_ (void* p, Block9Data* _data9_) {
	FolksIndividual * self;
	gboolean _tmp0_ = FALSE;
	self = _data9_->self;
	if (FOLKS_IS_GROUPS (p)) {
		_tmp0_ = folks_persona_store_get_is_writeable (folks_persona_get_store (FOLKS_PERSONA (p))) == TRUE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		folks_groups_set_groups (FOLKS_GROUPS (p), _data9_->value);
	}
}


static void __lambda14__gfunc (void* data, gpointer self) {
	_lambda14_ (data, self);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->self);
		_g_hash_table_unref0 (_data9_->value);
		g_slice_free (Block9Data, _data9_);
	}
}


static void folks_individual_real_set_groups (FolksGroups* base, GHashTable* value) {
	FolksIndividual* self;
	Block9Data* _data9_;
	GHashTable* _tmp0_;
	self = (FolksIndividual*) base;
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_data9_->value = _g_hash_table_ref0 (value);
	self->priv->_groups = (_tmp0_ = _g_hash_table_ref0 (_data9_->value), _g_hash_table_unref0 (self->priv->_groups), _tmp0_);
	g_list_foreach (self->priv->_persona_list, __lambda14__gfunc, _data9_);
	block9_data_unref (_data9_);
	g_object_notify ((GObject *) self, "groups");
}


GList* folks_individual_get_personas (FolksIndividual* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_persona_list;
	return result;
}


void folks_individual_set_personas (FolksIndividual* self, GList* value) {
	g_return_if_fail (self != NULL);
	_folks_individual_set_personas (self, value, NULL);
	g_object_notify ((GObject *) self, "personas");
}


static void folks_individual_class_init (FolksIndividualClass * klass) {
	folks_individual_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksIndividualPrivate));
	G_OBJECT_CLASS (klass)->get_property = folks_individual_get_property;
	G_OBJECT_CLASS (klass)->set_property = folks_individual_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_individual_finalize;
	/**
	   * The trust level of the Individual.
	   *
	   * This specifies how far the Individual can be trusted to be who it claims
	   * to be. See the descriptions for the elements of {@link TrustLevel}.
	   *
	   * Clients should ''not'' allow linking of Individuals who have a trust level
	   * of {@link TrustLevel.NONE}.
	   *
	   * @since 0.1.15
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_TRUST_LEVEL, g_param_spec_enum ("trust-level", "trust-level", "trust-level", FOLKS_TYPE_TRUST_LEVEL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AVATAR, "avatar");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_PRESENCE_TYPE, "presence-type");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_PRESENCE_MESSAGE, "presence-message");
	/**
	   * A unique identifier for the Individual.
	   *
	   * This uniquely identifies the Individual, and persists across
	   * {@link IndividualAggregator} instances.
	   *
	   * FIXME: Will this.id actually be the persistent ID for storage?
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_ALIAS, "alias");
	/**
	   * Whether this Individual is a user-defined favourite.
	   *
	   * This property is `true` if any of this Individual's {@link Persona}s are
	   * favourites).
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_IS_FAVOURITE, "is-favourite");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_GROUPS, "groups");
	/**
	   * The set of {@link Persona}s encapsulated by this Individual.
	   *
	   * Changing the set of personas may cause updates to the aggregated properties
	   * provided by the Individual, resulting in property notifications for them.
	   *
	   * Changing the set of personas will not cause permanent linking/unlinking of
	   * the added/removed personas to/from this Individual. To do that, call
	   * {@link IndividualAggregator.link_personas} or
	   * {@link IndividualAggregator.unlink_individual}, which will ensure the link
	   * changes are written to the appropriate backend.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_PERSONAS, g_param_spec_pointer ("personas", "personas", "personas", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Emitted when the last of the Individual's {@link Persona}s has been
	   * removed.
	   *
	   * At this point, the Individual is invalid, so any client referencing it
	   * should unreference it and remove it from their UI.
	   *
	   * @param replacement_individual the individual which has replaced this one
	   * due to linking, or `null` if this individual was removed for another reason
	   * @since 0.1.13
	   */
	g_signal_new ("removed", FOLKS_TYPE_INDIVIDUAL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_INDIVIDUAL);
	/**
	   * Emitted when one or more {@link Persona}s are added to or removed from
	   * the Individual.
	   *
	   * @param added a list of {@link Persona}s which have been added
	   * @param removed a list of {@link Persona}s which have been removed
	   *
	   * @since 0.1.15
	   */
	g_signal_new ("personas_changed", FOLKS_TYPE_INDIVIDUAL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_POINTER, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_POINTER);
}


static void folks_individual_folks_alias_interface_init (FolksAliasIface * iface) {
	folks_individual_folks_alias_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_alias = folks_individual_real_get_alias;
	iface->set_alias = folks_individual_real_set_alias;
}


static void folks_individual_folks_avatar_interface_init (FolksAvatarIface * iface) {
	folks_individual_folks_avatar_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = folks_individual_real_get_avatar;
	iface->set_avatar = folks_individual_real_set_avatar;
}


static void folks_individual_folks_favourite_interface_init (FolksFavouriteIface * iface) {
	folks_individual_folks_favourite_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_is_favourite = folks_individual_real_get_is_favourite;
	iface->set_is_favourite = folks_individual_real_set_is_favourite;
}


static void folks_individual_folks_groups_interface_init (FolksGroupsIface * iface) {
	folks_individual_folks_groups_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_group = folks_individual_real_change_group;
	iface->change_group_finish = folks_individual_real_change_group_finish;
	iface->get_groups = folks_individual_real_get_groups;
	iface->set_groups = folks_individual_real_set_groups;
}


static void folks_individual_folks_presence_interface_init (FolksPresenceIface * iface) {
	folks_individual_folks_presence_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_presence_type = folks_individual_real_get_presence_type;
	iface->set_presence_type = folks_individual_real_set_presence_type;
	iface->get_presence_message = folks_individual_real_get_presence_message;
	iface->set_presence_message = folks_individual_real_set_presence_message;
}


static void folks_individual_instance_init (FolksIndividual * self) {
	self->priv = FOLKS_INDIVIDUAL_GET_PRIVATE (self);
}


static void folks_individual_finalize (GObject* obj) {
	FolksIndividual * self;
	self = FOLKS_INDIVIDUAL (obj);
	_g_free0 (self->priv->_alias);
	_g_hash_table_unref0 (self->priv->_groups);
	_g_list_free0 (self->priv->_persona_list);
	_g_object_unref0 (self->priv->_persona_set);
	_g_object_unref0 (self->priv->stores);
	_g_object_unref0 (self->priv->_avatar);
	_g_free0 (self->priv->_presence_message);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_individual_parent_class)->finalize (obj);
}


/**
 * A physical person, aggregated from the various {@link Persona}s the person
 * might have, such as their different IM addresses or vCard entries.
 */
GType folks_individual_get_type (void) {
	static volatile gsize folks_individual_type_id__volatile = 0;
	if (g_once_init_enter (&folks_individual_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksIndividualClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_individual_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksIndividual), 0, (GInstanceInitFunc) folks_individual_instance_init, NULL };
		static const GInterfaceInfo folks_alias_info = { (GInterfaceInitFunc) folks_individual_folks_alias_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_avatar_info = { (GInterfaceInitFunc) folks_individual_folks_avatar_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_favourite_info = { (GInterfaceInitFunc) folks_individual_folks_favourite_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_groups_info = { (GInterfaceInitFunc) folks_individual_folks_groups_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_presence_info = { (GInterfaceInitFunc) folks_individual_folks_presence_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType folks_individual_type_id;
		folks_individual_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksIndividual", &g_define_type_info, 0);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_ALIAS, &folks_alias_info);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_AVATAR, &folks_avatar_info);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_FAVOURITE, &folks_favourite_info);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_GROUPS, &folks_groups_info);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_PRESENCE, &folks_presence_info);
		g_once_init_leave (&folks_individual_type_id__volatile, folks_individual_type_id);
	}
	return folks_individual_type_id__volatile;
}


static void folks_individual_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksIndividual * self;
	self = FOLKS_INDIVIDUAL (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_TRUST_LEVEL:
		g_value_set_enum (value, folks_individual_get_trust_level (self));
		break;
		case FOLKS_INDIVIDUAL_AVATAR:
		g_value_set_object (value, folks_avatar_get_avatar ((FolksAvatar*) self));
		break;
		case FOLKS_INDIVIDUAL_PRESENCE_TYPE:
		g_value_set_enum (value, folks_presence_get_presence_type ((FolksPresence*) self));
		break;
		case FOLKS_INDIVIDUAL_PRESENCE_MESSAGE:
		g_value_set_string (value, folks_presence_get_presence_message ((FolksPresence*) self));
		break;
		case FOLKS_INDIVIDUAL_ID:
		g_value_set_string (value, folks_individual_get_id (self));
		break;
		case FOLKS_INDIVIDUAL_ALIAS:
		g_value_set_string (value, folks_alias_get_alias ((FolksAlias*) self));
		break;
		case FOLKS_INDIVIDUAL_IS_FAVOURITE:
		g_value_set_boolean (value, folks_favourite_get_is_favourite ((FolksFavourite*) self));
		break;
		case FOLKS_INDIVIDUAL_GROUPS:
		g_value_set_boxed (value, folks_groups_get_groups ((FolksGroups*) self));
		break;
		case FOLKS_INDIVIDUAL_PERSONAS:
		g_value_set_pointer (value, folks_individual_get_personas (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void folks_individual_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksIndividual * self;
	self = FOLKS_INDIVIDUAL (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_TRUST_LEVEL:
		folks_individual_set_trust_level (self, g_value_get_enum (value));
		break;
		case FOLKS_INDIVIDUAL_AVATAR:
		folks_avatar_set_avatar ((FolksAvatar*) self, g_value_get_object (value));
		break;
		case FOLKS_INDIVIDUAL_PRESENCE_TYPE:
		folks_presence_set_presence_type ((FolksPresence*) self, g_value_get_enum (value));
		break;
		case FOLKS_INDIVIDUAL_PRESENCE_MESSAGE:
		folks_presence_set_presence_message ((FolksPresence*) self, g_value_get_string (value));
		break;
		case FOLKS_INDIVIDUAL_ID:
		folks_individual_set_id (self, g_value_get_string (value));
		break;
		case FOLKS_INDIVIDUAL_ALIAS:
		folks_alias_set_alias ((FolksAlias*) self, g_value_get_string (value));
		break;
		case FOLKS_INDIVIDUAL_IS_FAVOURITE:
		folks_favourite_set_is_favourite ((FolksFavourite*) self, g_value_get_boolean (value));
		break;
		case FOLKS_INDIVIDUAL_GROUPS:
		folks_groups_set_groups ((FolksGroups*) self, g_value_get_boxed (value));
		break;
		case FOLKS_INDIVIDUAL_PERSONAS:
		folks_individual_set_personas (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}



