/* individual-aggregator.c generated by valac 0.11.2.11-bbde6, the Vala compiler
 * generated from individual-aggregator.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_INDIVIDUAL_AGGREGATOR (folks_individual_aggregator_get_type ())
#define FOLKS_INDIVIDUAL_AGGREGATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator))
#define FOLKS_INDIVIDUAL_AGGREGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorClass))
#define FOLKS_IS_INDIVIDUAL_AGGREGATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR))
#define FOLKS_IS_INDIVIDUAL_AGGREGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR))
#define FOLKS_INDIVIDUAL_AGGREGATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorClass))

typedef struct _FolksIndividualAggregator FolksIndividualAggregator;
typedef struct _FolksIndividualAggregatorClass FolksIndividualAggregatorClass;
typedef struct _FolksIndividualAggregatorPrivate FolksIndividualAggregatorPrivate;

#define FOLKS_TYPE_BACKEND_STORE (folks_backend_store_get_type ())
#define FOLKS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStore))
#define FOLKS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))
#define FOLKS_IS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_IS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_BACKEND_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))

typedef struct _FolksBackendStore FolksBackendStore;
typedef struct _FolksBackendStoreClass FolksBackendStoreClass;

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;

#define FOLKS_TYPE_BACKEND (folks_backend_get_type ())
#define FOLKS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND, FolksBackend))
#define FOLKS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND, FolksBackendClass))
#define FOLKS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND))
#define FOLKS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND))
#define FOLKS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND, FolksBackendClass))

typedef struct _FolksBackend FolksBackend;
typedef struct _FolksBackendClass FolksBackendClass;

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FolksIndividualAggregatorPrepareData FolksIndividualAggregatorPrepareData;
typedef struct _Block11Data Block11Data;
typedef struct _FolksIndividualAggregatorAddBackendData FolksIndividualAggregatorAddBackendData;
typedef struct _Block12Data Block12Data;

#define FOLKS_TYPE_PERSONA_STORE_TRUST (folks_persona_store_trust_get_type ())

#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;

#define FOLKS_GROUPABLE_TYPE_CHANGE_REASON (folks_groupable_change_reason_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block13Data Block13Data;

#define FOLKS_TYPE_TRUST_LEVEL (folks_trust_level_get_type ())
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _FolksIndividualAggregatorAddPersonaFromDetailsData FolksIndividualAggregatorAddPersonaFromDetailsData;
typedef struct _Block16Data Block16Data;
typedef struct _FolksIndividualAggregatorRemoveIndividualData FolksIndividualAggregatorRemoveIndividualData;
typedef struct _FolksIndividualAggregatorRemovePersonaData FolksIndividualAggregatorRemovePersonaData;
typedef struct _Block17Data Block17Data;

#define FOLKS_TYPE_IMABLE (folks_imable_get_type ())
#define FOLKS_IMABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMABLE, FolksIMable))
#define FOLKS_IS_IMABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMABLE))
#define FOLKS_IMABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IMABLE, FolksIMableIface))

typedef struct _FolksIMable FolksIMable;
typedef struct _FolksIMableIface FolksIMableIface;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block18Data Block18Data;
typedef struct _FolksIndividualAggregatorLinkPersonasData FolksIndividualAggregatorLinkPersonasData;
typedef struct _FolksIndividualAggregatorUnlinkIndividualData FolksIndividualAggregatorUnlinkIndividualData;

/**
 * Errors from {@link IndividualAggregator}s.
 */
typedef enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_NOT_FOUND,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE
} FolksIndividualAggregatorError;
#define FOLKS_INDIVIDUAL_AGGREGATOR_ERROR folks_individual_aggregator_error_quark ()
struct _FolksIndividualAggregator {
	GObject parent_instance;
	FolksIndividualAggregatorPrivate * priv;
};

struct _FolksIndividualAggregatorClass {
	GObjectClass parent_class;
};

struct _FolksIndividualAggregatorPrivate {
	FolksBackendStore* backend_store;
	GeeHashMap* stores;
	FolksPersonaStore* writeable_store;
	GeeHashSet* backends;
	GHashTable* link_map;
	gboolean linking_enabled;
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	GHashTable* _individuals;
	FolksIndividual* _user;
};

struct _FolksIndividualAggregatorPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	GError * _inner_error_;
};

struct _Block11Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	FolksBackend* backend;
	gpointer _async_data_;
};

struct _FolksIndividualAggregatorAddBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksBackend* backend;
	Block11Data* _data11_;
	gboolean _tmp0_;
	GHashTable* _tmp1_;
};

struct _Block12Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	gchar* store_id;
	FolksPersonaStore* store;
};

typedef enum  {
	FOLKS_PERSONA_STORE_TRUST_NONE,
	FOLKS_PERSONA_STORE_TRUST_PARTIAL,
	FOLKS_PERSONA_STORE_TRUST_FULL
} FolksPersonaStoreTrust;

typedef enum  {
	FOLKS_GROUPABLE_CHANGE_REASON_NONE = 0,
	FOLKS_GROUPABLE_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUPABLE_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUPABLE_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUPABLE_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUPABLE_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUPABLE_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUPABLE_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUPABLE_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUPABLE_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUPABLE_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUPABLE_CHANGE_REASON_SEPARATED = 11
} FolksGroupableChangeReason;

struct _Block13Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GList* candidate_inds;
	GeeHashSet* candidate_ind_set;
	GList* final_personas;
	FolksIndividual* final_individual;
};

typedef enum  {
	FOLKS_TRUST_LEVEL_NONE,
	FOLKS_TRUST_LEVEL_PERSONAS
} FolksTrustLevel;

struct _Block14Data {
	int _ref_count_;
	Block13Data * _data13_;
	const gchar* prop_name;
};

typedef void (*FolksPersonaLinkablePropertyCallback) (const gchar* link, void* user_data);
struct _Block15Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GList* removed_individuals;
	GeeHashSet* removed_personas;
};

typedef enum  {
	FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT,
	FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED,
	FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER,
	FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE
} FolksPersonaStoreError;
#define FOLKS_PERSONA_STORE_ERROR folks_persona_store_error_quark ()
struct _FolksIndividualAggregatorAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* parent;
	gchar* persona_store_type;
	gchar* persona_store_id;
	GHashTable* details;
	FolksPersona* result;
	gchar* _tmp0_;
	gchar* full_id;
	gpointer _tmp1_;
	FolksPersonaStore* store;
	const gchar* _tmp2_;
	GError* _tmp3_;
	FolksPersona* persona;
	GHashTable* _tmp4_;
	GHashTable* details_copy;
	FolksPersona* _tmp5_;
	FolksPersona* _tmp6_;
	FolksPersona* _tmp7_;
	GError * e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	gboolean _tmp11_;
	GList* _tmp12_;
	GList* _tmp13_;
	GList* personas;
	GError * _inner_error_;
};

struct _Block16Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GHashTable* retval;
};

struct _FolksIndividualAggregatorRemoveIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	GList* i;
	GList* _tmp0_;
	gboolean _tmp1_;
	FolksPersona* persona;
	FolksPersonaStore* _tmp2_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksPersona* persona;
	FolksPersonaStore* _tmp0_;
	GError * _inner_error_;
};

struct _Block17Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GHashTable* protocols_addrs_list;
	GHashTable* protocols_addrs_set;
	gpointer _async_data_;
};

struct _FolksIMableIface {
	GTypeInterface parent_iface;
	GHashTable* (*get_im_addresses) (FolksIMable* self);
	void (*set_im_addresses) (FolksIMable* self, GHashTable* value);
};

struct _Block18Data {
	int _ref_count_;
	Block17Data * _data17_;
	GPtrArray* address_list;
	GeeHashSet* address_set;
};

struct _FolksIndividualAggregatorLinkPersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	void* _personas;
	Block17Data* _data17_;
	GList* personas;
	const gchar* _tmp0_;
	GError* _tmp1_;
	const gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GList* persona_collection;
	GList* persona_it;
	FolksPersona* persona;
	GHashTable* _tmp5_;
	GValue addresses_value;
	GHashTable* _tmp6_;
	GHashTable* details;
	gchar* _tmp7_;
	GValue* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	FolksPersona* _tmp11_;
	FolksPersona* _tmp12_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorUnlinkIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GList* personas;
	GList* p_collection;
	GList* p_it;
	FolksPersona* _tmp4_;
	FolksPersona* p;
	GList* persona_collection;
	GList* persona_it;
	FolksPersona* persona;
	FolksPersonaStore* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GError * _inner_error_;
};


static gpointer folks_individual_aggregator_parent_class = NULL;

GQuark folks_individual_aggregator_error_quark (void);
GType folks_individual_aggregator_get_type (void) G_GNUC_CONST;
GType folks_backend_store_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
GType folks_backend_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
#define FOLKS_INDIVIDUAL_AGGREGATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorPrivate))
enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_DUMMY_PROPERTY,
	FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED,
	FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS,
	FOLKS_INDIVIDUAL_AGGREGATOR_USER
};
FolksIndividualAggregator* folks_individual_aggregator_new (void);
FolksIndividualAggregator* folks_individual_aggregator_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self, GHashTable* value);
FolksBackendStore* folks_backend_store_dup (void);
static void folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self, FolksBackendStore* backend_store, FolksBackend* backend);
static void _folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self);
static void folks_individual_aggregator_prepare_data_free (gpointer _data);
static void folks_individual_aggregator_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_individual_aggregator_prepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_prepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* data);
void folks_backend_store_load_backends (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_load_backends_finish (FolksBackendStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_add_backend_data_free (gpointer _data);
static void folks_individual_aggregator_add_backend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_add_backend (FolksIndividualAggregator* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_individual_aggregator_add_backend_finish (FolksIndividualAggregator* self, GAsyncResult* _res_);
static gboolean folks_individual_aggregator_add_backend_co (FolksIndividualAggregatorAddBackendData* data);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static void folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store);
static void _folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store);
static void _folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
GHashTable* folks_backend_get_persona_stores (FolksBackend* self);
static void _lambda27_ (const gchar* k, FolksPersonaStore* v, Block11Data* _data11_);
static void __lambda27__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
static gchar* folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self, const gchar* type_id, const gchar* id);
const gchar* folks_persona_store_get_type_id (FolksPersonaStore* self);
const gchar* folks_persona_store_get_id (FolksPersonaStore* self);
void folks_persona_store_set_is_writeable (FolksPersonaStore* self, gboolean value);
GType folks_persona_store_trust_get_type (void) G_GNUC_CONST;
void folks_persona_store_set_trust_level (FolksPersonaStore* self, FolksPersonaStoreTrust value);
GType folks_persona_get_type (void) G_GNUC_CONST;
GType folks_groupable_change_reason_get_type (void) G_GNUC_CONST;
static void folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self, FolksPersonaStore* store, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupableChangeReason reason);
static void _folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupableChangeReason reason, gpointer self);
static void folks_individual_aggregator_is_writeable_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec);
static void _folks_individual_aggregator_is_writeable_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void folks_individual_aggregator_trust_level_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec);
static void _folks_individual_aggregator_trust_level_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void folks_persona_store_prepare (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_prepare_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void _lambda26_ (GObject* obj, GAsyncResult* _result_, Block12Data* _data12_);
static void __lambda26__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void folks_individual_aggregator_add_personas (FolksIndividualAggregator* self, GList* added, GList** added_individuals, GeeHashMap** replaced_individuals, FolksIndividual** user);
static void _g_list_free__g_object_unref0_ (GList* self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
FolksPersonaStore* folks_persona_get_store (FolksPersona* self);
FolksPersonaStoreTrust folks_persona_store_get_trust_level (FolksPersonaStore* self);
const gchar* folks_persona_get_uid (FolksPersona* self);
const gchar* folks_persona_get_iid (FolksPersona* self);
gboolean folks_persona_get_is_user (FolksPersona* self);
const gchar* folks_individual_get_id (FolksIndividual* self);
GType folks_trust_level_get_type (void) G_GNUC_CONST;
FolksTrustLevel folks_individual_get_trust_level (FolksIndividual* self);
gchar** folks_persona_get_linkable_properties (FolksPersona* self, int* result_length1);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (Block14Data* _data14_);
void folks_persona_linkable_property_to_links (FolksPersona* self, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static void _lambda19_ (const gchar* l, Block14Data* _data14_);
static void __lambda19__folks_persona_linkable_property_callback (const gchar* link, gpointer self);
static void _lambda20_ (FolksIndividual* i, Block13Data* _data13_);
GList* folks_individual_get_personas (FolksIndividual* self);
static void _lambda21_ (FolksPersona* p, FolksIndividualAggregator* self);
static void __lambda21__gfunc (gconstpointer data, gpointer self);
static void __lambda20__gfunc (gconstpointer data, gpointer self);
FolksIndividual* folks_individual_new (GList* personas);
FolksIndividual* folks_individual_construct (GType object_type, GList* personas);
static void _lambda22_ (FolksPersona* i, Block13Data* _data13_);
static void _lambda23_ (const gchar* l, Block13Data* _data13_);
static void __lambda23__folks_persona_linkable_property_callback (const gchar* link, gpointer self);
static void __lambda22__gfunc (gconstpointer data, gpointer self);
gboolean folks_individual_get_is_user (FolksIndividual* self);
static void folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self, FolksIndividual* i, FolksIndividual* replacement);
static void _folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender, FolksIndividual* replacement_individual, gpointer self);
GHashTable* folks_individual_aggregator_get_individuals (FolksIndividualAggregator* self);
static void folks_individual_aggregator_remove_persona_from_link_map (FolksIndividualAggregator* self, FolksPersona* persona);
static void _lambda25_ (const gchar* l, FolksIndividualAggregator* self);
static void __lambda25__folks_persona_linkable_property_callback (const gchar* link, gpointer self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (Block15Data* _data15_);
FolksIndividual* folks_individual_aggregator_get_user (FolksIndividualAggregator* self);
static void _lambda24_ (FolksPersona* p, Block15Data* _data15_);
static void __lambda24__gfunc (gconstpointer data, gpointer self);
void folks_individual_set_personas (FolksIndividual* self, GList* value);
static void folks_individual_aggregator_set_user (FolksIndividualAggregator* self, FolksIndividual* value);
void folks_individual_replace (FolksIndividual* self, FolksIndividual* replacement_individual);
gboolean folks_persona_store_get_is_writeable (FolksPersonaStore* self);
static void folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data);
static void folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_individual_aggregator_add_persona_from_details (FolksIndividualAggregator* self, FolksIndividual* parent, const gchar* persona_store_type, const gchar* persona_store_id, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* folks_individual_aggregator_add_persona_from_details_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* data);
static GHashTable* folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self, GHashTable* asv);
void folks_persona_store_add_persona_from_details (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
GQuark folks_persona_store_error_quark (void);
FolksPersona* folks_persona_store_add_persona_from_details_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (Block16Data* _data16_);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static void _lambda28_ (const gchar* k, GValue* v, Block16Data* _data16_);
static GValue* _g_value_dup (GValue* self);
static void __lambda28__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void folks_individual_aggregator_remove_individual_data_free (gpointer _data);
static void folks_individual_aggregator_remove_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_individual_aggregator_remove_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_remove_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* data);
void folks_persona_store_remove_persona (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_remove_persona_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_remove_persona_data_free (gpointer _data);
static void folks_individual_aggregator_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_individual_aggregator_remove_persona (FolksIndividualAggregator* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_remove_persona_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* data);
static void folks_individual_aggregator_link_personas_data_free (gpointer _data);
static void folks_individual_aggregator_link_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_individual_aggregator_link_personas (FolksIndividualAggregator* self, void* _personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_link_personas_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* data);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (Block17Data* _data17_);
static void _g_ptr_array_unref0_ (gpointer var);
GType folks_imable_get_type (void) G_GNUC_CONST;
GHashTable* folks_imable_get_im_addresses (FolksIMable* self);
static void _lambda29_ (const gchar* k, GPtrArray* v, Block17Data* _data17_);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (Block18Data* _data18_);
static void _lambda30_ (const gchar* a, Block18Data* _data18_);
static void __lambda30__gfunc (gconstpointer data, gpointer self);
static void __lambda29__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void folks_individual_aggregator_unlink_individual_data_free (gpointer _data);
static void folks_individual_aggregator_unlink_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_individual_aggregator_unlink_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_unlink_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* data);
gboolean folks_individual_aggregator_get_is_prepared (FolksIndividualAggregator* self);
static void g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void folks_individual_aggregator_finalize (GObject* obj);
static void _vala_folks_individual_aggregator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_individual_aggregator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark folks_individual_aggregator_error_quark (void) {
	return g_quark_from_static_string ("folks_individual_aggregator_error-quark");
}


/**
   * Create a new IndividualAggregator.
   *
   * Clients should connect to the
   * {@link IndividualAggregator.individuals_changed} signal, then call
   * {@link IndividualAggregator.prepare} to load the backends and start
   * aggregating individuals.
   *
   * An example of how to set up an IndividualAggregator:
   * {{{
   *   IndividualAggregator agg = new IndividualAggregator ();
   *   agg.individuals_changed.connect (individuals_changed_cb);
   *   agg.prepare ();
   * }}}
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void _folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self) {
	folks_individual_aggregator_backend_available_cb (self, _sender, backend);
}


FolksIndividualAggregator* folks_individual_aggregator_construct (GType object_type) {
	FolksIndividualAggregator * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_;
	GHashTable* _tmp2_ = NULL;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_;
	GeeHashSet* _tmp6_ = NULL;
	GeeHashSet* _tmp7_;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* disable_linking;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	FolksBackendStore* _tmp16_ = NULL;
	FolksBackendStore* _tmp17_;
	self = (FolksIndividualAggregator*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->stores);
	self->priv->stores = _tmp1_;
	_tmp2_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_tmp3_ = _tmp2_;
	folks_individual_aggregator_set_individuals (self, _tmp3_);
	_g_hash_table_unref0 (_tmp3_);
	_tmp4_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_tmp5_ = _tmp4_;
	_g_hash_table_unref0 (self->priv->link_map);
	self->priv->link_map = _tmp5_;
	_tmp6_ = gee_hash_set_new (FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (self->priv->backends);
	self->priv->backends = _tmp7_;
	_tmp8_ = g_getenv ("FOLKS_DISABLE_LINKING");
	_tmp9_ = g_strdup (_tmp8_);
	disable_linking = _tmp9_;
	if (disable_linking != NULL) {
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		_tmp10_ = string_strip (disable_linking);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) (-1));
		_tmp13_ = _tmp12_;
		_g_free0 (disable_linking);
		disable_linking = _tmp13_;
		_g_free0 (_tmp11_);
	}
	if (disable_linking == NULL) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = g_strcmp0 (disable_linking, "no") == 0;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = g_strcmp0 (disable_linking, "0") == 0;
	}
	self->priv->linking_enabled = _tmp14_;
	_tmp16_ = folks_backend_store_dup ();
	_tmp17_ = _tmp16_;
	_g_object_unref0 (self->priv->backend_store);
	self->priv->backend_store = _tmp17_;
	g_signal_connect_object (self->priv->backend_store, "backend-available", (GCallback) _folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available, self, 0);
	_g_free0 (disable_linking);
	return self;
}


FolksIndividualAggregator* folks_individual_aggregator_new (void) {
	return folks_individual_aggregator_construct (FOLKS_TYPE_INDIVIDUAL_AGGREGATOR);
}


static void folks_individual_aggregator_prepare_data_free (gpointer _data) {
	FolksIndividualAggregatorPrepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorPrepareData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void folks_individual_aggregator_prepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorPrepareData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_prepare_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_individual_aggregator_prepare_co (_data_);
}


void folks_individual_aggregator_prepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_individual_aggregator_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorPrepareData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_prepare_co (data);
}


/**
   * Prepare the IndividualAggregator for use.
   *
   * This loads all the available backends and prepares them for use by the
   * IndividualAggregator. This should be called //after// connecting to the
   * {@link IndividualAggregator.individuals_changed} signal, or a race
   * condition could occur, with the signal being emitted before your code has
   * connected to them, and {@link Individual}s getting "lost" as a result.
   *
   * This function is guaranteed to be idempotent (since version 0.3.0).
   *
   * @since 0.1.11
   */
static gboolean folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__is_prepared);
		if (!data->self->priv->_is_prepared) {
			data->_state_ = 1;
			folks_backend_store_load_backends (data->self->priv->backend_store, folks_individual_aggregator_prepare_ready, data);
			return FALSE;
			_state_1:
			folks_backend_store_load_backends_finish (data->self->priv->backend_store, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __finally8;
			}
			data->self->priv->_is_prepared = TRUE;
			g_object_notify ((GObject*) data->self, "is-prepared");
		}
		__finally8:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_add_backend_data_free (gpointer _data) {
	FolksIndividualAggregatorAddBackendData* data;
	data = _data;
	_g_object_unref0 (data->backend);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorAddBackendData, data);
}


static void folks_individual_aggregator_add_backend (FolksIndividualAggregator* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorAddBackendData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorAddBackendData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_add_backend);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_add_backend_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->backend = _g_object_ref0 (backend);
	folks_individual_aggregator_add_backend_co (_data_);
}


static void folks_individual_aggregator_add_backend_finish (FolksIndividualAggregator* self, GAsyncResult* _res_) {
	FolksIndividualAggregatorAddBackendData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_individual_aggregator_add_backend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorAddBackendData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_add_backend_co (data);
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->self);
		_g_object_unref0 (_data11_->backend);
		g_slice_free (Block11Data, _data11_);
	}
}


static void _folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	folks_individual_aggregator_backend_persona_store_added_cb (self, _sender, store);
}


static void _folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	folks_individual_aggregator_backend_persona_store_removed_cb (self, _sender, store);
}


static void _lambda27_ (const gchar* k, FolksPersonaStore* v, Block11Data* _data11_) {
	FolksIndividualAggregator * self;
	self = _data11_->self;
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	folks_individual_aggregator_backend_persona_store_added_cb (self, _data11_->backend, FOLKS_PERSONA_STORE (v));
}


static void __lambda27__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda27_ (key, value, self);
}


static gboolean folks_individual_aggregator_add_backend_co (FolksIndividualAggregatorAddBackendData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data11_ = g_slice_new0 (Block11Data);
	data->_data11_->_ref_count_ = 1;
	data->_data11_->self = g_object_ref (data->self);
	data->_data11_->backend = _g_object_ref0 (data->backend);
	data->_data11_->_async_data_ = data;
	data->_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) data->self->priv->backends, data->_data11_->backend);
	if (!data->_tmp0_) {
		gee_abstract_collection_add ((GeeAbstractCollection*) data->self->priv->backends, data->_data11_->backend);
		g_signal_connect_object (data->_data11_->backend, "persona-store-added", (GCallback) _folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added, data->self, 0);
		g_signal_connect_object (data->_data11_->backend, "persona-store-removed", (GCallback) _folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed, data->self, 0);
		data->_tmp1_ = NULL;
		data->_tmp1_ = folks_backend_get_persona_stores (data->_data11_->backend);
		g_hash_table_foreach (data->_tmp1_, __lambda27__gh_func, data->_data11_);
	}
	block11_data_unref (data->_data11_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self, FolksBackendStore* backend_store, FolksBackend* backend) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend_store != NULL);
	g_return_if_fail (backend != NULL);
	folks_individual_aggregator_add_backend (self, backend, NULL, NULL);
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		_g_object_unref0 (_data12_->self);
		_g_free0 (_data12_->store_id);
		_g_object_unref0 (_data12_->store);
		g_slice_free (Block12Data, _data12_);
	}
}


static void _folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupableChangeReason reason, gpointer self) {
	folks_individual_aggregator_personas_changed_cb (self, _sender, added, removed, message, actor, reason);
}


static void _folks_individual_aggregator_is_writeable_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_aggregator_is_writeable_changed_cb (self, _sender, pspec);
}


static void _folks_individual_aggregator_trust_level_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_aggregator_trust_level_changed_cb (self, _sender, pspec);
}


static void _lambda26_ (GObject* obj, GAsyncResult* _result_, Block12Data* _data12_) {
	FolksIndividualAggregator * self;
	GError * _inner_error_ = NULL;
	self = _data12_->self;
	g_return_if_fail (_result_ != NULL);
	folks_persona_store_prepare_finish (_data12_->store, _result_, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch9_g_error;
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		const gchar* _tmp0_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = _ ("Error preparing persona store '%s': %s");
		g_warning (_tmp0_, _data12_->store_id, e->message);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda26__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda26_ (source_object, res, self);
	block12_data_unref (self);
}


static void folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store) {
	Block12Data* _data12_;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_data12_->store = _g_object_ref0 (store);
	_tmp0_ = folks_persona_store_get_type_id (_data12_->store);
	_tmp1_ = folks_persona_store_get_id (_data12_->store);
	_tmp2_ = folks_individual_aggregator_get_store_full_id (self, _tmp0_, _tmp1_);
	_data12_->store_id = _tmp2_;
	_tmp3_ = folks_persona_store_get_type_id (_data12_->store);
	if (g_strcmp0 (_tmp3_, "key-file") == 0) {
		folks_persona_store_set_is_writeable (_data12_->store, TRUE);
		folks_persona_store_set_trust_level (_data12_->store, FOLKS_PERSONA_STORE_TRUST_FULL);
		self->priv->writeable_store = _data12_->store;
	}
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->stores, _data12_->store_id, _data12_->store);
	g_signal_connect_object (_data12_->store, "personas-changed", (GCallback) _folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self, 0);
	g_signal_connect_object ((GObject*) _data12_->store, "notify::is-writeable", (GCallback) _folks_individual_aggregator_is_writeable_changed_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) _data12_->store, "notify::trust-level", (GCallback) _folks_individual_aggregator_trust_level_changed_cb_g_object_notify, self, 0);
	folks_persona_store_prepare (_data12_->store, __lambda26__gasync_ready_callback, block12_data_ref (_data12_));
	block12_data_unref (_data12_);
}


static void folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store) {
	guint _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	guint _tmp3_;
	GQuark _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	g_signal_parse_name ("personas-changed", FOLKS_TYPE_PERSONA_STORE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self);
	g_signal_parse_name ("notify::trust-level", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _folks_individual_aggregator_trust_level_changed_cb_g_object_notify, self);
	g_signal_parse_name ("notify::is-writeable", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _folks_individual_aggregator_is_writeable_changed_cb_g_object_notify, self);
	if (self->priv->writeable_store == store) {
		self->priv->writeable_store = NULL;
	}
	_tmp5_ = folks_persona_store_get_type_id (store);
	_tmp6_ = folks_persona_store_get_id (store);
	_tmp7_ = folks_individual_aggregator_get_store_full_id (self, _tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->stores, _tmp8_, NULL);
	_g_free0 (_tmp8_);
}


static gchar* folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self, const gchar* type_id, const gchar* id) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_id != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_strconcat (type_id, ":", NULL);
	result = (_tmp1_ = g_strconcat (_tmp0_, id, NULL), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		_g_object_unref0 (_data13_->self);
		_g_object_unref0 (_data13_->final_individual);
		__g_list_free__g_object_unref0_0 (_data13_->final_personas);
		_g_object_unref0 (_data13_->candidate_ind_set);
		__g_list_free__g_object_unref0_0 (_data13_->candidate_inds);
		g_slice_free (Block13Data, _data13_);
	}
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (Block14Data* _data14_) {
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		block13_data_unref (_data14_->_data13_);
		g_slice_free (Block14Data, _data14_);
	}
}


static void _lambda19_ (const gchar* l, Block14Data* _data14_) {
	Block13Data* _data13_;
	FolksIndividualAggregator * self;
	gchar* _tmp0_;
	gchar* prop_linking_value;
	gconstpointer _tmp1_ = NULL;
	FolksIndividual* _tmp2_;
	FolksIndividual* candidate_ind;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	_data13_ = _data14_->_data13_;
	self = _data13_->self;
	g_return_if_fail (l != NULL);
	_tmp0_ = g_strdup ((const gchar*) l);
	prop_linking_value = _tmp0_;
	_tmp1_ = g_hash_table_lookup (self->priv->link_map, prop_linking_value);
	_tmp2_ = _g_object_ref0 ((FolksIndividual*) _tmp1_);
	candidate_ind = _tmp2_;
	if (candidate_ind != NULL) {
		FolksTrustLevel _tmp5_;
		_tmp5_ = folks_individual_get_trust_level (candidate_ind);
		_tmp4_ = _tmp5_ != FOLKS_TRUST_LEVEL_NONE;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp6_;
		_tmp6_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data13_->candidate_ind_set, candidate_ind);
		_tmp3_ = !_tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp7_ = NULL;
		FolksIndividual* _tmp8_;
		_tmp7_ = folks_individual_get_id (candidate_ind);
		g_debug ("    Found candidate individual '%s' by " "linkable property '%s' = '%s'.", _tmp7_, _data14_->prop_name, prop_linking_value);
		_tmp8_ = _g_object_ref0 (candidate_ind);
		_data13_->candidate_inds = g_list_prepend (_data13_->candidate_inds, _tmp8_);
		gee_abstract_collection_add ((GeeAbstractCollection*) _data13_->candidate_ind_set, candidate_ind);
	}
	_g_object_unref0 (candidate_ind);
	_g_free0 (prop_linking_value);
}


static void __lambda19__folks_persona_linkable_property_callback (const gchar* link, gpointer self) {
	_lambda19_ (link, self);
}


static void _lambda21_ (FolksPersona* p, FolksIndividualAggregator* self) {
	g_return_if_fail (p != NULL);
	g_object_ref ((GObject*) FOLKS_PERSONA (p));
}


static void __lambda21__gfunc (gconstpointer data, gpointer self) {
	_lambda21_ (data, self);
}


static void _lambda20_ (FolksIndividual* i, Block13Data* _data13_) {
	FolksIndividualAggregator * self;
	FolksIndividual* individual;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	self = _data13_->self;
	g_return_if_fail (i != NULL);
	individual = FOLKS_INDIVIDUAL (i);
	_tmp0_ = folks_individual_get_personas (individual);
	g_list_foreach (_tmp0_, __lambda21__gfunc, self);
	_tmp1_ = folks_individual_get_personas (individual);
	_tmp2_ = g_list_copy (_tmp1_);
	_data13_->final_personas = g_list_concat (_data13_->final_personas, _tmp2_);
}


static void __lambda20__gfunc (gconstpointer data, gpointer self) {
	_lambda20_ (data, self);
}


static void _lambda23_ (const gchar* l, Block13Data* _data13_) {
	FolksIndividualAggregator * self;
	gchar* _tmp0_;
	gchar* prop_linking_value;
	gchar* _tmp1_;
	FolksIndividual* _tmp2_;
	self = _data13_->self;
	g_return_if_fail (l != NULL);
	_tmp0_ = g_strdup ((const gchar*) l);
	prop_linking_value = _tmp0_;
	g_debug ("individual-aggregator.vala:457:             %s", prop_linking_value);
	_tmp1_ = g_strdup (prop_linking_value);
	_tmp2_ = _g_object_ref0 (_data13_->final_individual);
	g_hash_table_replace (self->priv->link_map, _tmp1_, _tmp2_);
	_g_free0 (prop_linking_value);
}


static void __lambda23__folks_persona_linkable_property_callback (const gchar* link, gpointer self) {
	_lambda23_ (link, self);
}


static void _lambda22_ (FolksPersona* i, Block13Data* _data13_) {
	FolksIndividualAggregator * self;
	FolksPersona* final_persona;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	FolksIndividual* _tmp6_;
	FolksPersonaStore* _tmp7_ = NULL;
	FolksPersonaStoreTrust _tmp8_;
	self = _data13_->self;
	g_return_if_fail (i != NULL);
	final_persona = FOLKS_PERSONA (i);
	_tmp0_ = NULL;
	_tmp1_ = folks_persona_get_is_user (final_persona);
	if (_tmp1_) {
		_tmp0_ = "yes";
	} else {
		_tmp0_ = "no";
	}
	_tmp2_ = folks_persona_get_uid (final_persona);
	_tmp3_ = folks_persona_get_iid (final_persona);
	g_debug ("individual-aggregator.vala:421:         %s (is user: %s, IID: %s)", _tmp2_, _tmp0_, _tmp3_);
	_tmp4_ = folks_persona_get_iid (final_persona);
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _g_object_ref0 (_data13_->final_individual);
	g_hash_table_replace (self->priv->link_map, _tmp5_, _tmp6_);
	_tmp7_ = folks_persona_get_store (final_persona);
	_tmp8_ = folks_persona_store_get_trust_level (_tmp7_);
	if (_tmp8_ == FOLKS_PERSONA_STORE_TRUST_FULL) {
		gchar** _tmp9_ = NULL;
		gint _tmp10_;
		g_debug ("individual-aggregator.vala:434:         Inserting links:");
		_tmp9_ = folks_persona_get_linkable_properties (final_persona, &_tmp10_);
		{
			gchar** prop_name_collection;
			int prop_name_collection_length1;
			int prop_name_it;
			prop_name_collection = _tmp9_;
			prop_name_collection_length1 = _tmp10_;
			for (prop_name_it = 0; prop_name_it < _tmp10_; prop_name_it = prop_name_it + 1) {
				const gchar* prop_name;
				prop_name = prop_name_collection[prop_name_it];
				{
					GObjectClass* _tmp11_ = NULL;
					GObjectClass* pclass;
					GParamSpec* _tmp12_ = NULL;
					_tmp11_ = G_OBJECT_GET_CLASS ((GObject*) final_persona);
					pclass = _tmp11_;
					_tmp12_ = g_object_class_find_property (pclass, prop_name);
					if (_tmp12_ == NULL) {
						const gchar* _tmp13_ = NULL;
						_tmp13_ = _ ("Unknown property '%s' in linkable property list.");
						g_warning (_tmp13_, prop_name);
						continue;
					}
					folks_persona_linkable_property_to_links (final_persona, prop_name, __lambda23__folks_persona_linkable_property_callback, _data13_);
				}
			}
		}
	}
}


static void __lambda22__gfunc (gconstpointer data, gpointer self) {
	_lambda22_ (data, self);
}


static void _folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender, FolksIndividual* replacement_individual, gpointer self) {
	folks_individual_aggregator_individual_removed_cb (self, _sender, replacement_individual);
}


static void folks_individual_aggregator_add_personas (FolksIndividualAggregator* self, GList* added, GList** added_individuals, GeeHashMap** replaced_individuals, FolksIndividual** user) {
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* almost_added_individuals;
	g_return_if_fail (self != NULL);
	g_return_if_fail (replaced_individuals != NULL);
	g_return_if_fail (user != NULL);
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	almost_added_individuals = _tmp0_;
	{
		GList* persona_collection;
		GList* persona_it;
		persona_collection = added;
		for (persona_it = persona_collection; persona_it != NULL; persona_it = persona_it->next) {
			FolksPersona* persona;
			persona = (FolksPersona*) persona_it->data;
			{
				Block13Data* _data13_;
				FolksPersonaStore* _tmp1_ = NULL;
				FolksPersonaStoreTrust _tmp2_;
				FolksPersonaStoreTrust trust_level;
				GeeHashSet* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_;
				FolksPersonaStore* _tmp18_ = NULL;
				FolksPersonaStoreTrust _tmp19_;
				FolksPersona* _tmp25_;
				gboolean _tmp26_ = FALSE;
				FolksIndividual* _tmp27_ = NULL;
				FolksIndividual* _tmp28_;
				const gchar* _tmp29_ = NULL;
				gboolean _tmp31_;
				_data13_ = g_slice_new0 (Block13Data);
				_data13_->_ref_count_ = 1;
				_data13_->self = g_object_ref (self);
				_tmp1_ = folks_persona_get_store (persona);
				_tmp2_ = folks_persona_store_get_trust_level (_tmp1_);
				trust_level = _tmp2_;
				_data13_->candidate_inds = NULL;
				_tmp3_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
				_data13_->candidate_ind_set = _tmp3_;
				_data13_->final_personas = NULL;
				_data13_->final_individual = NULL;
				_tmp4_ = folks_persona_get_uid (persona);
				_tmp5_ = folks_persona_get_iid (persona);
				g_debug ("individual-aggregator.vala:310: Aggregating persona '%s' on '%s'.", _tmp4_, _tmp5_);
				_tmp7_ = folks_persona_get_is_user (persona);
				if (_tmp7_ == TRUE) {
					_tmp6_ = (*user) != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					const gchar* _tmp8_ = NULL;
					FolksIndividual* _tmp9_;
					_tmp8_ = folks_individual_get_id (*user);
					g_debug ("individual-aggregator.vala:316:     Found candidate individual '%s' as" \
" user.", _tmp8_);
					_tmp9_ = _g_object_ref0 (*user);
					_data13_->candidate_inds = g_list_prepend (_data13_->candidate_inds, _tmp9_);
					gee_abstract_collection_add ((GeeAbstractCollection*) _data13_->candidate_ind_set, *user);
				}
				if (trust_level != FOLKS_PERSONA_STORE_TRUST_NONE) {
					const gchar* _tmp10_ = NULL;
					gconstpointer _tmp11_ = NULL;
					FolksIndividual* _tmp12_;
					FolksIndividual* candidate_ind;
					gboolean _tmp13_ = FALSE;
					_tmp10_ = folks_persona_get_iid (persona);
					_tmp11_ = g_hash_table_lookup (self->priv->link_map, _tmp10_);
					_tmp12_ = _g_object_ref0 ((FolksIndividual*) _tmp11_);
					candidate_ind = _tmp12_;
					if (candidate_ind != NULL) {
						FolksTrustLevel _tmp14_;
						_tmp14_ = folks_individual_get_trust_level (candidate_ind);
						_tmp13_ = _tmp14_ != FOLKS_TRUST_LEVEL_NONE;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						const gchar* _tmp15_ = NULL;
						const gchar* _tmp16_ = NULL;
						FolksIndividual* _tmp17_;
						_tmp15_ = folks_individual_get_id (candidate_ind);
						_tmp16_ = folks_persona_get_iid (persona);
						g_debug ("individual-aggregator.vala:329:     Found candidate individual '%s' by" \
" IID '%s'.", _tmp15_, _tmp16_);
						_tmp17_ = _g_object_ref0 (candidate_ind);
						_data13_->candidate_inds = g_list_prepend (_data13_->candidate_inds, _tmp17_);
						gee_abstract_collection_add ((GeeAbstractCollection*) _data13_->candidate_ind_set, candidate_ind);
					}
					_g_object_unref0 (candidate_ind);
				}
				_tmp18_ = folks_persona_get_store (persona);
				_tmp19_ = folks_persona_store_get_trust_level (_tmp18_);
				if (_tmp19_ == FOLKS_PERSONA_STORE_TRUST_FULL) {
					gchar** _tmp20_ = NULL;
					gint _tmp21_;
					_tmp20_ = folks_persona_get_linkable_properties (persona, &_tmp21_);
					{
						gchar** foo_collection;
						int foo_collection_length1;
						int foo_it;
						foo_collection = _tmp20_;
						foo_collection_length1 = _tmp21_;
						for (foo_it = 0; foo_it < _tmp21_; foo_it = foo_it + 1) {
							const gchar* foo;
							foo = foo_collection[foo_it];
							{
								Block14Data* _data14_;
								GObjectClass* _tmp22_ = NULL;
								GObjectClass* pclass;
								GParamSpec* _tmp23_ = NULL;
								_data14_ = g_slice_new0 (Block14Data);
								_data14_->_ref_count_ = 1;
								_data14_->_data13_ = block13_data_ref (_data13_);
								_data14_->prop_name = foo;
								_tmp22_ = G_OBJECT_GET_CLASS ((GObject*) persona);
								pclass = _tmp22_;
								_tmp23_ = g_object_class_find_property (pclass, _data14_->prop_name);
								if (_tmp23_ == NULL) {
									const gchar* _tmp24_ = NULL;
									_tmp24_ = _ ("Unknown property '%s' in linkable property list.");
									g_warning (_tmp24_, _data14_->prop_name);
									block14_data_unref (_data14_);
									continue;
								}
								folks_persona_linkable_property_to_links (persona, _data14_->prop_name, __lambda19__folks_persona_linkable_property_callback, _data14_);
								block14_data_unref (_data14_);
							}
						}
					}
				}
				_tmp25_ = _g_object_ref0 (persona);
				_data13_->final_personas = g_list_prepend (_data13_->final_personas, _tmp25_);
				if (_data13_->candidate_inds != NULL) {
					_tmp26_ = self->priv->linking_enabled == TRUE;
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					g_list_foreach (_data13_->candidate_inds, __lambda20__gfunc, _data13_);
				} else {
					if (_data13_->candidate_inds != NULL) {
						g_debug ("individual-aggregator.vala:406:     Linking disabled.");
					} else {
						g_debug ("individual-aggregator.vala:410:     Did not find any candidate individ" \
"uals.");
					}
				}
				_tmp27_ = folks_individual_new (_data13_->final_personas);
				_tmp28_ = _tmp27_;
				_g_object_unref0 (_data13_->final_individual);
				_data13_->final_individual = _tmp28_;
				_tmp29_ = folks_individual_get_id (_data13_->final_individual);
				g_debug ("individual-aggregator.vala:415:     Created new individual '%s' with p" \
"ersonas:", _tmp29_);
				g_list_foreach (_data13_->final_personas, __lambda22__gfunc, _data13_);
				{
					GList* i_collection;
					GList* i_it;
					i_collection = _data13_->candidate_inds;
					for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
						FolksIndividual* i;
						i = (FolksIndividual*) i_it->data;
						{
							gboolean _tmp30_;
							_tmp30_ = gee_abstract_collection_contains ((GeeAbstractCollection*) almost_added_individuals, i);
							if (_tmp30_ == TRUE) {
								gee_abstract_collection_remove ((GeeAbstractCollection*) almost_added_individuals, i);
							} else {
								gee_abstract_map_set ((GeeAbstractMap*) (*replaced_individuals), i, _data13_->final_individual);
							}
						}
					}
				}
				_tmp31_ = folks_individual_get_is_user (_data13_->final_individual);
				if (_tmp31_ == TRUE) {
					FolksIndividual* _tmp32_;
					FolksIndividual* _tmp33_;
					_tmp32_ = _g_object_ref0 (_data13_->final_individual);
					_tmp33_ = _tmp32_;
					_g_object_unref0 (*user);
					*user = _tmp33_;
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) almost_added_individuals, _data13_->final_individual);
				block13_data_unref (_data13_);
			}
		}
	}
	{
		GeeIterator* _tmp34_ = NULL;
		GeeIterator* _i_it;
		_tmp34_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) almost_added_individuals);
		_i_it = _tmp34_;
		while (TRUE) {
			gboolean _tmp35_;
			gpointer _tmp36_ = NULL;
			FolksIndividual* i;
			FolksIndividual* _tmp37_;
			const gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			FolksIndividual* _tmp40_;
			_tmp35_ = gee_iterator_next (_i_it);
			if (!_tmp35_) {
				break;
			}
			_tmp36_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp36_;
			g_signal_connect_object (i, "removed", (GCallback) _folks_individual_aggregator_individual_removed_cb_folks_individual_removed, self, 0);
			_tmp37_ = _g_object_ref0 (i);
			*added_individuals = g_list_prepend (*added_individuals, _tmp37_);
			_tmp38_ = folks_individual_get_id (i);
			_tmp39_ = g_strdup (_tmp38_);
			_tmp40_ = _g_object_ref0 (i);
			g_hash_table_insert (self->priv->_individuals, _tmp39_, _tmp40_);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_g_object_unref0 (almost_added_individuals);
}


static void _lambda25_ (const gchar* l, FolksIndividualAggregator* self) {
	gchar* _tmp0_;
	gchar* prop_linking_value;
	g_return_if_fail (l != NULL);
	_tmp0_ = g_strdup ((const gchar*) l);
	prop_linking_value = _tmp0_;
	g_debug ("individual-aggregator.vala:523:         %s", prop_linking_value);
	g_hash_table_remove (self->priv->link_map, prop_linking_value);
	_g_free0 (prop_linking_value);
}


static void __lambda25__folks_persona_linkable_property_callback (const gchar* link, gpointer self) {
	_lambda25_ (link, self);
}


static void folks_individual_aggregator_remove_persona_from_link_map (FolksIndividualAggregator* self, FolksPersona* persona) {
	const gchar* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	FolksPersonaStoreTrust _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	_tmp0_ = folks_persona_get_iid (persona);
	g_hash_table_remove (self->priv->link_map, _tmp0_);
	_tmp1_ = folks_persona_get_store (persona);
	_tmp2_ = folks_persona_store_get_trust_level (_tmp1_);
	if (_tmp2_ == FOLKS_PERSONA_STORE_TRUST_FULL) {
		const gchar* _tmp3_ = NULL;
		gchar** _tmp4_ = NULL;
		gint _tmp5_;
		_tmp3_ = folks_persona_get_uid (persona);
		g_debug ("individual-aggregator.vala:502:     Removing links to %s:", _tmp3_);
		_tmp4_ = folks_persona_get_linkable_properties (persona, &_tmp5_);
		{
			gchar** prop_name_collection;
			int prop_name_collection_length1;
			int prop_name_it;
			prop_name_collection = _tmp4_;
			prop_name_collection_length1 = _tmp5_;
			for (prop_name_it = 0; prop_name_it < _tmp5_; prop_name_it = prop_name_it + 1) {
				gchar* _tmp6_;
				gchar* prop_name;
				_tmp6_ = g_strdup (prop_name_collection[prop_name_it]);
				prop_name = _tmp6_;
				{
					GObjectClass* _tmp7_ = NULL;
					GObjectClass* pclass;
					GParamSpec* _tmp8_ = NULL;
					_tmp7_ = G_OBJECT_GET_CLASS ((GObject*) persona);
					pclass = _tmp7_;
					_tmp8_ = g_object_class_find_property (pclass, prop_name);
					if (_tmp8_ == NULL) {
						const gchar* _tmp9_ = NULL;
						_tmp9_ = _ ("Unknown property '%s' in linkable property list.");
						g_warning (_tmp9_, prop_name);
						_g_free0 (prop_name);
						continue;
					}
					folks_persona_linkable_property_to_links (persona, prop_name, __lambda25__folks_persona_linkable_property_callback, self);
					_g_free0 (prop_name);
				}
			}
		}
	}
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (Block15Data* _data15_) {
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		_g_object_unref0 (_data15_->self);
		_g_object_unref0 (_data15_->removed_personas);
		__g_list_free__g_object_unref0_0 (_data15_->removed_individuals);
		g_slice_free (Block15Data, _data15_);
	}
}


static void _lambda24_ (FolksPersona* p, Block15Data* _data15_) {
	FolksIndividualAggregator * self;
	FolksPersona* persona;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	FolksIndividual* _tmp6_;
	FolksIndividual* ind;
	self = _data15_->self;
	g_return_if_fail (p != NULL);
	persona = FOLKS_PERSONA (p);
	_tmp0_ = NULL;
	_tmp1_ = folks_persona_get_is_user (persona);
	if (_tmp1_) {
		_tmp0_ = "yes";
	} else {
		_tmp0_ = "no";
	}
	_tmp2_ = folks_persona_get_uid (persona);
	_tmp3_ = folks_persona_get_iid (persona);
	g_debug ("individual-aggregator.vala:562:     %s (is user: %s, IID: %s)", _tmp2_, _tmp0_, _tmp3_);
	gee_abstract_collection_add ((GeeAbstractCollection*) _data15_->removed_personas, persona);
	_tmp4_ = folks_persona_get_iid (persona);
	_tmp5_ = g_hash_table_lookup (self->priv->link_map, _tmp4_);
	_tmp6_ = _g_object_ref0 ((FolksIndividual*) _tmp5_);
	ind = _tmp6_;
	if (ind != NULL) {
		FolksIndividual* _tmp7_;
		_tmp7_ = _g_object_ref0 (ind);
		_data15_->removed_individuals = g_list_prepend (_data15_->removed_individuals, _tmp7_);
	}
	folks_individual_aggregator_remove_persona_from_link_map (self, persona);
	_g_object_unref0 (ind);
}


static void __lambda24__gfunc (gconstpointer data, gpointer self) {
	_lambda24_ (data, self);
}


static void folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self, FolksPersonaStore* store, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupableChangeReason reason) {
	Block15Data* _data15_;
	GList* added_individuals;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* replaced_individuals;
	GList* relinked_personas;
	GeeHashSet* _tmp1_ = NULL;
	FolksIndividual* _tmp2_;
	FolksIndividual* user;
	gboolean _tmp19_ = FALSE;
	GeeMapIterator* _tmp20_ = NULL;
	GeeMapIterator* iter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	added_individuals = NULL;
	_data15_->removed_individuals = NULL;
	_tmp0_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	replaced_individuals = _tmp0_;
	relinked_personas = NULL;
	_tmp1_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal);
	_data15_->removed_personas = _tmp1_;
	_tmp2_ = _g_object_ref0 (self->priv->_user);
	user = _tmp2_;
	if (added != NULL) {
		folks_individual_aggregator_add_personas (self, added, &added_individuals, &replaced_individuals, &user);
	}
	g_debug ("individual-aggregator.vala:556: Removing Personas:");
	g_list_foreach (removed, __lambda24__gfunc, _data15_);
	g_debug ("individual-aggregator.vala:587: Removing Individuals due to removed li" \
"nks:");
	{
		GList* individual_collection;
		GList* individual_it;
		individual_collection = _data15_->removed_individuals;
		for (individual_it = individual_collection; individual_it != NULL; individual_it = individual_it->next) {
			FolksIndividual* _tmp3_;
			FolksIndividual* individual;
			_tmp3_ = _g_object_ref0 ((FolksIndividual*) individual_it->data);
			individual = _tmp3_;
			{
				const gchar* _tmp4_ = NULL;
				gconstpointer _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				GList* _tmp7_ = NULL;
				const gchar* _tmp11_ = NULL;
				_tmp4_ = folks_individual_get_id (individual);
				_tmp5_ = g_hash_table_lookup (self->priv->_individuals, _tmp4_);
				if (((FolksIndividual*) _tmp5_) == NULL) {
					_g_object_unref0 (individual);
					continue;
				}
				_tmp6_ = folks_individual_get_id (individual);
				g_debug ("individual-aggregator.vala:594:     %s", _tmp6_);
				_tmp7_ = folks_individual_get_personas (individual);
				{
					GList* persona_collection;
					GList* persona_it;
					persona_collection = _tmp7_;
					for (persona_it = persona_collection; persona_it != NULL; persona_it = persona_it->next) {
						FolksPersona* persona;
						persona = (FolksPersona*) persona_it->data;
						{
							gboolean _tmp8_;
							FolksPersona* _tmp9_;
							_tmp8_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data15_->removed_personas, persona);
							if (_tmp8_ == TRUE) {
								continue;
							}
							_tmp9_ = _g_object_ref0 (persona);
							relinked_personas = g_list_prepend (relinked_personas, _tmp9_);
							folks_individual_aggregator_remove_persona_from_link_map (self, persona);
						}
					}
				}
				if (user == individual) {
					FolksIndividual* _tmp10_;
					_tmp10_ = NULL;
					_g_object_unref0 (user);
					user = _tmp10_;
				}
				_tmp11_ = folks_individual_get_id (individual);
				g_hash_table_remove (self->priv->_individuals, _tmp11_);
				folks_individual_set_personas (individual, NULL);
				_g_object_unref0 (individual);
			}
		}
	}
	g_debug ("individual-aggregator.vala:616: Relinking Personas:");
	{
		GList* persona_collection;
		GList* persona_it;
		persona_collection = relinked_personas;
		for (persona_it = persona_collection; persona_it != NULL; persona_it = persona_it->next) {
			FolksPersona* persona;
			persona = (FolksPersona*) persona_it->data;
			{
				const gchar* _tmp12_;
				gboolean _tmp13_;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				_tmp12_ = NULL;
				_tmp13_ = folks_persona_get_is_user (persona);
				if (_tmp13_) {
					_tmp12_ = "yes";
				} else {
					_tmp12_ = "no";
				}
				_tmp14_ = folks_persona_get_uid (persona);
				_tmp15_ = folks_persona_get_iid (persona);
				g_debug ("individual-aggregator.vala:619:     %s (is user: %s, IID: %s)", _tmp14_, _tmp12_, _tmp15_);
			}
		}
	}
	folks_individual_aggregator_add_personas (self, relinked_personas, &added_individuals, &replaced_individuals, &user);
	if (replaced_individuals != NULL) {
		GeeMapIterator* _tmp16_ = NULL;
		GeeMapIterator* iter;
		_tmp16_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) replaced_individuals);
		iter = _tmp16_;
		while (TRUE) {
			gboolean _tmp17_;
			gpointer _tmp18_ = NULL;
			_tmp17_ = gee_map_iterator_next (iter);
			if (!(_tmp17_ == TRUE)) {
				break;
			}
			_tmp18_ = gee_map_iterator_get_key (iter);
			_data15_->removed_individuals = g_list_prepend (_data15_->removed_individuals, (FolksIndividual*) _tmp18_);
		}
		_g_object_unref0 (iter);
	}
	folks_individual_aggregator_set_user (self, user);
	if (added_individuals != NULL) {
		_tmp19_ = TRUE;
	} else {
		_tmp19_ = _data15_->removed_individuals != NULL;
	}
	if (_tmp19_) {
		g_signal_emit_by_name (self, "individuals-changed", added_individuals, _data15_->removed_individuals, NULL, NULL, 0);
	}
	g_debug ("individual-aggregator.vala:651: Replacing Individuals due to linking:");
	_tmp20_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) replaced_individuals);
	iter = _tmp20_;
	while (TRUE) {
		gboolean _tmp21_;
		gpointer _tmp22_ = NULL;
		FolksIndividual* _tmp23_;
		gpointer _tmp24_ = NULL;
		FolksIndividual* _tmp25_;
		_tmp21_ = gee_map_iterator_next (iter);
		if (!(_tmp21_ == TRUE)) {
			break;
		}
		_tmp22_ = gee_map_iterator_get_key (iter);
		_tmp23_ = (FolksIndividual*) _tmp22_;
		_tmp24_ = gee_map_iterator_get_value (iter);
		_tmp25_ = (FolksIndividual*) _tmp24_;
		folks_individual_replace (_tmp23_, _tmp25_);
		_g_object_unref0 (_tmp25_);
		_g_object_unref0 (_tmp23_);
	}
	_g_object_unref0 (iter);
	_g_object_unref0 (user);
	__g_list_free__g_object_unref0_0 (relinked_personas);
	_g_object_unref0 (replaced_individuals);
	__g_list_free__g_object_unref0_0 (added_individuals);
	block15_data_unref (_data15_);
}


static void folks_individual_aggregator_is_writeable_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec) {
	FolksPersonaStore* store;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	store = FOLKS_PERSONA_STORE (object);
	_tmp2_ = folks_persona_store_get_is_writeable (store);
	if (_tmp2_ == TRUE) {
		_tmp1_ = store == self->priv->writeable_store;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		_tmp4_ = folks_persona_store_get_is_writeable (store);
		if (_tmp4_ == FALSE) {
			_tmp3_ = store != self->priv->writeable_store;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp0_ = _tmp3_;
	}
	g_assert (_tmp0_);
}


static void folks_individual_aggregator_trust_level_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec) {
	FolksPersonaStore* store;
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	store = FOLKS_PERSONA_STORE (object);
	_tmp0_ = folks_persona_store_get_type_id (store);
	if (g_strcmp0 (_tmp0_, "key-file") == 0) {
		FolksPersonaStoreTrust _tmp1_;
		_tmp1_ = folks_persona_store_get_trust_level (store);
		g_assert (_tmp1_ == FOLKS_PERSONA_STORE_TRUST_FULL);
	} else {
		FolksPersonaStoreTrust _tmp2_;
		_tmp2_ = folks_persona_store_get_trust_level (store);
		g_assert (_tmp2_ != FOLKS_PERSONA_STORE_TRUST_FULL);
	}
}


static void folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self, FolksIndividual* i, FolksIndividual* replacement) {
	const gchar* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GList* i_list;
	FolksIndividual* _tmp2_;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	_tmp0_ = folks_individual_get_id (i);
	_tmp1_ = g_hash_table_lookup (self->priv->_individuals, _tmp0_);
	if (((FolksIndividual*) _tmp1_) == NULL) {
		return;
	}
	if (self->priv->_user == i) {
		folks_individual_aggregator_set_user (self, NULL);
	}
	i_list = NULL;
	_tmp2_ = _g_object_ref0 (i);
	i_list = g_list_append (i_list, _tmp2_);
	if (replacement != NULL) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = folks_individual_get_id (i);
		_tmp4_ = folks_individual_get_id (replacement);
		g_debug ("individual-aggregator.vala:694: Individual '%s' removed (replaced by '" \
"%s')", _tmp3_, _tmp4_);
	} else {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = folks_individual_get_id (i);
		g_debug ("individual-aggregator.vala:699: Individual '%s' removed (not replaced)", _tmp5_);
	}
	g_signal_emit_by_name (self, "individuals-changed", NULL, i_list, NULL, NULL, 0);
	_tmp6_ = folks_individual_get_id (i);
	g_hash_table_remove (self->priv->_individuals, _tmp6_);
	__g_list_free__g_object_unref0_0 (i_list);
}


static void folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* data;
	data = _data;
	_g_object_unref0 (data->parent);
	_g_free0 (data->persona_store_type);
	_g_free0 (data->persona_store_id);
	_g_hash_table_unref0 (data->details);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorAddPersonaFromDetailsData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void folks_individual_aggregator_add_persona_from_details (FolksIndividualAggregator* self, FolksIndividual* parent, const gchar* persona_store_type, const gchar* persona_store_id, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_add_persona_from_details_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->parent = _g_object_ref0 (parent);
	_data_->persona_store_type = g_strdup (persona_store_type);
	_data_->persona_store_id = g_strdup (persona_store_id);
	_data_->details = _g_hash_table_ref0 (details);
	folks_individual_aggregator_add_persona_from_details_co (_data_);
}


FolksPersona* folks_individual_aggregator_add_persona_from_details_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_add_persona_from_details_co (data);
}


/**
   * Add a new persona in the given {@link PersonaStore} based on the `details`
   * provided.
   *
   * If the target store is offline, this function will throw
   * {@link IndividualAggregatorError.STORE_OFFLINE}. It's the responsibility of
   * the caller to cache details and re-try this function if it wishes to make
   * offline adds work.
   *
   * The details hash is a backend-specific mapping of key, value strings.
   * Common keys include:
   *
   *  * contact - service-specific contact ID
   *
   * If a {@link Persona} with the given details already exists in the store, no
   * error will be thrown and this function will return `null`.
   *
   * @param parent an optional {@link Individual} to add the new {@link Persona}
   * to. This persona will be appended to its ordered list of personas.
   * @param persona_store_type the {@link PersonaStore.type_id} of the
   * {@link PersonaStore} to use
   * @param persona_store_id the {@link PersonaStore.id} of the
   * {@link PersonaStore} to use
   * @param details a key-value map of details to use in creating the new
   * {@link Persona}
   * @return the new {@link Persona} or `null` if the corresponding
   * {@link Persona} already existed. If non-`null`, the new {@link Persona}
   * will also be added to a new or existing {@link Individual} as necessary.
   */
static gboolean folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_individual_aggregator_get_store_full_id (data->self, data->persona_store_type, data->persona_store_id);
	data->full_id = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) data->self->priv->stores, data->full_id);
	data->store = (FolksPersonaStore*) data->_tmp1_;
	if (data->store == NULL) {
		data->_tmp2_ = NULL;
		data->_tmp2_ = _ ("No store known for type ID '%s' and ID '%s'.");
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_NOT_FOUND, data->_tmp2_, data->persona_store_type, data->persona_store_id);
		data->_inner_error_ = data->_tmp3_;
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->store);
			_g_free0 (data->full_id);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->store);
			_g_free0 (data->full_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->persona = NULL;
	data->_tmp4_ = NULL;
	data->_tmp4_ = folks_individual_aggregator_asv_copy (data->self, data->details);
	data->details_copy = data->_tmp4_;
	data->_state_ = 1;
	folks_persona_store_add_persona_from_details (data->store, data->details_copy, folks_individual_aggregator_add_persona_from_details_ready, data);
	return FALSE;
	_state_1:
	data->_tmp5_ = NULL;
	data->_tmp5_ = folks_persona_store_add_persona_from_details_finish (data->store, data->_res_, &data->_inner_error_);
	data->_tmp6_ = data->_tmp5_;
	if (data->_inner_error_ != NULL) {
		_g_hash_table_unref0 (data->details_copy);
		if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			goto __catch10_folks_persona_store_error;
		}
		_g_hash_table_unref0 (data->details_copy);
		_g_object_unref0 (data->persona);
		_g_object_unref0 (data->store);
		_g_free0 (data->full_id);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp7_ = data->_tmp6_;
	_g_object_unref0 (data->persona);
	data->persona = data->_tmp7_;
	_g_hash_table_unref0 (data->details_copy);
	goto __finally10;
	__catch10_folks_persona_store_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		if (g_error_matches (data->e, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
			data->_tmp8_ = NULL;
			data->_tmp8_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE, data->e->message);
			data->_inner_error_ = data->_tmp8_;
			_g_error_free0 (data->e);
			_g_object_unref0 (data->persona);
			_g_object_unref0 (data->store);
			_g_free0 (data->full_id);
			goto __finally10;
		} else {
			data->_tmp9_ = NULL;
			data->_tmp9_ = _ ("Failed to add contact for store type '%s', ID '%s': %s");
			data->_tmp10_ = NULL;
			data->_tmp10_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED, data->_tmp9_, data->persona_store_type, data->persona_store_id, data->e->message);
			data->_inner_error_ = data->_tmp10_;
			_g_error_free0 (data->e);
			_g_object_unref0 (data->persona);
			_g_object_unref0 (data->store);
			_g_free0 (data->full_id);
			goto __finally10;
		}
		_g_error_free0 (data->e);
	}
	__finally10:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->persona);
			_g_object_unref0 (data->store);
			_g_free0 (data->full_id);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->persona);
			_g_object_unref0 (data->store);
			_g_free0 (data->full_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->parent != NULL) {
		data->_tmp11_ = data->persona != NULL;
	} else {
		data->_tmp11_ = FALSE;
	}
	if (data->_tmp11_) {
		data->_tmp12_ = NULL;
		data->_tmp12_ = folks_individual_get_personas (data->parent);
		data->_tmp13_ = NULL;
		data->_tmp13_ = g_list_copy (data->_tmp12_);
		data->personas = data->_tmp13_;
		data->personas = g_list_append (data->personas, data->persona);
		folks_individual_set_personas (data->parent, data->personas);
		_g_list_free0 (data->personas);
	}
	data->result = data->persona;
	_g_object_unref0 (data->store);
	_g_free0 (data->full_id);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->persona);
	_g_object_unref0 (data->store);
	_g_free0 (data->full_id);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (Block16Data* _data16_) {
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		_g_object_unref0 (_data16_->self);
		_g_hash_table_unref0 (_data16_->retval);
		g_slice_free (Block16Data, _data16_);
	}
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _lambda28_ (const gchar* k, GValue* v, Block16Data* _data16_) {
	FolksIndividualAggregator * self;
	gchar* _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue* _tmp2_;
	self = _data16_->self;
	g_return_if_fail (k != NULL);
	_tmp0_ = g_strdup ((const gchar*) k);
	_tmp2_ = __g_value_dup0 ((G_VALUE_HOLDS (v, G_TYPE_VALUE) && g_value_get_boxed (v)) ? (*((GValue**) g_value_get_boxed (v))) : (g_warning ("Invalid GValue unboxing (wrong type or NULL)"), _tmp1_));
	g_hash_table_insert (_data16_->retval, _tmp0_, _tmp2_);
}


static void __lambda28__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda28_ (key, value, self);
}


static GHashTable* folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self, GHashTable* asv) {
	GHashTable* result = NULL;
	Block16Data* _data16_;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (asv != NULL, NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	_data16_->retval = _tmp0_;
	g_hash_table_foreach (asv, __lambda28__gh_func, _data16_);
	_tmp1_ = _g_hash_table_ref0 (_data16_->retval);
	result = _tmp1_;
	block16_data_unref (_data16_);
	return result;
}


static void folks_individual_aggregator_remove_individual_data_free (gpointer _data) {
	FolksIndividualAggregatorRemoveIndividualData* data;
	data = _data;
	_g_object_unref0 (data->individual);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorRemoveIndividualData, data);
}


void folks_individual_aggregator_remove_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemoveIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_remove_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_remove_individual_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->individual = _g_object_ref0 (individual);
	folks_individual_aggregator_remove_individual_co (_data_);
}


void folks_individual_aggregator_remove_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_individual_aggregator_remove_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorRemoveIndividualData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_remove_individual_co (data);
}


/**
   * Completely remove the individual and all of its personas from their
   * backing stores.
   *
   * @param individual the {@link Individual} to remove
   * @since 0.1.11
   */
static gboolean folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_tmp0_ = NULL;
		data->_tmp0_ = folks_individual_get_personas (data->individual);
		data->i = data->_tmp0_;
		data->_tmp1_ = TRUE;
		while (TRUE) {
			if (!data->_tmp1_) {
				data->i = data->i->next;
			}
			data->_tmp1_ = FALSE;
			if (!(data->i != NULL)) {
				break;
			}
			data->persona = FOLKS_PERSONA ((FolksPersona*) data->i->data);
			data->_tmp2_ = NULL;
			data->_tmp2_ = folks_persona_get_store (data->persona);
			data->_state_ = 1;
			folks_persona_store_remove_persona (data->_tmp2_, data->persona, folks_individual_aggregator_remove_individual_ready, data);
			return FALSE;
			_state_1:
			folks_persona_store_remove_persona_finish (data->_tmp2_, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_remove_persona_data_free (gpointer _data) {
	FolksIndividualAggregatorRemovePersonaData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorRemovePersonaData, data);
}


void folks_individual_aggregator_remove_persona (FolksIndividualAggregator* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_remove_persona_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->persona = _g_object_ref0 (persona);
	folks_individual_aggregator_remove_persona_co (_data_);
}


void folks_individual_aggregator_remove_persona_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_individual_aggregator_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorRemovePersonaData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_remove_persona_co (data);
}


/**
   * Completely remove the persona from its backing store.
   *
   * This will leave other personas in the same individual alone.
   *
   * @param persona the {@link Persona} to remove
   * @since 0.1.11
   */
static gboolean folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_persona_get_store (data->persona);
	data->_state_ = 1;
	folks_persona_store_remove_persona (data->_tmp0_, data->persona, folks_individual_aggregator_remove_persona_ready, data);
	return FALSE;
	_state_1:
	folks_persona_store_remove_persona_finish (data->_tmp0_, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_link_personas_data_free (gpointer _data) {
	FolksIndividualAggregatorLinkPersonasData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorLinkPersonasData, data);
}


void folks_individual_aggregator_link_personas (FolksIndividualAggregator* self, void* _personas, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorLinkPersonasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_link_personas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_link_personas_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->_personas = _personas;
	folks_individual_aggregator_link_personas_co (_data_);
}


void folks_individual_aggregator_link_personas_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_individual_aggregator_link_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorLinkPersonasData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_link_personas_co (data);
}


/**
   * Link the given {@link Persona}s together.
   *
   * Create links between the given {@link Persona}s so that they form a single
   * {@link Individual}. The new {@link Individual} will be returned via the
   * {@link IndividualAggregator.individuals_changed} signal.
   *
   * Removal of the {@link Individual}s which the {@link Persona}s were in
   * before is signalled by {@link IndividualAggregator.individuals_changed} and
   * {@link Individual.removed}.
   *
   * @param _personas the {@link Persona}s to be linked
   * @since 0.1.13
   */
static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (Block17Data* _data17_) {
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		_g_object_unref0 (_data17_->self);
		_g_hash_table_unref0 (_data17_->protocols_addrs_set);
		_g_hash_table_unref0 (_data17_->protocols_addrs_list);
		g_slice_free (Block17Data, _data17_);
	}
}


static void _g_ptr_array_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}


static void block18_data_unref (Block18Data* _data18_) {
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		block17_data_unref (_data18_->_data17_);
		_g_object_unref0 (_data18_->address_set);
		_g_ptr_array_unref0 (_data18_->address_list);
		g_slice_free (Block18Data, _data18_);
	}
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static void _lambda30_ (const gchar* a, Block18Data* _data18_) {
	Block17Data* _data17_;
	FolksIndividualAggregator * self;
	const gchar* address;
	gboolean _tmp0_;
	_data17_ = _data18_->_data17_;
	self = _data17_->self;
	g_return_if_fail (a != NULL);
	address = (const gchar*) a;
	_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data18_->address_set, address);
	if (!_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (address);
		g_ptr_array_add (_data18_->address_list, _tmp1_);
		gee_abstract_collection_add ((GeeAbstractCollection*) _data18_->address_set, address);
	}
}


static void __lambda30__gfunc (gconstpointer data, gpointer self) {
	_lambda30_ (data, self);
}


static void _lambda29_ (const gchar* k, GPtrArray* v, Block17Data* _data17_) {
	FolksIndividualAggregator * self;
	Block18Data* _data18_;
	const gchar* protocol;
	GPtrArray* addresses;
	gconstpointer _tmp0_ = NULL;
	GPtrArray* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	GeeHashSet* _tmp3_;
	gboolean _tmp4_ = FALSE;
	self = _data17_->self;
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->_data17_ = block17_data_ref (_data17_);
	protocol = (const gchar*) k;
	addresses = (GPtrArray*) v;
	_tmp0_ = g_hash_table_lookup (_data17_->protocols_addrs_list, protocol);
	_tmp1_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp0_);
	_data18_->address_list = _tmp1_;
	_tmp2_ = g_hash_table_lookup (_data17_->protocols_addrs_set, protocol);
	_tmp3_ = _g_object_ref0 ((GeeHashSet*) _tmp2_);
	_data18_->address_set = _tmp3_;
	if (_data18_->address_list == NULL) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = _data18_->address_set == NULL;
	}
	if (_tmp4_) {
		GPtrArray* _tmp5_ = NULL;
		GPtrArray* _tmp6_;
		GeeHashSet* _tmp7_ = NULL;
		GeeHashSet* _tmp8_;
		gchar* _tmp9_;
		GPtrArray* _tmp10_;
		gchar* _tmp11_;
		GeeHashSet* _tmp12_;
		_tmp5_ = g_ptr_array_new_with_free_func (_g_free0_);
		_tmp6_ = _tmp5_;
		_g_ptr_array_unref0 (_data18_->address_list);
		_data18_->address_list = _tmp6_;
		_tmp7_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_data18_->address_set);
		_data18_->address_set = _tmp8_;
		_tmp9_ = g_strdup (protocol);
		_tmp10_ = _g_ptr_array_ref0 (_data18_->address_list);
		g_hash_table_insert (_data17_->protocols_addrs_list, _tmp9_, _tmp10_);
		_tmp11_ = g_strdup (protocol);
		_tmp12_ = _g_object_ref0 (_data18_->address_set);
		g_hash_table_insert (_data17_->protocols_addrs_set, _tmp11_, _tmp12_);
	}
	g_ptr_array_foreach (addresses, __lambda30__gfunc, _data18_);
	block18_data_unref (_data18_);
}


static void __lambda29__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda29_ (key, value, self);
}


static gboolean folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data17_ = g_slice_new0 (Block17Data);
	data->_data17_->_ref_count_ = 1;
	data->_data17_->self = g_object_ref (data->self);
	data->_data17_->_async_data_ = data;
	data->personas = (GList*) data->_personas;
	if (data->self->priv->writeable_store == NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = _ ("Can't link personas with no writeable store.");
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE, data->_tmp0_);
		data->_inner_error_ = data->_tmp1_;
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			block17_data_unref (data->_data17_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			block17_data_unref (data->_data17_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->personas->next == NULL) {
		block17_data_unref (data->_data17_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->self->priv->linking_enabled == FALSE) {
		g_debug ("individual-aggregator.vala:862: Can't link Personas: linking disabled.");
		block17_data_unref (data->_data17_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp2_ = NULL;
	data->_tmp2_ = folks_persona_store_get_type_id (data->self->priv->writeable_store);
	g_assert (g_strcmp0 (data->_tmp2_, "key-file") == 0);
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_ptr_array_unref0_);
	data->_data17_->protocols_addrs_list = data->_tmp3_;
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	data->_data17_->protocols_addrs_set = data->_tmp4_;
	{
		data->persona_collection = data->personas;
		for (data->persona_it = data->persona_collection; data->persona_it != NULL; data->persona_it = data->persona_it->next) {
			data->persona = (FolksPersona*) data->persona_it->data;
			{
				if (!FOLKS_IS_IMABLE (data->persona)) {
					continue;
				}
				data->_tmp5_ = NULL;
				data->_tmp5_ = folks_imable_get_im_addresses (FOLKS_IMABLE (data->persona));
				g_hash_table_foreach (data->_tmp5_, __lambda29__gh_func, data->_data17_);
			}
		}
	}
	g_value_init (&data->addresses_value, G_TYPE_HASH_TABLE);
	g_value_set_boxed (&data->addresses_value, data->_data17_->protocols_addrs_list);
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details = data->_tmp6_;
	data->_tmp7_ = g_strdup ("im-addresses");
	data->_tmp8_ = __g_value_dup0 (&data->addresses_value);
	g_hash_table_insert (data->details, data->_tmp7_, data->_tmp8_);
	data->_tmp9_ = NULL;
	data->_tmp9_ = folks_persona_store_get_type_id (data->self->priv->writeable_store);
	data->_tmp10_ = NULL;
	data->_tmp10_ = folks_persona_store_get_id (data->self->priv->writeable_store);
	data->_state_ = 1;
	folks_individual_aggregator_add_persona_from_details (data->self, NULL, data->_tmp9_, data->_tmp10_, data->details, folks_individual_aggregator_link_personas_ready, data);
	return FALSE;
	_state_1:
	data->_tmp11_ = NULL;
	data->_tmp11_ = folks_individual_aggregator_add_persona_from_details_finish (data->self, data->_res_, &data->_inner_error_);
	data->_tmp12_ = data->_tmp11_;
	data->_tmp12_;
	_g_object_unref0 (data->_tmp12_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_hash_table_unref0 (data->details);
			G_IS_VALUE (&data->addresses_value) ? (g_value_unset (&data->addresses_value), NULL) : NULL;
			block17_data_unref (data->_data17_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_hash_table_unref0 (data->details);
			G_IS_VALUE (&data->addresses_value) ? (g_value_unset (&data->addresses_value), NULL) : NULL;
			block17_data_unref (data->_data17_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	_g_hash_table_unref0 (data->details);
	G_IS_VALUE (&data->addresses_value) ? (g_value_unset (&data->addresses_value), NULL) : NULL;
	block17_data_unref (data->_data17_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_unlink_individual_data_free (gpointer _data) {
	FolksIndividualAggregatorUnlinkIndividualData* data;
	data = _data;
	_g_object_unref0 (data->individual);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualAggregatorUnlinkIndividualData, data);
}


void folks_individual_aggregator_unlink_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorUnlinkIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_unlink_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_unlink_individual_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->individual = _g_object_ref0 (individual);
	folks_individual_aggregator_unlink_individual_co (_data_);
}


void folks_individual_aggregator_unlink_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_individual_aggregator_unlink_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorUnlinkIndividualData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_aggregator_unlink_individual_co (data);
}


/**
   * Unlinks the given {@link Individual} into its constituent {@link Persona}s.
   *
   * This completely unlinks the given {@link Individual}, destroying all of
   * its writeable {@link Persona}s.
   *
   * The {@link Individual}'s removal is signalled by
   * {@link IndividualAggregator.individuals_changed} and
   * {@link Individual.removed}.
   *
   * The {@link Persona}s comprising the {@link Individual} will be re-linked
   * into one or more new {@link Individual}s, depending on how much linking
   * data remains (typically only implicit links remain). The addition of these
   * new {@link Individual}s will be signalled by
   * {@link IndividualAggregator.individuals_changed}.
   *
   * @param individual the {@link Individual} to unlink
   * @since 0.1.13
   */
static gboolean folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->self->priv->linking_enabled == FALSE) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = folks_individual_get_id (data->individual);
		g_debug ("individual-aggregator.vala:953: Can't unlink Individual '%s': linking " \
"disabled.", data->_tmp0_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_get_id (data->individual);
	g_debug ("individual-aggregator.vala:961: Unlinking Individual '%s', deleting Pe" \
"rsonas:", data->_tmp1_);
	data->_tmp2_ = NULL;
	data->_tmp2_ = folks_individual_get_personas (data->individual);
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_list_copy (data->_tmp2_);
	data->personas = data->_tmp3_;
	{
		data->p_collection = data->personas;
		for (data->p_it = data->p_collection; data->p_it != NULL; data->p_it = data->p_it->next) {
			data->_tmp4_ = _g_object_ref0 ((FolksPersona*) data->p_it->data);
			data->p = data->_tmp4_;
			{
				g_object_ref ((GObject*) data->p);
				_g_object_unref0 (data->p);
			}
		}
	}
	{
		data->persona_collection = data->personas;
		for (data->persona_it = data->persona_collection; data->persona_it != NULL; data->persona_it = data->persona_it->next) {
			data->persona = (FolksPersona*) data->persona_it->data;
			{
				data->_tmp5_ = NULL;
				data->_tmp5_ = folks_persona_get_store (data->persona);
				if (data->_tmp5_ == data->self->priv->writeable_store) {
					data->_tmp7_ = folks_persona_get_is_user (data->persona);
					if (data->_tmp7_) {
						data->_tmp6_ = "yes";
					} else {
						data->_tmp6_ = "no";
					}
					data->_tmp8_ = NULL;
					data->_tmp8_ = folks_persona_get_uid (data->persona);
					data->_tmp9_ = NULL;
					data->_tmp9_ = folks_persona_get_iid (data->persona);
					g_debug ("individual-aggregator.vala:975:     %s (is user: %s, IID: %s)", data->_tmp8_, data->_tmp6_, data->_tmp9_);
					data->_state_ = 1;
					folks_persona_store_remove_persona (data->self->priv->writeable_store, data->persona, folks_individual_aggregator_unlink_individual_ready, data);
					return FALSE;
					_state_1:
					folks_persona_store_remove_persona_finish (data->self->priv->writeable_store, data->_res_, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
						g_error_free (data->_inner_error_);
						__g_list_free__g_object_unref0_0 (data->personas);
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			}
		}
	}
	__g_list_free__g_object_unref0_0 (data->personas);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


gboolean folks_individual_aggregator_get_is_prepared (FolksIndividualAggregator* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_prepared;
	return result;
}


GHashTable* folks_individual_aggregator_get_individuals (FolksIndividualAggregator* self) {
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_individuals;
	return result;
}


static void folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self, GHashTable* value) {
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_hash_table_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_hash_table_unref0 (self->priv->_individuals);
	self->priv->_individuals = _tmp1_;
	g_object_notify ((GObject *) self, "individuals");
}


FolksIndividual* folks_individual_aggregator_get_user (FolksIndividualAggregator* self) {
	FolksIndividual* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_user;
	return result;
}


static void folks_individual_aggregator_set_user (FolksIndividualAggregator* self, FolksIndividual* value) {
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_user);
	self->priv->_user = _tmp1_;
	g_object_notify ((GObject *) self, "user");
}


static void g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_string (param_values + 3), g_value_get_object (param_values + 4), g_value_get_enum (param_values + 5), data2);
}


static void folks_individual_aggregator_class_init (FolksIndividualAggregatorClass * klass) {
	folks_individual_aggregator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksIndividualAggregatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_individual_aggregator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_individual_aggregator_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_individual_aggregator_finalize;
	/**
	   * Whether {@link IndividualAggregator.prepare} has successfully completed for
	   * this aggregator.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * A table mapping {@link Individual.id}s to their {@link Individual}s.
	   *
	   * This is the canonical set of {@link Individual}s provided by this
	   * IndividualAggregator.
	   *
	   * {@link Individual}s may be added or removed using
	   * {@link IndividualAggregator.add_persona_from_details} and
	   * {@link IndividualAggregator.remove_individual}, respectively.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS, g_param_spec_boxed ("individuals", "individuals", "individuals", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The {@link Individual} representing the user.
	   *
	   * If it exists, this holds the {@link Individual} who is the user — the
	   * {@link Individual} containing the {@link Persona}s who are the owners of
	   * the accounts for their respective backends.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_USER, g_param_spec_object ("user", "user", "user", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Emitted when one or more {@link Individual}s are added to or removed from
	   * the aggregator.
	   *
	   * This will not be emitted until after {@link IndividualAggregator.prepare}
	   * has been called.
	   *
	   * @param added a list of {@link Individual}s which have been removed
	   * @param removed a list of {@link Individual}s which have been removed
	   * @param message a string message from the backend, if any
	   * @param actor the {@link Persona} who made the change, if known
	   * @param reason the reason for the change
	   */
	g_signal_new ("individuals_changed", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM, G_TYPE_NONE, 5, G_TYPE_POINTER, G_TYPE_POINTER, G_TYPE_STRING, FOLKS_TYPE_PERSONA, FOLKS_GROUPABLE_TYPE_CHANGE_REASON);
}


static void folks_individual_aggregator_instance_init (FolksIndividualAggregator * self) {
	self->priv = FOLKS_INDIVIDUAL_AGGREGATOR_GET_PRIVATE (self);
	self->priv->linking_enabled = TRUE;
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
}


static void folks_individual_aggregator_finalize (GObject* obj) {
	FolksIndividualAggregator * self;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (obj);
	_g_object_unref0 (self->priv->backend_store);
	_g_object_unref0 (self->priv->stores);
	_g_object_unref0 (self->priv->backends);
	_g_hash_table_unref0 (self->priv->link_map);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_hash_table_unref0 (self->priv->_individuals);
	_g_object_unref0 (self->priv->_user);
	G_OBJECT_CLASS (folks_individual_aggregator_parent_class)->finalize (obj);
}


/**
 * Stores {@link Individual}s which have been created through
 * aggregation of all the {@link Persona}s provided by the various
 * {@link Backend}s.
 *
 * This is the main interface for client applications.
 */
GType folks_individual_aggregator_get_type (void) {
	static volatile gsize folks_individual_aggregator_type_id__volatile = 0;
	if (g_once_init_enter (&folks_individual_aggregator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksIndividualAggregatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_individual_aggregator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksIndividualAggregator), 0, (GInstanceInitFunc) folks_individual_aggregator_instance_init, NULL };
		GType folks_individual_aggregator_type_id;
		folks_individual_aggregator_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksIndividualAggregator", &g_define_type_info, 0);
		g_once_init_leave (&folks_individual_aggregator_type_id__volatile, folks_individual_aggregator_type_id);
	}
	return folks_individual_aggregator_type_id__volatile;
}


static void _vala_folks_individual_aggregator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksIndividualAggregator * self;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED:
		g_value_set_boolean (value, folks_individual_aggregator_get_is_prepared (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS:
		g_value_set_boxed (value, folks_individual_aggregator_get_individuals (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_USER:
		g_value_set_object (value, folks_individual_aggregator_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_individual_aggregator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksIndividualAggregator * self;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS:
		folks_individual_aggregator_set_individuals (self, g_value_get_boxed (value));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_USER:
		folks_individual_aggregator_set_user (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



