/* command-personas.c generated by valac 0.11.7, the Vala compiler
 * generated from command-personas.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <folks.h>
#include <stdio.h>
#include <readline/readline.h>


#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
typedef struct _FolksInspectCommandPrivate FolksInspectCommandPrivate;

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS (folks_inspect_commands_personas_get_type ())
#define FOLKS_INSPECT_COMMANDS_PERSONAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS, FolksInspectCommandsPersonas))
#define FOLKS_INSPECT_COMMANDS_PERSONAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS, FolksInspectCommandsPersonasClass))
#define FOLKS_INSPECT_COMMANDS_IS_PERSONAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS))
#define FOLKS_INSPECT_COMMANDS_IS_PERSONAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS))
#define FOLKS_INSPECT_COMMANDS_PERSONAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS, FolksInspectCommandsPersonasClass))

typedef struct _FolksInspectCommandsPersonas FolksInspectCommandsPersonas;
typedef struct _FolksInspectCommandsPersonasClass FolksInspectCommandsPersonasClass;
typedef struct _FolksInspectCommandsPersonasPrivate FolksInspectCommandsPersonasPrivate;
typedef struct _Block1Data Block1Data;
#define _folks_inspect_command_unref0(var) ((var == NULL) ? NULL : (var = (folks_inspect_command_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FolksInspectCommand {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectCommandPrivate * priv;
	FolksInspectClient* client;
};

struct _FolksInspectCommandClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectCommand *self);
	void (*run) (FolksInspectCommand* self, const gchar* command_string);
	gchar** (*complete_subcommand) (FolksInspectCommand* self, const gchar* subcommand);
	const gchar* (*get_name) (FolksInspectCommand* self);
	const gchar* (*get_description) (FolksInspectCommand* self);
	const gchar* (*get_help) (FolksInspectCommand* self);
};

struct _FolksInspectCommandsPersonas {
	FolksInspectCommand parent_instance;
	FolksInspectCommandsPersonasPrivate * priv;
};

struct _FolksInspectCommandsPersonasClass {
	FolksInspectCommandClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	FolksInspectCommandsPersonas * self;
	gchar* command_string;
};


static gpointer folks_inspect_commands_personas_parent_class = NULL;

gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
GType folks_inspect_commands_personas_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_COMMANDS_PERSONAS_DUMMY_PROPERTY
};
FolksInspectCommandsPersonas* folks_inspect_commands_personas_new (FolksInspectClient* client);
FolksInspectCommandsPersonas* folks_inspect_commands_personas_construct (GType object_type, FolksInspectClient* client);
FolksInspectCommand* folks_inspect_command_construct (GType object_type, FolksInspectClient* client);
static void folks_inspect_commands_personas_real_run (FolksInspectCommand* base, const gchar* command_string);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
static void _lambda6_ (const gchar* k, FolksIndividual* v, Block1Data* _data1_);
void folks_inspect_utils_print_persona (FolksPersona* persona);
void folks_inspect_utils_print_line (const gchar* format, ...);
static void __lambda6__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static gchar** folks_inspect_commands_personas_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1);
gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state);
static gchar* _folks_inspect_utils_persona_uid_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gint _vala_array_length (gpointer array);


FolksInspectCommandsPersonas* folks_inspect_commands_personas_construct (GType object_type, FolksInspectClient* client) {
	FolksInspectCommandsPersonas* self = NULL;
	g_return_val_if_fail (client != NULL, NULL);
	self = (FolksInspectCommandsPersonas*) folks_inspect_command_construct (object_type, client);
	return self;
}


FolksInspectCommandsPersonas* folks_inspect_commands_personas_new (FolksInspectClient* client) {
	return folks_inspect_commands_personas_construct (FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS, client);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_folks_inspect_command_unref0 (_data1_->self);
		_g_free0 (_data1_->command_string);
		g_slice_free (Block1Data, _data1_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda6_ (const gchar* k, FolksIndividual* v, Block1Data* _data1_) {
	FolksInspectCommandsPersonas * self;
	FolksIndividual* _tmp0_;
	FolksIndividual* individual;
	GList* _tmp1_ = NULL;
	self = _data1_->self;
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_INDIVIDUAL (v));
	individual = _tmp0_;
	_tmp1_ = folks_individual_get_personas (individual);
	{
		GList* persona_collection;
		GList* persona_it;
		persona_collection = _tmp1_;
		for (persona_it = persona_collection; persona_it != NULL; persona_it = persona_it->next) {
			FolksPersona* _tmp2_;
			FolksPersona* persona;
			_tmp2_ = _g_object_ref0 ((FolksPersona*) persona_it->data);
			persona = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				if (_data1_->command_string != NULL) {
					const gchar* _tmp4_ = NULL;
					_tmp4_ = folks_persona_get_uid (persona);
					_tmp3_ = g_strcmp0 (_tmp4_, _data1_->command_string) != 0;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					_g_object_unref0 (persona);
					continue;
				}
				folks_inspect_utils_print_persona (persona);
				if (_data1_->command_string == NULL) {
					folks_inspect_utils_print_line ("");
				}
				_g_object_unref0 (persona);
			}
		}
	}
	_g_object_unref0 (individual);
}


static void __lambda6__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda6_ (key, value, self);
}


static void folks_inspect_commands_personas_real_run (FolksInspectCommand* base, const gchar* command_string) {
	FolksInspectCommandsPersonas * self;
	Block1Data* _data1_;
	FolksIndividualAggregator* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	self = (FolksInspectCommandsPersonas*) base;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = folks_inspect_command_ref (self);
	_data1_->command_string = g_strdup (command_string);
	_tmp0_ = folks_inspect_client_get_aggregator (((FolksInspectCommand*) self)->client);
	_tmp1_ = folks_individual_aggregator_get_individuals (_tmp0_);
	g_hash_table_foreach (_tmp1_, __lambda6__gh_func, _data1_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static gchar* _folks_inspect_utils_persona_uid_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_utils_persona_uid_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar** folks_inspect_commands_personas_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1) {
	FolksInspectCommandsPersonas * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	self = (FolksInspectCommandsPersonas*) base;
	g_return_val_if_fail (subcommand != NULL, NULL);
	_tmp1_ = _tmp0_ = rl_completion_matches (subcommand, _folks_inspect_utils_persona_uid_completion_cb_rl_compentry_func_t);
	_tmp2_ = (_tmp3_ = _tmp1_, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup5 (_tmp3_, _vala_array_length (_tmp0_)));
	_tmp4_ = _tmp2_;
	*result_length1 = _vala_array_length (_tmp0_);
	result = _tmp4_;
	return result;
}


static const gchar* folks_inspect_commands_personas_real_get_name (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsPersonas* self;
	self = (FolksInspectCommandsPersonas*) base;
	result = "personas";
	return result;
}


static const gchar* folks_inspect_commands_personas_real_get_description (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsPersonas* self;
	self = (FolksInspectCommandsPersonas*) base;
	result = "Inspect the personas currently present in the aggregator";
	return result;
}


static const gchar* folks_inspect_commands_personas_real_get_help (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsPersonas* self;
	self = (FolksInspectCommandsPersonas*) base;
	result = "personas                  List all known personas.\n" "personas [persona UID]    Display the details of the " "specified persona.";
	return result;
}


static void folks_inspect_commands_personas_class_init (FolksInspectCommandsPersonasClass * klass) {
	folks_inspect_commands_personas_parent_class = g_type_class_peek_parent (klass);
	FOLKS_INSPECT_COMMAND_CLASS (klass)->run = folks_inspect_commands_personas_real_run;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->complete_subcommand = folks_inspect_commands_personas_real_complete_subcommand;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_name = folks_inspect_commands_personas_real_get_name;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_description = folks_inspect_commands_personas_real_get_description;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_help = folks_inspect_commands_personas_real_get_help;
}


static void folks_inspect_commands_personas_instance_init (FolksInspectCommandsPersonas * self) {
}


GType folks_inspect_commands_personas_get_type (void) {
	static volatile gsize folks_inspect_commands_personas_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_commands_personas_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectCommandsPersonasClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_commands_personas_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectCommandsPersonas), 0, (GInstanceInitFunc) folks_inspect_commands_personas_instance_init, NULL };
		GType folks_inspect_commands_personas_type_id;
		folks_inspect_commands_personas_type_id = g_type_register_static (FOLKS_INSPECT_TYPE_COMMAND, "FolksInspectCommandsPersonas", &g_define_type_info, 0);
		g_once_init_leave (&folks_inspect_commands_personas_type_id__volatile, folks_inspect_commands_personas_type_id);
	}
	return folks_inspect_commands_personas_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



