/* link-personas.c generated by valac 0.12.0, the Vala compiler
 * generated from link-personas.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gconf/gconf-client.h>
#include <gconf/gconf.h>
#include <gio/gio.h>


#define TYPE_LINK_PERSONAS_TESTS (link_personas_tests_get_type ())
#define LINK_PERSONAS_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_PERSONAS_TESTS, LinkPersonasTests))
#define LINK_PERSONAS_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINK_PERSONAS_TESTS, LinkPersonasTestsClass))
#define IS_LINK_PERSONAS_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_PERSONAS_TESTS))
#define IS_LINK_PERSONAS_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINK_PERSONAS_TESTS))
#define LINK_PERSONAS_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINK_PERSONAS_TESTS, LinkPersonasTestsClass))

typedef struct _LinkPersonasTests LinkPersonasTests;
typedef struct _LinkPersonasTestsClass LinkPersonasTestsClass;
typedef struct _LinkPersonasTestsPrivate LinkPersonasTestsPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gconf_value_free0(var) ((var == NULL) ? NULL : (var = (gconf_value_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _LinkPersonasTestsTestLinkingPersonasAsyncData LinkPersonasTestsTestLinkingPersonasAsyncData;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _LinkPersonasTestsAddPersonasData LinkPersonasTestsAddPersonasData;

struct _LinkPersonasTests {
	FolksTestCase parent_instance;
	LinkPersonasTestsPrivate * priv;
};

struct _LinkPersonasTestsClass {
	FolksTestCaseClass parent_class;
};

struct _LinkPersonasTestsPrivate {
	GMainLoop* _main_loop;
	TrackerTestBackend* _tracker_backend;
	FolksIndividualAggregator* _aggregator;
	gchar* _persona_fullname_1;
	gchar* _persona_fullname_2;
	gchar* _proto;
	gchar* _im_address_1;
	gchar* _im_address_2;
	gboolean _linking_fired;
	gboolean _persona_found_1;
	gboolean _persona_found_2;
	gchar* _persona_iid_1;
	gchar* _persona_iid_2;
	GeeHashSet* _personas;
	gint _removed_individuals;
	gchar* _folks_config_key;
	GConfClient* _gconf_client;
	GeeHashMap* _linking_props;
};

struct _LinkPersonasTestsTestLinkingPersonasAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	LinkPersonasTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	FolksPersonaStore* pstore;
	GeeMap* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _backend_it;
	gboolean _tmp7_;
	gpointer _tmp8_;
	FolksBackend* backend;
	GeeMap* _tmp9_;
	gpointer _tmp10_;
	GError * e;
	GError * _inner_error_;
};

struct _LinkPersonasTestsAddPersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	LinkPersonasTests* self;
	FolksPersonaStore* pstore;
	GHashTable* _tmp0_;
	GHashTable* details1;
	GValue _tmp1_;
	GValue _tmp2_;
	GValue _tmp3_;
	GValue* _tmp4_;
	GValue* _tmp5_;
	GValue* v1;
	GeeHashMultiMap* _tmp6_;
	GeeHashMultiMap* im_addrs1;
	gchar* _tmp7_;
	GValue* _tmp8_;
	GValue _tmp9_;
	GValue _tmp10_;
	GValue _tmp11_;
	GValue* _tmp12_;
	GValue* _tmp13_;
	GValue* v2;
	gchar* _tmp14_;
	GValue* _tmp15_;
	GHashTable* _tmp16_;
	GHashTable* details2;
	GValue _tmp17_;
	GValue _tmp18_;
	GValue _tmp19_;
	GValue* _tmp20_;
	GValue* _tmp21_;
	GValue* v3;
	GeeHashMultiMap* _tmp22_;
	GeeHashMultiMap* im_addrs2;
	gchar* _tmp23_;
	GValue* _tmp24_;
	GValue _tmp25_;
	GValue _tmp26_;
	GValue _tmp27_;
	GValue* _tmp28_;
	GValue* _tmp29_;
	GValue* v4;
	gchar* _tmp30_;
	GValue* _tmp31_;
	FolksPersona* _tmp32_;
	FolksPersona* _tmp33_;
	FolksPersona* _tmp34_;
	FolksPersona* _tmp35_;
	GError * e;
	GError * _inner_error_;
};


static gpointer link_personas_tests_parent_class = NULL;

GType link_personas_tests_get_type (void) G_GNUC_CONST;
#define LINK_PERSONAS_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LINK_PERSONAS_TESTS, LinkPersonasTestsPrivate))
enum  {
	LINK_PERSONAS_TESTS_DUMMY_PROPERTY
};
LinkPersonasTests* link_personas_tests_new (void);
LinkPersonasTests* link_personas_tests_construct (GType object_type);
void link_personas_tests_test_linking_personas (LinkPersonasTests* self);
static void _link_personas_tests_test_linking_personas_folks_test_case_test_method (gpointer self);
static void link_personas_tests_real_set_up (FolksTestCase* base);
static void link_personas_tests_real_tear_down (FolksTestCase* base);
static void _link_personas_tests_test_linking_personas_async (LinkPersonasTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _link_personas_tests_test_linking_personas_finish (LinkPersonasTests* self, GAsyncResult* _res_);
static gboolean _lambda1_ (LinkPersonasTests* self);
static gboolean __lambda1__gsource_func (gpointer self);
static void _link_personas_tests_test_linking_personas_async_data_free (gpointer _data);
static gboolean _link_personas_tests_test_linking_personas_async_co (LinkPersonasTestsTestLinkingPersonasAsyncData* data);
static void _link_personas_tests_test_linking_personas_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _link_personas_tests_individuals_changed_cb (LinkPersonasTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __link_personas_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _link_personas_tests_add_personas (LinkPersonasTests* self, FolksPersonaStore* pstore, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _link_personas_tests_add_personas_finish (LinkPersonasTests* self, GAsyncResult* _res_);
static void _link_personas_tests_add_personas_data_free (gpointer _data);
static gboolean _link_personas_tests_add_personas_co (LinkPersonasTestsAddPersonasData* data);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void _link_personas_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _link_personas_tests_check_personas (LinkPersonasTests* self, FolksIndividual* i);
static void _link_personas_tests_notify_cb (LinkPersonasTests* self, GObject* individual_obj, GParamSpec* ps);
static void __link_personas_tests_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _lambda0_ (LinkPersonasTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void link_personas_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _link_personas_tests_test_linking_personas_folks_test_case_test_method (gpointer self) {
	link_personas_tests_test_linking_personas (self);
}


LinkPersonasTests* link_personas_tests_construct (GType object_type) {
	LinkPersonasTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (LinkPersonasTests*) folks_test_case_construct (object_type, "LinkPersonasTests");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	folks_test_case_add_test ((FolksTestCase*) self, "test linking personas", _link_personas_tests_test_linking_personas_folks_test_case_test_method, self);
	return self;
}


LinkPersonasTests* link_personas_tests_new (void) {
	return link_personas_tests_construct (TYPE_LINK_PERSONAS_TESTS);
}


static void link_personas_tests_real_set_up (FolksTestCase* base) {
	LinkPersonasTests * self;
	GConfClient* _tmp0_ = NULL;
	GConfValue* _tmp1_ = NULL;
	GConfValue* val;
	GError * _inner_error_ = NULL;
	self = (LinkPersonasTests*) base;
	_tmp0_ = gconf_client_get_default ();
	self->priv->_gconf_client = _tmp0_;
	_tmp1_ = gconf_value_new (GCONF_VALUE_STRING);
	val = _tmp1_;
	gconf_value_set_string (val, "tracker");
	gconf_client_set (self->priv->_gconf_client, self->priv->_folks_config_key, val, &_inner_error_);
	if (_inner_error_ != NULL) {
		_gconf_value_free0 (val);
		goto __catch0_g_error;
	}
	_gconf_value_free0 (val);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("link-personas.vala:70: Couldn't set primary store: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tracker_test_backend_set_up (self->priv->_tracker_backend);
}


static void link_personas_tests_real_tear_down (FolksTestCase* base) {
	LinkPersonasTests * self;
	GError * _inner_error_ = NULL;
	self = (LinkPersonasTests*) base;
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
	gconf_client_unset (self->priv->_gconf_client, self->priv->_folks_config_key, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("link-personas.vala:92: Couldn't unset primary store: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean _lambda1_ (LinkPersonasTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


void link_personas_tests_test_linking_personas (LinkPersonasTests* self) {
	GMainLoop* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeHashSet* _tmp3_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	_tmp1_ = g_strdup ("persona #1");
	_g_free0 (self->priv->_persona_fullname_1);
	self->priv->_persona_fullname_1 = _tmp1_;
	_tmp2_ = g_strdup ("persona #2");
	_g_free0 (self->priv->_persona_fullname_2);
	self->priv->_persona_fullname_2 = _tmp2_;
	_tmp3_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp3_;
	self->priv->_persona_found_1 = FALSE;
	self->priv->_persona_found_2 = FALSE;
	self->priv->_linking_fired = FALSE;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_linking_props);
	self->priv->_linking_props = _tmp4_;
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->_linking_props, "prop1", self->priv->_im_address_1);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->_linking_props, "prop2", self->priv->_im_address_2);
	_link_personas_tests_test_linking_personas_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda1__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	_tmp5_ = gee_map_get_size ((GeeMap*) self->priv->_linking_props);
	g_assert (_tmp5_ == 0);
	g_assert (self->priv->_removed_individuals == 2);
}


static void _link_personas_tests_test_linking_personas_async_data_free (gpointer _data) {
	LinkPersonasTestsTestLinkingPersonasAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (LinkPersonasTestsTestLinkingPersonasAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _link_personas_tests_test_linking_personas_async (LinkPersonasTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LinkPersonasTestsTestLinkingPersonasAsyncData* _data_;
	_data_ = g_slice_new0 (LinkPersonasTestsTestLinkingPersonasAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _link_personas_tests_test_linking_personas_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _link_personas_tests_test_linking_personas_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_link_personas_tests_test_linking_personas_async_co (_data_);
}


static void _link_personas_tests_test_linking_personas_finish (LinkPersonasTests* self, GAsyncResult* _res_) {
	LinkPersonasTestsTestLinkingPersonasAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _link_personas_tests_test_linking_personas_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LinkPersonasTestsTestLinkingPersonasAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_link_personas_tests_test_linking_personas_async_co (data);
}


static void __link_personas_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_link_personas_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static gboolean _link_personas_tests_test_linking_personas_async_co (LinkPersonasTestsTestLinkingPersonasAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, _link_personas_tests_test_linking_personas_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_aggregator_new ();
	_g_object_unref0 (data->self->priv->_aggregator);
	data->self->priv->_aggregator = data->_tmp1_;
	g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __link_personas_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, _link_personas_tests_test_linking_personas_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	data->pstore = NULL;
	{
		data->_tmp2_ = NULL;
		data->_tmp2_ = folks_backend_store_get_enabled_backends (data->store);
		data->_tmp3_ = NULL;
		data->_tmp3_ = gee_map_get_values (data->_tmp2_);
		data->_tmp4_ = data->_tmp3_;
		data->_tmp5_ = NULL;
		data->_tmp5_ = gee_iterable_iterator ((GeeIterable*) data->_tmp4_);
		data->_tmp6_ = data->_tmp5_;
		_g_object_unref0 (data->_tmp4_);
		data->_backend_it = data->_tmp6_;
		while (TRUE) {
			data->_tmp7_ = gee_iterator_next (data->_backend_it);
			if (!data->_tmp7_) {
				break;
			}
			data->_tmp8_ = NULL;
			data->_tmp8_ = gee_iterator_get (data->_backend_it);
			data->backend = (FolksBackend*) data->_tmp8_;
			data->_tmp9_ = NULL;
			data->_tmp9_ = folks_backend_get_persona_stores (data->backend);
			data->_tmp10_ = NULL;
			data->_tmp10_ = gee_map_get (data->_tmp9_, "tracker");
			_g_object_unref0 (data->pstore);
			data->pstore = (FolksPersonaStore*) data->_tmp10_;
			if (data->pstore != NULL) {
				_g_object_unref0 (data->backend);
				break;
			}
			_g_object_unref0 (data->backend);
		}
		_g_object_unref0 (data->_backend_it);
	}
	g_assert (data->pstore != NULL);
	data->_state_ = 3;
	_link_personas_tests_add_personas (data->self, data->pstore, _link_personas_tests_test_linking_personas_async_ready, data);
	return FALSE;
	_state_3:
	_link_personas_tests_add_personas_finish (data->self, data->_res_);
	_g_object_unref0 (data->pstore);
	goto __finally2;
	__catch2_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("link-personas.vala:154: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally2:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _link_personas_tests_add_personas_data_free (gpointer _data) {
	LinkPersonasTestsAddPersonasData* data;
	data = _data;
	_g_object_unref0 (data->pstore);
	_g_object_unref0 (data->self);
	g_slice_free (LinkPersonasTestsAddPersonasData, data);
}


static void _link_personas_tests_add_personas (LinkPersonasTests* self, FolksPersonaStore* pstore, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LinkPersonasTestsAddPersonasData* _data_;
	_data_ = g_slice_new0 (LinkPersonasTestsAddPersonasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _link_personas_tests_add_personas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _link_personas_tests_add_personas_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->pstore = _g_object_ref0 (pstore);
	_link_personas_tests_add_personas_co (_data_);
}


static void _link_personas_tests_add_personas_finish (LinkPersonasTests* self, GAsyncResult* _res_) {
	LinkPersonasTestsAddPersonasData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _link_personas_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LinkPersonasTestsAddPersonasData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_link_personas_tests_add_personas_co (data);
}


static gboolean _link_personas_tests_add_personas_co (LinkPersonasTestsAddPersonasData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details1 = data->_tmp0_;
	memset (&data->_tmp1_, 0, sizeof (GValue));
	g_value_init (&data->_tmp1_, GEE_TYPE_MULTI_MAP);
	memset (&data->_tmp2_, 0, sizeof (GValue));
	data->_tmp2_ = data->_tmp1_;
	data->_tmp3_ = data->_tmp2_;
	data->_tmp4_ = __g_value_dup0 (&data->_tmp3_);
	data->_tmp5_ = data->_tmp4_;
	G_IS_VALUE (&data->_tmp3_) ? (g_value_unset (&data->_tmp3_), NULL) : NULL;
	data->v1 = data->_tmp5_;
	data->_tmp6_ = NULL;
	data->_tmp6_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	data->im_addrs1 = data->_tmp6_;
	gee_multi_map_set ((GeeMultiMap*) data->im_addrs1, data->self->priv->_proto, data->self->priv->_im_address_1);
	g_value_set_object (data->v1, (GObject*) data->im_addrs1);
	data->_tmp7_ = g_strdup ("im-addresses");
	data->_tmp8_ = data->v1;
	data->v1 = NULL;
	g_hash_table_insert (data->details1, data->_tmp7_, data->_tmp8_);
	memset (&data->_tmp9_, 0, sizeof (GValue));
	g_value_init (&data->_tmp9_, G_TYPE_STRING);
	memset (&data->_tmp10_, 0, sizeof (GValue));
	data->_tmp10_ = data->_tmp9_;
	data->_tmp11_ = data->_tmp10_;
	data->_tmp12_ = __g_value_dup0 (&data->_tmp11_);
	data->_tmp13_ = data->_tmp12_;
	G_IS_VALUE (&data->_tmp11_) ? (g_value_unset (&data->_tmp11_), NULL) : NULL;
	data->v2 = data->_tmp13_;
	g_value_set_string (data->v2, data->self->priv->_persona_fullname_1);
	data->_tmp14_ = g_strdup ("full-name");
	data->_tmp15_ = data->v2;
	data->v2 = NULL;
	g_hash_table_insert (data->details1, data->_tmp14_, data->_tmp15_);
	data->_tmp16_ = NULL;
	data->_tmp16_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details2 = data->_tmp16_;
	memset (&data->_tmp17_, 0, sizeof (GValue));
	g_value_init (&data->_tmp17_, GEE_TYPE_MULTI_MAP);
	memset (&data->_tmp18_, 0, sizeof (GValue));
	data->_tmp18_ = data->_tmp17_;
	data->_tmp19_ = data->_tmp18_;
	data->_tmp20_ = __g_value_dup0 (&data->_tmp19_);
	data->_tmp21_ = data->_tmp20_;
	G_IS_VALUE (&data->_tmp19_) ? (g_value_unset (&data->_tmp19_), NULL) : NULL;
	data->v3 = data->_tmp21_;
	data->_tmp22_ = NULL;
	data->_tmp22_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	data->im_addrs2 = data->_tmp22_;
	gee_multi_map_set ((GeeMultiMap*) data->im_addrs2, data->self->priv->_proto, data->self->priv->_im_address_2);
	g_value_set_object (data->v3, (GObject*) data->im_addrs2);
	data->_tmp23_ = g_strdup ("im-addresses");
	data->_tmp24_ = data->v3;
	data->v3 = NULL;
	g_hash_table_insert (data->details2, data->_tmp23_, data->_tmp24_);
	memset (&data->_tmp25_, 0, sizeof (GValue));
	g_value_init (&data->_tmp25_, G_TYPE_STRING);
	memset (&data->_tmp26_, 0, sizeof (GValue));
	data->_tmp26_ = data->_tmp25_;
	data->_tmp27_ = data->_tmp26_;
	data->_tmp28_ = __g_value_dup0 (&data->_tmp27_);
	data->_tmp29_ = data->_tmp28_;
	G_IS_VALUE (&data->_tmp27_) ? (g_value_unset (&data->_tmp27_), NULL) : NULL;
	data->v4 = data->_tmp29_;
	g_value_set_string (data->v4, data->self->priv->_persona_fullname_2);
	data->_tmp30_ = g_strdup ("full-name");
	data->_tmp31_ = data->v4;
	data->v4 = NULL;
	g_hash_table_insert (data->details2, data->_tmp30_, data->_tmp31_);
	data->_state_ = 1;
	folks_individual_aggregator_add_persona_from_details (data->self->priv->_aggregator, NULL, data->pstore, data->details1, _link_personas_tests_add_personas_ready, data);
	return FALSE;
	_state_1:
	data->_tmp32_ = NULL;
	data->_tmp32_ = folks_individual_aggregator_add_persona_from_details_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	data->_tmp33_ = data->_tmp32_;
	_g_object_unref0 (data->_tmp33_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			goto __catch3_folks_individual_aggregator_error;
		}
		__vala_GValue_free0 (data->v4);
		_g_object_unref0 (data->im_addrs2);
		__vala_GValue_free0 (data->v3);
		_g_hash_table_unref0 (data->details2);
		__vala_GValue_free0 (data->v2);
		_g_object_unref0 (data->im_addrs1);
		__vala_GValue_free0 (data->v1);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_state_ = 2;
	folks_individual_aggregator_add_persona_from_details (data->self->priv->_aggregator, NULL, data->pstore, data->details2, _link_personas_tests_add_personas_ready, data);
	return FALSE;
	_state_2:
	data->_tmp34_ = NULL;
	data->_tmp34_ = folks_individual_aggregator_add_persona_from_details_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	data->_tmp35_ = data->_tmp34_;
	_g_object_unref0 (data->_tmp35_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			goto __catch3_folks_individual_aggregator_error;
		}
		__vala_GValue_free0 (data->v4);
		_g_object_unref0 (data->im_addrs2);
		__vala_GValue_free0 (data->v3);
		_g_hash_table_unref0 (data->details2);
		__vala_GValue_free0 (data->v2);
		_g_object_unref0 (data->im_addrs1);
		__vala_GValue_free0 (data->v1);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	goto __finally3;
	__catch3_folks_individual_aggregator_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("link-personas.vala:202: [AddPersonaError] add_persona_from_details: %s" \
"\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally3:
	if (data->_inner_error_ != NULL) {
		__vala_GValue_free0 (data->v4);
		_g_object_unref0 (data->im_addrs2);
		__vala_GValue_free0 (data->v3);
		_g_hash_table_unref0 (data->details2);
		__vala_GValue_free0 (data->v2);
		_g_object_unref0 (data->im_addrs1);
		__vala_GValue_free0 (data->v1);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	__vala_GValue_free0 (data->v4);
	_g_object_unref0 (data->im_addrs2);
	__vala_GValue_free0 (data->v3);
	_g_hash_table_unref0 (data->details2);
	__vala_GValue_free0 (data->v2);
	_g_object_unref0 (data->im_addrs1);
	__vala_GValue_free0 (data->v1);
	_g_hash_table_unref0 (data->details1);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void __link_personas_tests_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_link_personas_tests_notify_cb (self, _sender, pspec);
}


static void _link_personas_tests_individuals_changed_cb (LinkPersonasTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) added);
		_i_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksIndividual* i;
			gboolean _tmp3_;
			_tmp1_ = gee_iterator_next (_i_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp2_;
			_tmp3_ = folks_individual_get_is_user (i);
			if (!_tmp3_) {
				_link_personas_tests_check_personas (self, i);
				g_signal_connect_object ((GObject*) i, "notify::full-name", (GCallback) __link_personas_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::im-addresses", (GCallback) __link_personas_tests_notify_cb_g_object_notify, self, 0);
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_tmp4_ = gee_collection_get_size ((GeeCollection*) removed);
	if (_tmp4_ > 0) {
		gint _tmp5_;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) removed);
		self->priv->_removed_individuals = self->priv->_removed_individuals + ((gint) _tmp5_);
	}
}


static void _link_personas_tests_notify_cb (LinkPersonasTests* self, GObject* individual_obj, GParamSpec* ps) {
	FolksIndividual* _tmp0_;
	FolksIndividual* i;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual_obj != NULL);
	g_return_if_fail (ps != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_INDIVIDUAL (individual_obj));
	i = _tmp0_;
	_link_personas_tests_check_personas (self, i);
	_g_object_unref0 (i);
}


static gboolean _lambda0_ (LinkPersonasTests* self) {
	gboolean result = FALSE;
	folks_individual_aggregator_link_personas (self->priv->_aggregator, (GeeSet*) self->priv->_personas, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


static void _link_personas_tests_check_personas (LinkPersonasTests* self, FolksIndividual* i) {
	FolksPersona* first_persona;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp34_ = FALSE;
	gint _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	first_persona = NULL;
	{
		GeeSet* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = folks_individual_get_personas (i);
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_p_it = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			gpointer _tmp3_ = NULL;
			FolksPersona* p;
			FolksPersona* _tmp4_;
			_tmp2_ = gee_iterator_next (_p_it);
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = gee_iterator_get (_p_it);
			p = (FolksPersona*) _tmp3_;
			_tmp4_ = _g_object_ref0 (p);
			_g_object_unref0 (first_persona);
			first_persona = _tmp4_;
			_g_object_unref0 (p);
			break;
		}
		_g_object_unref0 (_p_it);
	}
	_tmp6_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
	if (g_strcmp0 (_tmp6_, self->priv->_persona_fullname_1) == 0) {
		_tmp5_ = g_strcmp0 (self->priv->_persona_iid_1, "") == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp7_ = folks_persona_get_iid (first_persona);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (self->priv->_persona_iid_1);
		self->priv->_persona_iid_1 = _tmp8_;
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_personas, first_persona);
	} else {
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_ = NULL;
		_tmp10_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
		if (g_strcmp0 (_tmp10_, self->priv->_persona_fullname_2) == 0) {
			_tmp9_ = g_strcmp0 (self->priv->_persona_iid_2, "") == 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			_tmp11_ = folks_persona_get_iid (first_persona);
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (self->priv->_persona_iid_2);
			self->priv->_persona_iid_2 = _tmp12_;
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_personas, first_persona);
		} else {
			GeeSet* _tmp13_ = NULL;
			gint _tmp14_;
			_tmp13_ = folks_individual_get_personas (i);
			_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
			if (_tmp14_ > 1) {
				gint _tmp33_;
				{
					GeeMultiMap* _tmp15_ = NULL;
					GeeSet* _tmp16_ = NULL;
					GeeSet* _tmp17_;
					GeeIterator* _tmp18_ = NULL;
					GeeIterator* _tmp19_;
					GeeIterator* _proto_it;
					_tmp15_ = folks_im_details_get_im_addresses ((FolksImDetails*) i);
					_tmp16_ = gee_multi_map_get_keys (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
					_tmp19_ = _tmp18_;
					_g_object_unref0 (_tmp17_);
					_proto_it = _tmp19_;
					while (TRUE) {
						gboolean _tmp20_;
						gpointer _tmp21_ = NULL;
						gchar* proto;
						GeeMultiMap* _tmp22_ = NULL;
						GeeCollection* _tmp23_ = NULL;
						GeeCollection* addrs;
						_tmp20_ = gee_iterator_next (_proto_it);
						if (!_tmp20_) {
							break;
						}
						_tmp21_ = gee_iterator_get (_proto_it);
						proto = (gchar*) _tmp21_;
						_tmp22_ = folks_im_details_get_im_addresses ((FolksImDetails*) i);
						_tmp23_ = gee_multi_map_get (_tmp22_, proto);
						addrs = _tmp23_;
						{
							GeeIterator* _tmp24_ = NULL;
							GeeIterator* _a_it;
							_tmp24_ = gee_iterable_iterator ((GeeIterable*) addrs);
							_a_it = _tmp24_;
							while (TRUE) {
								gboolean _tmp25_;
								gpointer _tmp26_ = NULL;
								gchar* a;
								gpointer _tmp27_ = NULL;
								gchar* _tmp28_;
								gboolean _tmp29_;
								_tmp25_ = gee_iterator_next (_a_it);
								if (!_tmp25_) {
									break;
								}
								_tmp26_ = gee_iterator_get (_a_it);
								a = (gchar*) _tmp26_;
								_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_linking_props, "prop1");
								_tmp28_ = (gchar*) _tmp27_;
								_tmp29_ = g_strcmp0 (a, _tmp28_) == 0;
								_g_free0 (_tmp28_);
								if (_tmp29_) {
									gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_linking_props, "prop1", NULL);
								} else {
									gpointer _tmp30_ = NULL;
									gchar* _tmp31_;
									gboolean _tmp32_;
									_tmp30_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_linking_props, "prop2");
									_tmp31_ = (gchar*) _tmp30_;
									_tmp32_ = g_strcmp0 (a, _tmp31_) == 0;
									_g_free0 (_tmp31_);
									if (_tmp32_) {
										gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_linking_props, "prop2", NULL);
									}
								}
								_g_free0 (a);
							}
							_g_object_unref0 (_a_it);
						}
						_g_object_unref0 (addrs);
						_g_free0 (proto);
					}
					_g_object_unref0 (_proto_it);
				}
				_tmp33_ = gee_map_get_size ((GeeMap*) self->priv->_linking_props);
				if (_tmp33_ == 0) {
					g_main_loop_quit (self->priv->_main_loop);
				}
			}
		}
	}
	_tmp35_ = gee_collection_get_size ((GeeCollection*) self->priv->_personas);
	if (_tmp35_ == 2) {
		_tmp34_ = self->priv->_linking_fired == FALSE;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		self->priv->_linking_fired = TRUE;
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	}
	_g_object_unref0 (first_persona);
}


static void link_personas_tests_class_init (LinkPersonasTestsClass * klass) {
	link_personas_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LinkPersonasTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = link_personas_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = link_personas_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = link_personas_tests_finalize;
}


static void link_personas_tests_instance_init (LinkPersonasTests * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self->priv = LINK_PERSONAS_TESTS_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("jabber");
	self->priv->_proto = _tmp0_;
	_tmp1_ = g_strdup ("someone-1@jabber.example.org");
	self->priv->_im_address_1 = _tmp1_;
	_tmp2_ = g_strdup ("someone-2@jabber.example.org");
	self->priv->_im_address_2 = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_persona_iid_1 = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_persona_iid_2 = _tmp4_;
	self->priv->_removed_individuals = 0;
	_tmp5_ = g_strdup ("/system/folks/backends/primary_store");
	self->priv->_folks_config_key = _tmp5_;
}


static void link_personas_tests_finalize (GObject* obj) {
	LinkPersonasTests * self;
	self = LINK_PERSONAS_TESTS (obj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_object_unref0 (self->priv->_aggregator);
	_g_free0 (self->priv->_persona_fullname_1);
	_g_free0 (self->priv->_persona_fullname_2);
	_g_free0 (self->priv->_proto);
	_g_free0 (self->priv->_im_address_1);
	_g_free0 (self->priv->_im_address_2);
	_g_free0 (self->priv->_persona_iid_1);
	_g_free0 (self->priv->_persona_iid_2);
	_g_object_unref0 (self->priv->_personas);
	_g_free0 (self->priv->_folks_config_key);
	_g_object_unref0 (self->priv->_linking_props);
	G_OBJECT_CLASS (link_personas_tests_parent_class)->finalize (obj);
}


GType link_personas_tests_get_type (void) {
	static volatile gsize link_personas_tests_type_id__volatile = 0;
	if (g_once_init_enter (&link_personas_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LinkPersonasTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) link_personas_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LinkPersonasTests), 0, (GInstanceInitFunc) link_personas_tests_instance_init, NULL };
		GType link_personas_tests_type_id;
		link_personas_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "LinkPersonasTests", &g_define_type_info, 0);
		g_once_init_leave (&link_personas_tests_type_id__volatile, link_personas_tests_type_id);
	}
	return link_personas_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	LinkPersonasTests* _tmp1_ = NULL;
	LinkPersonasTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = link_personas_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



