; Aisleriot - fortunes.scm
; Copyright (C) 1998 Rosanna Yuen <rwsy@mit.edu>

(define (new-game)
  (initialize-playing-area)
;  (set-ace-high)
  (set-ace-low)
  (make-standard-deck)
  (shuffle-deck)

  (add-normal-slot DECK)

  (add-blank-slot)
  (add-extended-slot '() down)
  (add-extended-slot '() down)
  (add-extended-slot '() down)
  (add-extended-slot '() down)

  (list 6 3)
)

(define (button-pressed slot-id card-list)
  (and card-list
       (> slot-id 0)
       (or (empty-slot? 1)
	   (empty-slot? 2)
	   (empty-slot? 3)
	   (empty-slot? 4))))

(define (button-released start-slot card-list end-slot)
  (if (= end-slot start-slot)
      (if (= 1 (length card-list))
	  (begin
	    (move-n-cards! start-slot end-slot card-list)
	    (if (button-clicked start-slot)
		#t
		#t))
	  #f)
      (if (empty-slot? end-slot)
	  (move-n-cards! start-slot end-slot card-list)
	  #f)))

(define (removable? slot-id reason)
  (if (= slot-id reason)
      (if (= reason 4)
	  #f
	  (removable? slot-id (+ reason 1)))
      (if (and (not (empty-slot? reason))
	       (= (get-suit (get-top-card slot-id))
		  (get-suit (get-top-card reason)))
	       (< (get-value (get-top-card slot-id))
		  (get-value (get-top-card reason))))
	  (begin
	    (remove-card slot-id)
	    (add-to-score! 1))
	  (if (= reason 4)
	      #f
	      (removable? slot-id (+ reason 1))))))

(define (button-clicked slot-id)
  (if (empty-slot? slot-id)
      #f
      (if (= slot-id 0)
	  (begin 
	    (deal-cards 0 '(1 2 3 4))
	    (flip-top-card 1)
	    (flip-top-card 2)
	    (flip-top-card 3)
	    (flip-top-card 4))
	  (removable? slot-id 1))))
  
(define (button-double-clicked slot)
  (button-clicked slot))     
	  
(define (game-won)
  (and (empty-slot? 0)
       (= 1 (length (get-cards 1)))
       (= 1 (length (get-cards 2)))
       (= 1 (length (get-cards 3)))
       (= 1 (length (get-cards 4)))))
     
(define (game-over)
  (not (and (empty-slot? 0)
	    (and (not (empty-slot? 1))
		     (not (empty-slot? 2))
		     (not (empty-slot? 3))
		     (not (empty-slot? 4))
		     (not (= (get-suit (get-top-card 1))
			     (get-suit (get-top-card 2))))
		     (not (= (get-suit (get-top-card 1))
			     (get-suit (get-top-card 3))))		
		     (not (= (get-suit (get-top-card 1))
			     (get-suit (get-top-card 4))))
		     (not (= (get-suit (get-top-card 2))
			     (get-suit (get-top-card 3))))
		     (not (= (get-suit (get-top-card 2))
			     (get-suit (get-top-card 4))))
		     (not (= (get-suit (get-top-card 3))
			     (get-suit (get-top-card 4))))))))

(define (check-hint slot1 slot2)
  (if (> slot2 4)
      #f
      (if (and (not (empty-slot? slot1))
	       (not (empty-slot? slot2))
	       (eq? (get-suit (get-top-card slot1))
		    (get-suit (get-top-card slot2))))
	  (if (< (get-value (get-top-card slot1))
		 (get-value (get-top-card slot2)))
	      (list 3 (get-name (get-top-card slot1)) "off the board")
	      (list 3 (get-name (get-top-card slot2)) "off the board"))
	  (check-hint slot1 (+ 1 slot2)))))

(define (get-hint)
  (or (check-hint 1 2)
      (check-hint 2 3)
      (check-hint 3 4)
      (if (and (not (and (empty-slot? 1)
			 (empty-slot? 2)
			 (empty-slot? 3)
			 (empty-slot? 4)))
	       (or (empty-slot? 1)
		   (empty-slot? 2)
		   (empty-slot? 3)
		   (empty-slot? 4)))
	  (list 0 "Consider moving something into empty slot")
	  #f)
      (if (not (empty-slot? 0))
	  (list 0 "Deal another round")
	  #f)))

(define (get-options) #f)

(define (apply-options options) #f)

(define (timeout) #f)

(set-lambda new-game button-pressed button-released button-clicked button-double-clicked game-over game-won get-hint get-options apply-options timeout)
