/* Generated by GOB (v2.0.11) on Tue Jan 25 19:52:36 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 14 "games-scores-dialog.gob"

/* Games Scores Dialog - Display high scores
 *
 * Copyright (c) 2004 by Callum McKenzie
 *
 */


#line 17 "games-scores-dialog.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "games-scores-dialog.h"

#include "games-scores-dialog-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 23 "games-scores-dialog.gob"

#include <gnome.h>

#line 42 "games-scores-dialog.c"

#line 27 "games-scores-dialog.gob"

#include <math.h>

#line 48 "games-scores-dialog.c"
/* self casting macros */
#define SELF(x) GAMES_SCORES_DIALOG(x)
#define SELF_CONST(x) GAMES_SCORES_DIALOG_CONST(x)
#define IS_SELF(x) GAMES_IS_SCORES_DIALOG(x)
#define TYPE_SELF GAMES_TYPE_SCORES_DIALOG
#define SELF_CLASS(x) GAMES_SCORES_DIALOG_CLASS(x)

#define SELF_GET_CLASS(x) GAMES_SCORES_DIALOG_GET_CLASS(x)

/* self typedefs */
typedef GamesScoresDialog Self;
typedef GamesScoresDialogClass SelfClass;

/* here are local prototypes */
static void games_scores_dialog_class_init (GamesScoresDialogClass * c) G_GNUC_UNUSED;
static void games_scores_dialog_set_hilight_private (GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_redraw (GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_change_category (GtkComboBox * widget, GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_show (GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_hide (GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_init (GamesScoresDialog * self) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkDialogClass *parent_class = NULL;

/* Short form macros */
#define self_new games_scores_dialog_new
#define self_set_hilight_private games_scores_dialog_set_hilight_private
#define self_redraw games_scores_dialog_redraw
#define self_change_category games_scores_dialog_change_category
#define self_show games_scores_dialog_show
#define self_hide games_scores_dialog_hide
#define self_add_category games_scores_dialog_add_category
#define self_set_category games_scores_dialog_set_category
#define self_set_style games_scores_dialog_set_style
#define self_set_category_description games_scores_dialog_set_category_description
#define self_set_hilight games_scores_dialog_set_hilight
GType
games_scores_dialog_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GamesScoresDialogClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) games_scores_dialog_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GamesScoresDialog),
			0 /* n_preallocs */,
			(GInstanceInitFunc) games_scores_dialog_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_DIALOG, "GamesScoresDialog", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GamesScoresDialog *)g_object_new(games_scores_dialog_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GamesScoresDialog * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GamesScoresDialog *
GET_NEW_VARG (const char *first, ...)
{
	GamesScoresDialog *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GamesScoresDialog *)g_object_new_valist (games_scores_dialog_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::finalize"
	GamesScoresDialog *self G_GNUC_UNUSED = GAMES_SCORES_DIALOG (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 40 "games-scores-dialog.gob"
	if(self->_priv->domain) { g_free ((gpointer) self->_priv->domain); self->_priv->domain = NULL; }
#line 139 "games-scores-dialog.c"
#line 41 "games-scores-dialog.gob"
	if(self->_priv->categories) { g_hash_table_destroy ((gpointer) self->_priv->categories); self->_priv->categories = NULL; }
#line 142 "games-scores-dialog.c"
#line 42 "games-scores-dialog.gob"
	if(self->_priv->catindices) { g_hash_table_destroy ((gpointer) self->_priv->catindices); self->_priv->catindices = NULL; }
#line 145 "games-scores-dialog.c"
}
#undef __GOB_FUNCTION__

static void 
games_scores_dialog_class_init (GamesScoresDialogClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(GamesScoresDialogPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_DIALOG);

	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__
#line 156 "games-scores-dialog.gob"
static void 
games_scores_dialog_init (GamesScoresDialog * self G_GNUC_UNUSED)
#line 165 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,TYPE_SELF,GamesScoresDialogPrivate);
 {
#line 156 "games-scores-dialog.gob"

    GtkWidget *hbox;
    GtkWidget *vbox;
    GtkWidget *scroll;
    GtkWidget *listview;
    GtkTreeViewColumn *column;
    GtkCellRenderer *renderer;

    self->_priv->style = GAMES_SCORES_STYLE_PLAIN;
    /* These two hashes are the reverse of each other. As an optimisation 
     * they share the same set of strings (as keys in the first case and
     * as data in the second). The first hash is responsible for 
     * deallocating the memory for the strings. These two are only
     * valid as a pair. */
    self->_priv->categories = g_hash_table_new_full (g_str_hash, g_str_equal,
						     g_free, NULL);
    self->_priv->catindices = g_hash_table_new (g_direct_hash, g_direct_equal);
    self->_priv->catcounter = 0;
    self->_priv->hilight = 0;

    gtk_dialog_set_has_separator (GTK_DIALOG (self), FALSE);

    g_signal_connect (G_OBJECT (self), "show", 
		      G_CALLBACK (games_scores_dialog_show), NULL);
    g_signal_connect (G_OBJECT (self), "hide", 
		      G_CALLBACK (games_scores_dialog_hide), NULL);

    vbox = GTK_DIALOG (self)->vbox;
 
    scroll = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
				    GTK_POLICY_AUTOMATIC,
				    GTK_POLICY_AUTOMATIC);
    gtk_widget_set_size_request (scroll, 250, 265);
    gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scroll),
					 GTK_SHADOW_ETCHED_IN);
    gtk_box_pack_end (GTK_BOX (vbox), scroll, TRUE, TRUE, 0);
    
    hbox = gtk_hbox_new (FALSE, 5);
    gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 5);

    self->_priv->label = gtk_label_new ("");
    gtk_box_pack_start (GTK_BOX (hbox), self->_priv->label, FALSE, FALSE, 
			5);	
   
    self->_priv->combo = gtk_combo_box_new_text ();
    gtk_box_pack_start (GTK_BOX (hbox), self->_priv->combo, TRUE, TRUE, 5);

    g_signal_connect (G_OBJECT (self->_priv->combo), "changed", 
		      G_CALLBACK (games_scores_dialog_change_category), self);

    self->_priv->list = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);

    listview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (self->_priv->list));
    self->_priv->treeview = GTK_TREE_VIEW (listview);

    renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes (_("Name"),
						       renderer,
						       "text", 0,
						       NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (listview),
				 GTK_TREE_VIEW_COLUMN (column));
    renderer = gtk_cell_renderer_text_new ();
    /* Note that this assumes the default style is plain. */
    column = gtk_tree_view_column_new_with_attributes (_("Score"),
						       renderer,
						       "text", 1,
						       NULL);
    g_object_set (G_OBJECT (renderer), "xalign", 1.0, NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (listview),
				 GTK_TREE_VIEW_COLUMN (column));
    self->_priv->column = column;
   
    gtk_container_add (GTK_CONTAINER (scroll), listview);
    
    gtk_dialog_add_button (GTK_DIALOG (self), GTK_STOCK_CLOSE,
			   GTK_RESPONSE_CLOSE);
    gtk_dialog_set_default_response (GTK_DIALOG (self), 
				     GTK_RESPONSE_CLOSE);
    gtk_window_set_destroy_with_parent (GTK_WINDOW (self), TRUE);

    gtk_widget_show_all (vbox);
  
#line 255 "games-scores-dialog.c"
 }
}
#undef __GOB_FUNCTION__


/**
 * games_scores_dialog_new:
 * @domain: the scores domain to use, usually the application name
 * @title: the title for the dialog
 *
 * Creates a new high scores dialog. Use gtk_dialog_run and 
 * gtk_widget_destroy to manage it.
 *
 * Returns: a new widget
 *
 **/
#line 60 "games-scores-dialog.gob"
GtkWidget * 
games_scores_dialog_new (const gchar * domain, const gchar * title)
#line 275 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::new"
{
#line 60 "games-scores-dialog.gob"
	
    GamesScoresDialog *dialog = GET_NEW;

    dialog->_priv->domain = g_strdup (domain);

    gtk_window_set_title (GTK_WINDOW (dialog), title);

    return (GtkWidget *)dialog;
  }}
#line 289 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 70 "games-scores-dialog.gob"
static void 
games_scores_dialog_set_hilight_private (GamesScoresDialog * self)
#line 295 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::set_hilight_private"
{
#line 71 "games-scores-dialog.gob"
	
    GtkTreePath *path;
    GtkTreeSelection *selection;

    if (self->_priv->hilight == 0)
      return;

    selection = gtk_tree_view_get_selection (self->_priv->treeview);
    path = gtk_tree_path_new_from_indices (self->_priv->hilight - 1, -1);
    gtk_tree_selection_select_path (selection, path);
    g_free (path);
  }}
#line 312 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 84 "games-scores-dialog.gob"
static void 
games_scores_dialog_redraw (GamesScoresDialog * self)
#line 318 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::redraw"
{
#line 85 "games-scores-dialog.gob"
	
    gint i,n;
    GtkTreeIter iter;
    gchar **names = NULL;
    gfloat *scores = NULL;
    time_t *scoretimes = NULL;
    gchar **name;
    gfloat *score;
    gchar *ss;
    gint intscore;
    gint index;
    gchar *category;

    index = gtk_combo_box_get_active (GTK_COMBO_BOX (self->_priv->combo));
    category = g_hash_table_lookup (self->_priv->catindices, 
				    GINT_TO_POINTER (index));

    gtk_list_store_clear (self->_priv->list);
    
    n = gnome_score_get_notable (self->_priv->domain, category, 
				 &names, &scores, &scoretimes);

    i = 1;
    name = names;
    score = scores;
    while (n--) {
      switch (self->_priv->style) {
      case GAMES_SCORES_STYLE_TIME:
	intscore = rint (100*(*score));
	/* Translators: this is for a minutes, seconds time display. */
	ss = g_strdup_printf (_("%dm %ds"), intscore/100, intscore%100);
	break;
      case GAMES_SCORES_STYLE_PLAIN:
      default:
	intscore = rint (*score);
	ss = g_strdup_printf ("%d", intscore);
      }
      gtk_list_store_append (self->_priv->list, &iter);
      gtk_list_store_set (self->_priv->list, &iter, 0, *name, 1, ss, -1);
      g_free (ss);
      name++;
      score++;
    }
      
    g_free (names);
    g_free (scores);
    g_free (scoretimes);        

    games_scores_dialog_set_hilight_private (self);
  }}
#line 373 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 136 "games-scores-dialog.gob"
static void 
games_scores_dialog_change_category (GtkComboBox * widget, GamesScoresDialog * self)
#line 379 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::change_category"
{
#line 137 "games-scores-dialog.gob"
	
    self->_priv->hilight = 0;
    games_scores_dialog_redraw (self);
  }}
#line 388 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 146 "games-scores-dialog.gob"
static void 
games_scores_dialog_show (GamesScoresDialog * self)
#line 394 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::show"
{
#line 147 "games-scores-dialog.gob"
	 
    games_scores_dialog_redraw (self);
  }}
#line 402 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 151 "games-scores-dialog.gob"
static void 
games_scores_dialog_hide (GamesScoresDialog * self)
#line 408 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::hide"
{
#line 152 "games-scores-dialog.gob"
	
    self->_priv->hilight = 0;
  }}
#line 416 "games-scores-dialog.c"
#undef __GOB_FUNCTION__


/**
 * games_scores_dialog_add_category:
 * @self: a pointer to a GamesScoresDialog
 * @key: an identifier for the category. This should also be a valid
 * score category for the gnome_score system.
 * @name: the category name
 *
 * Adds a new category to combo box selector.
 *
 **/
#line 251 "games-scores-dialog.gob"
void 
games_scores_dialog_add_category (GamesScoresDialog * self, const gchar * key, const gchar * name)
#line 433 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::add_category"
{
#line 253 "games-scores-dialog.gob"
	
    gchar *k;

    k = g_strdup (key);

    g_hash_table_insert (self->_priv->categories, k, 
			 GINT_TO_POINTER (self->_priv->catcounter));
    g_hash_table_insert (self->_priv->catindices, 
			 GINT_TO_POINTER (self->_priv->catcounter),
			 k);
    self->_priv->catcounter++;
    gtk_combo_box_append_text (GTK_COMBO_BOX (self->_priv->combo), name);
  }}
#line 451 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

/**
 * games_scores_dialog_set_category:
 * @self: a pointer to a GamesScoresDialog
 * @style: the style to use
 *
 * Sets the style of score displayed. e.g. GAMES_SCORES_STYLE_TIME
 * displays the scores as times. Note that the order of the scores
 * is determined at the gnome_score layer but their interpretation
 * is at this layer.
 *
 **/
#line 275 "games-scores-dialog.gob"
void 
games_scores_dialog_set_category (GamesScoresDialog * self, const gchar * key)
#line 468 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::set_category"
{
#line 275 "games-scores-dialog.gob"
	
    gint index;

    index = GPOINTER_TO_INT (g_hash_table_lookup (self->_priv->categories, 
						   key));
    gtk_combo_box_set_active (GTK_COMBO_BOX (self->_priv->combo), index);
  }}
#line 480 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 294 "games-scores-dialog.gob"
void 
games_scores_dialog_set_style (GamesScoresDialog * self, GamesScoresStyle style)
#line 486 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::set_style"
{
#line 294 "games-scores-dialog.gob"
	
    gchar *header;

    self->_priv->style = style;
    switch (style) {
    case GAMES_SCORES_STYLE_TIME:
      header = _("Time");
      break;
    case GAMES_SCORES_STYLE_PLAIN:
    default:
      header = _("Score");
    }

    gtk_tree_view_column_set_title (self->_priv->column, header);
    games_scores_dialog_change_category (GTK_COMBO_BOX (self->_priv->combo), 
					 self);
  }}
#line 508 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

/**
 * games_scores_dialog_set_category_description:
 * @self: a pointer to a GamesScoresDialog
 * @pos: the position in the high score list to hilight. Should be in the
 * range 1 to 10.
 *
 * Hilights an entry in the high score list. This is suitable for indicating
 * to the player where the game they just played is.
 *
 **/
#line 321 "games-scores-dialog.gob"
void 
games_scores_dialog_set_category_description (GamesScoresDialog * self, const gchar * description)
#line 524 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::set_category_description"
{
#line 322 "games-scores-dialog.gob"
	
    gchar *lstr;

    lstr = g_strdup_printf ("<b>%s</b>", description);
    gtk_label_set_text (GTK_LABEL (self->_priv->label), lstr);
    gtk_label_set_use_markup (GTK_LABEL (self->_priv->label), TRUE);
    g_free(lstr);
  }}
#line 537 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 341 "games-scores-dialog.gob"
void 
games_scores_dialog_set_hilight (GamesScoresDialog * self, guint pos)
#line 543 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::set_hilight"
{
#line 342 "games-scores-dialog.gob"
	
    /* We silently exit here since 0 is an explicit indication that we don't 
     * have a place in mind while greater than 10 is legitimate, but we
     * aren't going to display it. */
    if ((pos < 1) || (pos > 10))
      return;

    self->_priv->hilight = pos;
    games_scores_dialog_set_hilight_private (self);
  }}
#line 558 "games-scores-dialog.c"
#undef __GOB_FUNCTION__
