/*
   Copyright (C) 2004 Fernando Herrera <fherrera@onirica.com>
   Copyright (C) 2004 GNOME Love Project <gnome-love@gnome.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef GNOME_KEYRING_MANAGER_ATTRIBUTE_EDITOR_H
#define GNOME_KEYRING_MANAGER_ATTRIBUTE_EDITOR_H

#include <config.h>

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GKM_TYPE_ATTRIBUTE_EDITOR            (gkm_attribute_editor_get_type ())
#define GKM_ATTRIBUTE_EDITOR(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GKM_TYPE_ATTRIBUTE_EDITOR, GKMAttributeEditor))
#define GKM_ATTRIBUTE_EDITOR_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  GKM_TYPE_ATTRIBUTE_EDITOR, GKMAttributeEditorClass))
#define GKM_IS_ATTRIBUTE_EDITOR(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GKM_TYPE_ATTRIBUTE_EDITOR))
#define GKM_IS_ATTRIBUTE_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  GKM_TYPE_ATTRIBUTE_EDITOR))
#define GKM_ATTRIBUTE_EDITOR_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  GKM_TYPE_ATTRIBUTE_EDITOR, GKMAttributeEditorClass))

typedef struct _GKMAttributeEditor         GKMAttributeEditor;
typedef struct _GKMAttributeEditorClass    GKMAttributeEditorClass;
typedef struct _GKMAttributeEditorPrivate  GKMAttributeEditorPrivate;

struct _GKMAttributeEditor
{
  GtkWindow window;

  gboolean attributes_modified;
  gboolean acl_modified;

  GKMAttributeEditorPrivate *priv;
};

struct _GKMAttributeEditorClass
{
  GtkWindowClass window_class;
};

GType gkm_attribute_editor_get_type (void);

GtkWidget *gkm_attribute_editor_new (const gchar    *keyring_name,
				     const guint     item_id,
				     const gchar    *item_name);

GnomeKeyringAttributeList *gkm_attribute_editor_get_attribute_list (GKMAttributeEditor *editor);
GList *gkm_attribute_editor_get_acl (GKMAttributeEditor *editor);

G_END_DECLS

#endif
