/*
 *  Copyright (C) 2005 Robert Staudinger
 *
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "nsString.h"
#include "nsIWebBrowser.h"

#include "gme-web-browser-private.h"
#include "gtkmozedit/gme-supports-private.h"
#include "gtkmozedit/dom/gme-dom-window-private.h"

enum {
	PROP_0,
	PROP_WRAPPED_PTR,
	_NUM_PROPS
};

static GmeSupportsClass *gme_web_browser_parent_class = NULL;

static void
instance_init (GmeWebBrowser *self)
{
	self->browser = NULL;
	self->is_disposed = FALSE;
}

static void
instance_dispose (GObject *instance)
{
	GmeWebBrowser *self = GME_WEB_BROWSER (instance);

	if (self->is_disposed)
		return;

	if (self->browser) NS_RELEASE (self->browser);
	self->browser = NULL;
	self->is_disposed = TRUE;

	gme_web_browser_parent_class->dispose (G_OBJECT (self));
}

static void
set_property (GObject      *object,
	      guint         prop_id,
	      GValue const *value,
	      GParamSpec   *pspec)
{
	GmeWebBrowser *self = GME_WEB_BROWSER (object);
	nsISupports *ptr = NULL;
	nsresult rv;

	switch (prop_id) {
	case PROP_WRAPPED_PTR:
		ptr = reinterpret_cast<nsISupports*>(g_value_get_pointer (value));
		rv = CallQueryInterface (ptr, &self->browser);
		if (NS_SUCCEEDED (rv) && self->browser) {
			NS_ADDREF (self->browser);
			/* constuction param, init parent */
			gme_supports_private_set_wrapped_ptr (GME_SUPPORTS (self), self->browser);
		}
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
	}
}

static void
get_property (GObject    *object,
	      guint       prop_id,
	      GValue     *value,
	      GParamSpec *pspec)
{
	GmeWebBrowser *self = GME_WEB_BROWSER (object);

	switch (prop_id) {
	case PROP_WRAPPED_PTR:
		g_value_set_pointer (value, (gpointer) self->browser);
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
	}
}

static void
class_init (GmeWebBrowserClass *klass)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

	/* vfuncs */
	klass->dispose = instance_dispose;

	/* hook gobject vfuncs */
	gobject_class->dispose = instance_dispose;

	gme_web_browser_parent_class = (GmeSupportsClass*) g_type_class_peek_parent (klass);

	gobject_class->set_property = set_property;
	gobject_class->get_property = get_property;

	g_object_class_install_property (gobject_class,
		PROP_WRAPPED_PTR,
		g_param_spec_pointer ("wrapped-ptr", _("Wrapped Pointer"),
			_("Pointer to the wrapped c++ object"),
			(GParamFlags)(G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY)));
}

GType
gme_web_browser_get_gtype (void)
{
        static GType type = 0;
        if (!type) {
                static const GTypeInfo info = {
                        sizeof (GmeWebBrowserClass),
                        NULL,           /* base_init */
                        NULL,           /* base_finalize */
                        (GClassInitFunc) class_init,
                        NULL,           /* class_finalize */
                        NULL,           /* class_data */
                        sizeof (GmeWebBrowser),
                        0,              /* n_preallocs */
                        (GInstanceInitFunc) instance_init,
                };
                type = g_type_register_static (GME_TYPE_SUPPORTS, "GmeWebBrowser", &info, (GTypeFlags)0);
        }
        return type;
}

void 
gme_web_browser_private_set_wrapped_ptr (GmeWebBrowser *self, 
				      nsIWebBrowser *browser)
{
	g_assert (self && browser);
	self->browser = browser;
	NS_ADDREF (self->browser);
}

GmeWebBrowser* 
gme_web_browser_new (nsIWebBrowser *browser)
{
	return GME_WEB_BROWSER (g_object_new (GME_TYPE_WEB_BROWSER, "wrapped-ptr", browser, NULL));
}

GmeDOMWindow* 
gme_web_browser_get_content_dom_window (GmeWebBrowser *self)
{
	nsIDOMWindow *w = NULL;
	GmeDOMWindow *win = NULL;
	nsresult rv;
	g_assert (self);

	rv = self->browser->GetContentDOMWindow (&(w));
	if (NS_SUCCEEDED (rv)) {
		win = gme_dom_window_new (w);
	}
	return win;
}
