// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMOZEMBEDMM_WEBCONTROL_H
#define _GTKMOZEMBEDMM_WEBCONTROL_H

#include <glibmm.h>

/* $Id: webcontrol.hg,v 1.2 2004/09/27 21:39:54 murrayc Exp $ */

/* Copyright (C) 2004 Max Vasin
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtkmm/bin.h>
#include <gtkmozembed.h>
#include <gtkmozembed_internal.h>
#include <nsCOMPtr.h>
#include <nsIDOMKeyEvent.h>
#include <nsIDOMMouseEvent.h>
#include <nsIRequest.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkMozEmbed GtkMozEmbed;
typedef struct _GtkMozEmbedClass GtkMozEmbedClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Mozilla
{ class WebControl_Class; } // namespace Mozilla
namespace Mozilla
{
  /** @addtogroup gtkmozembedmmEnums Enums and Flags */

/**
 * @ingroup gtkmozembedmmEnums
 * @par Bitwise operators:
 * <tt>%ProgressFlags operator|(ProgressFlags, ProgressFlags)</tt><br>
 * <tt>%ProgressFlags operator&(ProgressFlags, ProgressFlags)</tt><br>
 * <tt>%ProgressFlags operator^(ProgressFlags, ProgressFlags)</tt><br>
 * <tt>%ProgressFlags operator~(ProgressFlags)</tt><br>
 * <tt>%ProgressFlags& operator|=(ProgressFlags&, ProgressFlags)</tt><br>
 * <tt>%ProgressFlags& operator&=(ProgressFlags&, ProgressFlags)</tt><br>
 * <tt>%ProgressFlags& operator^=(ProgressFlags&, ProgressFlags)</tt><br>
 */
enum ProgressFlags
{
  WEB_CONTROL_FLAG_START = GTK_MOZ_EMBED_FLAG_START,
  WEB_CONTROL_FLAG_REDIRECTING = GTK_MOZ_EMBED_FLAG_REDIRECTING,
  WEB_CONTROL_FLAG_TRANSFERRING = GTK_MOZ_EMBED_FLAG_TRANSFERRING,
  WEB_CONTROL_FLAG_NEGOTIATING = GTK_MOZ_EMBED_FLAG_NEGOTIATING,
  WEB_CONTROL_FLAG_STOP = GTK_MOZ_EMBED_FLAG_STOP,
  WEB_CONTROL_FLAG_IS_REQUEST = GTK_MOZ_EMBED_FLAG_IS_REQUEST,
  WEB_CONTROL_FLAG_IS_DOCUMENT = GTK_MOZ_EMBED_FLAG_IS_DOCUMENT,
  WEB_CONTROL_FLAG_IS_NETWORK = GTK_MOZ_EMBED_FLAG_IS_NETWORK,
  WEB_CONTROL_FLAG_IS_WINDOW = GTK_MOZ_EMBED_FLAG_IS_WINDOW
};

/** @ingroup gtkmozembedmmEnums */
inline ProgressFlags operator|(ProgressFlags lhs, ProgressFlags rhs)
  { return static_cast<ProgressFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmozembedmmEnums */
inline ProgressFlags operator&(ProgressFlags lhs, ProgressFlags rhs)
  { return static_cast<ProgressFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmozembedmmEnums */
inline ProgressFlags operator^(ProgressFlags lhs, ProgressFlags rhs)
  { return static_cast<ProgressFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmozembedmmEnums */
inline ProgressFlags operator~(ProgressFlags flags)
  { return static_cast<ProgressFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmozembedmmEnums */
inline ProgressFlags& operator|=(ProgressFlags& lhs, ProgressFlags rhs)
  { return (lhs = static_cast<ProgressFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmozembedmmEnums */
inline ProgressFlags& operator&=(ProgressFlags& lhs, ProgressFlags rhs)
  { return (lhs = static_cast<ProgressFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmozembedmmEnums */
inline ProgressFlags& operator^=(ProgressFlags& lhs, ProgressFlags rhs)
  { return (lhs = static_cast<ProgressFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


  /**
 * @ingroup gtkmozembedmmEnums
 * @par Bitwise operators:
 * <tt>%ReloadFlags operator|(ReloadFlags, ReloadFlags)</tt><br>
 * <tt>%ReloadFlags operator&(ReloadFlags, ReloadFlags)</tt><br>
 * <tt>%ReloadFlags operator^(ReloadFlags, ReloadFlags)</tt><br>
 * <tt>%ReloadFlags operator~(ReloadFlags)</tt><br>
 * <tt>%ReloadFlags& operator|=(ReloadFlags&, ReloadFlags)</tt><br>
 * <tt>%ReloadFlags& operator&=(ReloadFlags&, ReloadFlags)</tt><br>
 * <tt>%ReloadFlags& operator^=(ReloadFlags&, ReloadFlags)</tt><br>
 */
enum ReloadFlags
{
  WEB_CONTROL_FLAG_RELOAD_NORMAL = GTK_MOZ_EMBED_FLAG_RELOADNORMAL,
  WEB_CONTROL_FLAG_RELOAD_BYPASS_CACHE = GTK_MOZ_EMBED_FLAG_RELOADBYPASSCACHE,
  WEB_CONTROL_FLAG_RELOAD_BYPASS_PROXY = GTK_MOZ_EMBED_FLAG_RELOADBYPASSPROXY,
  WEB_CONTROL_FLAG_RELOAD_BYPASS_PROXY_AND_CACHE = GTK_MOZ_EMBED_FLAG_RELOADBYPASSPROXYANDCACHE,
  WEB_CONTROL_FLAG_RELOAD_CHARSET_CHANGE = GTK_MOZ_EMBED_FLAG_RELOADCHARSETCHANGE
};

/** @ingroup gtkmozembedmmEnums */
inline ReloadFlags operator|(ReloadFlags lhs, ReloadFlags rhs)
  { return static_cast<ReloadFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmozembedmmEnums */
inline ReloadFlags operator&(ReloadFlags lhs, ReloadFlags rhs)
  { return static_cast<ReloadFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmozembedmmEnums */
inline ReloadFlags operator^(ReloadFlags lhs, ReloadFlags rhs)
  { return static_cast<ReloadFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmozembedmmEnums */
inline ReloadFlags operator~(ReloadFlags flags)
  { return static_cast<ReloadFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmozembedmmEnums */
inline ReloadFlags& operator|=(ReloadFlags& lhs, ReloadFlags rhs)
  { return (lhs = static_cast<ReloadFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmozembedmmEnums */
inline ReloadFlags& operator&=(ReloadFlags& lhs, ReloadFlags rhs)
  { return (lhs = static_cast<ReloadFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmozembedmmEnums */
inline ReloadFlags& operator^=(ReloadFlags& lhs, ReloadFlags rhs)
  { return (lhs = static_cast<ReloadFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


  /**
 * @ingroup gtkmozembedmmEnums
 * @par Bitwise operators:
 * <tt>%StatusFlags operator|(StatusFlags, StatusFlags)</tt><br>
 * <tt>%StatusFlags operator&(StatusFlags, StatusFlags)</tt><br>
 * <tt>%StatusFlags operator^(StatusFlags, StatusFlags)</tt><br>
 * <tt>%StatusFlags operator~(StatusFlags)</tt><br>
 * <tt>%StatusFlags& operator|=(StatusFlags&, StatusFlags)</tt><br>
 * <tt>%StatusFlags& operator&=(StatusFlags&, StatusFlags)</tt><br>
 * <tt>%StatusFlags& operator^=(StatusFlags&, StatusFlags)</tt><br>
 */
enum StatusFlags
{
  WEB_CONTROL_STATUS_FAILED_DNS = GTK_MOZ_EMBED_STATUS_FAILED_DNS,
  WEB_CONTROL_STATUS_FAILED_CONNECT = GTK_MOZ_EMBED_STATUS_FAILED_CONNECT,
  WEB_CONTROL_STATUS_FAILED_TIMEOUT = GTK_MOZ_EMBED_STATUS_FAILED_TIMEOUT,
  WEB_CONTROL_STATUS_FAILED_USERCANCELED = GTK_MOZ_EMBED_STATUS_FAILED_USERCANCELED
};

/** @ingroup gtkmozembedmmEnums */
inline StatusFlags operator|(StatusFlags lhs, StatusFlags rhs)
  { return static_cast<StatusFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmozembedmmEnums */
inline StatusFlags operator&(StatusFlags lhs, StatusFlags rhs)
  { return static_cast<StatusFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmozembedmmEnums */
inline StatusFlags operator^(StatusFlags lhs, StatusFlags rhs)
  { return static_cast<StatusFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmozembedmmEnums */
inline StatusFlags operator~(StatusFlags flags)
  { return static_cast<StatusFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmozembedmmEnums */
inline StatusFlags& operator|=(StatusFlags& lhs, StatusFlags rhs)
  { return (lhs = static_cast<StatusFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmozembedmmEnums */
inline StatusFlags& operator&=(StatusFlags& lhs, StatusFlags rhs)
  { return (lhs = static_cast<StatusFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmozembedmmEnums */
inline StatusFlags& operator^=(StatusFlags& lhs, StatusFlags rhs)
  { return (lhs = static_cast<StatusFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


  /**
 * @ingroup gtkmozembedmmEnums
 * @par Bitwise operators:
 * <tt>%ChromeFlags operator|(ChromeFlags, ChromeFlags)</tt><br>
 * <tt>%ChromeFlags operator&(ChromeFlags, ChromeFlags)</tt><br>
 * <tt>%ChromeFlags operator^(ChromeFlags, ChromeFlags)</tt><br>
 * <tt>%ChromeFlags operator~(ChromeFlags)</tt><br>
 * <tt>%ChromeFlags& operator|=(ChromeFlags&, ChromeFlags)</tt><br>
 * <tt>%ChromeFlags& operator&=(ChromeFlags&, ChromeFlags)</tt><br>
 * <tt>%ChromeFlags& operator^=(ChromeFlags&, ChromeFlags)</tt><br>
 */
enum ChromeFlags
{
  WEB_CONTROL_FLAG_DEFAULTCHROME = GTK_MOZ_EMBED_FLAG_DEFAULTCHROME,
  WEB_CONTROL_FLAG_WINDOWBORDERSON = GTK_MOZ_EMBED_FLAG_WINDOWBORDERSON,
  WEB_CONTROL_FLAG_WINDOWCLOSEON = GTK_MOZ_EMBED_FLAG_WINDOWCLOSEON,
  WEB_CONTROL_FLAG_WINDOWRESIZEON = GTK_MOZ_EMBED_FLAG_WINDOWRESIZEON,
  WEB_CONTROL_FLAG_MENUBARON = GTK_MOZ_EMBED_FLAG_MENUBARON,
  WEB_CONTROL_FLAG_TOOLBARON = GTK_MOZ_EMBED_FLAG_TOOLBARON,
  WEB_CONTROL_FLAG_LOCATIONBARON = GTK_MOZ_EMBED_FLAG_LOCATIONBARON,
  WEB_CONTROL_FLAG_STATUSBARON = GTK_MOZ_EMBED_FLAG_STATUSBARON,
  WEB_CONTROL_FLAG_PERSONALTOOLBARON = GTK_MOZ_EMBED_FLAG_PERSONALTOOLBARON,
  WEB_CONTROL_FLAG_SCROLLBARSON = GTK_MOZ_EMBED_FLAG_SCROLLBARSON,
  WEB_CONTROL_FLAG_TITLEBARON = GTK_MOZ_EMBED_FLAG_TITLEBARON,
  WEB_CONTROL_FLAG_EXTRACHROMEON = GTK_MOZ_EMBED_FLAG_EXTRACHROMEON,
  WEB_CONTROL_FLAG_ALLCHROME = GTK_MOZ_EMBED_FLAG_ALLCHROME,
  WEB_CONTROL_FLAG_WINDOWRAISED = GTK_MOZ_EMBED_FLAG_WINDOWRAISED,
  WEB_CONTROL_FLAG_WINDOWLOWERED = GTK_MOZ_EMBED_FLAG_WINDOWLOWERED,
  WEB_CONTROL_FLAG_CENTERSCREEN = GTK_MOZ_EMBED_FLAG_CENTERSCREEN,
  WEB_CONTROL_FLAG_DEPENDENT = GTK_MOZ_EMBED_FLAG_DEPENDENT,
  WEB_CONTROL_FLAG_MODAL = GTK_MOZ_EMBED_FLAG_MODAL,
  WEB_CONTROL_FLAG_OPENASDIALOG = GTK_MOZ_EMBED_FLAG_OPENASDIALOG,
  WEB_CONTROL_FLAG_OPENASCHROME = GTK_MOZ_EMBED_FLAG_OPENASCHROME
};

/** @ingroup gtkmozembedmmEnums */
inline ChromeFlags operator|(ChromeFlags lhs, ChromeFlags rhs)
  { return static_cast<ChromeFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmozembedmmEnums */
inline ChromeFlags operator&(ChromeFlags lhs, ChromeFlags rhs)
  { return static_cast<ChromeFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmozembedmmEnums */
inline ChromeFlags operator^(ChromeFlags lhs, ChromeFlags rhs)
  { return static_cast<ChromeFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmozembedmmEnums */
inline ChromeFlags operator~(ChromeFlags flags)
  { return static_cast<ChromeFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmozembedmmEnums */
inline ChromeFlags& operator|=(ChromeFlags& lhs, ChromeFlags rhs)
  { return (lhs = static_cast<ChromeFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmozembedmmEnums */
inline ChromeFlags& operator&=(ChromeFlags& lhs, ChromeFlags rhs)
  { return (lhs = static_cast<ChromeFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmozembedmmEnums */
inline ChromeFlags& operator^=(ChromeFlags& lhs, ChromeFlags rhs)
  { return (lhs = static_cast<ChromeFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


  /**
   * WebControl is an easy-to-use widget that will allow you to embed
   * a Mozilla browser window into your Gtkmm application.
   *
   * It's designed to be easy to use and uncomplicated to make the
   * barrier for use as low as possible. This means that the
   * functionality exposed should cover about 80% of uses. 
   */
  
class WebControl : public Gtk::Bin
  {
    
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef WebControl CppObjectType;
  typedef WebControl_Class CppClassType;
  typedef GtkMozEmbed BaseObjectType;
  typedef GtkMozEmbedClass BaseClassType;

private:  friend class WebControl_Class;
  static CppClassType webcontrol_class_;

private:
  // noncopyable
  WebControl(const WebControl&);
  WebControl& operator=(const WebControl&);

protected:
  explicit WebControl(const Glib::ConstructParams& construct_params);
  explicit WebControl(GtkMozEmbed* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~WebControl();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkMozEmbed*       gobj()       { return reinterpret_cast<GtkMozEmbed*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkMozEmbed* gobj() const { return reinterpret_cast<GtkMozEmbed*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkMozEmbed* gobj_copy();

private:


    sigc::signal<WebControl*, ChromeFlags> m_signal_new_window;

  public:

    /**
     * This class provides a simple way to perform stream open/close
     * in presence of exceptions.
     */
    class Stream
    {
      WebControl& wc;

    public:
      Stream(WebControl& wc, const Glib::ustring& base_uri, const Glib::ustring& mime_type);
      ~Stream();
    };

    WebControl();

    
  static void push_startup();
    
  static void pop_startup();
    
  /** This function must be called before the first widget is created
   * or XPCOM is initialized.  It allows you to set the path to the
   * mozilla components.
   * @param path Path to Mozilla components.
   */
  static void set_comp_path(const Glib::ustring& path);
    
  static void set_profile_path(const Glib::ustring& dir, const Glib::ustring& name);
    
  /** This function starts loading a url in the embedding widget. All
   * loads are asynchronous.  The url argument should be in the form
   * of http://www.gnome.org.
   */
  void load_url(const Glib::ustring& url);
    
  /** 
   */
  void stop_load();
    
  /** This function will return whether or not you can go backwards
   * in the document's navigation history.
   * @return True if it can go backwards, false if it can't.
   */
  bool can_go_back() const;
    
  /** This function will return whether or not you can go forwards in
   * the document's navigation history.  It will return
   * @return True if it can go forwards, false if it can't.
   */
  bool can_go_forward() const;
    
  /** This function will go backwards one step in the document's
   * navigation history.
   */
  void go_back();
    
  /** This function will go forward one step in the document's
   * navigation history.
   */
  void go_forward();

    /**
     * This function will allow you to take a chunk of random data
     * and render it into the document.  You need to pass in the data
     * and the length of the data.
     *
     * @param base_uri is used to resolve internal references in the
     * document and the mime_type is used to determine how to render
     * the document internally.
     */
    
  void render_data(const char* data, guint32 len, const Glib::ustring& base_uri, const Glib::ustring& mime_type);
    void render_data(const Glib::ustring& data, const Glib::ustring& base_uri, const Glib::ustring& mime_type);

    
  /** This function is used to start loading a document from an
   * external source into the embedding widget. You need to pass in
   * the @a base_uri  for resolving internal links and and the @a mime_type 
   * of the document.
   */
  void open_stream(const Glib::ustring& base_uri, const Glib::ustring& mime_type);

    /**
     * This function allows you to append data to an already opened
     * stream in the widget. You need to pass in the data that you
     * want to append to the document and its length.
     */
    
  void append_data(const char* data, guint32 len);
    void append_data(const Glib::ustring& data);

    
  /** This function closes the stream that you have been using to
   * append data manually to the embedding widget.
   */
  void close_stream();

    /**
     * This function returns the current link message of the document if there is one. 
     */
    
  Glib::ustring get_link_message() const;

    /**
     * This function returns the js_status message if there is one.
     */
    
  Glib::ustring get_js_status() const;

    /**
     * This function will get the current title for a document.
     */
    
  Glib::ustring get_title() const;

    /**
     * This function will return the current location of the
     * document. 
     */
    
  Glib::ustring get_location() const;
    
  /** This function reloads the document. The flags argument can be
   * used to control the behaviour of the reload.
   */
  void reload(ReloadFlags flags);
    
  /** This function is used to set the chome mask for this window.
   */
  void set_chrome_mask(ChromeFlags flags);
    
  /** This function gets the current chome mask for this window.
   */
  ChromeFlags get_chrome_mask() const;

    /**
     * This signal is emitted when the link message changes. This
     * happens when the user moves the mouse over a link in a web
     * page.
     */
    

  Glib::SignalProxy0< void > signal_link_message();


    /**
     * This signal is emitted when the JavaScript status message
     * changes.
     */
    

  Glib::SignalProxy0< void > signal_js_status();


    /**
     * This signal is emitted any time that the location of the
     * document has changed.
     */
    

  Glib::SignalProxy0< void > signal_location();


    /**
     * This signal is emitted any time that the location of the
     * document has changed.
     */
    

  Glib::SignalProxy0< void > signal_title();


    /**
     * This signal is emitted any time that there is a change in the
     * progress of loading a document.
     *
     * @param cur value indicates how much of the document has been
     * downloaded.
     *
     * @param max value indicates the length of the document. If the
     * value of max is less than one the full length of the document
     * can not be determined.
     */
    

  Glib::SignalProxy2< void,int,int > signal_progress();


  Glib::SignalProxy3< void,const Glib::ustring&,int,int > signal_progress_all();

    
  Glib::SignalProxy2< void,ProgressFlags,StatusFlags > signal_net_state();

    
  Glib::SignalProxy3< void,const Glib::ustring&,ProgressFlags,StatusFlags > signal_net_state_all();


    /**
     * This signal is emitted any time that the load of a document has
     * been started.
     */
    

  Glib::SignalProxy0< void > signal_net_start();


    /**
     * This signal is emitted any time that the loading of a document
     * has completed.
     */
    

  Glib::SignalProxy0< void > signal_net_stop();


    /**
     * This signal is emitted any time that a new toplevel window is
     * requested by the document. This will happen in the case of a
     * window.open() in JavaScript. Responding to this signal allows
     * you to surround a new toplevel window with your chrome.
     *
     * You should return the newly created GtkMozEmbed object via the
     * retval.
     */
    sigc::signal<WebControl*, ChromeFlags> signal_new_window()
    {
      return m_signal_new_window;
    }

    /**
     * This signal is emitted when the toplevel window in question
     * needs to be shown or hidden. If the visibility argument is true
     * then the window should be shown. If it's false it should be
     * hidden.
     */
    

  Glib::SignalProxy1< void,bool > signal_visibility();


    /**
     * This signal is emitted when the document as requested that the
     * toplevel window be closed. This will happen in the case of a
     * JavaScript window.close().
     */
    

  Glib::SignalProxy0< void > signal_destroy_browser();


    /**
     * This signal is emitted when the document tries to load a new
     * document, for example when someone clicks on a link in a web
     * page. This signal gives the embedder the opportunity to keep
     * the new document from being loaded. The uri argument is the
     * uri that's going to be loaded.
     *
     * If you return true from this signal, the new document will NOT
     * be loaded. If you return false the new document will be
     * loaded. This is somewhat non-intuitive. Think of it as the
     * Mozilla engine is asking if you want to interrupt the loading
     * of a new document. By returning true you are saying "don't load
     * this document."
     */
    

  Glib::SignalProxy1< bool,const Glib::ustring& > signal_open_uri();


//TODO: What are the signals's parameter names?
    

  Glib::SignalProxy2< void,int,int > signal_size_to();


//TODO: Can't we pass these smartpointers by const reference? murrayc.

    
  Glib::SignalProxy1< int,nsCOMPtr<nsIDOMKeyEvent> > signal_dom_key_down();

    
  Glib::SignalProxy1< int,nsCOMPtr<nsIDOMKeyEvent> > signal_dom_key_press();

    
  Glib::SignalProxy1< int,nsCOMPtr<nsIDOMKeyEvent> > signal_dom_key_up();

    
  Glib::SignalProxy1< int,nsCOMPtr<nsIDOMMouseEvent> > signal_dom_mouse_down();

    
  Glib::SignalProxy1< int,nsCOMPtr<nsIDOMMouseEvent> > signal_dom_mouse_up();

    
  Glib::SignalProxy1< int,nsCOMPtr<nsIDOMMouseEvent> > signal_dom_mouse_click();

    
  Glib::SignalProxy1< int,nsCOMPtr<nsIDOMMouseEvent> > signal_dom_mouse_dbl_click();

    
  Glib::SignalProxy1< int,nsCOMPtr<nsIDOMMouseEvent> > signal_dom_mouse_over();

    
  Glib::SignalProxy1< int,nsCOMPtr<nsIDOMMouseEvent> > signal_dom_mouse_out();


  Glib::SignalProxy2< void,nsCOMPtr<nsIRequest>,guint > signal_security_change();

    
  Glib::SignalProxy3< void,nsCOMPtr<nsIRequest>,StatusFlags,gpointer > signal_status_change();


      /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_is_focus() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_focus() const;

      /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_no_show_all() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_no_show_all() const;


    nsIWebBrowser* get_nsIWebBrowser();

    
  PRUnichar* get_title_unichar();
    
  PRUnichar* get_js_status_unichar();
    
  PRUnichar* get_link_message_unichar();
    
  static void set_directory_service_provider(nsIDirectoryServiceProvider* appFileLocProvider);
    
  static void set_app_components(const nsModuleComponentInfo* aComps, int aNumComps);

  private:
    

  Glib::SignalProxy2< void,GtkMozEmbed**,ChromeFlags > signal_new_window_old();

    void new_window_old_stub(GtkMozEmbed** new_wc, ChromeFlags chrome_flags);
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_link_message();
  virtual void on_js_status();
  virtual void on_location();
  virtual void on_title();
  virtual void on_progress(int curprogress, int maxprogress);
  virtual void on_progress_all(const Glib::ustring& aUri, int curprogress, int maxprogress);
  virtual void on_net_state(ProgressFlags state, StatusFlags status);
  virtual void on_net_state_all(const Glib::ustring& aUri, ProgressFlags state, StatusFlags status);
  virtual void on_net_start();
  virtual void on_net_stop();
  virtual void on_visibility(bool visibility);
  virtual void on_destroy_browser();
  virtual bool on_open_uri(const Glib::ustring& uri);
  virtual void on_size_to(int p1, int p2);
  virtual int on_dom_key_down(nsCOMPtr<nsIDOMKeyEvent> dom_key_event);
  virtual int on_dom_key_press(nsCOMPtr<nsIDOMKeyEvent> dom_key_event);
  virtual int on_dom_key_up(nsCOMPtr<nsIDOMKeyEvent> dom_key_event);
  virtual int on_dom_mouse_down(nsCOMPtr<nsIDOMMouseEvent> dom_mouse_event);
  virtual int on_dom_mouse_up(nsCOMPtr<nsIDOMMouseEvent> dom_mouse_event);
  virtual int on_dom_mouse_click(nsCOMPtr<nsIDOMMouseEvent> dom_mouse_event);
  virtual int on_dom_mouse_dbl_click(nsCOMPtr<nsIDOMMouseEvent> dom_mouse_event);
  virtual int on_dom_mouse_over(nsCOMPtr<nsIDOMMouseEvent> dom_mouse_event);
  virtual int on_dom_mouse_out(nsCOMPtr<nsIDOMMouseEvent> dom_mouse_event);
  virtual void on_security_change(nsCOMPtr<nsIRequest> request, guint state);
  virtual void on_status_change(nsCOMPtr<nsIRequest> request, StatusFlags status, gpointer message);
  virtual void on_new_window_old(GtkMozEmbed** new_wc, ChromeFlags chrome_flags);


};
}

/*
 * Local Variables:
 * mode: c++
 * End:
 */


namespace Glib
{
  /** @relates Mozilla::WebControl
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Mozilla::WebControl> wrap(GtkMozEmbed* object, bool take_copy = false);
}


#endif /* _GTKMOZEMBEDMM_WEBCONTROL_H */

