/*
  gyrus-common.c - Common modules.

  GYRUS -- GNOME Cyrus Administrator.

  Copyright (C) 2003-2004 Claudio Saavedra V.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
*/

#include <gtk/gtk.h>
#include <string.h>

#include "gyrus-i18n.h"
#include "gyrus-common.h"

void
gyrus_common_show_message (GtkWindow *parent,
			   GtkMessageType type,
			   const gchar* message)
{
	GtkWidget *dialog;

	dialog = gtk_message_dialog_new (parent, GTK_DIALOG_MODAL,
				 type, GTK_BUTTONS_OK, message);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
}

gboolean
gtk_entry_has_text (GtkEntry *entry)
{
	gboolean has_text;
	g_return_val_if_fail (entry != NULL, FALSE);
	g_return_val_if_fail (GTK_IS_ENTRY (entry), FALSE);

	gchar *text = g_strdup (gtk_entry_get_text (entry));
	has_text = strlen (g_strstrip (text)) > 0;
	g_free (text);
	return (has_text);
}
