/*
  gyrus-main-app.h

  GYRUS -- GNOME Cyrus Administrator Main Application Class header definitions.
  
  Copyright (C) 2004 Claudio Saavedra Valds <csaavedra@alumnos.utalca.cl>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef GYRUS_MAIN_APP_H
#define GYRUS_MAIN_APP_H

/* #include <libgnomeui/libgnomeui.h> */
#include <bonobo/bonobo-window.h> /*libbonoboui.h>*/
#include <glib-object.h>

#define GYRUS_TYPE_MAIN_APP            (gyrus_main_app_get_type ())
#define GYRUS_MAIN_APP(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GYRUS_TYPE_MAIN_APP, GyrusMainApp))
#define GYRUS_MAIN_APP_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass),  GYRUS_TYPE_MAIN_APP, GyrusMainAppClass))
#define GYRUS_IS_MAIN_APP(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GYRUS_TYPE_MAIN_APP))
#define GYRUS_IS_MAIN_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  GYRUS_TYPE_MAIN_APP))
#define GYRUS_MAIN_APP_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj),  GYRUS_TYPE_MAIN_APP, GyrusMainApp))

typedef struct _GyrusMainAppPrivate GyrusMainAppPrivate;
typedef struct _GyrusMainApp        GyrusMainApp;
typedef struct _GyrusMainAppClass   GyrusMainAppClass;

/*** Gyrus Main Application Private Data ***/
struct _GyrusMainAppPrivate {
	GtkWidget *notebook;
};

/*** Gyrus Main Application Data ***/
struct _GyrusMainApp {
	BonoboWindow window;
	GyrusMainAppPrivate *priv;
};

/*** Gyrus Main Application Class Data ***/
/*** derived from BonoboWindowClass ***/
struct _GyrusMainAppClass {
	BonoboWindowClass window_class;
};

#include "gyrus-session.h"
#include "gyrus-admin.h"

GType gyrus_main_app_get_type (void);
GtkWidget * gyrus_main_app_new (void);
GtkWidget * gyrus_main_app_append_page (GyrusMainApp *app,
					GyrusSession *session);
void gyrus_main_app_menu_set_sensitive (GyrusMainApp *app, gboolean sens);
GyrusAdmin *gyrus_main_app_get_current_admin (GyrusMainApp *app);
void gyrus_main_app_menu_item_set_sensitive (GyrusMainApp *app,
					     const gchar *command,
					     gboolean sensitive);
#endif /* GYRUS_MAIN_APP_H */
