// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_DATAHANDLER_H
#define _LIBGDAMM_DATAHANDLER_H


#include <glibmm.h>

// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* datahandler.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>
#include <libgdamm/value.h>
#include <libgda/gda-data-handler.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaDataHandler GdaDataHandler;
typedef struct _GdaDataHandlerClass GdaDataHandlerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class DataHandler_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{


class DataHandler : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataHandler CppObjectType;
  typedef DataHandler_Class CppClassType;
  typedef GdaDataHandler BaseObjectType;
  typedef GdaDataHandlerClass BaseClassType;

private:
  friend class DataHandler_Class;
  static CppClassType datahandler_class_;

  // noncopyable
  DataHandler(const DataHandler&);
  DataHandler& operator=(const DataHandler&);

protected:
  DataHandler(); // you must derive from this class
  explicit DataHandler(GdaDataHandler* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataHandler();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaDataHandler*       gobj()       { return reinterpret_cast<GdaDataHandler*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GdaDataHandler* gobj() const { return reinterpret_cast<GdaDataHandler*>(gobject_); }

private:

public:

  
  /** Creates a new string which is an SQL representation of the given value. If the value is <tt>0</tt> or
   * is of type GDA_TYPE_<tt>0</tt>, the returned string is <tt>0</tt>.
   * @param value The value to be converted to a string.
   * @return The new string.
   */
  Glib::ustring get_sql_from_value(const Value& value) const;
  
  /** Creates a new string which is a "user friendly" representation of the given value
   * (in the users's locale, specially for the dates). If the value is 
   * <tt>0</tt> or is of type GDA_TYPE_<tt>0</tt>, the returned string is a copy of "" (empty string).
   * @param value The value to be converted to a string.
   * @return The new string.
   */
  Glib::ustring get_str_from_value(const Value& value) const;

  // Hand-coded this to get proper return values
  
  Value get_value_from_sql(const Glib::ustring& sql, GType type) const;
  Value get_value_from_str(const Glib::ustring& str, GType type) const;
  Value get_sane_init_value(GType type) const;

  
  /** Get the number of GType types the GdaDataHandler can handle correctly
   * @return The number.
   */
  unsigned int get_nb_g_types() const;
  
  /** Checks wether the GdaDataHandler is able to handle the gda type given as argument.
   * @return <tt>true</tt> if the gda type can be handled.
   */
  bool accepts_g_type(GType type) const;
  
  /** Get the GType handled by the GdaDataHandler, at the given position (starting at zero).
   * @return The GType.
   */
  GType get_g_type_index(guint index) const;
  
  /** Get a short description of the GdaDataHandler
   * @return The description.
   */
  Glib::ustring get_descr() const;

protected:

  //TODO: Is this comment meant to be here, or is it just a copy/paste error? murrayc:
  //We don't wrap the vfuncs because they are only useful for creating new backends,
  //and they have a high code-size and per-object memory cost.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::DataHandler
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::DataHandler> wrap(GdaDataHandler* object, bool take_copy = false);

} // namespace Glib


#endif /* _LIBGDAMM_DATAHANDLER_H */

