// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_CLIENT_H
#define _LIBGDAMM_CLIENT_H


#include <glibmm.h>

/* $Id: client.hg,v 1.17 2006/12/23 09:29:35 murrayc Exp $ */
// -*- C++ -*- //

/* client.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/transactionstatus.h>
#include <libgdamm/connection.h>
//#include <libgda/gda-client.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaClient GdaClient;
typedef struct _GdaClientClass GdaClientClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Client_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** Exception class for Gda client errors.
 */
class ClientError : public Glib::Error
{
public:
  enum Code
  {
    CLIENT_GENERAL_ERROR
  };

  ClientError(Code error_code, const Glib::ustring& error_message);
  explicit ClientError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ClientError::Code> : public Glib::Value_Enum<Gnome::Gda::ClientError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum ClientEvent
{
  CLIENT_EVENT_INVALID,
  CLIENT_EVENT_ERROR,
  CLIENT_EVENT_CONNECTION_OPENED,
  CLIENT_EVENT_CONNECTION_CLOSED,
  CLIENT_EVENT_TRANSACTION_STARTED,
  CLIENT_EVENT_TRANSACTION_COMMITTED,
  CLIENT_EVENT_TRANSACTION_CANCELLED
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ClientEvent> : public Glib::Value_Enum<Gnome::Gda::ClientEvent>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


class ServerOperation;

/** Database client access.
 *
 * This class is the main entry point for libgda client applications. It provides the way by which client applications 
 * open connections. Thus, before using any other database-oriented function in libgda, applications must create a 
 * Client object and open the connections from it.
 *
 * The Client class also provides a way to treat several connections as if they were only one (a connection pool), which 
 * allows applications to, for instance, commit/rollback a transaction in all the connections being managed by a unique 
 * Client object, or obtain the list of all tables in all opened connections.
 *
 * Database creation and destruction is done through a Client object using the create_database() and 
 * drop_database() methods. Note however that depending on the provider, an opened connection may be required in order 
 * to create or destroy a database. 
 */

class Client : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Client CppObjectType;
  typedef Client_Class CppClassType;
  typedef GdaClient BaseObjectType;
  typedef GdaClientClass BaseClassType;

private:  friend class Client_Class;
  static CppClassType client_class_;

private:
  // noncopyable
  Client(const Client&);
  Client& operator=(const Client&);

protected:
  explicit Client(const Glib::ConstructParams& construct_params);
  explicit Client(GdaClient* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Client();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaClient*       gobj()       { return reinterpret_cast<GdaClient*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaClient* gobj() const { return reinterpret_cast<GdaClient*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaClient* gobj_copy();

private:

protected:
  Client();

public:
  
  static Glib::RefPtr<Client> create();

  
  /** This function is the way of opening database connections with libgda.
   * 
   * Establishes a connection to a data source. The connection will be opened
   * if no identical connection is available in the Gda::Client connection pool,
   * and re-used if available. If you dont want to share the connection,
   * specify Gda::CONNECTION_OPTIONS_DONT_SHARE as one of the flags in
   * the @a options  parameter.
   * 
   * The username and password used to actually open the connection are the first
   * non-<tt>0</tt> string being chosen by order from
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;the @a username  or @a password &lt;/listitem&gt;
   * &lt;listitem&gt;the username or password sprcified in the DSN definition&lt;/listitem&gt;
   * &lt;listitem&gt;the USERNAME= and PASSWORD= parts of the connection string in the DSN definition&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * @param dsn Data source name.
   * @param username User name or <tt>0</tt>.
   * @param password Password for @a username , or <tt>0</tt>.
   * @param options Options for the connection (see Gda::ConnectionOptions).
   * @param error A place to store an error, or <tt>0</tt>.
   * @return The opened connection if successful, <tt>0</tt> if there is
   * an error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<Connection> open_connection(const Glib::ustring& dsn, const Glib::ustring& username, const Glib::ustring& password, ConnectionOptions options = (ConnectionOptions)0);
#else
  Glib::RefPtr<Connection> open_connection(const Glib::ustring& dsn, const Glib::ustring& username, const Glib::ustring& password, ConnectionOptions options, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Opens a connection given a provider ID and a connection string. This
   * allows applications to open connections without having to create
   * a data source in the configuration. The format of @a cnc_string  is
   * similar to PostgreSQL and MySQL connection strings. It is a semicolumn-separated
   * series of key=value pairs. Do not add extra whitespace after the semicolumn
   * separator. The possible keys depend on the provider, but
   * these keys should work with all providers:
   * USER, PASSWORD, HOST, DATABASE, PORT
   * 
   * The username and password used to actually open the connection are the first
   * non-<tt>0</tt> string being chosen by order from
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;the @a username  or @a password &lt;/listitem&gt;
   * &lt;listitem&gt;the USERNAME= and PASSWORD= parts of the @a cnc_string &lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * @param provider_id Provider ID to connect to.
   * @param cnc_string Connection string.
   * @param username User name.
   * @param password Password for @a username .
   * @param options Options for the connection (see Gda::ConnectionOptions).
   * @param error A place to store an error, or <tt>0</tt>.
   * @return The opened connection if successful, <tt>0</tt> if there is
   * an error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<Connection> open_connection_from_string(const Glib::ustring& provider_id, const Glib::ustring& cnc_string, const Glib::ustring& username, const Glib::ustring& password, ConnectionOptions options = (ConnectionOptions)0);
#else
  Glib::RefPtr<Connection> open_connection_from_string(const Glib::ustring& provider_id, const Glib::ustring& cnc_string, const Glib::ustring& username, const Glib::ustring& password, ConnectionOptions options, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Declares the @a cnc  to @a client . This function should not be used directly
   * @param cnc A Gda::Connection object.
   */
  void declare_connection(const Glib::RefPtr<Connection>& cnc);

 //Use a special conversion here, because we should not own any part of the returned GList,
 //as specified by the gda_client_get_connections() documentation,
 // and because we need to unconst the GList.:
  

  /** Gets the list of all open connections in the given Gda::Client object.
   * The GList returned is an internal pointer, so DON'T TRY TO
   * FREE IT.
   * @return A GList of Gda::Connection objects; dont't modify that list.
   */
  Glib::ListHandle< Glib::RefPtr<Connection> > get_connections();
  
  /** Gets the list of all open connections in the given Gda::Client object.
   * The GList returned is an internal pointer, so DON'T TRY TO
   * FREE IT.
   * @return A GList of Gda::Connection objects; dont't modify that list.
   */
  Glib::ListHandle< Glib::RefPtr<const Connection> > get_connections() const;
   
  
  /** Looks for an open connection given a data source name (per libgda
   * configuration), a username and a password.
   * 
   * This function iterates over the list of open connections in the
   * given Gda::Client and looks for one that matches the given data source
   * name, username and password.
   * @param dsn Data source name.
   * @param username User name.
   * @param password Password for @a username .
   * @return A pointer to the found connection, or <tt>0</tt> if it could not
   * be found.
   */
  Glib::RefPtr<Connection> find_connection(const Glib::ustring& dsn, const Glib::ustring& username, const Glib::ustring& password);
  
  /** Closes all connections opened by the given Gda::Client object.
   */
  void close_all_connections();

  
  /** Notifies an event to the given Gda::Client's listeners. The event can be
   * anything (see Gda::ClientEvent) ranging from a connection opening
   * operation, to changes made to a table in an underlying database.
   * @param cnc A Gda::Connection object where the event has occurred.
   * @param event Event ID.
   * @param params Parameters associated with the event.
   */
  void notify_event(const Glib::RefPtr<Connection>& cnc, ClientEvent event, const Glib::RefPtr<ParameterList>& params);

  //TODO: Wrap GdaConnectionEvent as exception?
  
  /** Notifies the given Gda::Client of the Gda::CLIENT_EVENT_ERROR event.
   * @param cnc A Gda::Connection object.
   * @param error The error to be notified.
   */
  void notify_error_event(const Glib::RefPtr<Connection>& cnc, GdaConnectionEvent *error);
  
  /** Notifies the given Gda::Client of the Gda::CLIENT_EVENT_CONNECTION_OPENED 
   * event.
   * @param cnc A Gda::Connection object.
   */
  void notify_connection_opened_event(const Glib::RefPtr<Connection>& cnc);
  
  /** Notifies the given Gda::Client of the Gda::CLIENT_EVENT_CONNECTION_CLOSED 
   * event.
   * @param cnc A Gda::Connection object.
   */
  void notify_connection_closed_event(const Glib::RefPtr<Connection>& cnc);

  
  /** Get an XML string representing the parameters which can be present in the
   * DSN string used to open a connection.
   * @param provider A provider.
   * @return A string (free it after usage), or <tt>0</tt> if an error occurred.
   */
  Glib::ustring get_dsn_specs(const Glib::ustring& provider) const;

  
  /** Creates a new Gda::ServerOperation object which contains the specifications required
   * to create a database. Once these specifications provided, use 
   * perform_create_database() to perform the database creation.
   * 
   * If @a db_name  is left <tt>0</tt>, then the name of the database to create will have to be set in the
   * returned Gda::ServerOperation using Gda::ServerOperation::set_value_at().
   * @param db_name The name of the database to create, or <tt>0</tt>.
   * @param provider A provider.
   * @return New Gda::ServerOperation object, or <tt>0</tt> if the provider does not support database
   * creation.
   */
  Glib::RefPtr<ServerOperation> prepare_create_database(const Glib::ustring& db_name, const Glib::ustring& provider);
  
  /** Creates a new database using the specifications in @a op , which must have been obtained using
   * prepare_create_database()
   * @param op A Gda::ServerOperation object obtained using prepare_create_database().
   * @param error A place to store en error, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred and the database has been created.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool perform_create_database(const Glib::RefPtr<ServerOperation>& op);
#else
  bool perform_create_database(const Glib::RefPtr<ServerOperation>& op, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Creates a new Gda::ServerOperation object which contains the specifications required
   * to drop a database. Once these specifications provided, use 
   * perform_drop_database() to perform the database creation.
   * 
   * If @a db_name  is left <tt>0</tt>, then the name of the database to drop will have to be set in the
   * returned Gda::ServerOperation using Gda::ServerOperation::set_value_at().
   * @param db_name The name of the database to drop, or <tt>0</tt>.
   * @param provider A provider.
   * @return New Gda::ServerOperation object, or <tt>0</tt> if the provider does not support database
   * destruction.
   */
  Glib::RefPtr<ServerOperation> prepare_drop_database(const Glib::ustring& db_name, const Glib::ustring& provider);
  
  /** Destroys an existing database using the specifications in @a op ,  which must have been obtained using
   * prepare_drop_database()
   * @param op A Gda::ServerOperation object obtained using prepare_drop_database().
   * @param error A place to store en error, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred and the database has been destroyed.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool perform_drop_database(const Glib::RefPtr<ServerOperation>& op);
#else
  bool perform_drop_database(const Glib::RefPtr<ServerOperation>& op, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Starts a transaction on all connections being managed by the given
   * Gda::Client. It is important to note that this operates on all
   * connections opened within a Gda::Client, which could not be what
   * you're looking for.
   * 
   * To execute a transaction on a unique connection, use
   * #gda_connection_begin_transaction, #gda_connection_commit_transaction
   * and #gda_connection_rollback_transaction.
   * @param name The name of the transation to start.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if all transactions could be started successfully,
   * or <tt>false</tt> if one of them fails.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool begin_transaction(const Glib::ustring& name, TransactionIsolation level);
#else
  bool begin_transaction(const Glib::ustring& name, TransactionIsolation level, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Commits a running transaction on all connections being managed by the given
   * Gda::Client. It is important to note that this operates on all
   * connections opened within a Gda::Client, which could not be what
   * you're looking for.
   * 
   * To execute a transaction on a unique connection, use
   * #gda_connection_begin_transaction, #gda_connection_commit_transaction
   * and #gda_connection_rollback_transaction.
   * @param name The name of the transation to commit.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if all transactions could be committed successfully,
   * or <tt>false</tt> if one of them fails.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool commit_transaction(const Glib::ustring& name);
#else
  bool commit_transaction(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Cancels a running transaction on all connections being managed by the given
   * Gda::Client. It is important to note that this operates on all
   * connections opened within a Gda::Client, which could not be what
   * you're looking for.
   * 
   * To execute a transaction on a unique connection, use
   * #gda_connection_begin_transaction, #gda_connection_commit_transaction
   * and #gda_connection_rollback_transaction.
   * @param name The name of the transation to rollback.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if all transactions could be cancelled successfully,
   * or <tt>false</tt> if one of them fails.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool rollback_transaction(const Glib::ustring& name);
#else
  bool rollback_transaction(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


/**
   * @par Prototype:
   * <tt>void %event_notification(const Glib::RefPtr<Connection>& cnc, ClientEvent event, const Glib::RefPtr<ParameterList>& params)</tt>
   */

  Glib::SignalProxy3< void,const Glib::RefPtr<Connection>&,ClientEvent,const Glib::RefPtr<ParameterList>& > signal_event_notification();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_event_notification(const Glib::RefPtr<Connection>& cnc, ClientEvent event, const Glib::RefPtr<ParameterList>& params);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::Client
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::Client> wrap(GdaClient* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_CLIENT_H */

