// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_PARAMETER_H
#define _LIBGDAMM_PARAMETER_H


#include <glibmm.h>

/* $Id: parameter.hg,v 1.12 2006/11/08 01:42:01 murrayc Exp $ */
// -*- C++ -*- //

/* parameter.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/object.h>
#include <libgdamm/value.h>
#include <libgdamm/entityfield.h>
#include <libgdamm/referer.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaParameter GdaParameter;
typedef struct _GdaParameterClass GdaParameterClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Parameter_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** Exception class for Gda parameter errors.
 */
class ParameterError : public Glib::Error
{
public:
  enum Code
  {
    PARAMETER_QUERY_LIMIT_ERROR
  };

  ParameterError(Code error_code, const Glib::ustring& error_message);
  explicit ParameterError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ParameterError::Code> : public Glib::Value_Enum<Gnome::Gda::ParameterError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


class DataModel;

/** Represents a Value with various attributes.
 *
 * @ingroup DataModels
 */

class Parameter
  : public Object,
    public Referer
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Parameter CppObjectType;
  typedef Parameter_Class CppClassType;
  typedef GdaParameter BaseObjectType;
  typedef GdaParameterClass BaseClassType;

private:  friend class Parameter_Class;
  static CppClassType parameter_class_;

private:
  // noncopyable
  Parameter(const Parameter&);
  Parameter& operator=(const Parameter&);

protected:
  explicit Parameter(const Glib::ConstructParams& construct_params);
  explicit Parameter(GdaParameter* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Parameter();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaParameter*       gobj()       { return reinterpret_cast<GdaParameter*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaParameter* gobj() const { return reinterpret_cast<GdaParameter*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaParameter* gobj_copy();

private:

  
protected:

  Parameter();

  Parameter(const Glib::ustring& name, const Value& value);
  
  Parameter(const Glib::ustring& name, bool value);
  
  Parameter(const Glib::ustring& name, const Glib::ustring& value);
  

  // Parameter("foo", "bar") calls Parameter(ustring, bool) without this.
  Parameter(const Glib::ustring& name, const char* value);

public:
  
  static Glib::RefPtr<Parameter> create();

  
  static Glib::RefPtr<Parameter> create(const Glib::ustring& name, bool value);
;
  
  static Glib::RefPtr<Parameter> create(const Glib::ustring& name, const Glib::ustring& value);
;
  
  static Glib::RefPtr<Parameter> create(const Glib::ustring& name, const gchar* value);
;

  typedef Glib::SListHandle< Glib::RefPtr<EntityField> > ListHandleEntityField; 
   

  Value get_value() const;
  

  /** Copy constructor.
   * @return A new Gda::Parameter object.
   */
  Glib::RefPtr<Parameter> copy() const;
  
  
  /** Get a new string containing a "clean" version of @a param 's name: chars which
   * are not among [0-9A-Za-z] are replaced with '_'.
   * @return A new string.
   */
  Glib::ustring get_alphanum_name() const;
  
  
  /** Get the requested data type for @a param .
   * @return The data type.
   */
  GType get_g_type() const;

  
  void set_value(const Value& value);
  
  /** Same function as set_value() except that the value
   * is provided as a string, and may return <tt>false</tt> if the string did not
   * represent a correct value for the data type of the parameter.
   * @param value A value to set the parameter to, as a string.
   * @return <tt>true</tt> if no error occurred.
   */
  bool set_value(const Glib::ustring& value);


  /** Forces a parameter to be invalid; to set it valid again, a new value must be assigned
   * to it using set_value().
   */
  void declare_invalid();
  
  /** Get the validity of @a param  (that is, of the value held by @a param )
   * @return <tt>true</tt> if @a param 's value can safely be used.
   */
  bool is_valid() const;

  Value get_default_value() const;
  

  void set_default_value(const Value& value);
  
  /** 
   * @return <tt>true</tt> if @a param  has a default value (which may be unspecified).
   */
  bool get_exists_default_value();
  
  /** Tells if @a param  has default unspecified value. This function is usefull
   * if one wants to inform that @a param  has a default value but does not know
   * what that default value actually is.
   */
  void set_exists_default_value(bool default_value_exists = true);

  
  /** Sets if the parameter can have a <tt>0</tt> value. If @a not_null  is <tt>true</tt>, then that won't be allowed
   */
  void set_not_null(bool not_null = true);
  
  /** Get wether the parameter can be <tt>0</tt> or not
   * @return <tt>true</tt> if the parameter cannot be <tt>0</tt>.
   */
  bool get_not_null() const;

  
  /** Sets a limit on the possible values for the @a param  parameter: the value must be among the values
   * contained in the @a col  column of the @a model  data model.
   * @param model A Gda::DataModel object or <tt>0</tt>.
   * @param col The reference column in @a model .
   * @param error Location to store error, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool restrict_values(const Glib::RefPtr<DataModel>& model, int col);
#else
  bool restrict_values(const Glib::RefPtr<DataModel>& model, int col, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  bool has_restrict_values() const;
  bool has_restrict_values(Glib::RefPtr<DataModel>& model, int& col) const;
  

  /** Sets @a param  to change when @a bind_to  changes (and does not make @a bind_to  change when @a param  changes)
   * @param bind_to A Gda::Parameter or <tt>0</tt>.
   */
  void bind_to_param(const Glib::RefPtr<Parameter>& bind_to);

  
  /** Get the parameter which makes @a param  change its value when the param's value is changed.
   * @return The Gda::Parameter or <tt>0</tt>.
   */
  Glib::RefPtr<Parameter> get_bind_param();
  
  /** Get the parameter which makes @a param  change its value when the param's value is changed.
   * @return The Gda::Parameter or <tt>0</tt>.
   */
  Glib::RefPtr<const Parameter> get_bind_param() const;

  
  // Hand-code because it might return NULL;
  // TODO: That shouldn't be a problem. murrayc
  Glib::ustring get_value_str() const;

   
  /** Get the Gda::EntityField objects which created @a param  (and which will use its value)
   * @return The list of Gda::EntityField object; it must not be changed or free'd.
   */
  Glib::SListHandle<Glib::RefPtr<EntityField> > get_param_users();;
  
  /** Get the Gda::EntityField objects which created @a param  (and which will use its value)
   * @return The list of Gda::EntityField object; it must not be changed or free'd.
   */
  Glib::SListHandle<Glib::RefPtr<const EntityField> > get_param_users() const;;

  // TODO: How to wrap GHashTable?
  //_WRAP_METHOD(void replace_param_users(GHashTable* param), gda_parameter_replace_param_users)

  
  /** Tells that @a user  is potentially using @a param .
   * @param user The Gda::Object object using that parameter for.
   */
  void declare_param_user(const Glib::RefPtr<Object>& user);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<GType> property_g_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_entry_plugin() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_entry_plugin() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_default_value() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_default_value() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_not_null() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_not_null() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Parameter> > property_simple_bind() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Parameter> > property_simple_bind() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Parameter> > property_full_bind() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Parameter> > property_full_bind() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<DataModel> > property_restrict_model() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DataModel> > property_restrict_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_restrict_column() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_restrict_column() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


/**
   * @par Prototype:
   * <tt>void %restrict_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_restrict_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_restrict_changed();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::Parameter
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::Parameter> wrap(GdaParameter* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_PARAMETER_H */

