// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_BLOBOP_H
#define _LIBGDAMM_BLOBOP_H


#include <glibmm.h>

// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* blob-op.h
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaBlobOp GdaBlobOp;
typedef struct _GdaBlobOpClass GdaBlobOpClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class BlobOp_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class Blob;

/** Blobs handling. 
 * This object is a base class for individual database providers which support BLOB types.
 * It supports operations to read and write data in a BLOB.
 */

class BlobOp : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BlobOp CppObjectType;
  typedef BlobOp_Class CppClassType;
  typedef GdaBlobOp BaseObjectType;
  typedef GdaBlobOpClass BaseClassType;

private:  friend class BlobOp_Class;
  static CppClassType blobop_class_;

private:
  // noncopyable
  BlobOp(const BlobOp&);
  BlobOp& operator=(const BlobOp&);

protected:
  explicit BlobOp(const Glib::ConstructParams& construct_params);
  explicit BlobOp(GdaBlobOp* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BlobOp();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaBlobOp*       gobj()       { return reinterpret_cast<GdaBlobOp*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaBlobOp* gobj() const { return reinterpret_cast<GdaBlobOp*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaBlobOp* gobj_copy();

private:

  
  protected:
    BlobOp();
  
  public:
    
  static Glib::RefPtr<BlobOp> create();

    
  /** Opens an existing BLOB. The BLOB must be initialized by
   * #gda_connection_create_blob or obtained from a G::Value.
   * FIXME: gda_connection_create_blob() no longer exists.
   * @return The length of the blob in bytes. In case of error, -1 is returned and the
   * provider should have added an error (a Gda::ConnectionEvent) to the connection.
   */
  long get_length() const;
    
  /** Reads a chunk of bytes from the BLOB into @a blob .
   * @param blob A Gda::Blob to read data to.
   * @param offset Offset to read from the start of the blob (starts at 0).
   * @param size Maximum number of bytes to read.
   * @return The number of bytes actually read. In case of error, -1 is returned and the
   * provider should have added an error to the connection.
   */
  long read(Blob& blob, long offset, long size);
    
  /** Writes a chunk of bytes from a @a blob  to the BLOB accessible through @a op .
   * @param blob A Gda::Blob which contains the data to write.
   * @param offset Offset to write from the start of the blob (starts at 0).
   * @return The number of bytes written. In case of error, -1 is returned and the
   * provider should have added an error to the connection.
   */
  long write(Blob& blob, long offset);
    
  /** Reads the whole contents of the blob manipulated by @a op  into @a blob 
   * @param blob A Gda::Blob to read data to.
   * @return <tt>true</tt> if @a blob -&gt;data contains the whole BLOB manipulated by @a op .
   */
  bool read_all(Blob& blob);
    
  /** Writes the whole contents of @a blob  into the blob manipulated by @a op . If necessary the resulting
   * blob is truncated from its previous length.
   * @param blob A Gda::Blob which contains the data to write.
   * @return <tt>true</tt> on success.
   */
  bool write_all(Blob& blob);
    
    // vfuncs are not wrapped!


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda

} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::BlobOp
   */
  Glib::RefPtr<Gnome::Gda::BlobOp> wrap(GdaBlobOp* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_BLOBOP_H */

