/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 8-*- */

/*This file is part of GNU MlView
 *
 *GNU MlView is free software; 
 *you can redistribute it and/or modify it under the terms of 
 *the GNU General Public License as published by 
 *the Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will be useful, 
 *but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the GNU General 
 *Public License along with MlView; 
 *see the file COPYING. If not, write to the 
 *Free Software Foundation, Inc., 59 
 *Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *Copyright 2001-2002 Dodji Seketeli, Gal Chamoulaud.
 *http://www.freespiders.org
 */

#ifndef __MLVIEW_APP_CONTEXT_H__
#  define __MLVIEW_APP_CONTEXT_H__


#  include <gnome.h>
#  include <libxml/parser.h>
#  include <libxml/catalog.h>

#  include "mlview-file-selection.h"


/**
 *@file
 *#MlViewAppContext class declaration file.
 */
G_BEGIN_DECLS
#  define NEW 1
#  ifndef NEW
#    define MLVIEW_TYPE_APP_CONTEXT (mlview_app_context_get_type())
#    define MLVIEW_APP_CONTEXT(object) (GTK_CHECK_CAST((object), MLVIEW_TYPE_APP_CONTEXT,MlViewAppContext))
#    define MLVIEW_APP_CONTEXT_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), MLVIEW_TYPE_APP_CONTEXT,MlViewContextClass))
#    define MLVIEW_IS_APP_CONTEXT(object) (GTK_CHECK_TYPE((object), MLVIEW_TYPE_APP_CONTEXT))
#    define MLVIEW_IS_APP_CONTEXT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), MLVIEW_TYPE_APP_CONTEXT))
typedef struct _MlViewAppContext MlViewAppContext;
typedef struct _MlViewAppContextClass MlViewAppContextClass;
typedef struct _MlVAppContextPrivate MlVAppContextPrivate;

/**
 *MlViewAppContext objects structure.
 *This structure describes the data members
 *of each instance of MlViewAppContext.
 */
struct _MlViewAppContext {
 /**
	 *The member stucture of
         *MlViewAppContext's parent class.
         */
        GObject object;
        /**
         *The private members of MlViewAppContext.
         */
        MlVAppContextPrivate *private;
};

/**
 *MlViewAppContext class structure.
 *The class inherits GtkObjects.
 */
struct _MlViewAppContextClass {
        /**
         *The class structure of the parent
         *class of MlViewAppContext.
         */
        GObjectClass parent_class;
};

guint mlview_app_context_get_type (void);

gint *mlview_app_context_get_last_id_ptr (MlViewAppContext *
                                          a_app_context);

gint
mlview_app_context_get_last_id (MlViewAppContext *
                                a_app_context);

void
 mlview_app_context_set_last_id (MlViewAppContext * a_app_context,
                                 gint a_new_id);

void
 mlview_app_context_set_element (MlViewAppContext * a_context,
                                 const gchar * a_element_name,
                                 gpointer a_context_element);

gpointer
mlview_app_context_get_element (MlViewAppContext * a_context,
                                const gchar * a_element_name);

MlViewAppContext *mlview_app_context_get_instance (void);

/*display a message in the app bar*/
void
 mlview_app_context_sbar_push_message (MlViewAppContext * a_context,
                                       gchar * a_msg_format,
                                       ...);

void
 mlview_app_context_sbar_pop_message (MlViewAppContext * a_context);

void
 mlview_app_context_sbar_set_default_message (MlViewAppContext * a_context,
                                              const gchar *
                                              a_msg_format, ...);

void
 mlview_app_context_message (MlViewAppContext * a_context,
                             const gchar * a_msg_format, ...);

void
 mlview_app_context_error (MlViewAppContext * a_context,
                           const gchar * a_msg_format, ...);

void
 mlview_app_context_warning (MlViewAppContext * a_context,
                             const gchar * a_msg_format, ...);

void mlview_app_context_bufferize_error (MlViewAppContext *
                                         a_context,
                                         const gchar *
                                         a_msg_format, ...);
void
 mlview_app_context_display_buffered_error (MlViewAppContext * a_context);

gboolean
mlview_app_context_error_buffer_is_empty (MlViewAppContext *
                                          a_context);

void
 mlview_app_context_set_error_dialog_title (MlViewAppContext * a_context,
                                            gchar * a_title);

gchar *mlview_app_context_get_error_dialog_title
        (MlViewAppContext * a_context);

void
 mlview_app_context_set_settings_hash_table (MlViewAppContext * a_context,
                                             GHashTable *
                                             a_settings);

GHashTable
        * mlview_app_context_get_settings_hash_table
        (MlViewAppContext * a_context);

gboolean
mlview_app_context_settings_exist (MlViewAppContext *
                                   a_app_context);

gchar *mlview_app_context_get_settings_value (MlViewAppContext *
                                              a_app_context,
                                              const gchar *
                                              a_key);

void
 mlview_app_context_set_settings_value (MlViewAppContext * a_app_context,
                                        const gchar * a_key,
                                        const gchar * a_value);

MlViewFileSelection
        *
mlview_app_context_get_file_selector (MlViewAppContext *
                                      a_app_context,
                                      const gchar * a_title);

void
 mlview_app_context_set_window_icon (MlViewAppContext * a_app_context,
                                     GtkWidget * a_widget);

void
 mlview_app_context_set_window_transient_for_app (MlViewAppContext * a_app_context,
                                                  GtkWindow *
                                                  a_window);

gint
mlview_app_context_get_xpm (MlViewAppContext * a_app_context,
                            const gchar * a_xpm_name,
                            GdkPixmap ** a_pixmap,
                            GdkBitmap ** a_bitmap);

void
 mlview_app_context_set_xml_catalog (MlViewAppContext * a_app_context,
                                     xmlCatalog * a_xml_catalog);

xmlCatalog *mlview_app_context_get_xml_catalog (MlViewAppContext
                                                * a_app_context);

#  else
#    define MLVIEW_TYPE_APP_CONTEXT (mlview_app_context_get_type())
#    define MLVIEW_APP_CONTEXT(object) (G_TYPE_CHECK_INSTANCE_CAST((object), MLVIEW_TYPE_APP_CONTEXT, MlViewAppContext))
#    define MLVIEW_APP_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), MLVIEW_TYPE_APP_CONTEXT, MlViewContextClass))
#    define MLVIEW_IS_APP_CONTEXT(object) (G_TYPE_CHECK_INSTANCE_TYPE((object), MLVIEW_TYPE_APP_CONTEXT))
#    define MLVIEW_IS_APP_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), MLVIEW_TYPE_APP_CONTEXT))
typedef struct _MlViewAppContext MlViewAppContext;
typedef struct _MlViewAppContextClass MlViewAppContextClass;
typedef struct _MlVAppContextPrivate MlVAppContextPrivate;

/**
 *MlViewAppContext objects structure.
 *This structure describes the data members
 *of each instance of MlViewAppContext.
 */
struct _MlViewAppContext {
 /**
	 *The member stucture of
         *MlViewAppContext's parent class.
         */
        GObject object;

        /**
         *The private members of MlViewAppContext.
         */
        MlVAppContextPrivate *private;
};

/**
 *MlViewAppContext class structure.
 *The class inherits GtkObjects.
 */
struct _MlViewAppContextClass {
        /**
         *The class structure of the parent
         *class of MlViewAppContext.
         */
        GObjectClass parent_class;
};

guint mlview_app_context_get_type (void);

gint *mlview_app_context_get_last_id_ptr (MlViewAppContext *
                                          a_app_context);

gint
mlview_app_context_get_last_id (MlViewAppContext *
                                a_app_context);

void
 mlview_app_context_set_last_id (MlViewAppContext * a_app_context,
                                 gint a_new_id);

void
 mlview_app_context_set_element (MlViewAppContext * a_context,
                                 const gchar * a_element_name,
                                 gpointer a_context_element);

gpointer
mlview_app_context_get_element (MlViewAppContext * a_context,
                                const gchar * a_element_name);

MlViewAppContext *mlview_app_context_get_instance (void);

/*display a message in the app bar*/
void
 mlview_app_context_sbar_push_message (MlViewAppContext * a_context,
                                       const gchar *
                                       a_msg_format, ...);

void
 mlview_app_context_sbar_pop_message (MlViewAppContext * a_context);

void
 mlview_app_context_sbar_set_default_message (MlViewAppContext * a_context,
                                              const gchar *
                                              a_msg_format, ...);

void
 mlview_app_context_message (MlViewAppContext * a_context,
                             const gchar * a_msg_format, ...);

void
 mlview_app_context_error (MlViewAppContext * a_context,
                           const gchar * a_msg_format, ...);

void
 mlview_app_context_warning (MlViewAppContext * a_context,
                             const gchar * a_msg_format, ...);

void mlview_app_context_bufferize_error (MlViewAppContext *
                                         a_context,
                                         const gchar *
                                         a_msg_format, ...);
void
 mlview_app_context_display_buffered_error (MlViewAppContext * a_context);

gboolean
mlview_app_context_error_buffer_is_empty (MlViewAppContext *
                                          a_context);

void
 mlview_app_context_set_error_dialog_title (MlViewAppContext * a_context,
                                            const gchar *
                                            a_title);

gchar *mlview_app_context_get_error_dialog_title
        (MlViewAppContext * a_context);

void
 mlview_app_context_set_settings_hash_table (MlViewAppContext * a_context,
                                             GHashTable *
                                             a_settings);

GHashTable
        * mlview_app_context_get_settings_hash_table
        (MlViewAppContext * a_context);

gboolean
mlview_app_context_settings_exist (MlViewAppContext *
                                   a_app_context);

gchar *mlview_app_context_get_settings_value (MlViewAppContext *
                                              a_app_context,
                                              const gchar *
                                              a_key);

void
 mlview_app_context_set_settings_value (MlViewAppContext * a_app_context,
                                        const gchar * a_key,
                                        const gchar * a_value);

MlViewFileSelection
        *
mlview_app_context_get_file_selector (MlViewAppContext *
                                      a_app_context,
                                      const gchar * a_title);

void
 mlview_app_context_set_window_icon (MlViewAppContext * a_app_context,
                                     GtkWindow * a_widget);

void
 mlview_app_context_set_window_transient_for_app (MlViewAppContext * a_app_context,
                                                  GtkWindow *
                                                  a_window);

gint
mlview_app_context_get_xpm (MlViewAppContext * a_app_context,
                            const gchar * a_xpm_name,
                            GdkPixmap ** a_pixmap,
                            GdkBitmap ** a_bitmap);

void
 mlview_app_context_set_xml_catalog (MlViewAppContext * a_app_context,
                                     xmlCatalog * a_xml_catalog);

xmlCatalog *mlview_app_context_get_xml_catalog (MlViewAppContext
                                                * a_app_context);

#  endif

G_END_DECLS
#endif /*__MLVIEW-APP-CONTEXT_H__*/
