/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 8-*- */

/*
 *This file is part of MlView
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published 
 *by the Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *MlView is distributed in the hope that it 
 *will be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. If not, write to the 
 *Free Software Foundation, Inc., 59 Temple Place 
 *- Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2002 Dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

#ifndef __MLVIEW_FILE_DESCRIPTOR_H__
#  define __MLVIEW_FILE_DESCRIPTOR_H__

#  include <gnome.h>

/**
 *@file
 *The declarations of #MlViewFileDescriptor class.
 */
typedef struct _MlViewFileDescriptor MlViewFileDescriptor;
typedef struct _MlViewFileDescriptorPrivate
 MlViewFileDescriptorPrivate;

/**
 *An abstraction of a file.
 *
 *This class is an encapsulation (at least for future portability issues)
 *of a file handle. All the access to file system (either local or remote)
 *should be made via the apis exposed by this object. The api is far 
 *from being complete but MlView uses it to have infos about the local files.
 */
struct _MlViewFileDescriptor {
        MlViewFileDescriptorPrivate *private;
};

MlViewFileDescriptor *mlview_file_descriptor_new (const gchar *
                                                  a_file_path);

void
 mlview_file_descriptor_destroy (MlViewFileDescriptor * a_file_desc);

gchar *mlview_file_descriptor_get_file_path (const
                                             MlViewFileDescriptor
                                             * a_file_desc);

enum MLVIEW_FILE_DESCRIPTOR_STATUS
 mlview_file_descriptor_fetch_file (MlViewFileDescriptor * a_file_desc,
                                    const gchar * a_file_path);
void
 mlview_file_descriptor_set_file_path (MlViewFileDescriptor * a_file_desc,
                                       gchar * file_path);

guint
mlview_file_descriptor_get_lmd (const MlViewFileDescriptor *
                                a_file_desc);

void
 mlview_file_descriptor_set_lmd (MlViewFileDescriptor * a_file_desc,
                                 guint a_last_modified_time);

void
 mlview_file_descriptor_update_modified_time (MlViewFileDescriptor * a_file_desc);

gint
mlview_file_descriptor_is_modified (const MlViewFileDescriptor *
                                    a_file_desc,
                                    gboolean * a_is_modified);

gint
mlview_file_descriptor_is_readable (const MlViewFileDescriptor *
                                    a_file_desc,
                                    gboolean * a_is_readable);

gint
mlview_file_descriptor_is_writeable (const MlViewFileDescriptor *
                                     a_file_desc,
                                     gboolean * a_is_writeable);

gint
mlview_file_descriptor_is_dir (const MlViewFileDescriptor *
                               a_file_desc, gboolean * a_is_dir);

gint mlview_file_descriptor_is_regular_file (const
                                             MlViewFileDescriptor
                                             * a_file_desc,
                                             gboolean *
                                             a_is_reg);

gint
mlview_file_descriptor_create_directory (MlViewFileDescriptor *
                                         a_file_desc,
                                         guint a_mode);

gint
mlview_file_descriptor_create_file (MlViewFileDescriptor *
                                    a_file_desc, guint a_mode);

gint
mlview_file_descriptor_is_local (MlViewFileDescriptor *
                                 a_file_desc,
                                 gboolean * a_is_local);
#endif
