/* -*- Mode: C; indent-tabs-mode:nil; c-basic-offset: 8-*- */
/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *See COPYRIGHT file for copyright information.
 */

#ifndef __MLVIEW_TREE_VIEW_H__
#define __MLVIEW_TREE_VIEW_H__

#include <libxml/tree.h>
#include "mlview-tree-editor2.h"
#include "mlview-node-editor.h"
#include "mlview-app-context.h"
#include "mlview-view-adapter.h"
#include "mlview-action.h"

/**
 *@file
 *The declaration of the #MlViewTreeView class.
 */

G_BEGIN_DECLS
#define MLVIEW_TYPE_TREE_VIEW (mlview_tree_view_get_type ())
#define MLVIEW_TREE_VIEW(widget) (G_TYPE_CHECK_INSTANCE_CAST ((widget), MLVIEW_TYPE_TREE_VIEW, MlViewTreeView))
#define MLVIEW_TREE_VIEW_CLASS(widget) (G_TYPE_CHECK_CLASS_CAST ((widget), MLVIEW_TYPE_TREE_VIEW, MlViewTreeViewClass))
#define MLVIEW_IS_TREE_VIEW(widget) (G_TYPE_CHECK_INSTANCE_TYPE ((widget),MLVIEW_TYPE_TREE_VIEW))
#define MLVIEW_IS_TREE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MLVIEW_TYPE_TREE_VIEW))
typedef struct _MlViewTreeView MlViewTreeView;
typedef struct _MlViewTreeViewClass MlViewTreeViewClass;
typedef struct _MlViewTreeViewPrivate MlViewTreeViewPrivate;

/**
 *The #MlViewTreeView class.
 *This is the default tree view editing view
 *of MlView. It inherits the #MlViewViewAdapter class.
 */
struct _MlViewTreeView {
        MlViewViewAdapter view;
        MlViewTreeViewPrivate *priv;
};

struct _MlViewTreeViewClass {
        MlViewViewAdapterClass parent_class;

        /*signal default handlers */
        void (*document_changed) (MlViewTreeView *
                                  tree_view, gpointer a_data);
};

GType mlview_tree_view_get_type (void);

GtkWidget *mlview_tree_view_new (MlViewXMLDocument *a_doc,
                                 gchar * a_name,
                                 MlViewAppContext *a_app_ctxt);

void mlview_tree_view_set_app_context (MlViewTreeView * a_tree_view,
                                       MlViewAppContext * a_app_ctxt);

enum MlViewStatus mlview_tree_view_get_app_context (MlViewTreeView *a_this,
                                                    MlViewAppContext **a_app_context_ptr) ;

MlViewTreeEditor2 * mlview_tree_view_get_tree_editor (MlViewTreeView * a_tree_view);

MlViewNodeEditor * mlview_tree_view_get_node_editor (MlViewTreeView * a_tree_view);

GtkNotebook *
mlview_tree_view_get_trees (MlViewTreeView *a_this) ;

void mlview_tree_view_construct (MlViewTreeView * a_tree_view,
                                 MlViewXMLDocument *a_doc,
                                 gchar * a_name,
                                 MlViewAppContext *a_app_ctxt) ;

enum MlViewStatus mlview_tree_view_create_internal_subset_node_interactive (MlViewTreeView *a_this) ;

void mlview_tree_view_add_child_node_interactive (MlViewTreeView * a_this);

void mlview_tree_view_insert_sibling_node_interactive (MlViewTreeView * a_this);

void mlview_tree_view_insert_prev_sibling_node_interactive (MlViewTreeView * a_this);

void mlview_tree_view_insert_next_sibling_node_interactive (MlViewTreeView * a_this);

void mlview_tree_view_cut_node (MlViewTreeView * a_this);

void mlview_tree_view_copy_node (MlViewTreeView * a_this);

void mlview_tree_view_paste_node_as_child (MlViewTreeView * a_this);

void mlview_tree_view_paste_node_as_prev_sibling (MlViewTreeView * a_this);

void mlview_tree_view_paste_node_as_next_sibling (MlViewTreeView * a_this);

void mlview_tree_view_set_upper_paned1_proportions (MlViewTreeView * a_this,
                                                    const guint a_percentage);

void mlview_tree_view_find_xml_node_that_contains_str_interactive (MlViewTreeView * a_this)  ;

void mlview_tree_view_set_main_paned_proportions (MlViewTreeView * a_this,
                                                  const guint a_percentage);

void mlview_tree_view_set_all_paned_proportions (MlViewTreeView * a_this,
                                                 const guint a_main_paned_percentage,
                                                 const guint a_node_editor_paned_percentage);

void mlview_tree_view_set_xml_document_path (MlViewTreeView * a_view,
                                             gchar * a_file_path);

void mlview_tree_view_expand_tree_to_depth_interactive (MlViewTreeView * a_view);

enum MlViewStatus mlview_tree_view_get_contextual_menu (MlViewTreeView *a_this, 
                                                        GtkMenu **a_menu_ptr) ;

void mlview_tree_view_update_contextual_menu (MlViewTreeView * a_view,
                                              GtkMenu ** a_menu_ptr);

G_END_DECLS
#endif
