// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 4 -*-

/*
 *  PaperBox - main-window.hh
 *
 *  Copyright (C) 2007 Marko Anastasov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __PAPER_BOX_MAIN_WINDOW__
#define __PAPER_BOX_MAIN_WINDOW__

#include <boost/shared_ptr.hpp>
#include <gtkmm/box.h>
#include <gtkmm/paned.h>
#include <gtkmm/window.h>
#include <gtk/gtkwindow.h>
#include <libglademm.h>
#include <gtkmm-utils/tile.h>
#include "document-tile-view.hh"
#include "tag-cloud-model.hh"
#include "tag-cloud.hh"
#include "tile-set.hh"
#include "thumbnailer.hh"

namespace paperbox {

    class Browser;
    class Document;

    class MainWindow : public Gtk::Window
    {
    public:
        explicit MainWindow(GtkWindow* cobject,
                            const Glib::RefPtr<Gnome::Glade::Xml>& glade);
        virtual ~MainWindow();

        static MainWindow* create();

    protected:
        void init_gui();
        void get_widgets_from_ui_file();
        void set_up_tiles();
        void set_pane_pos();

        void connect_signals();

        void render_new_tile_set(
            const std::vector<boost::shared_ptr<Document> >& docs);

        /*** Signal handlers ***/
        void on_new_document(const boost::shared_ptr<Document>& doc);

        void on_document_tile_selected(/*Document*/Gtk::Util::Tile& t);

        // Handler for DocumentTileView's and TagCloud's signals
        void on_tag_clicked(const Glib::ustring& tag);

        void on_view_all();

        /*** Members ***/
        Browser* browser_;

        Glib::RefPtr<Gnome::Glade::Xml> glade_;

        /*@* Child widgets *@*/
        Gtk::HPaned*      hpane_;
        Gtk::VBox*        left_top_vbox_;
        DocumentTileView* tile_view_;

        boost::shared_ptr<TileSet> tiles_;

        Gtk::VBox*        right_top_vbox_;

        boost::shared_ptr<TagCloudModel> model_;
        TagCloud tag_cloud_;
        Gtk::VBox tag_box_;
        Gtk::Button button_view_all_;

        Thumbnailer thumbnailer_;

    private:
        // Non-copyable:
        MainWindow(const MainWindow& );
        MainWindow& operator=(const MainWindow& );
    };

} // namespace paperbox

#endif // __PAPER_BOX_MAIN_WINDOW__
