
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define TYPE_TRACKER_SEARCH_ENTRY (tracker_search_entry_get_type ())
#define TRACKER_SEARCH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_SEARCH_ENTRY, TrackerSearchEntry))
#define TRACKER_SEARCH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_SEARCH_ENTRY, TrackerSearchEntryClass))
#define IS_TRACKER_SEARCH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_SEARCH_ENTRY))
#define IS_TRACKER_SEARCH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_SEARCH_ENTRY))
#define TRACKER_SEARCH_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_SEARCH_ENTRY, TrackerSearchEntryClass))

typedef struct _TrackerSearchEntry TrackerSearchEntry;
typedef struct _TrackerSearchEntryClass TrackerSearchEntryClass;
typedef struct _TrackerSearchEntryPrivate TrackerSearchEntryPrivate;

#define TYPE_TRACKER_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_QUERY, TrackerQueryClass))
#define IS_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_QUERY))
#define IS_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TrackerSearchEntry {
	GtkEntry parent_instance;
	TrackerSearchEntryPrivate * priv;
};

struct _TrackerSearchEntryClass {
	GtkEntryClass parent_class;
};

struct _TrackerSearchEntryPrivate {
	TrackerQuery* _Query;
};


static gpointer tracker_search_entry_parent_class = NULL;

GType tracker_search_entry_get_type (void);
GType tracker_query_get_type (void);
#define TRACKER_SEARCH_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRACKER_SEARCH_ENTRY, TrackerSearchEntryPrivate))
enum  {
	TRACKER_SEARCH_ENTRY_DUMMY_PROPERTY,
	TRACKER_SEARCH_ENTRY_QUERY
};
TrackerQuery* tracker_search_entry_get_Query (TrackerSearchEntry* self);
void tracker_query_set_SearchTerms (TrackerQuery* self, const char* value);
char* tracker_utils_EscapeSparql (const char* sparql, gboolean add_wildcard);
static void tracker_search_entry_entry_changed (TrackerSearchEntry* self, GtkEditable* editable);
TrackerSearchEntry* tracker_search_entry_new (void);
TrackerSearchEntry* tracker_search_entry_construct (GType object_type);
void tracker_search_entry_set_Query (TrackerSearchEntry* self, TrackerQuery* value);
static void _tracker_search_entry_entry_changed_gtk_editable_changed (TrackerSearchEntry* _sender, gpointer self);
static void _lambda1_ (GtkEntryIconPosition p0, GdkEvent* p1, TrackerSearchEntry* self);
static void __lambda1__gtk_entry_icon_press (TrackerSearchEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static GObject * tracker_search_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void tracker_search_entry_finalize (GObject* obj);
static void tracker_search_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_search_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



#line 43 "tracker-entry.gs"
static void tracker_search_entry_entry_changed (TrackerSearchEntry* self, GtkEditable* editable) {
#line 43 "tracker-entry.gs"
	g_return_if_fail (self != NULL);
#line 43 "tracker-entry.gs"
	g_return_if_fail (editable != NULL);
#line 44 "tracker-entry.gs"
	if (self->priv->_Query != NULL) {
#line 45 "tracker-entry.gs"
		if (gtk_entry_get_text ((GtkEntry*) self) == NULL) {
#line 46 "tracker-entry.gs"
			gtk_entry_set_icon_sensitive ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, FALSE);
#line 47 "tracker-entry.gs"
			tracker_query_set_SearchTerms (self->priv->_Query, "");
#line 88 "tracker-entry.c"
		} else {
			char* _tmp0_;
#line 49 "tracker-entry.gs"
			gtk_entry_set_icon_sensitive ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, TRUE);
#line 50 "tracker-entry.gs"
			tracker_query_set_SearchTerms (self->priv->_Query, _tmp0_ = tracker_utils_EscapeSparql (gtk_entry_get_text ((GtkEntry*) self), TRUE));
#line 95 "tracker-entry.c"
			_g_free0 (_tmp0_);
		}
	}
}


#line 28 "tracker-entry.gs"
TrackerSearchEntry* tracker_search_entry_construct (GType object_type) {
#line 104 "tracker-entry.c"
	TrackerSearchEntry * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


#line 28 "tracker-entry.gs"
TrackerSearchEntry* tracker_search_entry_new (void) {
#line 28 "tracker-entry.gs"
	return tracker_search_entry_construct (TYPE_TRACKER_SEARCH_ENTRY);
#line 115 "tracker-entry.c"
}


TrackerQuery* tracker_search_entry_get_Query (TrackerSearchEntry* self) {
	TrackerQuery* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Query;
	return result;
}


void tracker_search_entry_set_Query (TrackerSearchEntry* self, TrackerQuery* value) {
	g_return_if_fail (self != NULL);
	self->priv->_Query = value;
	g_object_notify ((GObject *) self, "Query");
}


#line 43 "tracker-entry.gs"
static void _tracker_search_entry_entry_changed_gtk_editable_changed (TrackerSearchEntry* _sender, gpointer self) {
#line 136 "tracker-entry.c"
	tracker_search_entry_entry_changed (self, _sender);
}


static void _lambda1_ (GtkEntryIconPosition p0, GdkEvent* p1, TrackerSearchEntry* self) {
	g_return_if_fail (p1 != NULL);
#line 39 "tracker-entry.gs"
	if (p0 == GTK_ENTRY_ICON_SECONDARY) {
#line 40 "tracker-entry.gs"
		gtk_entry_set_text ((GtkEntry*) self, "");
#line 147 "tracker-entry.c"
	}
}


static void __lambda1__gtk_entry_icon_press (TrackerSearchEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	_lambda1_ (p0, p1, self);
}


static GObject * tracker_search_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	TrackerSearchEntryClass * klass;
	GObjectClass * parent_class;
	TrackerSearchEntry * self;
	klass = TRACKER_SEARCH_ENTRY_CLASS (g_type_class_peek (TYPE_TRACKER_SEARCH_ENTRY));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TRACKER_SEARCH_ENTRY (obj);
	{
#line 32 "tracker-entry.gs"
		gtk_entry_set_icon_from_stock ((GtkEntry*) self, GTK_ENTRY_ICON_PRIMARY, GTK_STOCK_FIND);
#line 33 "tracker-entry.gs"
		gtk_entry_set_icon_from_stock ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, GTK_STOCK_CLEAR);
#line 34 "tracker-entry.gs"
		gtk_entry_set_icon_sensitive ((GtkEntry*) self, GTK_ENTRY_ICON_PRIMARY, FALSE);
#line 35 "tracker-entry.gs"
		gtk_entry_set_icon_sensitive ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, FALSE);
#line 36 "tracker-entry.gs"
		gtk_entry_set_icon_tooltip_text ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, _ ("Clear the search text"));
#line 37 "tracker-entry.gs"
		g_signal_connect_object ((GtkEditable*) self, "changed", (GCallback) _tracker_search_entry_entry_changed_gtk_editable_changed, self, 0);
#line 38 "tracker-entry.gs"
		g_signal_connect_object ((GtkEntry*) self, "icon-press", (GCallback) __lambda1__gtk_entry_icon_press, self, 0);
#line 181 "tracker-entry.c"
	}
	return obj;
}


static void tracker_search_entry_class_init (TrackerSearchEntryClass * klass) {
	tracker_search_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSearchEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_search_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_search_entry_set_property;
	G_OBJECT_CLASS (klass)->constructor = tracker_search_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = tracker_search_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SEARCH_ENTRY_QUERY, g_param_spec_object ("Query", "Query", "Query", TYPE_TRACKER_QUERY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tracker_search_entry_instance_init (TrackerSearchEntry * self) {
	self->priv = TRACKER_SEARCH_ENTRY_GET_PRIVATE (self);
}


static void tracker_search_entry_finalize (GObject* obj) {
	TrackerSearchEntry * self;
	self = TRACKER_SEARCH_ENTRY (obj);
	G_OBJECT_CLASS (tracker_search_entry_parent_class)->finalize (obj);
}


GType tracker_search_entry_get_type (void) {
	static GType tracker_search_entry_type_id = 0;
	if (tracker_search_entry_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSearchEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_search_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSearchEntry), 0, (GInstanceInitFunc) tracker_search_entry_instance_init, NULL };
		tracker_search_entry_type_id = g_type_register_static (GTK_TYPE_ENTRY, "TrackerSearchEntry", &g_define_type_info, 0);
	}
	return tracker_search_entry_type_id;
}


static void tracker_search_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSearchEntry * self;
	self = TRACKER_SEARCH_ENTRY (object);
	switch (property_id) {
		case TRACKER_SEARCH_ENTRY_QUERY:
		g_value_set_object (value, tracker_search_entry_get_Query (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tracker_search_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSearchEntry * self;
	self = TRACKER_SEARCH_ENTRY (object);
	switch (property_id) {
		case TRACKER_SEARCH_ENTRY_QUERY:
		tracker_search_entry_set_Query (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




