/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* 
 * Copyright (C) 2000 Eazel, Inc
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Andy Hertzfeld
 */

/* header file for the package view component */

#ifndef NAUTILUS_PACKAGE_VIEW_H
#define NAUTILUS_PACKAGE_VIEW_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libnautilus/nautilus-view.h>
#include <gnome.h>

typedef struct NautilusPackageView      NautilusPackageView;
typedef struct NautilusPackageViewClass NautilusPackageViewClass;

#define NAUTILUS_TYPE_PACKAGE_VIEW	          (nautilus_package_view_get_type ())
#define NAUTILUS_PACKAGE_VIEW(obj)	          (GTK_CHECK_CAST ((obj), NAUTILUS_TYPE_PACKAGE_VIEW, NautilusPackageView))
#define NAUTILUS_PACKAGE_VIEW_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), NAUTILUS_TYPE_PACKAGE_VIEW, NautilusPackageViewClass))
#define NAUTILUS_IS_PACKAGE_VIEW(obj)	  (GTK_CHECK_TYPE ((obj), NAUTILUS_TYPE_PACKAGE_VIEW))
#define NAUTILUS_IS_PACKAGE_VIEW_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), NAUTILUS_TYPE_PACKAGE_VIEW))

typedef struct NautilusPackageViewDetails NautilusPackageViewDetails;

struct NautilusPackageView {
	GtkEventBox parent;
	NautilusPackageViewDetails *details;
};

struct NautilusPackageViewClass {
	GtkEventBoxClass parent_class;
};

/* GtkObject support */
GtkType       nautilus_package_view_get_type          (void);

/* Component embedding support */
NautilusView *nautilus_package_view_get_nautilus_view (NautilusPackageView *view);

/* URI handling */
char*	      nautilus_package_view_get_uri		  (NautilusPackageView *view);
gboolean      nautilus_package_view_load_uri          (NautilusPackageView *view,
						   const char      *uri);
gboolean      nautilus_package_view_get_installed     (NautilusPackageView *view);
NautilusView* nautilus_package_view_get_view          (NautilusPackageView *view);

#endif /* NAUTILUS_PACKAGE_VIEW_H */
